/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch.eql.EqlHits;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class EqlSearchResponseBase<TEvent>
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean isPartial;
    @Nullable
    private final Boolean isRunning;
    @Nullable
    private final Integer took;
    @Nullable
    private final Boolean timedOut;
    private final EqlHits<TEvent> hits;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;

    protected EqlSearchResponseBase(AbstractBuilder<TEvent, ?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.isPartial = ((AbstractBuilder)builder).isPartial;
        this.isRunning = ((AbstractBuilder)builder).isRunning;
        this.took = ((AbstractBuilder)builder).took;
        this.timedOut = ((AbstractBuilder)builder).timedOut;
        this.hits = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).hits, this, "hits");
        this.tEventSerializer = ((AbstractBuilder)builder).tEventSerializer;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean isPartial() {
        return this.isPartial;
    }

    @Nullable
    public final Boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    public final Integer took() {
        return this.took;
    }

    @Nullable
    public final Boolean timedOut() {
        return this.timedOut;
    }

    public final EqlHits<TEvent> hits() {
        return this.hits;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.isPartial != null) {
            generator.writeKey("is_partial");
            generator.write(this.isPartial.booleanValue());
        }
        if (this.isRunning != null) {
            generator.writeKey("is_running");
            generator.write(this.isRunning.booleanValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.intValue());
        }
        if (this.timedOut != null) {
            generator.writeKey("timed_out");
            generator.write(this.timedOut.booleanValue());
        }
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <TEvent, BuilderT extends AbstractBuilder<TEvent, BuilderT>> void setupEqlSearchResponseBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(AbstractBuilder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(AbstractBuilder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(AbstractBuilder::took, JsonpDeserializer.integerDeserializer(), "took");
        op.add(AbstractBuilder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(AbstractBuilder::hits, EqlHits.createEqlHitsDeserializer(tEventDeserializer), "hits");
    }

    protected static abstract class AbstractBuilder<TEvent, BuilderT extends AbstractBuilder<TEvent, BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String id;
        @Nullable
        private Boolean isPartial;
        @Nullable
        private Boolean isRunning;
        @Nullable
        private Integer took;
        @Nullable
        private Boolean timedOut;
        private EqlHits<TEvent> hits;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        protected AbstractBuilder() {
        }

        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isPartial(@Nullable Boolean value) {
            this.isPartial = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isRunning(@Nullable Boolean value) {
            this.isRunning = value;
            return (BuilderT)this.self();
        }

        public final BuilderT took(@Nullable Integer value) {
            this.took = value;
            return (BuilderT)this.self();
        }

        public final BuilderT timedOut(@Nullable Boolean value) {
            this.timedOut = value;
            return (BuilderT)this.self();
        }

        public final BuilderT hits(EqlHits<TEvent> value) {
            this.hits = value;
            return (BuilderT)this.self();
        }

        public final BuilderT hits(Function<EqlHits.Builder<TEvent>, ObjectBuilder<EqlHits<TEvent>>> fn) {
            return this.hits(fn.apply(new EqlHits.Builder()).build());
        }

        public final BuilderT tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

