/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.binder;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.alibaba.nacos.spring.context.properties.config.NacosConfigurationPropertiesBinder;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class NacosBootConfigurationPropertiesBinder
extends NacosConfigurationPropertiesBinder {
    private final Logger logger = LoggerFactory.getLogger(NacosBootConfigurationPropertiesBinder.class);
    private ConfigurationBeanFactoryMetadata beanFactoryMetadata;
    private StandardEnvironment environment = new StandardEnvironment();

    public NacosBootConfigurationPropertiesBinder(ConfigurableApplicationContext applicationContext) {
        super(applicationContext);
        this.beanFactoryMetadata = (ConfigurationBeanFactoryMetadata)applicationContext.getBean(ConfigurationBeanFactoryMetadata.BEAN_NAME, ConfigurationBeanFactoryMetadata.class);
    }

    protected void doBind(Object bean, String beanName, String dataId, String groupId, String configType, NacosConfigurationProperties properties, String content, ConfigService configService) {
        String name = "nacos-bootstrap-" + beanName;
        NacosPropertySource propertySource = new NacosPropertySource(name, dataId, groupId, content, configType);
        this.environment.getPropertySources().addLast((PropertySource)propertySource);
        Binder binder = Binder.get((Environment)this.environment);
        ResolvableType type = this.getBeanType(bean, beanName);
        Bindable target = Bindable.of((ResolvableType)type).withExistingValue(bean);
        binder.bind(properties.prefix(), target);
        this.publishBoundEvent(bean, beanName, dataId, groupId, properties, content, configService);
        this.publishMetadataEvent(bean, beanName, dataId, groupId, properties);
        this.environment.getPropertySources().remove(name);
    }

    private ResolvableType getBeanType(Object bean, String beanName) {
        Method factoryMethod = this.beanFactoryMetadata.findFactoryMethod(beanName);
        if (factoryMethod != null) {
            return ResolvableType.forMethodReturnType((Method)factoryMethod);
        }
        return ResolvableType.forClass(bean.getClass());
    }
}

