/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.refresh.NacosRefreshHistory;
import com.alibaba.cloud.nacos.refresh.NacosRefreshProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class NacosContextRefresher
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NacosContextRefresher.class);
    private static final AtomicLong REFRESH_COUNT = new AtomicLong(0L);
    private final NacosRefreshProperties refreshProperties;
    private final NacosRefreshHistory refreshHistory;
    private final ConfigService configService;
    private ApplicationContext applicationContext;
    private AtomicBoolean ready = new AtomicBoolean(false);
    private Map<String, Listener> listenerMap = new ConcurrentHashMap<String, Listener>(16);

    public NacosContextRefresher(NacosRefreshProperties refreshProperties, NacosRefreshHistory refreshHistory, ConfigService configService) {
        this.refreshProperties = refreshProperties;
        this.refreshHistory = refreshHistory;
        this.configService = configService;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (this.ready.compareAndSet(false, true)) {
            this.registerNacosListenersForApplications();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void registerNacosListenersForApplications() {
        if (this.refreshProperties.isEnabled()) {
            for (NacosPropertySource nacosPropertySource : NacosPropertySourceRepository.getAll()) {
                if (!nacosPropertySource.isRefreshable()) continue;
                String dataId = nacosPropertySource.getDataId();
                this.registerNacosListener(nacosPropertySource.getGroup(), dataId);
            }
        }
    }

    private void registerNacosListener(final String group, final String dataId) {
        Listener listener = this.listenerMap.get(dataId);
        if (listener == null) {
            listener = new Listener(){

                public void receiveConfigInfo(String configInfo) {
                    NacosContextRefresher.refreshCountIncrement();
                    String md5 = "";
                    if (!StringUtils.isEmpty((Object)configInfo)) {
                        try {
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            md5 = new BigInteger(1, md.digest(configInfo.getBytes("UTF-8"))).toString(16);
                        }
                        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                            log.warn("[Nacos] unable to get md5 for dataId: " + dataId, (Throwable)e);
                        }
                    }
                    NacosContextRefresher.this.refreshHistory.add(dataId, md5);
                    NacosContextRefresher.this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, null, "Refresh Nacos config"));
                    if (log.isDebugEnabled()) {
                        log.debug("Refresh Nacos config group{},dataId{}", (Object)group, (Object)dataId);
                    }
                }

                public Executor getExecutor() {
                    return null;
                }
            };
            this.listenerMap.put(dataId, listener);
        }
        try {
            this.configService.addListener(dataId, group, listener);
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }

    public static long getRefreshCount() {
        return REFRESH_COUNT.get();
    }

    public static void refreshCountIncrement() {
        REFRESH_COUNT.incrementAndGet();
    }
}

