/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DegradeRule
extends AbstractRule {
    private static ScheduledExecutorService pool = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("sentinel-degrade-reset-task", true));
    private double count;
    private int timeWindow;
    private int grade = 0;
    private int rtSlowRequestAmount = 5;
    private int minRequestAmount = 5;
    private AtomicLong passCount = new AtomicLong(0L);
    private final AtomicBoolean cut = new AtomicBoolean(false);

    public DegradeRule() {
    }

    public DegradeRule(String resourceName) {
        this.setResource(resourceName);
    }

    public int getGrade() {
        return this.grade;
    }

    public DegradeRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public DegradeRule setCount(double count) {
        this.count = count;
        return this;
    }

    public int getTimeWindow() {
        return this.timeWindow;
    }

    public DegradeRule setTimeWindow(int timeWindow) {
        this.timeWindow = timeWindow;
        return this;
    }

    public int getRtSlowRequestAmount() {
        return this.rtSlowRequestAmount;
    }

    public DegradeRule setRtSlowRequestAmount(int rtSlowRequestAmount) {
        this.rtSlowRequestAmount = rtSlowRequestAmount;
        return this;
    }

    public int getMinRequestAmount() {
        return this.minRequestAmount;
    }

    public DegradeRule setMinRequestAmount(int minRequestAmount) {
        this.minRequestAmount = minRequestAmount;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DegradeRule that = (DegradeRule)o;
        return Double.compare(that.count, this.count) == 0 && this.timeWindow == that.timeWindow && this.grade == that.grade && this.rtSlowRequestAmount == that.rtSlowRequestAmount && this.minRequestAmount == that.minRequestAmount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + new Double(this.count).hashCode();
        result = 31 * result + this.timeWindow;
        result = 31 * result + this.grade;
        result = 31 * result + this.rtSlowRequestAmount;
        result = 31 * result + this.minRequestAmount;
        return result;
    }

    public String toString() {
        return "DegradeRule{resource=" + this.getResource() + ", grade=" + this.grade + ", count=" + this.count + ", limitApp=" + this.getLimitApp() + ", timeWindow=" + this.timeWindow + ", rtSlowRequestAmount=" + this.rtSlowRequestAmount + ", minRequestAmount=" + this.minRequestAmount + "}";
    }

    @Override
    public boolean passCheck(Context context, DefaultNode node, int acquireCount, Object ... args) {
        double exception;
        if (this.cut.get()) {
            return false;
        }
        ClusterNode clusterNode = ClusterBuilderSlot.getClusterNode(this.getResource());
        if (clusterNode == null) {
            return true;
        }
        if (this.grade == 0) {
            double rt = clusterNode.avgRt();
            if (rt < this.count) {
                this.passCount.set(0L);
                return true;
            }
            if (this.passCount.incrementAndGet() < (long)this.rtSlowRequestAmount) {
                return true;
            }
        } else if (this.grade == 1) {
            exception = clusterNode.exceptionQps();
            double success = clusterNode.successQps();
            double total = clusterNode.totalQps();
            if (total < (double)this.minRequestAmount) {
                return true;
            }
            double realSuccess = success - exception;
            if (realSuccess <= 0.0 && exception < (double)this.minRequestAmount) {
                return true;
            }
            if (exception / success < this.count) {
                return true;
            }
        } else if (this.grade == 2 && (exception = (double)clusterNode.totalException()) < this.count) {
            return true;
        }
        if (this.cut.compareAndSet(false, true)) {
            ResetTask resetTask = new ResetTask(this);
            pool.schedule(resetTask, (long)this.timeWindow, TimeUnit.SECONDS);
        }
        return false;
    }

    private static final class ResetTask
    implements Runnable {
        private DegradeRule rule;

        ResetTask(DegradeRule rule) {
            this.rule = rule;
        }

        @Override
        public void run() {
            this.rule.passCount.set(0L);
            this.rule.cut.set(false);
        }
    }
}

