/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.sc.route;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.server.ServerWebExchange;

public class AntRoutePathMatcher
implements Predicate<ServerWebExchange> {
    private final String pattern;
    private final PathMatcher pathMatcher;
    private final boolean canMatch;

    public AntRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank((String)pattern, (String)"pattern cannot be blank");
        this.pattern = pattern;
        this.pathMatcher = new AntPathMatcher();
        this.canMatch = this.pathMatcher.isPattern(pattern);
    }

    public boolean test(ServerWebExchange exchange) {
        String path = exchange.getRequest().getPath().value();
        if (this.canMatch) {
            return this.pathMatcher.match(this.pattern, path);
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }
}

