/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.logger.adapter.logback14;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelHandlerFactoryMethod;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import com.alibaba.nacos.common.logging.NacosLoggingProperties;
import com.alibaba.nacos.logger.adapter.logback14.NacosClientPropertyModel;
import com.alibaba.nacos.logger.adapter.logback14.NacosClientPropertyModelAction;
import com.alibaba.nacos.logger.adapter.logback14.NacosModelHandlerFactoryMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class NacosLogbackConfiguratorAdapterV2
extends JoranConfigurator {
    private NacosLoggingProperties loggingProperties;

    public void setLoggingProperties(NacosLoggingProperties loggingProperties) {
        this.loggingProperties = loggingProperties;
    }

    public void registerSafeConfiguration(Model top) {
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(NacosClientPropertyModel.class, (ModelHandlerFactoryMethod)new NacosModelHandlerFactoryMethod(this.loggingProperties));
        super.addModelHandlerAssociations(defaultProcessor);
    }

    public void addElementSelectorAndActionAssociations(RuleStore ruleStore) {
        ElementSelector elementSelector = new ElementSelector("configuration/nacosClientProperty");
        if (null == ruleStore.matchActions(elementSelector.duplicate())) {
            super.addElementSelectorAndActionAssociations(ruleStore);
            ruleStore.addRule(elementSelector, NacosClientPropertyModelAction::new);
        }
    }

    public void configure(URL url) throws Exception {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            this.doConfigure(in, url.toExternalForm());
        }
        catch (IOException ioe) {
            String errMsg = "Could not open URL [" + url + "].";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    String errMsg = "Could not close input stream";
                    this.addError(errMsg, ioe);
                    throw new JoranException(errMsg, (Throwable)ioe);
                }
            }
        }
    }
}

