/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.sse;

import com.aliyun.core.utils.StringUtils;
import darabonba.core.ResponseIterator;
import darabonba.core.exception.TeaException;
import darabonba.core.sse.Event;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public abstract class SSEResponseIterator<T>
extends ResponseIterator<T> {
    private volatile int retry = 3000;
    private volatile boolean endOfEvent = false;
    private final Queue<T> events = new LinkedList<T>();
    private final List<T> backoff = new ArrayList<T>();
    private Map<String, String> headers;
    private Integer statusCode;
    private volatile boolean endOfFailure = false;
    private volatile Throwable throwable;

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    @Override
    public boolean hasNext() {
        while (this.events.isEmpty() && !this.endOfEvent && !this.isEndOfFailure()) {
            try {
                Thread.sleep(this.retry);
            }
            catch (InterruptedException e) {
                throw new TeaException(e);
            }
        }
        if (this.isEndOfFailure()) {
            SSEResponseIterator.sneakyThrow(this.getThrowable());
        }
        return !this.events.isEmpty() || !this.endOfEvent;
    }

    @Override
    public T next() {
        return this.events.poll();
    }

    public void addEvent(Event event) {
        String data;
        if (event.getRetry() > 0) {
            this.retry = event.getRetry();
        }
        if (!StringUtils.isEmpty((CharSequence)(data = event.getData()))) {
            T model = this.toModel(data);
            this.events.add(model);
            this.backoff.add(model);
        }
    }

    @Override
    public List<T> getAll() {
        return this.backoff;
    }

    protected abstract T toModel(String var1);

    protected void endOfEvent() {
        this.endOfEvent = true;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    protected void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    protected void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    protected void endOfFailure(Throwable throwable) {
        this.endOfFailure = true;
        this.throwable = throwable;
    }

    protected boolean isEndOfFailure() {
        return this.endOfFailure;
    }

    protected Throwable getThrowable() {
        return this.throwable;
    }
}

