/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client;

import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.DataFilterBase;
import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.utils.DataFilterUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class DataFilterV2
implements DataFilterBase {
    private String branchDB;
    private List<FilterInfo> filterInfoList;
    private boolean isAllMatch;
    private String storeFilter;
    private AtomicBoolean haveValidated;
    private Map<String, Map<String, List<String>>> requires;
    private Map<String, Map<String, List<String>>> dbTableColsReflectionMap;

    private DataFilterV2(String branchDB, List<FilterInfo> filterInfos) {
        this.filterInfoList = null == filterInfos ? new LinkedList<FilterInfo>() : filterInfos;
        this.branchDB = branchDB;
        this.haveValidated = new AtomicBoolean(false);
        this.requires = new HashMap<String, Map<String, List<String>>>();
        this.dbTableColsReflectionMap = new HashMap<String, Map<String, List<String>>>();
        this.isAllMatch = true;
        this.storeFilter = null;
    }

    private DataFilterV2() {
        this(null, null);
    }

    public static DataFilterV2 create() {
        return new DataFilterV2();
    }

    public DataFilterV2 addFilterTuple(String tenant, String db, String table, String ... cols) {
        FilterInfo filterInfo = new FilterInfo(tenant, db, table, cols);
        this.filterInfoList.add(filterInfo);
        return this;
    }

    public List<FilterInfo> getFilterInfoList() {
        return this.filterInfoList;
    }

    public String getBranchDB() {
        return this.branchDB;
    }

    @Override
    public String getConnectStoreFilterConditions() {
        return this.storeFilter;
    }

    @Override
    public boolean validateFilter(DBType dbType) throws DRCClientException {
        if (!this.haveValidated.compareAndSet(false, true)) {
            return true;
        }
        this.requires.clear();
        if (this.filterInfoList.isEmpty()) {
            this.haveValidated.compareAndSet(true, false);
            throw new DRCClientException("Filter list is empty, use addFilterTuple add filter tuple");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (FilterInfo filterInfo : this.filterInfoList) {
            String dbName = filterInfo.getDbName();
            String tableName = filterInfo.getTableName();
            String tenant = filterInfo.getTenant();
            List<String> cols = filterInfo.getColsList();
            String formatDbName = null;
            if (StringUtils.isEmpty((CharSequence)dbName) || StringUtils.isEmpty((CharSequence)tableName)) {
                throw new DRCClientException("DBName and TableName is strictly required, Current filter tuple: " + tenant + "," + dbName + "," + tableName + ",[" + StringUtils.join(cols, (String)".") + "]");
            }
            if (dbType == DBType.OCEANBASE1) {
                if (StringUtils.isEmpty((CharSequence)tenant)) {
                    this.haveValidated.compareAndSet(true, false);
                    throw new DRCClientException("Target database is OB1.0, tenant is strictly required, Current filter tuple: " + tenant + "," + dbName + "," + tableName + ",[" + StringUtils.join(cols, (String)".") + "]");
                }
                formatDbName = tenant + "." + dbName;
            } else {
                formatDbName = dbName;
            }
            stringBuilder.append(formatDbName).append(".").append(tableName).append("|");
            if (null == cols || 0 == cols.size()) {
                this.haveValidated.compareAndSet(true, false);
                throw new DRCClientException("Col filter must be set, Current filter tuple: " + tenant + "," + dbName + "," + tableName + ",[" + StringUtils.join(cols, (String)".") + "]");
            }
            for (String col : cols) {
                if ("*".equals(col)) continue;
                this.isAllMatch = false;
            }
            DataFilterUtil.putColNames(formatDbName, tableName, cols, this);
        }
        this.storeFilter = stringBuilder.toString();
        return true;
    }

    @Override
    @Deprecated
    public void setBranchDb(String branchDb) {
        this.branchDB = branchDb;
    }

    public String toString() {
        return this.storeFilter;
    }

    @Override
    public boolean getIsAllMatch() {
        return this.isAllMatch;
    }

    @Override
    public Map<String, Map<String, List<String>>> getReflectionMap() {
        return this.dbTableColsReflectionMap;
    }

    @Override
    public Map<String, Map<String, List<String>>> getRequireMap() {
        return this.requires;
    }

    public class FilterInfo {
        private String tenant;
        private String dbName;
        private String tableName;
        private List<String> colsList;

        public FilterInfo(String tenant, String dbName, String tableName, String ... cols) {
            this.tenant = tenant;
            this.dbName = dbName;
            this.tableName = tableName;
            this.colsList = new LinkedList<String>();
            if (null != cols) {
                for (String col : cols) {
                    this.colsList.add(col);
                }
            }
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<String> getColsList() {
            return this.colsList;
        }
    }
}

