/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.HttpBadResponseException;
import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.impl.Checkpoint;
import com.aliyun.drc.client.impl.DRCClientImpl;
import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.impl.NsLooker;
import com.aliyun.drc.client.impl.ServerProxy;
import com.aliyun.drc.client.impl.StoreResp;
import com.aliyun.drc.client.impl.TokenResp;
import com.aliyun.drc.client.impl.TopicsResp;
import com.aliyun.drc.client.impl.TypeResp;
import com.aliyun.drc.client.message.RedirectMessage;
import com.aliyun.drc.utils.CipherUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class ClusterManagers {
    private static final String DELM = ";";
    private final String[] primUrls;

    public ClusterManagers(String urls) {
        this.primUrls = urls.split(DELM);
    }

    public DBType getDatabaseType(DRCConfig config) throws DRCClientException, UnknownHostException, MalformedURLException {
        StringBuilder builder = new StringBuilder();
        for (String url : this.primUrls) {
            String[] managerUrls;
            for (String managerUrl : managerUrls = NsLooker.getInstance().performNSLookup(url)) {
                TypeResp tr;
                TopicsResp p;
                TokenResp t;
                try {
                    t = ServerProxy.askToken(managerUrl, config.getGroupName(), config.getIdentification(), config);
                }
                catch (Exception e) {
                    builder.append(e.toString());
                    continue;
                }
                try {
                    p = ServerProxy.askTopics(managerUrl, config.getDbname(), t.getToken(), config);
                }
                catch (Exception e) {
                    builder.append(e.toString());
                    continue;
                }
                try {
                    tr = ServerProxy.askTopicType(managerUrl, p.getTopics().get(0), config);
                }
                catch (Exception e) {
                    builder.append(e.toString());
                    continue;
                }
                return tr.getDatabaseType();
            }
        }
        throw new DRCClientException("Get exception from all cluster managers because " + builder.toString());
    }

    public ServerProxy findStore(DRCConfig config, DRCClientImpl drcClient) throws Exception {
        Object url;
        URL parsedUrl;
        if (this.primUrls.length == 1 && (parsedUrl = new URL((String)(url = this.primUrls[0]))).getPath().length() > 1 && !ServerProxy.askIfCm((String)url, config)) {
            return this.connectStore((String)url, "20", config, null, null, null);
        }
        if (config != null) {
            for (String persist : config.getPersists()) {
                if (config.getParam(persist) != null) continue;
                throw new DRCClientException("Required parameter " + persist + " is not given");
            }
        }
        int index = -1;
        for (String url2 : this.primUrls) {
            ++index;
            try {
                String[] managerUrls = NsLooker.getInstance().performNSLookup(url2);
                int managerIndex = -1;
                for (String managerUrl : managerUrls) {
                    try {
                        ++managerIndex;
                        ArrayList<BasicNameValuePair> query = new ArrayList<BasicNameValuePair>();
                        query.add(new BasicNameValuePair("ts", "" + System.currentTimeMillis()));
                        query.add(new BasicNameValuePair("consumer", config.getGroupName()));
                        query.add(new BasicNameValuePair("password", config.getIdentification()));
                        String token = CipherUtils.encrypt(URLEncodedUtils.format(query, (Charset)Charset.defaultCharset()));
                        TopicsResp p = ServerProxy.askTopics(managerUrl, config.getDbname(), token, config);
                        if (null == drcClient.getDBType()) {
                            TypeResp tr = ServerProxy.askTopicType(managerUrl, p.getTopics().get(0), config);
                            drcClient.setDbType(tr.getDatabaseType());
                            if (!drcClient.validateDataFilter()) {
                                throw new DRCClientException("Data filter check failed: for oceanbase 1.0, the filter format must be  [tenant.dbname.tbname.clos]");
                            }
                        }
                        StoreResp s = ServerProxy.askStore(managerUrl, p.getTopics().get(0), token, config);
                        return this.connectStore(s.getStore(), p.getTopics().get(0), s.getToken(), config);
                    }
                    catch (DRCClientException nonretryExc) {
                        throw nonretryExc;
                    }
                    catch (Exception retryExp) {
                        if (managerIndex + 1 != managerUrls.length) continue;
                        throw retryExp;
                    }
                }
            }
            catch (DRCClientException nonretryExp) {
                throw nonretryExp;
            }
            catch (Exception e) {
                if (index + 1 != this.primUrls.length) continue;
                throw e;
            }
        }
        throw new DRCClientException("Failed to recognize addresses of cluster manager: " + Arrays.toString(this.primUrls));
    }

    public ServerProxy connectStore(String addr, String subTopic, String token, DRCConfig config) throws Exception {
        String[] ipport = addr.split(":");
        if (ipport.length != 2) {
            throw new DRCClientException("Store addr " + addr + " not ip:port");
        }
        String storeUrl = (config.getUseHTTPS() ? "https://" : "http://") + ipport[0] + ":" + ipport[1] + "/" + subTopic;
        return this.connectStore(storeUrl, token, config, subTopic, ipport[0], ipport[1]);
    }

    public ServerProxy connectStore(String storeUrl, String token, DRCConfig config, String subTopic, String ip, String port) throws Exception {
        ServerProxy server = new ServerProxy(storeUrl, config);
        server.setSocketTimeout(config.getSocketTimeout());
        server.setConnectionTimeout(config.getConnectionTimeout());
        server.addParam("token", token);
        Checkpoint checkpoint = config.getCheckpoint();
        if (checkpoint.getTimestamp() != null && !checkpoint.getTimestamp().isEmpty()) {
            server.addParam("checkpoint", checkpoint.getTimestamp());
        } else if (checkpoint.getPosition() != null) {
            server.addParam("checkpoint", checkpoint.getPosition());
            server.addParam("serverid", checkpoint.getServerId());
        } else {
            throw new DRCClientException("Wrong checkpoint: " + checkpoint.toString());
        }
        int num = config.getNumOfRecordsPerBatch();
        if (num > 0) {
            server.addParam("writer.threshold", Integer.toString(num));
        }
        if (config.isBinaryFormat() && !config.getUseDrcNet()) {
            server.addParam("writer.type", "data");
        } else if (config.getUseDrcNet() && config.isBinaryFormat()) {
            server.addParam("useDrcNet", "true");
            server.addParam("writer.type", "sizedData");
        } else if (config.getUseDrcNet() && !config.isBinaryFormat()) {
            server.addParam("useDrcNet", "true");
        }
        if (config.getBlackList() != null) {
            server.addParam("filter.blacklist", config.getBlackList());
        }
        if (config.getGuid() != null) {
            server.addParam("guid", config.getGuid());
        }
        server.addParam("filter.conditions", config.getDataFilter().getConnectStoreFilterConditions());
        server.addParam("username", config.getGroupName());
        server.addParam("password", config.getIdentification());
        server.addParam("group", config.getGroup());
        server.addParam("subGroup", config.getSubGroup());
        if (config.isDrcMarkWorking()) {
            server.addParam("filter.drcmark", config.getDRCMark());
            if (config.getDRCMark().startsWith("!")) {
                server.addParam("filter.alithreadid", "off");
            } else {
                server.addParam("filter.alithreadid", "on");
            }
        }
        if (!config.isTxnMarkRequired()) {
            server.addParam("filter.txn", "false");
        }
        if (config.isUseCaseSensitive()) {
            server.addParam("casesensitive", "true");
        }
        if (config.isTrimLongType()) {
            server.addParam("filter.longtype", "true");
        }
        server.addParam("client.version", "55_SP");
        server.sendRequest(true);
        if (config.getUseDrcNet() && ip != null && port != null && subTopic != null) {
            server.addParam("topic", subTopic);
            server.addParam("drcnet.encrypt", String.valueOf(config.getDrcNetEncrypt()));
            server.conncetToDrcNetServer(ip, port, config.getConnectionTimeout());
        }
        return server;
    }

    public ServerProxy findClusterManager(DRCConfig config, RedirectMessage msg) throws HttpBadResponseException {
        ServerProxy server = null;
        for (String url : this.primUrls) {
            try {
                String[] managerUrls;
                for (String managerUrl : managerUrls = NsLooker.getInstance().performNSLookup(url)) {
                    String value;
                    server = new ServerProxy(managerUrl, config);
                    for (String parameterName : msg.getRequires()) {
                        value = config.getParam(parameterName);
                        if (value != null) {
                            server.addParam(parameterName, value);
                            continue;
                        }
                        throw new HttpBadResponseException(400, "Required parameter " + parameterName + " cannot be provided by client ");
                    }
                    for (String parameterName : msg.getOptional()) {
                        value = config.getParam(parameterName);
                        if (value == null) continue;
                        server.addParam(parameterName, value);
                    }
                    try {
                        server.sendRequest(true);
                        return server;
                    }
                    catch (Exception e) {
                        server = null;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

