/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.DRCClientException;

class DaemonInfo {
    private final String ip;
    private final String port;
    private final String token;

    DaemonInfo(String ip, String port, String token) throws DRCClientException {
        if (ip == null || port == null || token == null) {
            throw new DRCClientException("Returned daemon server info is not correct: " + ip + ":" + port + ":" + token);
        }
        this.ip = ip;
        this.port = port;
        this.token = token;
    }

    final String getIp() {
        return this.ip;
    }

    final String getPort() {
        return this.port;
    }

    final String getIpPort() {
        return this.ip + ":" + this.port;
    }

    final String getToken() {
        return this.token;
    }

    public String toString() {
        return this.getIpPort() + ":" + this.token;
    }
}

