/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

class LocalityFile {
    private String basename;
    private long sizeLimit = 0L;
    private long size = 0L;
    private FileOutputStream os;
    private BufferedReader is;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    LocalityFile(String name, int reotateLimit, long fileSize) throws FileNotFoundException {
        this.basename = name;
        this.sizeLimit = fileSize;
    }

    final synchronized void writeLine(String data) throws IOException {
        if (this.os == null) {
            this.os = new FileOutputStream(this.basename, false);
        }
        String date = DATE_FORMAT.format(new Date()) + " ";
        long writtenLength = (long)data.getBytes().length + (long)date.getBytes().length + (long)System.getProperty("line.separator").getBytes().length;
        if (this.size + writtenLength >= this.sizeLimit) {
            this.os.close();
            this.os = new FileOutputStream(this.basename);
        }
        this.os.write(date.getBytes());
        this.os.write(data.getBytes());
        this.os.write(System.getProperty("line.separator").getBytes());
        this.os.flush();
        this.size += writtenLength;
    }

    final synchronized String readLine() throws IOException {
        if (this.is == null) {
            this.is = new BufferedReader(new InputStreamReader(new FileInputStream(this.basename)));
        }
        return this.is.readLine();
    }

    final synchronized void close() throws IOException {
        this.size = 0L;
        if (this.os != null) {
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
        this.os = null;
    }
}

