/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.transfer;

import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.message.transfer.JavaObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class String2JavaObject {
    private static final String MAX_INTEGER = Integer.toString(Integer.MAX_VALUE);
    private static final String MAX_LONG = Long.toString(Long.MAX_VALUE);
    private static Timestamp ZEROTIME = Timestamp.valueOf("1970-01-01 00:00:00");
    private static final Map<DataMessage.Record.Field.Type, Integer> jdbcTypes = new HashMap<DataMessage.Record.Field.Type, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DataMessage.Record.Field.Type.INT8, -6);
            this.put(DataMessage.Record.Field.Type.INT16, 5);
            this.put(DataMessage.Record.Field.Type.INT24, 4);
            this.put(DataMessage.Record.Field.Type.INT32, 4);
            this.put(DataMessage.Record.Field.Type.INT64, -5);
            this.put(DataMessage.Record.Field.Type.DECIMAL, 3);
            this.put(DataMessage.Record.Field.Type.FLOAT, 6);
            this.put(DataMessage.Record.Field.Type.DOUBLE, 8);
            this.put(DataMessage.Record.Field.Type.NULL, 0);
            this.put(DataMessage.Record.Field.Type.TIMESTAMP, 93);
            this.put(DataMessage.Record.Field.Type.DATE, 91);
            this.put(DataMessage.Record.Field.Type.TIME, 92);
            this.put(DataMessage.Record.Field.Type.DATETIME, 93);
            this.put(DataMessage.Record.Field.Type.YEAR, 4);
            this.put(DataMessage.Record.Field.Type.BIT, -7);
            this.put(DataMessage.Record.Field.Type.ENUM, 1);
            this.put(DataMessage.Record.Field.Type.SET, 1);
            this.put(DataMessage.Record.Field.Type.BLOB, 2004);
            this.put(DataMessage.Record.Field.Type.STRING, 12);
            this.put(DataMessage.Record.Field.Type.GEOMETRY, 2004);
            this.put(DataMessage.Record.Field.Type.JSON, 12);
            this.put(DataMessage.Record.Field.Type.UNKOWN, 0);
        }
    };

    public static synchronized void setZeroTime(Timestamp ts) {
        ZEROTIME = ts;
    }

    public static final synchronized Timestamp getZeroTime() {
        return ZEROTIME;
    }

    public static int fieldType2Java(DataMessage.Record.Field.Type type) {
        return jdbcTypes.get((Object)type);
    }

    public static JavaObject field2Java(DataMessage.Record.Field field) throws NumberFormatException, UnsupportedEncodingException {
        JavaObject ob = new JavaObject();
        ob.setType(jdbcTypes.get((Object)field.getType()));
        ByteString value = field.getValue();
        if (value == null) {
            return ob;
        }
        String rvalue = null;
        if (ob.getType() == 1 || ob.getType() == 12) {
            if (!field.getEncoding().equals("binary")) {
                rvalue = value.toString(field.getEncoding());
            } else {
                ob.setType(2004);
            }
        } else if (ob.getType() != 2004) {
            rvalue = value.toString();
        }
        switch (ob.getType()) {
            case -7: {
                String2JavaObject.bitstr2Object(rvalue, ob);
                break;
            }
            case -6: 
            case 5: {
                ob.setObject(Integer.valueOf(rvalue));
                break;
            }
            case 4: {
                String2JavaObject.intstr2Object(rvalue, ob);
                break;
            }
            case -5: {
                String2JavaObject.bigintstr2object(rvalue, ob);
                break;
            }
            case 3: {
                ob.setObject(new BigDecimal(rvalue));
                break;
            }
            case 6: {
                ob.setObject(Float.valueOf(rvalue));
                break;
            }
            case 8: {
                ob.setObject(Double.valueOf(rvalue));
                break;
            }
            case 93: {
                String2JavaObject.timestamp2object(rvalue, ob);
                break;
            }
            case 91: {
                String2JavaObject.date2object(rvalue, ob);
                break;
            }
            case 92: {
                String2JavaObject.time2object(rvalue, ob);
                break;
            }
            case 2004: {
                ob.setObject(value.getBytes());
                break;
            }
            case 1: 
            case 12: {
                ob.setObject(rvalue);
                break;
            }
            default: {
                ob.setObject(null);
            }
        }
        return ob;
    }

    private static Object bitstr2Object(String rvalue, JavaObject ob) {
        int ret = rvalue.compareTo("1");
        if (ret > 0) {
            BigInteger bi = new BigInteger(rvalue);
            byte[] bytes = bi.toByteArray();
            int realLength = bytes.length;
            for (int i = 0; i < bytes.length && bytes[i] == 0; ++i) {
                --realLength;
            }
            byte[] realbyte = new byte[realLength];
            for (int j = i; j < bytes.length; ++j) {
                realbyte[j - i] = bytes[j];
            }
            ob.setObject(realbyte);
        } else {
            ob.setObject(ret == 0);
        }
        return ob;
    }

    private static Object intstr2Object(String rvalue, JavaObject ob) {
        int rlength = rvalue.length();
        int maxLength = MAX_INTEGER.length();
        if (rvalue.contains("-") || rlength < maxLength || rlength == maxLength && rvalue.compareTo(MAX_INTEGER) < 0) {
            ob.setObject(Integer.valueOf(rvalue));
        } else {
            ob.setUnsigned(true);
            ob.setObject(Long.valueOf(rvalue));
        }
        return ob;
    }

    private static Object bigintstr2object(String rvalue, JavaObject ob) {
        int rlength = rvalue.length();
        int maxLength = MAX_LONG.length();
        if (rvalue.contains("-") || rlength < maxLength || rlength == maxLength && rvalue.compareTo(MAX_LONG) < 0) {
            ob.setObject(Long.valueOf(rvalue));
        } else {
            ob.setUnsigned(true);
            ob.setObject(new BigInteger(rvalue));
        }
        return ob;
    }

    private static Object timestamp2object(String rvalue, JavaObject ob) {
        Object objectValue;
        try {
            long secondsRepresentedByMilli = Long.parseLong(StringUtils.substringBefore((String)rvalue, (String)".")) * 1000L;
            String fractionalRepresentedByNano = StringUtils.substringAfter((String)rvalue, (String)".");
            if (fractionalRepresentedByNano.contains(".") || fractionalRepresentedByNano.length() > 9) {
                objectValue = rvalue;
                ob.setOutOfRange(true);
            } else {
                fractionalRepresentedByNano = String.format("%-9s", fractionalRepresentedByNano).replace(" ", "0");
                objectValue = new Timestamp(secondsRepresentedByMilli);
                try {
                    ((Timestamp)objectValue).setNanos(Integer.parseInt(fractionalRepresentedByNano));
                }
                catch (NumberFormatException ne) {
                    objectValue = rvalue;
                    ob.setOutOfRange(true);
                }
            }
        }
        catch (IllegalArgumentException e) {
            try {
                objectValue = Timestamp.valueOf(rvalue);
            }
            catch (Exception err) {
                objectValue = rvalue;
                ob.setOutOfRange(true);
            }
        }
        ob.setObject(objectValue);
        return ob;
    }

    private static Object date2object(String rvalue, JavaObject ob) {
        Object objectValue;
        try {
            objectValue = Date.valueOf(rvalue.replaceAll("[^0-9]", "-"));
        }
        catch (Exception e) {
            objectValue = rvalue;
            ob.setOutOfRange(true);
        }
        ob.setObject(objectValue);
        return ob;
    }

    private static Object time2object(String rvalue, JavaObject ob) {
        Time objectValue = Time.valueOf(rvalue);
        if (!objectValue.toString().equals(rvalue)) {
            ob.setOutOfRange(true);
        }
        ob.setObject(objectValue);
        return ob;
    }
}

