/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient;

import java.util.Properties;

public class BaseClusterContext {
    static final String TAG_GUID = "guid";
    static final String TAG_MANAGER_HOST = "manager.host";
    static final String TAG_SERVER_MESSAGE_TYPE = "server.messageType";
    static final String TAG_USE_DRC_NET = "useDrcNet";
    static final String TAG_GROUP = "group";
    static final String TAG_USER = "user";
    static final String TAG_PASSWORD = "password";
    protected final Properties properties;
    private String clusterUrl;
    private String guid;
    private String group;
    private String user;
    private String password;
    private boolean useBinary;
    private boolean useDrcNet;
    private boolean usePublicIp;
    private int maxConns = 10240;
    private int maxCountOfBufferedRecordsNotAcked;
    private int maxSizeOfNotifyMessageQueue;
    private String threadNamePrefix = "DRC_";
    private String coordinatorThreadNamePrefix = "DRC_";
    private int maxConsumerNumPerCoordinator = 1024;
    private int maxIOThreadNumPerCoordinator = Runtime.getRuntime().availableProcessors() * 2;

    public BaseClusterContext() {
        this(new Properties());
    }

    public BaseClusterContext(Properties properties) {
        this.properties = properties;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
        this.properties.setProperty(TAG_MANAGER_HOST, clusterUrl);
    }

    public final String getClusterUrl() {
        if (this.clusterUrl == null) {
            this.clusterUrl = this.properties.getProperty(TAG_MANAGER_HOST);
        }
        return this.clusterUrl;
    }

    public void setAppGuid(String guid) {
        this.guid = guid;
        this.properties.setProperty(TAG_GUID, guid);
    }

    public final String getAppGuid() {
        if (this.guid == null) {
            this.guid = this.properties.getProperty(TAG_GUID);
        }
        return this.guid;
    }

    public void setAppGroup(String group) {
        this.group = group;
        this.properties.setProperty(TAG_GROUP, group);
    }

    public final String getAppGroup() {
        if (this.group == null) {
            this.group = this.properties.getProperty(TAG_GROUP);
        }
        return this.group;
    }

    public void setAppGroupUserName(String username) {
        this.user = username;
        this.properties.setProperty(TAG_USER, this.user);
    }

    public final String getAppGroupUserName() {
        if (this.user == null) {
            this.user = this.properties.getProperty(TAG_USER);
        }
        return this.user;
    }

    public void setAppGroupPassword(String password) {
        this.password = password;
        this.properties.setProperty(TAG_PASSWORD, password);
    }

    public final String getAppGroupPassword() {
        if (this.password == null) {
            this.password = this.properties.getProperty(TAG_PASSWORD);
        }
        return this.password;
    }

    public boolean isUseBinary() {
        return this.useBinary;
    }

    public void setUseBinary(boolean useBinary) {
        this.useBinary = useBinary;
        this.properties.put(TAG_SERVER_MESSAGE_TYPE, useBinary ? "binary" : "text");
    }

    public void setUseDrcNet(boolean useDrcNet) {
        this.useDrcNet = useDrcNet;
        this.properties.setProperty(TAG_USE_DRC_NET, String.valueOf(useDrcNet));
    }

    public final boolean getUseDrcNet() {
        this.useDrcNet = Boolean.valueOf(this.properties.getProperty(TAG_USE_DRC_NET));
        return this.useDrcNet;
    }

    public boolean isUsePublicIp() {
        return this.usePublicIp;
    }

    public void setUsePublicIp(boolean usePublicIp) {
        this.usePublicIp = usePublicIp;
    }

    public void setMaxConns(int maxConns) {
        this.maxConns = maxConns;
    }

    public final int getMaxConns() {
        return this.maxConns;
    }

    public void setMaxCountOfBufferedRecordsNotAcked(int maxCountOfBufferedRecordsNotAcked) {
        this.maxCountOfBufferedRecordsNotAcked = maxCountOfBufferedRecordsNotAcked;
    }

    public int getMaxCountOfBufferedRecordsNotAcked() {
        return this.maxCountOfBufferedRecordsNotAcked;
    }

    public int getMaxSizeOfNotifyMessageQueue() {
        return this.maxSizeOfNotifyMessageQueue;
    }

    public void setMaxSizeOfNotifyMessageQueue(int maxSizeOfNotifyMessageQueue) {
        this.maxSizeOfNotifyMessageQueue = maxSizeOfNotifyMessageQueue;
    }

    public void setThreadNamePrefix(String prefix) {
        this.threadNamePrefix = prefix;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public String getCoordinatorThreadNamePrefix() {
        return this.coordinatorThreadNamePrefix;
    }

    public void setCoordinatorThreadNamePrefix(String coordinatorThreadNamePrefix) {
        this.coordinatorThreadNamePrefix = coordinatorThreadNamePrefix;
    }

    public int getMaxConsumerNumPerCoordinator() {
        return this.maxConsumerNumPerCoordinator;
    }

    public void setMaxConsumerNumPerCoordinator(int maxConsumerNumPerCoordinator) {
        this.maxConsumerNumPerCoordinator = maxConsumerNumPerCoordinator;
    }

    public int getMaxIOThreadNumPerCoordinator() {
        return this.maxIOThreadNumPerCoordinator;
    }

    public void setMaxIOThreadNumPerCoordinator(int maxIOThreadNumPerCoordinator) {
        this.maxIOThreadNumPerCoordinator = maxIOThreadNumPerCoordinator;
    }
}

