/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.clustermanager;

import com.taobao.drc.clusterclient.clustermanager.AbstractControllerRequest;
import com.taobao.drc.clusterclient.clustermanager.BatchCommitRequest;
import com.taobao.drc.clusterclient.clustermanager.BatchCommitResponse;
import com.taobao.drc.clusterclient.clustermanager.BatchGetPartitionRequest;
import com.taobao.drc.clusterclient.clustermanager.BatchGetPartitionResponse;
import com.taobao.drc.clusterclient.httpclient.HttpClient;
import java.io.IOException;
import org.apache.http.client.config.RequestConfig;

public class APIProxy {
    private final HttpClient httpClient;
    private final String cmUrl;

    public APIProxy(String cmUrl) {
        this(new HttpClient(), cmUrl);
    }

    public APIProxy(HttpClient httpClient, String cmUrl) {
        this.httpClient = httpClient;
        this.cmUrl = cmUrl;
    }

    private String joinPath(String path) {
        return this.cmUrl + path;
    }

    private <R> R post(AbstractControllerRequest request, Class<R> responseClass, RequestConfig requestConfig) throws IOException {
        return this.httpClient.post(this.joinPath(request.getPath()), request.getContent(), responseClass, request.getAPIVersion(), requestConfig);
    }

    public BatchCommitResponse batchCommit(BatchCommitRequest request) throws IOException {
        return this.post(request, BatchCommitResponse.class, request.getRequestConfig());
    }

    public BatchGetPartitionResponse batchGetPartitions(BatchGetPartitionRequest request) throws IOException {
        return this.post(request, BatchGetPartitionResponse.class, request.getRequestConfig());
    }
}

