/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.coordinator;

import com.taobao.drc.clusterclient.coordinator.Coordinator;
import com.taobao.drc.clusterclient.coordinator.CoordinatorFactory;
import com.taobao.drc.clusterclient.coordinator.impl.DefaultCoordinatorFactory;
import com.taobao.drc.clusterclient.util.Futures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorManager {
    private static final Logger logger = LoggerFactory.getLogger(CoordinatorManager.class);
    private static volatile CoordinatorManager INSTANCE = null;
    private final CoordinatorFactory coordinatorFactory;
    private final String threadNamePrefix;
    private final int maxConsumerNumPerCoordinator;
    private final int maxIOThreadNumPerCoordinator;
    private final Map<String, List<CountedReference<Coordinator>>> coordinatorMap = new HashMap<String, List<CountedReference<Coordinator>>>();

    public static CoordinatorManager getInstance(boolean shared) {
        return CoordinatorManager.getInstance(shared, new DefaultCoordinatorFactory(), "DRC_", 1024, Runtime.getRuntime().availableProcessors() * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinatorManager getInstance(boolean shared, CoordinatorFactory factory, String threadNamePrefix, int maxConsumerNumPerCoordinator, int maxIOThreadNumPerCoordinator) {
        if (!shared) return new CoordinatorManager(factory, threadNamePrefix, maxConsumerNumPerCoordinator, maxIOThreadNumPerCoordinator);
        if (INSTANCE != null) return INSTANCE;
        Class<CoordinatorManager> clazz = CoordinatorManager.class;
        synchronized (CoordinatorManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CoordinatorManager(factory, threadNamePrefix, maxConsumerNumPerCoordinator, maxIOThreadNumPerCoordinator);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public CoordinatorManager(CoordinatorFactory coordinatorFactory, String threadNamePrefix, int maxConsumerNumPerCoordinator, int maxIOThreadNumPerCoordinator) {
        this.coordinatorFactory = coordinatorFactory;
        this.threadNamePrefix = threadNamePrefix;
        if (maxConsumerNumPerCoordinator < 1) {
            throw new IllegalArgumentException("Invalid max consumer number per coordinator [" + maxConsumerNumPerCoordinator + "]");
        }
        this.maxConsumerNumPerCoordinator = maxConsumerNumPerCoordinator;
        if (maxIOThreadNumPerCoordinator < 1) {
            throw new IllegalArgumentException("Invalid max IO thread number per coordinator [" + maxIOThreadNumPerCoordinator + "]");
        }
        this.maxIOThreadNumPerCoordinator = maxIOThreadNumPerCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coordinator acquireCoordinator(String clusterAddress) {
        CoordinatorManager coordinatorManager = this;
        synchronized (coordinatorManager) {
            List<CountedReference<Coordinator>> refs = this.coordinatorMap.get(clusterAddress);
            CountedReference<Coordinator> ref = null;
            if (refs == null) {
                refs = new ArrayList<CountedReference<Coordinator>>();
                this.coordinatorMap.put(clusterAddress, refs);
            }
            for (CountedReference<Coordinator> candidate : refs) {
                if (((CountedReference)candidate).getCount() >= this.maxConsumerNumPerCoordinator) continue;
                ref = candidate;
                break;
            }
            if (ref == null) {
                ref = new CountedReference<Coordinator>(this.coordinatorFactory.createCoordinator(clusterAddress, this.threadNamePrefix, this.maxIOThreadNumPerCoordinator));
                refs.add(ref);
            }
            int n = ((CountedReference)ref).increase();
            logger.info("Reference count of coordinator for [{}]: [{}]", (Object)clusterAddress, (Object)n);
            return ref.getRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future releaseCoordinator(Coordinator coordinator) {
        int refCount;
        CoordinatorManager coordinatorManager = this;
        synchronized (coordinatorManager) {
            List<CountedReference<Coordinator>> refs = this.coordinatorMap.get(coordinator.getClusterAddress());
            if (refs == null) {
                logger.debug("The coordinator to release for [{}] may have already been released", (Object)coordinator.getClusterAddress());
                return Futures.success(null);
            }
            CountedReference<Coordinator> ref = null;
            for (CountedReference<Coordinator> cr : refs) {
                if (cr.getRef() != coordinator) continue;
                ref = cr;
                break;
            }
            if (ref == null) {
                logger.debug("The coordinator to release for [{}] may already been released", (Object)coordinator.getClusterAddress());
                return Futures.success(null);
            }
            refCount = ((CountedReference)ref).decrease();
            if (((CountedReference)ref).getCount() == 0) {
                refs.remove(ref);
                if (refs.size() == 0) {
                    this.coordinatorMap.remove(coordinator.getClusterAddress());
                }
            }
            logger.info("Reference count of coordinator for [{}]: [{}]", (Object)coordinator.getClusterAddress(), (Object)refCount);
        }
        if (refCount == 0) {
            return coordinator.asyncClose();
        }
        return Futures.success(null);
    }

    static class CountedReference<T> {
        private final T ref;
        private int count = 0;

        public CountedReference(T ref) {
            this.ref = ref;
        }

        private int increase() {
            return ++this.count;
        }

        private int decrease() {
            return --this.count;
        }

        private int getCount() {
            return this.count;
        }

        public T getRef() {
            return this.ref;
        }
    }
}

