/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.drc.clusterclient.partition;

import com.taobao.drc.clusterclient.partition.BaseCheckpoint;
import com.taobao.drc.clusterclient.util.Gaugeable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointManager
implements Gaugeable,
Iterable<BaseCheckpoint> {
    public static final String KEY_CHECKPOINT_FIRST = "checkpoint.first";
    public static final String KEY_CHECKPOINT_LAST = "checkpoint.last";
    public static final String KEY_CHECKPOINT_LATEST = "checkpoint.latest";
    public static final String KEY_CHECKPOINT_QUEUE_SIZE = "checkpoint.queue.size";
    public static final String KEY_CHECKPOINT_QUEUE_CAPACITY = "checkpoint-manager.queue.capacity";
    private static final Logger logger = LoggerFactory.getLogger(CheckpointManager.class);
    private final int capacity;
    private int count;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final BaseCheckpoint head = new BaseCheckpoint(null);
    private final BaseCheckpoint tail = new BaseCheckpoint(null);
    private BaseCheckpoint latest = null;

    public CheckpointManager(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Illegal capacity [" + capacity + "]");
        }
        this.capacity = capacity;
        this.count = 0;
        this.head.setPrev(this.tail);
        this.head.setNext(this.tail);
        this.tail.setPrev(this.head);
        this.tail.setNext(this.head);
    }

    public void book(BaseCheckpoint checkpoint) throws InterruptedException {
        if (checkpoint == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            if (checkpoint.getPrev() != null || checkpoint.getNext() != null) {
                throw new IllegalArgumentException("Invalid checkpoint to book: checkpoint [" + checkpoint.toString() + "] may have already been booked");
            }
            while (this.count >= this.capacity) {
                this.notFull.await();
            }
            checkpoint.setPrev(this.tail.getPrev());
            checkpoint.setNext(this.tail);
            this.tail.getPrev().setNext(checkpoint);
            this.tail.setPrev(checkpoint);
            this.latest = checkpoint;
            ++this.count;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(BaseCheckpoint checkpoint) {
        if (checkpoint == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            if (checkpoint.getPrev() == null || checkpoint.getNext() == null) {
                throw new NoSuchElementException("Invalid checkpoint to ack: checkpoint [" + checkpoint.toString() + "] may have already been committed");
            }
            if (checkpoint.isAcked()) {
                throw new NoSuchElementException("Checkpoint [" + checkpoint + "] has already been acked");
            }
            BaseCheckpoint prev = checkpoint.getPrev();
            BaseCheckpoint next = checkpoint.getNext();
            prev.setNext(next);
            next.setPrev(prev);
            checkpoint.ack();
            --this.count;
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public BaseCheckpoint getFirstNotAckedOrLatestCheckpoint() {
        this.lock.lock();
        try {
            if (this.count == 0) {
                BaseCheckpoint baseCheckpoint = this.latest;
                return baseCheckpoint;
            }
            BaseCheckpoint baseCheckpoint = this.head.getNext();
            return baseCheckpoint;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    private BaseCheckpoint getFirstCheckpoint() {
        if (this.head.getNext() == this.tail) {
            return null;
        }
        return this.head.getNext();
    }

    private BaseCheckpoint getLastCheckpoint() {
        if (this.tail.getPrev() == this.head) {
            return null;
        }
        return this.tail.getPrev();
    }

    @Override
    public Map<String, Object> getMetrics() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put(KEY_CHECKPOINT_QUEUE_CAPACITY, this.capacity);
        this.lock.lock();
        try {
            map.put(KEY_CHECKPOINT_QUEUE_SIZE, this.size());
            if (this.getFirstCheckpoint() != null) {
                map.put(KEY_CHECKPOINT_FIRST, this.getFirstCheckpoint().toString());
            }
            if (this.getLastCheckpoint() != null) {
                map.put(KEY_CHECKPOINT_LAST, this.getLastCheckpoint().toString());
            }
            if (this.latest != null) {
                map.put(KEY_CHECKPOINT_LATEST, this.latest.toString());
            }
            TreeMap<String, Object> treeMap = map;
            return treeMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<BaseCheckpoint> iterator() {
        return new Iterator<BaseCheckpoint>(){
            private BaseCheckpoint current;
            {
                this.current = CheckpointManager.this.head.getNext();
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current != CheckpointManager.this.tail;
            }

            @Override
            public BaseCheckpoint next() {
                CheckpointManager.this.lock.lock();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    BaseCheckpoint ret = this.current;
                    this.current = this.current.getNext();
                    while (this.current != null && this.current != CheckpointManager.this.tail && this.current.isAcked()) {
                        this.current = this.current.getNext();
                    }
                    BaseCheckpoint baseCheckpoint = ret;
                    return baseCheckpoint;
                }
                finally {
                    CheckpointManager.this.lock.unlock();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

