/*
 * Decompiled with CFR 0.152.
 */
package alibaba.drcnet.reactor;

import alibaba.drcnet.buffer.CacheBuff;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.processer.DRCNetProcesser;
import alibaba.drcnet.processer.NetDataProcesser;
import alibaba.drcnet.util.Constant;
import alibaba.drcnet.util.SyncState;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRCNetReactor
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(DRCNetReactor.class);
    CacheBuff sink = null;
    UserConfig userConfig = null;
    SyncState syncState = null;
    NetDataProcesser dataProcesser = null;
    Connection connection = null;
    DRCNetConfig drcnetConfig = null;
    private volatile boolean parentInitOK = false;

    public void setInitOK() {
        this.parentInitOK = true;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        this.dataProcesser.process(ctx, byteBuf, this.userConfig, this.drcnetConfig, this.sink, this.syncState, this.connection);
        byteBuf.release();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int waitCount = 0;
        while (!this.parentInitOK && waitCount++ < 10) {
            Thread.sleep(500L);
        }
        if (!this.parentInitOK) {
            log.error("drc net: parent connection init too long, restart");
            throw new Exception("drc net: parent connection init too long, restart");
        }
        Attribute attr = ctx.channel().attr(Constant.configKey);
        this.userConfig = (UserConfig)attr.get();
        attr = ctx.channel().attr(Constant.cacheBuffer);
        this.sink = (CacheBuff)attr.get();
        attr = ctx.channel().attr(Constant.syncState);
        this.syncState = (SyncState)attr.get();
        attr = ctx.channel().attr(Constant.connection);
        this.connection = (Connection)attr.get();
        attr = ctx.channel().attr(Constant.drcnetConfig);
        this.drcnetConfig = (DRCNetConfig)attr.get();
        if (this.connection == null || this.sink == null || this.syncState == null || this.userConfig == null || null == this.drcnetConfig) {
            log.error("parent atttribute not found");
            throw new Exception("parent atttribute not found");
        }
        if (!this.syncState.isMultiConn) {
            this.dataProcesser = new DRCNetProcesser();
        } else {
            log.warn("mulit thread not supported now");
            this.dataProcesser = new DRCNetProcesser();
        }
        if (this.dataProcesser.initProcesser() < 0) {
            log.error("init process failed");
            throw new Exception("init process failed");
        }
        ctx.fireChannelActive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error(cause.getMessage(), cause);
        ctx.channel().close();
        this.connection.stopConnection();
    }
}

