/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.common;

import com.aliyun.dts.subscribe.clients.common.JDKCharsetMapper;
import com.google.common.primitives.UnsignedBytes;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BytesUtil.class);
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    private static final String UTF8_ENCODING = "UTF-8";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static boolean isValidEncoding(String encoding) {
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            return false;
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)encoding, (CharSequence)"null");
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static byte[] toBytes(float f) {
        return BytesUtil.toBytes(Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(double d) {
        return BytesUtil.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = BytesUtil.putInt(result, 0, val.scale());
        BytesUtil.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        try {
            return s.getBytes(UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UTF-8 not supported?", (Throwable)e);
            return null;
        }
    }

    public static byte[] toBytes(String value, String encoding) throws UnsupportedEncodingException {
        if (value == null) {
            return null;
        }
        String realEncoding = UTF8_ENCODING;
        if (BytesUtil.isValidEncoding(encoding)) {
            realEncoding = encoding;
        }
        try {
            return value.getBytes(realEncoding);
        }
        catch (UnsupportedEncodingException foo) {
            String mappedEncoding = JDKCharsetMapper.getJDKECharset(realEncoding);
            LOGGER.warn("get bytes from from using encoding {} failed, just try to use encoding {} again", (Object)realEncoding, (Object)mappedEncoding);
            return value.getBytes(mappedEncoding);
        }
    }

    public static byte[] toBytes(BigInteger bi) {
        if (bi == null) {
            return null;
        }
        return bi.toByteArray();
    }

    public static long toLong(byte[] bytes) {
        return BytesUtil.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    public static int toInt(byte[] bytes) {
        return BytesUtil.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return BytesUtil.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static boolean toBoolean(byte[] b) {
        return b[0] != 0;
    }

    public static float toFloat(byte[] bytes) {
        return BytesUtil.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(BytesUtil.toInt(bytes, offset, 4));
    }

    public static double toDouble(byte[] bytes) {
        return BytesUtil.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(BytesUtil.toLong(bytes, offset, 8));
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return BytesUtil.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = BytesUtil.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static String toString(byte[] bytes, String encoding) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        String realEncoding = UTF8_ENCODING;
        if (BytesUtil.isValidEncoding(encoding)) {
            realEncoding = encoding;
        }
        try {
            return new String(bytes, realEncoding);
        }
        catch (UnsupportedEncodingException foo) {
            String mappedEncoding = JDKCharsetMapper.getJDKECharset(realEncoding);
            LOGGER.warn("get bytes from from using encoding {} failed, just try to use encoding {} again", (Object)realEncoding, (Object)mappedEncoding);
            return new String(bytes, mappedEncoding);
        }
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        if (left.length == 0) {
            return true;
        }
        if (left[left.length - 1] != right[right.length - 1]) {
            return false;
        }
        return BytesUtil.compareTo(left, right) == 0;
    }

    public static int compareTo(byte[] left, byte[] right) {
        if (left == null) {
            return right == null ? 0 : -1;
        }
        if (right == null) {
            return 1;
        }
        return UnsignedBytes.lexicographicalComparator().compare(left, right);
    }

    public static BigInteger toBigInteger(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new BigInteger(bytes);
    }

    public static String byteBufferToHexString(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder(2 * (byteBuffer.limit() - byteBuffer.position()));
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            byte b = byteBuffer.get(i);
            int lowBits = b & 0xF;
            int highBits = (b & 0xF0) >> 4;
            stringBuilder.append(HEX_DIGITS[highBits]);
            stringBuilder.append(HEX_DIGITS[lowBits]);
        }
        return stringBuilder.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        StringBuilder stringBuilder = new StringBuilder(2 * (byteBuffer.limit() - byteBuffer.position()));
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            byte b = byteBuffer.get(i);
            int lowBits = b & 0xF;
            int highBits = (b & 0xF0) >> 4;
            stringBuilder.append(HEX_DIGITS[highBits]);
            stringBuilder.append(HEX_DIGITS[lowBits]);
        }
        return stringBuilder.toString();
    }

    public static ByteBuffer hexStringToByteBuffer(String hexString) {
        char[] chars = hexString.toCharArray();
        byte byteData = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(chars.length + 1 >> 1);
        for (int i = 0; i < chars.length; ++i) {
            byteData = chars[i] < 'A' ? (byte)(byteData | chars[i] - 48 & 0xF) : (chars[i] < 'a' ? (byte)(byteData | 10 + (chars[i] - 65) & 0xF) : (byte)(byteData | 10 + (chars[i] - 97) & 0xF));
            if (0 != (i & 1)) {
                byteBuffer.put(byteData);
                byteData = 0;
                continue;
            }
            byteData = (byte)(byteData << 4);
        }
        if (0 != (chars.length & 1)) {
            byteBuffer.put(byteData);
        }
        return byteBuffer;
    }

    public static byte[] hexStringToBytes(String hexString) {
        return BytesUtil.hexStringToByteBuffer(hexString).array();
    }
}

