/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.common;

import com.aliyun.dts.subscribe.clients.common.Time;
import com.aliyun.dts.subscribe.clients.exception.CriticalException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtil.class);
    private final String globalJobType;
    private final String objectNameShouldBeRetried;
    private Function<Throwable, Boolean> recoverableChecker;
    private int maxRetryTimes;
    private int freezeInterval;
    private TimeUnit freezeTimeUnit;

    public RetryUtil(String globalJobType, String objectNameShouldBeRetried, int freezeInterval, TimeUnit freezeTimeUnit, int maxRetryTimes, Function<Throwable, Boolean> recoverableChecker) {
        this.globalJobType = globalJobType;
        this.objectNameShouldBeRetried = objectNameShouldBeRetried;
        this.maxRetryTimes = maxRetryTimes;
        this.freezeInterval = freezeInterval;
        this.freezeTimeUnit = freezeTimeUnit;
        this.recoverableChecker = recoverableChecker;
    }

    public RetryUtil(Function<Throwable, Boolean> recoverableChecker) {
        this(5, TimeUnit.SECONDS, 1, recoverableChecker);
    }

    public RetryUtil(int freezeInterval, TimeUnit freezeTimeUnit, int maxRetryTimes, Function<Throwable, Boolean> recoverableChecker) {
        this("unknown", "unknown", freezeInterval, freezeTimeUnit, maxRetryTimes, recoverableChecker);
    }

    public void callFunctionWithRetry(ThrowableFunctionVoid throwableFunction) throws Exception {
        this.callFunctionWithRetry(throwableFunction, null, null);
    }

    public void callFunctionWithRetry(ThrowableFunctionVoid throwableFunction, BiFunction<Throwable, Integer, Boolean> recoverableChecker, Consumer<RetryInfo> retryInfoConsumer) throws Exception {
        this.callFunctionWithRetry(() -> {
            throwableFunction.call();
            return null;
        }, recoverableChecker, retryInfoConsumer);
    }

    public <T> T callFunctionWithRetry(ThrowableFunction<T> throwableFunction) throws Exception {
        return this.callFunctionWithRetry(this.maxRetryTimes, this.freezeInterval, this.freezeTimeUnit, throwableFunction);
    }

    public <T> T callFunctionWithRetry(int maxRetryTimes, int freezeInternal, TimeUnit freezeTimeUnit, ThrowableFunction<T> throwableFunction) throws Exception {
        return this.callFunctionWithRetry(maxRetryTimes, freezeInternal, freezeTimeUnit, throwableFunction, (e, times) -> this.recoverableChecker.apply((Throwable)e), null);
    }

    public <T> T callFunctionWithRetry(ThrowableFunction<T> throwableFunction, BiFunction<Throwable, Integer, Boolean> recoverableChecker, Consumer<RetryInfo> retryInfoConsumer) throws Exception {
        return this.callFunctionWithRetry(this.maxRetryTimes, this.freezeInterval, this.freezeTimeUnit, throwableFunction, recoverableChecker, retryInfoConsumer);
    }

    public <T> T callFunctionWithRetry(int maxRetryTimes, int freezeInternal, TimeUnit freezeTimeUnit, ThrowableFunction<T> throwableFunction, BiFunction<Throwable, Integer, Boolean> recoverableChecker, Consumer<RetryInfo> retryInfoConsumer) throws Exception {
        Throwable error = null;
        RetryInfo retryInfo = null;
        maxRetryTimes = Math.max(1, maxRetryTimes);
        for (int i = 0; i < maxRetryTimes; ++i) {
            try {
                T rs = throwableFunction.call();
                if (null != retryInfo) {
                    retryInfo.endRetry();
                }
                return rs;
            }
            catch (Throwable e) {
                error = e;
                if (!recoverableChecker.apply(e, i).booleanValue()) break;
                if (null == retryInfo) {
                    retryInfo = new RetryInfo(this.globalJobType, this.objectNameShouldBeRetried);
                }
                retryInfo.retry(e);
                LOG.warn("call function {} with {} times failed, try to execute it again", new Object[]{throwableFunction.toString(), retryInfo.getRetryCount(), e});
                freezeTimeUnit.sleep(freezeInternal);
                if (null == retryInfoConsumer) continue;
                retryInfoConsumer.accept(retryInfo);
                continue;
            }
        }
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new CriticalException("common", error);
    }

    public static class RetryInfo {
        private final String retryModule;
        private final String retryTarget;
        private String errMsg;
        private long retryCount;
        private long beginTimestamp;
        private long endTimestamp;

        public RetryInfo(String retryModule, String retryTarget) {
            this.retryModule = retryModule;
            this.retryTarget = retryTarget;
            this.retryCount = 0L;
            this.errMsg = "null";
            this.beginTimestamp = 0L;
            this.endTimestamp = 0L;
        }

        public boolean isRetrying() {
            return 0L != this.beginTimestamp && 0L == this.endTimestamp;
        }

        public long getBeginTimestamp() {
            return this.beginTimestamp;
        }

        void beginRetry() {
            this.beginTimestamp = Time.now();
        }

        void endRetry() {
            this.endTimestamp = Time.now();
        }

        public long getRetryCount() {
            return this.retryCount;
        }

        public void retry(Throwable e) {
            if (0L == this.beginTimestamp) {
                this.beginRetry();
            }
            if (null != e) {
                this.errMsg = e.toString();
            }
            ++this.retryCount;
        }

        public String getRetryModule() {
            return this.retryModule;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public String getRetryTarget() {
            return this.retryTarget;
        }

        public long getRetryTime(TimeUnit unit) {
            long end = 0L == this.endTimestamp ? Time.now() : this.endTimestamp;
            return TimeUnit.MILLISECONDS.convert(end - this.beginTimestamp, unit);
        }
    }

    public static interface ThrowableFunction<T> {
        public T call() throws Exception;
    }

    public static interface ThrowableFunctionVoid {
        public void call() throws Exception;
    }
}

