/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.common.function;

import java.io.Closeable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwallowException<T extends Closeable>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwallowException.class);
    private final T o;

    private SwallowException(T oo) {
        this.o = oo;
    }

    public static <R> R callAndSwallowException(CalleeFunctionWithReturnValue<R> callee) {
        try {
            return callee.call();
        }
        catch (Exception e) {
            LOGGER.info("call function {} failed, and swallow exception", (Object)callee.getClass().getName(), (Object)e);
            return null;
        }
    }

    public static void callAndSwallowException(CalleeFunctionWithoutReturnValue function) {
        SwallowException.callAndSwallowException(() -> {
            function.call();
            return null;
        });
    }

    public static <R> R callAndThrowRuntimeException(CalleeFunctionWithReturnValue<R> callee) {
        try {
            return callee.call();
        }
        catch (Exception e) {
            LOGGER.info("call function {} failed, and swallow exception", (Object)callee.getClass().getName(), (Object)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static void callAndThrowRuntimeException(CalleeFunctionWithoutReturnValue function) {
        SwallowException.callAndThrowRuntimeException(() -> {
            function.call();
            return null;
        });
    }

    public static <R, T extends RuntimeException> R callAndThrowException(CalleeFunctionWithReturnValue<R> callee, Function<Exception, T> exceptionSupplier) {
        try {
            return callee.call();
        }
        catch (Exception e) {
            LOGGER.info("call function {} failed", (Object)callee.getClass().getName(), (Object)e);
            throw (RuntimeException)exceptionSupplier.apply(e);
        }
    }

    public static <T extends RuntimeException> void callAndThrowException(CalleeFunctionWithoutReturnValue function, Function<Exception, T> exceptionSupplier) {
        SwallowException.callAndThrowException(() -> {
            function.call();
            return null;
        }, exceptionSupplier);
    }

    public static <R extends Closeable> SwallowException<R> create(R oo) {
        return new SwallowException<R>(oo);
    }

    public T getObject() {
        return this.o;
    }

    @Override
    public void close() {
        SwallowException.callAndSwallowException(() -> this.o.close());
    }

    public static interface ConsumerFunctionWithoutReturnValue<L> {
        public void call(L var1) throws Exception;
    }

    public static interface CalleeFunctionWithReturnValue<R> {
        public R call() throws Exception;
    }

    public static interface CalleeFunctionWithoutReturnValue {
        public void call() throws Exception;
    }
}

