/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.metastore;

import com.aliyun.dts.subscribe.clients.common.Checkpoint;
import com.aliyun.dts.subscribe.clients.metastore.MetaStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreCenter {
    private static final Logger log = LoggerFactory.getLogger(MetaStoreCenter.class);
    private final Map<String, MetaStore<Checkpoint>> registeredStore = new HashMap<String, MetaStore<Checkpoint>>();

    public void registerStore(String name, MetaStore metaStore) {
        log.info("MetaStoreCenter: register metaStore {}", (Object)name);
        this.registeredStore.put(name, metaStore);
    }

    public void store(TopicPartition topicPartition, String group, Checkpoint value) {
        this.registeredStore.values().forEach(v -> v.serializeTo(topicPartition, group, value));
    }

    public Checkpoint seek(String storeName, TopicPartition tp, String group) {
        MetaStore<Checkpoint> metaStore = this.registeredStore.get(storeName);
        if (null != metaStore) {
            return metaStore.deserializeFrom(tp, group);
        }
        return null;
    }
}

