/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record.value;

import com.aliyun.dts.subscribe.clients.record.value.UnixTimestamp;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import com.aliyun.dts.subscribe.clients.record.value.ValueType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import sun.util.calendar.ZoneInfoFile;

public class DateTime
implements Value<String> {
    private static Map<String, String> timeZoneOffsets = new TreeMap<String, String>();
    private static Set<String> commonEraNames = new HashSet<String>(17);
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();
    public static final String BC = "BC";
    public static final String AD = "AD";
    public static final int SEG_NEGATIVE = 1;
    public static final int SEG_YEAR = 2;
    public static final int SEG_MONTH = 4;
    public static final int SEG_DAY = 8;
    public static final int SEG_HOUR = 16;
    public static final int SEG_MINITE = 32;
    public static final int SEG_SECOND = 64;
    public static final int SEG_NAONS = 128;
    public static final int SEG_TIMEZONE = 256;
    public static final int SEG_COMMON_ERA = 512;
    public static final int SEG_TIME = 112;
    public static final int SEG_TIME_NAONS = 240;
    public static final int SEG_DATE = 14;
    public static final int SEG_DATETIME = 126;
    public static final int SEG_DATETIME_NAONS = 254;
    public static final int SEG_DATETIME_NAONS_TZ = 510;
    public static final int SEG_DATETIME_NAONS_TZ_ERA = 1022;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int naons;
    private String datetime;
    private String timeOffset;
    private String timeZone;
    private String commonEra;
    private int segments;

    public DateTime() {
    }

    public DateTime(String jdbcDatetime, int segments) {
        this.segments = segments;
        this.parseJdbcDatetime(jdbcDatetime);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATETIME;
    }

    @Override
    public String getData() {
        return this.toString();
    }

    public boolean isNegative() {
        return 0 != (this.segments & 1);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        if (year < 0) {
            this.setSegments(1);
        }
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        if (day < 0) {
            this.setSegments(1);
        }
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour < 0) {
            this.setSegments(1);
        }
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute < 0) {
            this.setSegments(1);
        }
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        if (second < 0) {
            this.setSegments(1);
        }
        this.second = second;
    }

    public int getNaons() {
        return this.naons;
    }

    public void setNaons(int naons) {
        if (naons < 0) {
            this.setSegments(1);
        }
        this.naons = naons;
    }

    public String getCommonEra() {
        return this.commonEra;
    }

    public void setCommonEra(String commonEra) {
        if (null != commonEra) {
            this.setSegments(512);
            this.commonEra = commonEra;
        }
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setTimeZone(String timeZone) {
        Triple<Boolean, StringBuilder, StringBuilder> zoneTriple = this.validateAndConvertTimeZone(timeZone);
        if (((Boolean)zoneTriple.getLeft()).booleanValue()) {
            this.timeOffset = ((StringBuilder)zoneTriple.getMiddle()).toString();
            this.timeZone = ((StringBuilder)zoneTriple.getRight()).toString();
        }
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public int getSegments() {
        return this.segments;
    }

    public void setSegments(int segments) {
        this.segments |= segments;
    }

    public void clearSegments(int segments) {
        this.segments &= ~segments;
    }

    @Override
    public String toString() {
        return this.toJdbcString(this.segments);
    }

    public boolean isSet(int segPart) {
        return this.isSet(this.segments, segPart);
    }

    public boolean isSet(int segments, int segPart) {
        return 0 != (segments & segPart);
    }

    public UnixTimestamp toUnixTimestampValue() throws ParseException {
        long timestampSeconds = this.toEpochMilliSeconds() / 1000L;
        int microSeconds = this.getNaons() / 1000;
        return new UnixTimestamp(timestampSeconds, microSeconds);
    }

    public long toUnixTimestamp() throws ParseException {
        return this.toEpochMilliSeconds();
    }

    public long toEpochMilliSeconds() throws ParseException {
        String parseTimeZone = this.getTimeOffset();
        SimpleDateFormat sdf = dateFormat.get();
        if (null == sdf) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            dateFormat.set(sdf);
        }
        String org = this.toJdbcString(254, false);
        String orgEndMilliSecond = StringUtils.substring((String)org, (int)0, (int)(org.length() - 6));
        if (null == parseTimeZone || parseTimeZone.trim().isEmpty()) {
            Date date = sdf.parse(orgEndMilliSecond);
            return date.getTime();
        }
        if (parseTimeZone.startsWith("GMT") && parseTimeZone.substring(3).length() == 5) {
            parseTimeZone = "GMT+0" + parseTimeZone.substring(4);
        }
        if (parseTimeZone.length() == 5) {
            parseTimeZone = "+0" + parseTimeZone.substring(1);
        }
        ZoneId zoneId = ZoneId.of(parseTimeZone);
        TimeZone timeZone = TimeZone.getTimeZone(zoneId);
        if (sdf.getTimeZone() != timeZone) {
            sdf.setTimeZone(timeZone);
        }
        Date date = sdf.parse(orgEndMilliSecond);
        return date.getTime();
    }

    public String toJdbcString(int segments) {
        return this.toJdbcString(segments, true);
    }

    private String toJdbcString(int segments, boolean trimTrailingZero) {
        StringBuffer datatimeBuf = new StringBuffer(32);
        if (this.isSet(segments, 2)) {
            int yearV = this.year > 0 ? this.year : -this.year;
            String yearZeros = "0000";
            String yearString = Integer.toString(yearV);
            if (yearV < 1000) {
                yearString = yearZeros.substring(0, 4 - yearString.length()) + yearString;
            }
            datatimeBuf.append(yearString);
        }
        if (this.isSet(segments, 4)) {
            int monthV;
            datatimeBuf.append("-");
            int n = monthV = this.month > 0 ? this.month : -this.month;
            if (monthV < 10) {
                datatimeBuf.append("0").append(monthV);
            } else {
                datatimeBuf.append(monthV);
            }
        }
        if (this.isSet(segments, 8)) {
            int dayV;
            if (datatimeBuf.length() > 0) {
                datatimeBuf.append("-");
            }
            int n = dayV = this.day > 0 ? this.day : -this.day;
            if (dayV < 10) {
                datatimeBuf.append("0").append(dayV);
            } else {
                datatimeBuf.append(dayV);
            }
        }
        if (this.isSet(segments, 16)) {
            int hourV;
            if (datatimeBuf.length() > 0) {
                datatimeBuf.append(" ");
            }
            int n = hourV = this.hour > 0 ? this.hour : -this.hour;
            if (hourV < 10) {
                datatimeBuf.append("0").append(hourV);
            } else {
                datatimeBuf.append(hourV);
            }
        }
        if (this.isSet(segments, 32)) {
            int minuteV;
            datatimeBuf.append(":");
            int n = minuteV = this.minute > 0 ? this.minute : -this.minute;
            if (minuteV < 10) {
                datatimeBuf.append("0").append(minuteV);
            } else {
                datatimeBuf.append(minuteV);
            }
        }
        if (this.isSet(segments, 64)) {
            int secondV;
            datatimeBuf.append(":");
            int n = secondV = this.second > 0 ? this.second : -this.second;
            if (secondV < 10) {
                datatimeBuf.append("0").append(secondV);
            } else {
                datatimeBuf.append(secondV);
            }
        }
        if (this.isSet(segments, 128)) {
            int prefixPadZeroNumber;
            int naonsV = this.naons > 0 ? this.naons : -this.naons;
            int trailZeroCount = 0;
            int remainingNumberCount = 0;
            if (0 == naonsV) {
                trailZeroCount = 8;
                remainingNumberCount = 1;
            } else {
                while (0 == naonsV % 10) {
                    ++trailZeroCount;
                    naonsV /= 10;
                }
                for (int tmp = naonsV; tmp > 0; tmp /= 10) {
                    ++remainingNumberCount;
                }
            }
            if (!trimTrailingZero) {
                datatimeBuf.append(".");
                for (prefixPadZeroNumber = 9 - trailZeroCount - remainingNumberCount; prefixPadZeroNumber > 0; --prefixPadZeroNumber) {
                    datatimeBuf.append("0");
                }
                datatimeBuf.append(naonsV);
                while (trailZeroCount > 0) {
                    datatimeBuf.append('0');
                    --trailZeroCount;
                }
            } else if (0 != naonsV) {
                datatimeBuf.append(".");
                for (prefixPadZeroNumber = 9 - trailZeroCount - remainingNumberCount; prefixPadZeroNumber > 0; --prefixPadZeroNumber) {
                    datatimeBuf.append("0");
                }
                datatimeBuf.append(naonsV);
            }
        }
        if (this.isSet(segments, 256) && this.timeOffset != null) {
            datatimeBuf.append(" ").append(this.timeOffset);
        }
        if (this.isSet(segments, 512) && null != this.commonEra) {
            datatimeBuf.append(" ").append(this.commonEra);
        }
        if (this.isSet(segments, 1)) {
            return "-" + datatimeBuf.toString();
        }
        return datatimeBuf.toString();
    }

    protected final int upMicroToNaons(int time, int n) {
        for (int i = 0; i < n; ++i) {
            time *= 10;
        }
        return time;
    }

    Triple<Boolean, StringBuilder, StringBuilder> validateAndConvertTimeZone(String timeZone) {
        StringBuilder tzSbl;
        StringBuilder sbl;
        boolean isLegalTimeZone;
        block41: {
            if (StringUtils.isEmpty((CharSequence)timeZone)) {
                return Triple.of((Object)false, null, null);
            }
            isLegalTimeZone = false;
            int index = 0;
            int totalLength = timeZone.length();
            sbl = new StringBuilder(16);
            tzSbl = new StringBuilder(16);
            char charValue = timeZone.charAt(index);
            switch (charValue) {
                case 'G': {
                    if ('M' == timeZone.charAt(++index) && 'T' == timeZone.charAt(++index)) {
                        tzSbl.append("GMT");
                        ++index;
                        break;
                    }
                    break block41;
                }
                case 'U': {
                    if ('T' == timeZone.charAt(++index) && 'C' == timeZone.charAt(++index)) {
                        tzSbl.append("UTC");
                        ++index;
                        break;
                    }
                    break block41;
                }
                case '+': 
                case '-': {
                    tzSbl.append("GMT");
                    break;
                }
                default: {
                    if ('0' <= charValue && '9' >= charValue) {
                        tzSbl.append("GMT");
                        break;
                    }
                    String tmpOffset = timeZoneOffsets.getOrDefault(timeZone.toLowerCase(), null);
                    if (null != tmpOffset) {
                        isLegalTimeZone = true;
                        sbl.append(tmpOffset);
                        tzSbl.append(timeZone);
                    }
                    break block41;
                }
            }
            int processingState = 0;
            block23: while (index < totalLength) {
                charValue = timeZone.charAt(index++);
                switch (processingState) {
                    case 0: {
                        if (' ' == charValue) {
                            processingState = 0;
                            continue block23;
                        }
                        if ('+' == charValue || '-' == charValue) {
                            sbl.append(charValue);
                            processingState = 1;
                            continue block23;
                        }
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append("+");
                            sbl.append(charValue);
                            processingState = 2;
                            continue block23;
                        }
                        break block41;
                    }
                    case 1: {
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append(charValue);
                            processingState = 2;
                            continue block23;
                        }
                        break block41;
                    }
                    case 2: {
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append(charValue);
                            processingState = 3;
                            continue block23;
                        }
                        if (':' == charValue) {
                            sbl.insert(sbl.length() - 1, '0');
                            sbl.append(charValue);
                            processingState = 4;
                            continue block23;
                        }
                        break block41;
                    }
                    case 3: {
                        if (':' == charValue) {
                            sbl.append(charValue);
                            processingState = 4;
                            continue block23;
                        }
                        break block41;
                    }
                    case 4: {
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append(charValue);
                            processingState = 5;
                            continue block23;
                        }
                        break block41;
                    }
                    case 5: {
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append(charValue);
                            processingState = 6;
                            continue block23;
                        }
                        break block41;
                    }
                    case 6: {
                        if (':' == charValue) {
                            processingState = 7;
                            sbl.append(charValue);
                            continue block23;
                        }
                        break block41;
                    }
                    case 7: {
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append(charValue);
                            processingState = 8;
                            continue block23;
                        }
                        break block41;
                    }
                    case 8: {
                        if ('0' <= charValue && '9' >= charValue) {
                            sbl.append(charValue);
                            processingState = 9;
                            continue block23;
                        }
                        break block41;
                    }
                }
                break block41;
            }
            switch (processingState) {
                case 0: {
                    sbl.append('+');
                    sbl.append('0');
                }
                case 2: {
                    sbl.insert(sbl.length() - 1, '0');
                }
                case 3: {
                    sbl.append(":00");
                    tzSbl.append((CharSequence)sbl);
                    isLegalTimeZone = true;
                    break;
                }
                case 5: 
                case 8: {
                    sbl.insert(sbl.length() - 1, '0');
                }
                case 6: 
                case 9: {
                    tzSbl.append((CharSequence)sbl);
                    isLegalTimeZone = true;
                }
            }
        }
        return Triple.of((Object)isLegalTimeZone, (Object)sbl, (Object)tzSbl);
    }

    protected void parseJdbcDatetime(String datetime) {
        String commonEra;
        if (null == datetime || datetime.trim().isEmpty()) {
            throw new IllegalArgumentException("datetime is null or empty.");
        }
        if (this.isSet(512) && datetime.length() > 2 && commonEraNames.contains(commonEra = datetime.substring(datetime.length() - 2))) {
            this.setCommonEra(commonEra);
            datetime = datetime.substring(0, datetime.length() - 2).trim();
        }
        if (this.isSet(256)) {
            String rawTimeZone;
            Triple<Boolean, StringBuilder, StringBuilder> normalizedTimeZone;
            int index = -1;
            for (int i = datetime.length() - 1; i >= 0; --i) {
                char lc;
                char c = datetime.charAt(i);
                if (' ' != c && '+' != c && '-' != c || i > 1 && ((lc = datetime.charAt(i - 1)) >= 'a' && lc <= 'z' || lc >= 'A' && lc <= 'Z')) continue;
                index = i;
                break;
            }
            if (index >= 0 && ((Boolean)(normalizedTimeZone = this.validateAndConvertTimeZone((rawTimeZone = datetime.substring(index)).trim())).getLeft()).booleanValue()) {
                this.timeOffset = ((StringBuilder)normalizedTimeZone.getMiddle()).toString();
                this.timeZone = ((StringBuilder)normalizedTimeZone.getRight()).toString();
                datetime = datetime.substring(0, datetime.length() - rawTimeZone.length()).trim();
            }
        }
        int[] ret = new int[7];
        int j = 0;
        int m = 0;
        int n = 0;
        byte[] bytes = datetime.getBytes();
        boolean microMode = false;
        for (int i = 0; i < bytes.length && j < bytes.length; ++i) {
            if (48 <= bytes[i] && 57 >= bytes[i]) {
                m *= 10;
                m += bytes[i] - 48;
                ++n;
                continue;
            }
            if (false == n) continue;
            ret[j] = m;
            if (microMode) {
                ret[j] = this.upMicroToNaons(m, 9 - n);
            }
            m = 0;
            n = 0;
            ++j;
            microMode = 46 == bytes[i];
        }
        if (n != 0) {
            ret[j] = m;
            if (microMode) {
                ret[j] = this.upMicroToNaons(m, 9 - n);
            }
        }
        int index = 0;
        if (this.isSet(2)) {
            this.setYear(ret[index++]);
        }
        if (this.isSet(4)) {
            this.setMonth(ret[index++]);
        }
        if (this.isSet(8)) {
            this.setDay(ret[index++]);
        }
        if (this.isSet(16)) {
            this.setHour(ret[index++]);
        }
        if (this.isSet(32)) {
            this.setMinute(ret[index++]);
        }
        if (this.isSet(64)) {
            this.setSecond(ret[index++]);
        }
        if (this.isSet(128)) {
            this.setNaons(ret[index++]);
        }
        if (45 == bytes[0]) {
            this.setSegments(1);
        }
    }

    public static boolean isZeroDate(String value) {
        return "0000-00-00".equalsIgnoreCase(value) || "0000-00-00 00:00:00".equalsIgnoreCase(value) || "0000-00-00 00:00:00.0".equalsIgnoreCase(value) || "0000-00-00 00:00:00.00".equalsIgnoreCase(value) || "0000-00-00 00:00:00.000".equalsIgnoreCase(value) || "0000-00-00 00:00:00.0000".equalsIgnoreCase(value) || "0000-00-00 00:00:00.00000".equalsIgnoreCase(value) || "0000-00-00 00:00:00.000000".equalsIgnoreCase(value);
    }

    @Override
    public long size() {
        return StringUtils.length((CharSequence)this.datetime) + StringUtils.length((CharSequence)this.timeOffset) + 32;
    }

    static {
        for (Map.Entry<String, String> kv : ZoneInfoFile.getAliasMap().entrySet()) {
            StringBuilder sbl = new StringBuilder(16);
            String tzID = kv.getKey();
            TimeZone zone = TimeZone.getTimeZone(tzID);
            int rawOffset = zone.getRawOffset();
            sbl.append(rawOffset < 0 ? (char)'-' : '+');
            long minutes = TimeUnit.MILLISECONDS.toMinutes(rawOffset);
            sbl.append(TimeUnit.MINUTES.toHours(minutes));
            if (sbl.length() < 3) {
                sbl.insert(sbl.length() - 1, '0');
            }
            sbl.append(":").append(minutes % 60L);
            if (sbl.length() < 6) {
                sbl.insert(sbl.length(), '0');
            }
            String timeOffset = sbl.toString();
            timeZoneOffsets.put(kv.getKey().toLowerCase(), timeOffset);
            timeZoneOffsets.put(kv.getValue().toLowerCase(), timeOffset);
        }
        commonEraNames.add(AD);
        commonEraNames.add("ad");
        commonEraNames.add("bc");
        commonEraNames.add(BC);
        commonEraNames.add(" AD");
        commonEraNames.add(" ad");
        commonEraNames.add(" bc");
        commonEraNames.add(" BC");
    }
}

