/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvocationContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;

public class RemotingHelper {
    public static final String ROCKETMQ_REMOTING = "RocketmqRemoting";
    public static final String ROCKETMQ_TRAFFIC = "RocketmqTraffic";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    public static final ThreadLocal<InvocationContext> THREAD_LOCAL = new ThreadLocal();

    public static String exceptionSimpleDesc(Throwable e) {
        StringBuffer sb = new StringBuffer();
        if (e != null) {
            sb.append(e.toString());
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                StackTraceElement elment = stackTrace[0];
                sb.append(", ");
                sb.append(elment.toString());
            }
        }
        return sb.toString();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        String[] s = addr.split(":");
        InetSocketAddress isa = new InetSocketAddress(s[0], Integer.parseInt(s[1]));
        return isa;
    }

    public static RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        long beginTime = System.currentTimeMillis();
        SocketAddress socketAddress = RemotingUtil.string2SocketAddress(addr);
        SocketChannel socketChannel = RemotingUtil.connect(socketAddress);
        if (socketChannel != null) {
            boolean sendRequestOK = false;
            try {
                socketChannel.configureBlocking(true);
                socketChannel.socket().setSoTimeout((int)timeoutMillis);
                ByteBuffer byteBufferRequest = request.encode();
                while (byteBufferRequest.hasRemaining()) {
                    int length = socketChannel.write(byteBufferRequest);
                    if (length > 0) {
                        if (byteBufferRequest.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingSendRequestException(addr);
                        }
                    } else {
                        throw new RemotingSendRequestException(addr);
                    }
                    Thread.sleep(1L);
                }
                sendRequestOK = true;
                ByteBuffer byteBufferSize = ByteBuffer.allocate(4);
                while (byteBufferSize.hasRemaining()) {
                    int length = socketChannel.read(byteBufferSize);
                    if (length > 0) {
                        if (byteBufferSize.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                int size = byteBufferSize.getInt(0);
                ByteBuffer byteBufferBody = ByteBuffer.allocate(size);
                while (byteBufferBody.hasRemaining()) {
                    int length = socketChannel.read(byteBufferBody);
                    if (length > 0) {
                        if (byteBufferBody.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                byteBufferBody.flip();
                RemotingCommand remotingCommand = RemotingCommand.decode(byteBufferBody);
                return remotingCommand;
            }
            catch (IOException e) {
                log.error("invokeSync failure", e);
                if (sendRequestOK) {
                    throw new RemotingTimeoutException(addr, timeoutMillis);
                }
                throw new RemotingSendRequestException(addr);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new RemotingConnectException(addr);
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        if (socketAddress != null) {
            String addr = socketAddress.toString();
            if (addr.contains("/")) {
                int pos = addr.indexOf(47);
                return addr.substring(pos + 1);
            }
            return socketAddress.toString();
        }
        return "";
    }

    public static void updateInvocationContextForMetrics(String key, String value) {
        InvocationContext invocationContext = THREAD_LOCAL.get();
        if (invocationContext == null) {
            invocationContext = new InvocationContext();
            HashMap<String, String> metricsData = new HashMap<String, String>();
            metricsData.put(key, value);
            invocationContext.setMetrics(metricsData);
            THREAD_LOCAL.set(invocationContext);
            return;
        }
        invocationContext.getMetrics().put(key, value);
    }

    public static void removeThreadLocal() {
        THREAD_LOCAL.remove();
    }

    public static int ipToInt(String ip) {
        String[] ips = ip.split("\\.");
        return Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
    }

    public static boolean ipInCIDR(String ip, String cidr) {
        int cidrIpAddr;
        String[] cidrArr;
        int netId;
        int mask;
        int ipAddr = RemotingHelper.ipToInt(ip);
        return (ipAddr & (mask = -1 << 32 - (netId = Integer.parseInt((cidrArr = cidr.split("/"))[1])))) == ((cidrIpAddr = RemotingHelper.ipToInt(cidrArr[0])) & mask);
    }
}

