/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.FailoverRetryPolicy;
import org.apache.calcite.avatica.remote.ProtobufService;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HARemoteProtobufService
extends ProtobufService {
    private static final Logger LOG = LoggerFactory.getLogger(HARemoteProtobufService.class);
    private final AvaticaHttpClient client;
    private final ProtobufTranslation translation;
    private final FailoverRetryPolicy retryPolicy;

    public HARemoteProtobufService(AvaticaHttpClient client, ProtobufTranslation translation, FailoverRetryPolicy retryPolicy) {
        this.client = client;
        this.translation = translation;
        this.retryPolicy = retryPolicy;
    }

    public Service.Response _apply(Service.Request request) {
        Service.Response resp;
        byte[] response;
        try {
            while (true) {
                try {
                    response = this.client.send(this.translation.serializeRequest(request));
                }
                catch (Exception e) {
                    LOG.warn("Retrying remote request " + this.retryPolicy.getRetries() + " times...", (Throwable)e);
                    if (this.retryPolicy.awaitUntilNextRetry(e.getCause())) continue;
                    throw e;
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to execute remote request: {}", (Object)request);
            throw new RuntimeException(e);
        }
        try {
            resp = this.translation.parseResponse(response);
        }
        catch (IOException e) {
            LOG.warn("Failed to deserialize reponse to {}. '{}'", (Object)request, (Object)new String(response, StandardCharsets.UTF_8));
            throw new RuntimeException(e);
        }
        if (resp instanceof Service.ErrorResponse) {
            throw ((Service.ErrorResponse)resp).toException();
        }
        return resp;
    }
}

