/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.support;

import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.SerializationUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

public class SerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    private Class<?> capturingClass;
    private String functionalInterfaceClass;
    private String functionalInterfaceMethodName;
    private String functionalInterfaceMethodSignature;
    private String implClass;
    private String implMethodName;
    private String implMethodSignature;
    private int implMethodKind;
    private String instantiatedMethodType;
    private Object[] capturedArgs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SerializedLambda resolve(SFunction lambda) {
        if (!lambda.getClass().isSynthetic()) {
            throw ExceptionUtils.mpe("\u8be5\u65b9\u6cd5\u4ec5\u80fd\u4f20\u5165 lambda \u8868\u8fbe\u5f0f\u4ea7\u751f\u7684\u5408\u6210\u7c7b", new Object[0]);
        }
        try (ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(SerializationUtils.serialize(lambda))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class<?> clazz = super.resolveClass(objectStreamClass);
                return clazz == java.lang.invoke.SerializedLambda.class ? SerializedLambda.class : clazz;
            }
        };){
            SerializedLambda serializedLambda = (SerializedLambda)objIn.readObject();
            return serializedLambda;
        }
        catch (IOException | ClassNotFoundException e) {
            throw ExceptionUtils.mpe("This is impossible to happen", e, new Object[0]);
        }
    }

    public String getFunctionalInterfaceClassName() {
        return this.normalName(this.functionalInterfaceClass);
    }

    public Class getImplClass() {
        return ClassUtils.toClassConfident(this.getImplClassName());
    }

    public String getImplClassName() {
        return this.normalName(this.implClass);
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    private String normalName(String name) {
        return name.replace('/', '.');
    }

    public String toString() {
        return String.format("%s -> %s::%s", this.getFunctionalInterfaceClassName(), this.getImplClass().getSimpleName(), this.implMethodName);
    }
}

