/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.EnableCommonReqParams;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetVirtualWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutVirtualWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.VirtualWarehouseVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseVirtualWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.yunxi.dg.base.center.report.api.share.IDgVirtualWarehouseApi;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehousePageReqDto;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_virtual_warehouse")
public class InventoryCenterBaseWarehouseVirtualWarehouseServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterBaseWarehouseVirtualWarehouseService {
    @Resource
    private IDgVirtualWarehouseApi dgVirtualWarehouseApi;
    @Autowired
    IVirtualWarehouseApi virtualWarehouseApi;

    @Override
    public RestResponse<VirtualWarehouseVO> getVirtualWarehouseById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5e97\u94fa\u6e20\u9053\u4e0d\u5b58\u5728");
        }
        DgVirtualWarehouseDto respDto = (DgVirtualWarehouseDto)RestResponseHelper.extractData((RestResponse)this.dgVirtualWarehouseApi.get(Long.valueOf(id)));
        VirtualWarehouseVO vo = new VirtualWarehouseVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setWarehouseId(ParamConverter.convertToString((Object)respDto.getId()));
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (respDto.getUpdateTime() != null) {
            vo.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setWarehouseType(WarehouseClassifyEnum.VIRTUAL.getCode());
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<VirtualWarehouseVO>> getVirtualWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetVirtualWarehouseListPageParams getVirtualWarehouseListPageParams) {
        DgVirtualWarehousePageReqDto reqDto = new DgVirtualWarehousePageReqDto();
        BeanUtils.copyProperties((Object)getVirtualWarehouseListPageParams, (Object)reqDto);
        if (ObjectUtils.isNotEmpty((Object)getVirtualWarehouseListPageParams.getWarehouseGroupId())) {
            reqDto.setGroupId(getVirtualWarehouseListPageParams.getWarehouseGroupId());
        }
        reqDto.setWarehouseType(ParamConverter.convertToInteger((Object)getVirtualWarehouseListPageParams.getIsMainVirtualWarehouse()));
        reqDto.setRelChannelWarehouseName(getVirtualWarehouseListPageParams.getSubWarehouseName());
        reqDto.setRelChannelWarehouseCode(getVirtualWarehouseListPageParams.getSubWarehouseCode());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgVirtualWarehouseApi.page(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            VirtualWarehouseVO vo = new VirtualWarehouseVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setWarehouseId(ParamConverter.convertToString((Object)o.getId()));
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setIsMainVirtualWarehouse(ParamConverter.convertToString((Object)o.getWarehouseType()));
            vo.setWarehouseType(WarehouseClassifyEnum.VIRTUAL.getCode());
            vo.setWarehouseGroupId(ParamConverter.convertToString((Object)o.getGroupId()));
            vo.setWarehouseGroupName(o.getGroupName());
            vo.setSubWarehouseName(o.getSubWarehouseName());
            vo.setSubChannelWarehouseName(o.getRelChannelWarehouseName());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetVirtualWarehouseListPageParams params = new GetVirtualWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetVirtualWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetVirtualWarehouseListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getVirtualWarehouseListPage((GetVirtualWarehouseListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutVirtualWarehouseVO vo = new OutVirtualWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setSubWarehouseName(o.getSubChannelWarehouseName());
                vo.setWarehouseType(Optional.ofNullable(o.getWarehouseType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "physics": {
                            return "\u7269\u7406\u4ed3";
                        }
                        case "logic": {
                            return "\u903b\u8f91\u4ed3";
                        }
                        case "virtual": {
                            return "\u865a\u62df\u4ed3";
                        }
                        case "channel": {
                            return "\u6e20\u9053\u4ed3";
                        }
                        case "in_transit": {
                            return "\u5728\u9014\u4ed3";
                        }
                    }
                    return o.getWarehouseType();
                }).orElse(""));
                vo.setWarehouseStatus(Optional.ofNullable(o.getWarehouseStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "disable": {
                            return "\u65e0\u6548";
                        }
                        case "enable": {
                            return "\u6709\u6548";
                        }
                    }
                    return o.getWarehouseStatus();
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutVirtualWarehouseVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetVirtualWarehouseListPageParams params = new GetVirtualWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetVirtualWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetVirtualWarehouseListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getVirtualWarehouseListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Void> addVirtualWarehouse(VirtualWarehouseReqDto virtualWarehouseReqDto) {
        if (virtualWarehouseReqDto.getId() == null) {
            Assert.isTrue((!StringUtils.isBlank((CharSequence)virtualWarehouseReqDto.getWarehouseCode()) ? 1 : 0) != 0, (String)"100002", (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u7a7a");
            RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApi.addVirtualWarehouse(virtualWarehouseReqDto));
        } else {
            RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApi.modifyVirtualWarehouse(virtualWarehouseReqDto));
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> setMainVirtualWarehouse(EnableCommonReqParams enableCommonReqParams) {
        VirtualWarehouseRespDto virtualWarehouseRespDto = (VirtualWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApi.queryById(enableCommonReqParams.getId()));
        VirtualWarehouseReqDto virtualWarehouseReqDto = (VirtualWarehouseReqDto)BeanUtil.copyProperties((Object)virtualWarehouseRespDto, VirtualWarehouseReqDto.class, (String[])new String[0]);
        virtualWarehouseReqDto.setWarehouseType(enableCommonReqParams.getStatus());
        RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApi.modifyVirtualWarehouse(virtualWarehouseReqDto));
        return RestResponse.VOID;
    }
}

