/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.BatchSharedInventoryParams;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetSharedInventoryListPageParams;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseShareRatioVO;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.SharedInventoryVO;
import com.dtyunxi.cis.pms.biz.model.SubmitSharedInventoryParams;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterSharedInventoryService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySharedTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IInventorySharedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IInventorySharedItemApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IInventorySharedWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterSharedInventoryServiceServiceImpl
implements InventoryCenterSharedInventoryService {
    @Resource
    private IInventorySharedApi csInventorySharedApi;
    @Resource
    private IInventorySharedApi csInventorySharedQueryApi;
    @Resource
    private IInventorySharedItemApi csInventorySharedItemQueryApi;
    @Resource
    private IInventorySharedWarehouseApi csInventorySharedWarehouseQueryApi;

    @Override
    public RestResponse<Object> addSharedInventory(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitSharedInventoryParams submitSharedInventoryParams) {
        InventorySharedReqDto reqDto = DtoExchangeUtils.createDtoBySource(submitSharedInventoryParams, InventorySharedReqDto.class);
        this.getSharedInfo(submitSharedInventoryParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInventorySharedApi.addInventoryShared(reqDto)));
    }

    private void getSharedInfo(SubmitSharedInventoryParams submitSharedInventoryParams, InventorySharedReqDto reqDto) {
        List<LogicalWarehouseVO> warehouseList;
        reqDto.setSharedCode(submitSharedInventoryParams.getStrategyCode());
        reqDto.setSharedName(submitSharedInventoryParams.getStrategyName());
        reqDto.setVirtualWarehouseCode(submitSharedInventoryParams.getMainVirtualWarehouseCode());
        reqDto.setVirtualWarehouseName(submitSharedInventoryParams.getMainVirtualWarehouseName());
        reqDto.setSharedStatus(submitSharedInventoryParams.getStrategyStatus());
        reqDto.setSharedNumerical(ParamConverter.convertToBigDecimal((Object)submitSharedInventoryParams.getBatchSharedRatio()));
        reqDto.setSharedItemScope(submitSharedInventoryParams.getApplicableGoodsType());
        reqDto.setSharedType(CsInventorySharedTypeEnum.RATIO.getCode());
        List<GoodsVO> goodsList = submitSharedInventoryParams.getApplicableGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            List itemAddReqDtos = goodsList.stream().map(o -> {
                InventorySharedItemReqDto itemAddReqDto = new InventorySharedItemReqDto();
                itemAddReqDto.setSharedCode(submitSharedInventoryParams.getStrategyCode());
                itemAddReqDto.setSharedName(submitSharedInventoryParams.getStrategyName());
                itemAddReqDto.setStatus(o.getGoodsStatus());
                itemAddReqDto.setSkuCode(o.getGoodsLongCode());
                itemAddReqDto.setSkuName(o.getGoodsName());
                return itemAddReqDto;
            }).collect(Collectors.toList());
            reqDto.setSharedItemList(itemAddReqDtos);
        }
        if (CollectionUtils.isNotEmpty(warehouseList = submitSharedInventoryParams.getApplicableLogicalWarehouseList())) {
            List warehouseAddReqDtoList = warehouseList.stream().map(o -> {
                InventorySharedWarehouseReqDto warehouseAddReqDto = new InventorySharedWarehouseReqDto();
                warehouseAddReqDto.setSharedCode(submitSharedInventoryParams.getStrategyCode());
                warehouseAddReqDto.setSharedName(submitSharedInventoryParams.getStrategyName());
                warehouseAddReqDto.setStatus(o.getWarehouseStatus());
                warehouseAddReqDto.setWarehouseCode(o.getWarehouseCode());
                warehouseAddReqDto.setWarehouseName(o.getWarehouseName());
                return warehouseAddReqDto;
            }).collect(Collectors.toList());
            reqDto.setWarehouseList(warehouseAddReqDtoList);
        }
    }

    @Override
    public RestResponse<Object> batchUpdateSharedInventoryStatus(@ApiParam(value="") @Valid @RequestBody(required=false) BatchSharedInventoryParams batchSharedInventoryParams) {
        if (CollectionUtils.isEmpty(batchSharedInventoryParams.getStrategyIds())) {
            throw new BizException("\u7b56\u7565code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ids = batchSharedInventoryParams.getStrategyIds().stream().collect(Collectors.joining(","));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInventorySharedApi.modifyInventorySharedStatus(ids, batchSharedInventoryParams.getStrategyStatus())));
    }

    @Override
    public RestResponse<Object> deleteSharedInventory(@ApiParam(value="") @Valid @RequestBody(required=false) BatchSharedInventoryParams batchSharedInventoryParams) {
        if (CollectionUtils.isEmpty(batchSharedInventoryParams.getStrategyIds())) {
            throw new BizException("\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ids = batchSharedInventoryParams.getStrategyIds().stream().collect(Collectors.joining(","));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInventorySharedApi.removeInventoryShared(ids)));
    }

    @Override
    public RestResponse<SharedInventoryVO> getSharedInventoryById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponse restResponse = this.csInventorySharedQueryApi.queryById(ParamConverter.convertToLong((Object)id));
        InventorySharedRespDto respDto = (InventorySharedRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (respDto != null) {
            List warehouseList;
            SharedInventoryVO vo = DtoExchangeUtils.createDtoBySource(respDto, SharedInventoryVO.class);
            vo.setStrategyCode(respDto.getSharedCode());
            vo.setStrategyName(respDto.getSharedName());
            vo.setStrategyStatus(respDto.getSharedStatus());
            vo.setStrategyId(ParamConverter.convertToString((Object)respDto.getId()));
            vo.setMainVirtualWarehouseCode(respDto.getVirtualWarehouseCode());
            vo.setMainVirtualWarehouseName(respDto.getVirtualWarehouseName());
            vo.setApplicableGoodsType(respDto.getSharedItemScope());
            if (respDto.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (respDto.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setBatchSharedRatio(respDto.getSharedNumerical() != null ? respDto.getSharedNumerical().setScale(0, 1).toString() : null);
            if (CollectionUtils.isNotEmpty((Collection)respDto.getSharedItemList())) {
                List<GoodsVO> goodsVOS = respDto.getSharedItemList().stream().map(o -> {
                    GoodsVO goodsVO = new GoodsVO();
                    BeanUtils.copyProperties((Object)o, (Object)goodsVO);
                    goodsVO.setGoodsLongCode(o.getSkuCode());
                    goodsVO.setGoodsSku(o.getSkuCode());
                    goodsVO.setGoodsName(o.getSkuName());
                    return goodsVO;
                }).collect(Collectors.toList());
                vo.setApplicableGoodsList(goodsVOS);
            }
            if (CollectionUtils.isNotEmpty((Collection)(warehouseList = respDto.getWarehouseList()))) {
                List<LogicalWarehouseShareRatioVO> warehouseShareRatioVOs = warehouseList.stream().map(o -> {
                    LogicalWarehouseShareRatioVO warehouseShareRatioVO = new LogicalWarehouseShareRatioVO();
                    BeanUtils.copyProperties((Object)o, (Object)warehouseShareRatioVO);
                    warehouseShareRatioVO.setWarehouseCode(o.getWarehouseCode());
                    warehouseShareRatioVO.setWarehouseName(o.getWarehouseName());
                    warehouseShareRatioVO.setWarehouseStatus(o.getStatus());
                    return warehouseShareRatioVO;
                }).collect(Collectors.toList());
                vo.setApplicableLogicalWarehouseList(warehouseShareRatioVOs);
            }
            return new RestResponse((Object)vo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<SharedInventoryVO>> getSharedInventoryListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSharedInventoryListPageParams getSharedInventoryListPageParams) {
        InventorySharedReqDto queryDto = new InventorySharedReqDto();
        BeanUtils.copyProperties((Object)getSharedInventoryListPageParams, (Object)queryDto);
        queryDto.setSharedCode(getSharedInventoryListPageParams.getStrategyCode());
        queryDto.setSharedName(getSharedInventoryListPageParams.getStrategyName());
        queryDto.setSharedStatus(getSharedInventoryListPageParams.getStrategyStatus());
        queryDto.setVirtualWarehouseName(getSharedInventoryListPageParams.getMainVirtualWarehouseName());
        queryDto.setVirtualWarehouseCode(getSharedInventoryListPageParams.getMainVirtualWarehouseCode());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventorySharedQueryApi.queryByPage(JSON.toJSONString((Object)queryDto), getSharedInventoryListPageParams.getPageNum(), getSharedInventoryListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            SharedInventoryVO vo = new SharedInventoryVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setStrategyCode(o.getSharedCode());
            vo.setStrategyName(o.getSharedName());
            vo.setStrategyStatus(o.getSharedStatus());
            vo.setMainVirtualWarehouseName(o.getVirtualWarehouseName());
            vo.setMainVirtualWarehouseCode(o.getVirtualWarehouseCode());
            vo.setStrategyId(ParamConverter.convertToString((Object)o.getId()));
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (CollectionUtils.isNotEmpty((Collection)o.getWarehouseList())) {
                ArrayList logicalWarehouseShareRatioList = Lists.newArrayList();
                for (InventorySharedWarehouseRespDto inventorySharedWarehouseRespDto : o.getWarehouseList()) {
                    LogicalWarehouseShareRatioVO logicalWarehouseShareRatioVO = new LogicalWarehouseShareRatioVO();
                    logicalWarehouseShareRatioVO.setWarehouseCode(inventorySharedWarehouseRespDto.getWarehouseCode());
                    logicalWarehouseShareRatioVO.setWarehouseName(inventorySharedWarehouseRespDto.getWarehouseName());
                    logicalWarehouseShareRatioList.add(logicalWarehouseShareRatioVO);
                }
                vo.setApplicableLogicalWarehouseList(logicalWarehouseShareRatioList);
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateSharedInventory(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitSharedInventoryParams submitSharedInventoryParams) {
        InventorySharedReqDto reqDto = DtoExchangeUtils.createDtoBySource(submitSharedInventoryParams, InventorySharedReqDto.class);
        reqDto.setId(ParamConverter.convertToLong((Object)submitSharedInventoryParams.getStrategyId()));
        this.getSharedInfo(submitSharedInventoryParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csInventorySharedApi.modifyInventoryShared(reqDto)));
    }

    @Override
    public RestResponse<Void> syncInventory(Long id) {
        return this.csInventorySharedApi.syncInventory(id);
    }
}

