/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.helper;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.dto.request.SaleMergeWmsDetailReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.SaleMergeWmsReqDto;
import com.dtyunxi.cis.pms.biz.service.SaleTransferService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferReportRespDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.WmsOrderBaseDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderTagRecordQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SaleAllotMqHelper {
    private static final Logger log = LoggerFactory.getLogger(SaleAllotMqHelper.class);
    @Value(value="#{'${pms.push.wms.wh:ZHK}'.split(',')}")
    private List<String> zhWhs;
    private final String redisMergeOrderGroup = "ORDER_MERGE";
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private IOrderTagRecordQueryApi orderTagRecordQueryApi;
    @Resource
    private SaleTransferService saleTransferService;

    public void sendOrderMergeMq(WmsOrderBaseDto wmsOrderBaseDto, BizSaleOrderRespDto order) {
        block20: {
            ArrayList allList;
            String platformOrderNo;
            block19: {
                List tagCodeList;
                boolean allotSaleFlag = true;
                if (CollectionUtils.isEmpty((Collection)order.getTagList())) {
                    log.info("\u9500\u552e\u8c03\u62e8\u7c7b\u578b\u8ba2\u5355\u672a\u6253\u6807\u7b7e");
                    allotSaleFlag = false;
                }
                if (!(tagCodeList = order.getTagList().stream().map(OrderTagBaseRespDto::getTagCode).collect(Collectors.toList())).contains("GS001")) {
                    log.info("\u9500\u552e\u8c03\u62e8\u7c7b\u578b\u8ba2\u5355\u672a\u6253\u5f00\u95e8\u7ea2\u6807\u7b7e");
                    allotSaleFlag = false;
                }
                if (tagCodeList.contains("YPH")) {
                    log.info("\u6253\u4e86\u4e00\u76d8\u8d27\u62c6\u5355\u6807\u7b7e,\u8981\u63a8\u9001\u5408\u5355");
                    allotSaleFlag = true;
                }
                if (!allotSaleFlag) {
                    log.info("\u6ca1\u6709\u6253\u4e00\u76d8\u8d27\u62c6\u5355\u6807\u7b7e\uff0c\u4e0d\u63a8\u9001\u5408\u5355\u6307\u4ee4");
                    return;
                }
                log.info("\u662f\u5426\u6709\u4e00\u76d8\u8d27\u62c6\u5355\u6807\u7b7e={}", (Object)allotSaleFlag);
                Integer type = SaleOrderLevelEnum.ORIGINAL.getType();
                if (Objects.equals(type, order.getOrderLevel()) || Objects.equals(SaleOrderLevelEnum.MAIN.getType(), order.getOrderLevel())) {
                    log.info("\u539f\u5355\u6216\u8005\u4e3b\u5355\uff0c\u4e0d\u9700\u8981\u63a8\u9001\u5408\u5355\u6307\u4ee4");
                    return;
                }
                platformOrderNo = order.getPlatformOrderNo();
                if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(wmsOrderBaseDto.getBusinessType())) {
                    platformOrderNo = platformOrderNo + "-TP";
                } else {
                    wmsOrderBaseDto.setKmhMasterOrderCode(platformOrderNo);
                }
                wmsOrderBaseDto.setOrderSplitNum(Integer.valueOf(0));
                ArrayList<String> orderMergeList = (ArrayList<String>)this.cacheService.getCache("ORDER_MERGE", platformOrderNo, List.class);
                log.info("\u83b7\u53d6\u7f13\u5b58\u4e2d\u8bf7\u6c42\u6b21\u6570={}", (Object)JSONObject.toJSONString((Object)orderMergeList));
                if (CollectionUtils.isEmpty((Collection)orderMergeList)) {
                    orderMergeList = new ArrayList<String>();
                }
                orderMergeList.add(order.getSaleOrderNo());
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
                saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.SPLIT.getCode()}));
                List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                log.info("\u5408\u5355\u6e20\u9053\u5355\u4fe1\u606f:{},{}", (Object)saleOrderQueryReqDto.getPlatformOrderNo(), JSONObject.toJSON((Object)saleOrderRespDtos));
                List orderIdList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
                List orderTagRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.orderTagRecordQueryApi.queryByOrderIds(orderIdList));
                List<Object> gsdbOrderIdList = Lists.newArrayList();
                if (CollectionUtil.isNotEmpty((Collection)orderTagRecordRespDtos)) {
                    gsdbOrderIdList = orderTagRecordRespDtos.stream().filter(tag -> Objects.equals(tag.getTagCode(), "GSDB")).map(OrderTagBaseRespDto::getOrderId).collect(Collectors.toList());
                }
                List<Object> yphOrderIdList = Lists.newArrayList();
                if (CollectionUtil.isNotEmpty((Collection)orderTagRecordRespDtos)) {
                    yphOrderIdList = orderTagRecordRespDtos.stream().filter(tag -> Objects.equals(tag.getTagCode(), "YPH")).map(OrderTagBaseRespDto::getOrderId).collect(Collectors.toList());
                }
                ArrayList saleList = Lists.newArrayList();
                ArrayList saleAllotOrderList = Lists.newArrayList();
                allList = Lists.newArrayList();
                for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                    if (yphOrderIdList.isEmpty()) {
                        if (gsdbOrderIdList.contains(saleOrderRespDto.getId())) {
                            saleAllotOrderList.add(saleOrderRespDto);
                            continue;
                        }
                        saleList.add(saleOrderRespDto);
                        continue;
                    }
                    if (!yphOrderIdList.contains(saleOrderRespDto.getId())) continue;
                    saleList.add(saleOrderRespDto);
                }
                if (allotSaleFlag && CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(wmsOrderBaseDto.getBusinessType())) {
                    allList.addAll(saleAllotOrderList);
                } else {
                    allList.addAll(saleList);
                }
                List orderNoList = allList.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
                boolean b = orderMergeList.containsAll(orderNoList);
                if (!b) {
                    this.cacheService.setCache("ORDER_MERGE", platformOrderNo, orderMergeList);
                    log.info("\u4e0d\u662f\u6e20\u9053\u5355\u6700\u540e\u4e00\u4e2a\u5b50\u5355\uff0c\u4e0d\u63a8\u9001\u5408\u5355\u6307\u4ee4");
                    return;
                }
                this.cacheService.delCache("ORDER_MERGE", platformOrderNo);
                if (CollectionUtils.isEmpty((Collection)allList)) {
                    log.info("\u6ca1\u6709\u9500\u552e\u8ba2\u5355\u4fe1\u606f=_=");
                    return;
                }
                if (!CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(wmsOrderBaseDto.getBusinessType())) break block19;
                SaleTransferReportReqDto saleTransferReportReqDto = new SaleTransferReportReqDto();
                saleTransferReportReqDto.setOrderNos(orderNoList);
                saleTransferReportReqDto.setPageNum(Integer.valueOf(1));
                saleTransferReportReqDto.setPageSize(Integer.valueOf(orderNoList.size()));
                log.info("\u6839\u636e\u8c03\u62e8\u5355\u67e5\u8be2\u9500\u552e\u8c03\u62e8\u5355\u5173\u8054\u5173\u7cfb");
                PageInfo saleTransferReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.saleTransferService.querySaleTransferPage(saleTransferReportReqDto));
                log.info("\u6839\u636e\u8c03\u62e8\u5355\u67e5\u8be2\u9500\u552e\u8c03\u62e8\u5355\u5173\u8054\u5173\u7cfb\u7ed3\u679c={}", JSON.toJSON((Object)saleTransferReportRespDtoPageInfo));
                if (!CollectionUtil.isNotEmpty((Collection)saleTransferReportRespDtoPageInfo.getList())) break block20;
                Map<String, List<SaleTransferReportRespDto>> physicsWarehouseGroup = saleTransferReportRespDtoPageInfo.getList().stream().filter(dto -> Objects.nonNull(dto.getOutPhysicsWarehouseCode())).collect(Collectors.groupingBy(SaleTransferReportRespDto::getOutPhysicsWarehouseCode));
                for (String physiceWarehouseCode : physicsWarehouseGroup.keySet()) {
                    List<SaleTransferReportRespDto> saleOrderList = physicsWarehouseGroup.get(physiceWarehouseCode);
                    this.sendWmsMqInfo(platformOrderNo, physiceWarehouseCode, saleOrderList.size());
                }
                break block20;
            }
            Map<String, List<SaleOrderRespDto>> physicsWarehouseGroup = allList.stream().collect(Collectors.groupingBy(SaleOrderRespDto::getPhysicsWarehouseCode));
            for (String physiceWarehouseCode : physicsWarehouseGroup.keySet()) {
                List<SaleOrderRespDto> saleOrderList = physicsWarehouseGroup.get(physiceWarehouseCode);
                this.sendWmsMqInfo(platformOrderNo, physiceWarehouseCode, saleOrderList.size());
            }
        }
    }

    private void sendWmsMqInfo(String platformOrderNo, String physiceWarehouseCode, Integer size) {
        log.info("\u8ba2\u5355\u63a8\u9001wms\u5408\u5355:{},\u914d\u7f6e\u7684\u7269\u7406\u4ed3\u7f16\u7801\uff1a{}", (Object)physiceWarehouseCode, (Object)JSONObject.toJSONString(this.zhWhs));
        if (size >= 1 && this.zhWhs.contains(physiceWarehouseCode)) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)platformOrderNo);
            messageVo.setExtValue1((Object)size);
            messageVo.setExtValue2((Object)physiceWarehouseCode);
            this.commonsMqService.sendDelaySingleMessage("OP_EXTERNAL_TOPIC", "ORDER_MERGE_TAG", (Object)messageVo, Long.valueOf(60L));
        }
    }

    public void sendSaleWmsMergeBatch(List<SaleMergeWmsReqDto> saleMergeWmsReqDtos) {
        List mergeWmsQueryList;
        log.info("\u8865\u507f\u63a8\u9001\u5408\u5355\u6307\u4ee4\u5165\u53c2={}", JSON.toJSON(saleMergeWmsReqDtos));
        AssertUtils.notEmpty(saleMergeWmsReqDtos, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (SaleMergeWmsReqDto saleMergeWmsReqDto : saleMergeWmsReqDtos) {
            AssertUtils.notEmpty((String)saleMergeWmsReqDto.getPlatformOrderNo(), (String)"\u6e20\u9053\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            if (!CollectionUtils.isNotEmpty(saleMergeWmsReqDto.getMergeDetailList())) continue;
            for (SaleMergeWmsDetailReqDto mergeDetail : saleMergeWmsReqDto.getMergeDetailList()) {
                AssertUtils.notEmpty((String)mergeDetail.getPhysiceWarehouseCode(), (String)"\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                if (!Objects.nonNull(mergeDetail.getMergeNum())) continue;
                saleMergeWmsReqDto.setQueryFlag(Boolean.TRUE);
            }
        }
        ArrayList allSendList = Lists.newArrayList();
        List mergeWmsReqDtos = saleMergeWmsReqDtos.stream().filter(s -> s.isQueryFlag()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(mergeWmsReqDtos)) {
            allSendList.addAll(mergeWmsReqDtos);
        }
        if (CollectionUtils.isNotEmpty(mergeWmsQueryList = saleMergeWmsReqDtos.stream().filter(s -> !s.isQueryFlag()).collect(Collectors.toList()))) {
            List platformOrderNoList = mergeWmsQueryList.stream().map(SaleMergeWmsReqDto::getPlatformOrderNo).collect(Collectors.toList());
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setPlatformOrderNoList(platformOrderNoList);
            saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.SPLIT.getCode()}));
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                List orderIdList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
                List orderTagRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.orderTagRecordQueryApi.queryByOrderIds(orderIdList));
                List<Object> gsdbOrderIdList = Lists.newArrayList();
                if (CollectionUtil.isNotEmpty((Collection)orderTagRecordRespDtos)) {
                    gsdbOrderIdList = orderTagRecordRespDtos.stream().filter(tag -> Objects.equals(tag.getTagCode(), "GSDB")).map(OrderTagBaseRespDto::getOrderId).collect(Collectors.toList());
                }
                ArrayList saleList = Lists.newArrayList();
                ArrayList saleAllotOrderList = Lists.newArrayList();
                for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                    if (gsdbOrderIdList.contains(saleOrderRespDto.getId())) {
                        saleAllotOrderList.add(saleOrderRespDto);
                        continue;
                    }
                    saleList.add(saleOrderRespDto);
                }
                Map<String, String> platformAllotMap = saleMergeWmsReqDtos.stream().collect(Collectors.toMap(SaleMergeWmsReqDto::getPlatformOrderNo, SaleMergeWmsReqDto::getSendType, (k1, k2) -> k1));
                Map<String, List> salePhysiceMap = saleMergeWmsReqDtos.stream().collect(Collectors.toMap(SaleMergeWmsReqDto::getPlatformOrderNo, SaleMergeWmsReqDto::getMergeDetailList, (k1, k2) -> k1));
                if (CollectionUtils.isNotEmpty((Collection)saleAllotOrderList)) {
                    List orderNoList = saleAllotOrderList.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
                    SaleTransferReportReqDto saleTransferReportReqDto = new SaleTransferReportReqDto();
                    saleTransferReportReqDto.setOrderNos(orderNoList);
                    saleTransferReportReqDto.setPageNum(Integer.valueOf(1));
                    saleTransferReportReqDto.setPageSize(Integer.valueOf(orderNoList.size()));
                    log.info("\u6839\u636e\u8c03\u62e8\u5355\u67e5\u8be2\u9500\u552e\u8c03\u62e8\u5355\u5173\u8054\u5173\u7cfb");
                    PageInfo saleTransferReportRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.saleTransferService.querySaleTransferPage(saleTransferReportReqDto));
                    log.info("\u6839\u636e\u8c03\u62e8\u5355\u67e5\u8be2\u9500\u552e\u8c03\u62e8\u5355\u5173\u8054\u5173\u7cfb\u7ed3\u679c={}", JSON.toJSON((Object)saleTransferReportRespDtoPageInfo));
                    if (CollectionUtil.isNotEmpty((Collection)saleTransferReportRespDtoPageInfo.getList())) {
                        Map<String, List<SaleTransferReportRespDto>> saleTransferMap = saleTransferReportRespDtoPageInfo.getList().stream().collect(Collectors.groupingBy(SaleTransferReportRespDto::getPlatformOrderNo));
                        for (String allotPlatformNo : saleTransferMap.keySet()) {
                            if (!platformAllotMap.containsKey(allotPlatformNo) || Objects.equals(platformAllotMap.get(allotPlatformNo), "delivery")) {
                                log.info("\u7edf\u8ba1\u9500\u552e\u8c03\u62e8\u6e20\u9053\u8ba2\u5355{},\u63a8\u9001\u7c7b\u578b{}", (Object)allotPlatformNo, (Object)platformAllotMap.get(allotPlatformNo));
                                continue;
                            }
                            List saleMergeWmsDetailReqDtos = salePhysiceMap.get(allotPlatformNo);
                            List physiceWarehouseCodeList = Lists.newArrayList();
                            if (CollectionUtils.isNotEmpty((Collection)saleMergeWmsDetailReqDtos)) {
                                physiceWarehouseCodeList = saleMergeWmsDetailReqDtos.stream().map(SaleMergeWmsDetailReqDto::getPhysiceWarehouseCode).collect(Collectors.toList());
                            }
                            List<SaleTransferReportRespDto> saleTransferReportRespDtos = saleTransferMap.get(allotPlatformNo);
                            Map<String, List<SaleTransferReportRespDto>> physicsWarehouseGroup = saleTransferReportRespDtos.stream().filter(dto -> Objects.nonNull(dto.getOutPhysicsWarehouseCode())).collect(Collectors.groupingBy(SaleTransferReportRespDto::getOutPhysicsWarehouseCode));
                            ArrayList mergeDetailList = Lists.newArrayList();
                            for (String physiceWarehouseCode : physicsWarehouseGroup.keySet()) {
                                if (CollectionUtils.isNotEmpty(physiceWarehouseCodeList) && !physiceWarehouseCodeList.contains(physiceWarehouseCode)) {
                                    log.info("\u7edf\u8ba1\u9500\u552e\u8c03\u62e8\u6e20\u9053\u8ba2\u5355{},\u6307\u5b9a\u7269\u7406\u4ed3\u63a8\u9001", (Object)allotPlatformNo, (Object)physiceWarehouseCode);
                                    continue;
                                }
                                List<SaleTransferReportRespDto> saleOrderList = physicsWarehouseGroup.get(physiceWarehouseCode);
                                SaleMergeWmsDetailReqDto mergeDetail = new SaleMergeWmsDetailReqDto();
                                mergeDetail.setMergeNum(saleOrderList.size());
                                mergeDetail.setPhysiceWarehouseCode(physiceWarehouseCode);
                                mergeDetailList.add(mergeDetail);
                            }
                            if (!CollectionUtils.isNotEmpty((Collection)mergeDetailList)) continue;
                            SaleMergeWmsReqDto saleMergeWmsReqDto = new SaleMergeWmsReqDto();
                            saleMergeWmsReqDto.setPlatformOrderNo(allotPlatformNo + "-TP");
                            saleMergeWmsReqDto.setMergeDetailList(mergeDetailList);
                            allSendList.add(saleMergeWmsReqDto);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)saleList)) {
                    Map<String, List<SaleOrderRespDto>> saleMap = saleList.stream().collect(Collectors.groupingBy(SaleOrderRespDto::getPlatformOrderNo));
                    for (String platformNo : saleMap.keySet()) {
                        if (!platformAllotMap.containsKey(platformNo) || Objects.equals(platformAllotMap.get(platformNo), "allot")) {
                            log.info("\u7edf\u8ba1\u76f4\u53d1\u8ba2\u5355\u6e20\u9053\u8ba2\u5355{},\u63a8\u9001\u7c7b\u578b{}", (Object)platformNo, (Object)platformAllotMap.get(platformNo));
                            continue;
                        }
                        List saleMergeWmsDetailReqDtos = salePhysiceMap.get(platformNo);
                        List<Object> physiceWarehouseCodeList = Lists.newArrayList();
                        if (CollectionUtils.isNotEmpty((Collection)saleMergeWmsDetailReqDtos)) {
                            physiceWarehouseCodeList = saleMergeWmsDetailReqDtos.stream().map(SaleMergeWmsDetailReqDto::getPhysiceWarehouseCode).collect(Collectors.toList());
                        }
                        Map<String, List<SaleOrderRespDto>> physicsWarehouseGroup = saleMap.get(platformNo).stream().collect(Collectors.groupingBy(SaleOrderRespDto::getPhysicsWarehouseCode));
                        ArrayList mergeDetailList = Lists.newArrayList();
                        for (String physiceWarehouseCode : physicsWarehouseGroup.keySet()) {
                            if (CollectionUtils.isNotEmpty((Collection)physiceWarehouseCodeList) && !physiceWarehouseCodeList.contains(physiceWarehouseCode)) {
                                log.info("\u7edf\u8ba1\u9500\u552e\u6e20\u9053\u8ba2\u5355{},\u6307\u5b9a\u7269\u7406\u4ed3\u63a8\u9001", (Object)platformNo, (Object)physiceWarehouseCode);
                                continue;
                            }
                            List<SaleOrderRespDto> saleOrderList = physicsWarehouseGroup.get(physiceWarehouseCode);
                            SaleMergeWmsDetailReqDto mergeDetail = new SaleMergeWmsDetailReqDto();
                            mergeDetail.setMergeNum(saleOrderList.size());
                            mergeDetail.setPhysiceWarehouseCode(physiceWarehouseCode);
                            mergeDetailList.add(mergeDetail);
                        }
                        if (!CollectionUtils.isNotEmpty((Collection)mergeDetailList)) continue;
                        SaleMergeWmsReqDto saleMergeWmsReqDto = new SaleMergeWmsReqDto();
                        saleMergeWmsReqDto.setPlatformOrderNo(platformNo);
                        saleMergeWmsReqDto.setMergeDetailList(mergeDetailList);
                        allSendList.add(saleMergeWmsReqDto);
                    }
                }
            }
        }
        log.info("\u8865\u507f\u63a5\u53e3\u63a8\u9001\u5408\u5355\u6307\u4ee4==>{}", JSON.toJSON((Object)allSendList));
        for (SaleMergeWmsReqDto saleMergeWmsReqDto : allSendList) {
            for (SaleMergeWmsDetailReqDto mergeWmsReqDto : saleMergeWmsReqDto.getMergeDetailList()) {
                this.sendWmsMqInfo(saleMergeWmsReqDto.getPlatformOrderNo(), mergeWmsReqDto.getPhysiceWarehouseCode(), mergeWmsReqDto.getMergeNum());
            }
        }
    }
}

