/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.dto.response.SaleOrderCheckStockResponseVo;
import com.dtyunxi.cis.pms.biz.dto.response.SaleOrderExtRespEsVo;
import com.dtyunxi.cis.pms.biz.dto.response.SaleOrderItemInventoryRespDto;
import com.dtyunxi.cis.pms.biz.dto.response.SaleOrderPartSplitDeliveryVo;
import com.dtyunxi.cis.pms.biz.dto.response.SourceDeliveryRespDto;
import com.dtyunxi.cis.pms.biz.dto.response.SourceDeliveryResultVo;
import com.dtyunxi.cis.pms.biz.enums.AssignStatusEnum;
import com.dtyunxi.cis.pms.biz.enums.BunchCodeFlagEnum;
import com.dtyunxi.cis.pms.biz.enums.IsGiftFlagEnum;
import com.dtyunxi.cis.pms.biz.enums.ItemTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.StatusEnum;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddSaleOrderParams;
import com.dtyunxi.cis.pms.biz.model.AppointBatchSaleOrderParams;
import com.dtyunxi.cis.pms.biz.model.BatchSplitSaleOrderParams;
import com.dtyunxi.cis.pms.biz.model.BunchCodeAuditSaleOrderParams;
import com.dtyunxi.cis.pms.biz.model.ChangeSaleOrderLogicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.CommonCreateVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOrderCenterSaleOrderVO;
import com.dtyunxi.cis.pms.biz.model.GetOrderCenterBatchListParams;
import com.dtyunxi.cis.pms.biz.model.GetOrderCenterLogicalWarehouseListParams;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderAddGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderCountParams;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderLogListPageParams;
import com.dtyunxi.cis.pms.biz.model.HandleSplitSaleOrderParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportSaleOrderDto;
import com.dtyunxi.cis.pms.biz.model.ImportSaleOrderResultDto;
import com.dtyunxi.cis.pms.biz.model.OrderCenterBatchVo;
import com.dtyunxi.cis.pms.biz.model.OrderCenterGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OrderCenterLogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.OrderOperationVO;
import com.dtyunxi.cis.pms.biz.model.OrderStepVO;
import com.dtyunxi.cis.pms.biz.model.OutWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.RelationBillVO;
import com.dtyunxi.cis.pms.biz.model.ReplenishmentSourcingOrderItemVO;
import com.dtyunxi.cis.pms.biz.model.ReplenishmentSourcingOrderVO;
import com.dtyunxi.cis.pms.biz.model.SaleChildOrderVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderCountVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderGoodsNumVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderLogVO;
import com.dtyunxi.cis.pms.biz.model.SaleOrderVO;
import com.dtyunxi.cis.pms.biz.model.SimpleOrderVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOrderFailResultVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOrderResultVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryService;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryTransferOrderService;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cis.pms.biz.service.SystemSettingSourcingOrderLogService;
import com.dtyunxi.cis.pms.biz.service.helper.WmsAble;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.AssertUtils;
import com.dtyunxi.cis.pms.biz.utils.DateTimeUtils;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cis.pms.biz.utils.ImportCheckUtils;
import com.dtyunxi.cis.pms.biz.utils.OrderOptLabelUtils;
import com.dtyunxi.cis.search.api.dto.request.GetSaleOrderListPageEsParams;
import com.dtyunxi.cis.search.api.dto.response.AddressVO;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderRespEsVo;
import com.dtyunxi.cis.search.api.query.trade.EsSaleOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cube.center.source.api.constant.SourceTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueSuitActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.OrderReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueActRespDto;
import com.dtyunxi.cube.center.source.api.query.IDistributionClueQueryApi;
import com.dtyunxi.cube.center.source.api.query.IOrderQueryApi;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.cube.component.track.commons.vo.pcp.ExternalDispatchBaseVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.request.IntransitCargoQueryDto;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.api.dto.response.IntransitCargoRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticsInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderStringCodeCountRespDto;
import com.dtyunxi.tcbj.api.query.ICostCenterQueryApi;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerStatusQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASBillTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.CancelOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsPhysicsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsPcpInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsBusinessTypeApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.CargoStorageTotalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryBatchQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryWarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.CargoStorageTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderTagRecordApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptLogApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferExtApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.EasVerifyStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderOptLabelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOnlineStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BatchSplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordAddBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderOptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitChildOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderByBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RelatedOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemSummaryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.StringCodeResultEum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderTagRecordQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderOptLogQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPcpOrderChannelQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThridOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_sale_order")
public class OrderCenterSaleOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements OrderCenterSaleOrderService {
    private static Logger logger = LoggerFactory.getLogger(OrderCenterSaleOrderServiceServiceImpl.class);
    @Value(value="${saleOrderEsQuery:false}")
    private Boolean saleOrderEsQuery;
    @Resource
    private EsSaleOrderQueryApi esSaleOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private ICsPhysicsInventoryExposedApi csPhysicsInventoryExposedApi;
    @Resource
    private ICsPcpInventoryExposedApi csPcpInventoryExposedApi;
    @Resource
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;
    @Resource
    private ICsInventoryExposedQueryApi csInventoryExposedQueryApi;
    @Resource
    private IOrderQueryApi orderQueryApi;
    @Resource
    private IPcpOrderChannelQueryApi pcpOrderChannelQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IPCPCustomerQueryApi pcpCustomerQueryApi;
    @Resource
    private ISaleOrderOptLogQueryApi saleOrderOptLogQueryApi;
    @Resource
    private IPCPCustomerStatusQueryApi pcpCustomerStatusQueryApi;
    @Resource
    private IPcpOrderApi pcpOrderApi;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IOrderTagRecordApi orderTagRecordApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Autowired
    IChannelInventoryApi channelInventoryQueryApi;
    @Autowired
    IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Autowired
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Autowired
    private IItemExtendQueryApi itemExtendQueryApi;
    @Resource
    private TradeEsReportQueryApi tradeEsReportQueryApi;
    @Resource
    private ICostCenterQueryApi costCenterQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private WmsAble wmsAble;
    @Resource
    private ICsOutNoticeOrderApi csOutNoticeOrderApi;
    @Resource
    private ICsBusinessTypeApi csBusinessTypeQueryApi;
    @Resource
    private IOutResultOrderQueryApi iOutResultOrderQueryApi;
    @Resource
    private ILogicInventoryQueryApi logicInventoryQueryApi;
    @Autowired
    IDgLogicWarehouseApi logicWarehouseApi;
    @Resource
    private ISaleTransferOrderApi saleTransferOrderApi;
    @Autowired
    ISaleTransferExtApi saleTransferExtApi;
    @Resource
    private ICacheService cacheService;
    public static final String SALE_ORDER_INTRANSIT_GROUP = "SALE_ORDER_INTRANSIT_GROUP";
    public static final String SALE_ORDER_ITEM_INTRANSIT_GROUP = "SALE_ORDER_ITEM_INTRANSIT_GROUP";
    public static final Integer SALE_ORDER_INTRANSIT_TIME = 1209600;
    @Resource
    private IDistributionClueQueryApi distributionClueQueryApi;
    @Resource
    private ISaleOrderOptLogApi saleOrderOptLogApi;
    @Resource
    private IOrderTagRecordQueryApi orderTagRecordQueryApi;
    @Resource
    private SystemSettingSourcingOrderLogService systemSettingSourcingOrderLogService;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private FinishedGoodsInventoryTransferOrderService finishedGoodsInventoryTransferOrderService;
    @Resource
    private FinishedGoodsInventoryService finishedGoodsInventoryService;
    @Resource
    private ICsLogisticsInfoQueryApi csLogisticsInfoQueryApi;

    @Override
    public RestResponse<Object> acceptDistributionAdviceSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        return new RestResponse();
    }

    @Override
    public RestResponse<CommonCreateVO> addSaleOrder(@Valid AddSaleOrderParams addSaleOrderParams) {
        if (this.isOutOrder(SaleOrderTypeEnum.enumOf((String)addSaleOrderParams.getOrderType()).getDesc()) && StringUtils.isEmpty((CharSequence)addSaleOrderParams.getPlatformOrderNo())) {
            String saleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.getSaleOrderNo());
            addSaleOrderParams.setSaleOrderNo(saleOrderNo);
            addSaleOrderParams.setPlatformOrderNo(saleOrderNo);
        }
        this.checkParam(addSaleOrderParams);
        BizSaleOrderReqDto reqDto = new BizSaleOrderReqDto();
        BeanUtils.copyProperties((Object)addSaleOrderParams, (Object)reqDto);
        reqDto.setOrderSource(YesOrNoEnum.NO.getCode());
        this.getSaleOrderAddrReqDto(addSaleOrderParams, reqDto);
        reqDto.setIsOnline(Integer.valueOf(0));
        reqDto.setCustomerId(StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getCustomerId()) ? Long.valueOf(addSaleOrderParams.getCustomerId()) : null);
        reqDto.setRemark(addSaleOrderParams.getOrderRemark());
        reqDto.setManualCreate(Boolean.valueOf(true));
        reqDto.setPayTime(StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getPayTime()) ? DateUtil.parse((String)addSaleOrderParams.getPayTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        reqDto.setOrderType(addSaleOrderParams.getOrderType());
        reqDto.setChannelId(StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getOrderChannelId()) ? Long.valueOf(addSaleOrderParams.getOrderChannelId()) : null);
        reqDto.setChannelName(addSaleOrderParams.getOrderChannelName());
        reqDto.setChannelCode(addSaleOrderParams.getOrderChannelCode());
        reqDto.setAllowSplitFlag(ParamConverter.convertToInteger((Object)addSaleOrderParams.getAllowSplitFlag()));
        reqDto.setDefaultLogicalWarehouseId(ParamConverter.convertToLong((Object)addSaleOrderParams.getDefaultLogicalWarehouseId()));
        reqDto.setChannelWarehouseId(StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getChannelWarehouseId()) ? Long.valueOf(addSaleOrderParams.getChannelWarehouseId()) : null);
        this.getItemList(addSaleOrderParams, reqDto);
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("customerCategory", StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getCustomerCategory()) ? addSaleOrderParams.getCustomerCategory() : "");
        reqDto.setExtension(JSON.toJSONString(extMap));
        String orderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderApi.addSaleOrder(reqDto));
        CommonCreateVO commonCreateVO = new CommonCreateVO();
        commonCreateVO.setOrderNo(orderNo);
        return new RestResponse((Object)commonCreateVO);
    }

    private void checkParam(AddSaleOrderParams addSaleOrderParams) {
        BigDecimal itemWeight;
        BigDecimal itemVolume;
        PcpItemRespDto itemSkuRespDto;
        boolean isNotClaimOrder;
        String platformOrderNo = addSaleOrderParams.getPlatformOrderNo();
        boolean bl = isNotClaimOrder = !Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), addSaleOrderParams.getOrderType()) && !Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), addSaleOrderParams.getOrderType());
        if (isNotClaimOrder) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u6e20\u9053\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(this.checkPlatformOrderNo(platformOrderNo), "\u6e20\u9053\u5355\u53f7\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc740\u4f4d");
            PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
            platformOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
            logger.info("\u67e5\u8be2\u5e73\u53f0\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)platformOrderQueryReqDto));
            List platformOrderRespList = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(platformOrderQueryReqDto));
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)platformOrderRespList), "\u6e20\u9053\u5355\u53f7\u5df2\u5b58\u5728;");
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
            logger.info("\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saleOrderQueryReqDto));
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)saleOrderRespDtos), "\u6e20\u9053\u5355\u53f7\u5df2\u5b58\u5728;");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getOrderChannelId()), "\u8ba2\u5355\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            PcpOrderChannelRespDto orderChannelRespDto = (PcpOrderChannelRespDto)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryById(Long.valueOf(addSaleOrderParams.getOrderChannelId())));
            AssertUtil.isTrue(Objects.nonNull(orderChannelRespDto), "\u8ba2\u5355\u6e20\u9053\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(StatusEnum.ENABLE.getCode().equals(orderChannelRespDto.getStatus()), "\u8ba2\u5355\u6e20\u9053\u5df2\u7981\u7528");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addSaleOrderParams.getChannelWarehouseCode()), "\u6e20\u9053\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
            HashSet channelWarehouseCodeSet = Sets.newHashSet((Object[])new String[]{addSaleOrderParams.getChannelWarehouseCode()});
            List channelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes((Set)channelWarehouseCodeSet));
            AssertUtil.isTrue(Objects.nonNull(channelWarehouseRespDtos), "\u6e20\u9053\u4ed3\u4e0d\u5b58\u5728");
            ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0);
            AssertUtil.isTrue(StatusEnum.ENABLE.getDesc().equals(channelWarehouseRespDto.getWarehouseStatus()), "\u6e20\u9053\u4ed3\u5df2\u7981\u7528");
            Set orderChannelCodes = channelWarehouseRespDto.getOrderChannelCodes();
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderChannelCodes), "\u8ba2\u5355\u6e20\u9053\u5173\u8054\u6e20\u9053\u4ed3\u4e3a\u7a7a");
            AssertUtil.isTrue(orderChannelCodes.contains(addSaleOrderParams.getOrderChannelCode()), "\u8ba2\u5355\u6e20\u9053\u548c\u6e20\u9053\u4ed3\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb");
        } else {
            AssertUtil.assertNotBlank(addSaleOrderParams.getLogicalWarehouseCode(), "\u7d22\u8d54\u8ba2\u5355\u6307\u5b9a\u53d1\u8d27\u4ed3\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Map channelWarehouseMap = (Map)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByLogicWarehouseCodes((Set)Sets.newHashSet((Object[])new String[]{addSaleOrderParams.getLogicalWarehouseCode()})));
            if (CollectionUtils.isNotEmpty((Collection)((Collection)channelWarehouseMap.get(addSaleOrderParams.getLogicalWarehouseCode())))) {
                logger.info("\u7d22\u8d54\u8ba2\u5355\u83b7\u53d6\u6e20\u9053\u4ed3\u5e93\u4fe1\u606f\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)channelWarehouseMap), (Object)addSaleOrderParams.getLogicalWarehouseCode());
                List channelWarehouseRespDtos = (List)channelWarehouseMap.get(addSaleOrderParams.getLogicalWarehouseCode());
                addSaleOrderParams.setChannelWarehouseId(((ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0)).getId() + "");
                addSaleOrderParams.setChannelWarehouseCode(((ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0)).getWarehouseCode());
                addSaleOrderParams.setChannelWarehouseName(((ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0)).getWarehouseName());
            }
        }
        PCPCustomerSearchReqDto pcpCustomerSearchReqDto = new PCPCustomerSearchReqDto();
        pcpCustomerSearchReqDto.setId(Long.valueOf(addSaleOrderParams.getCustomerId()));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryPCPCustomerDetail(pcpCustomerSearchReqDto));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)customerRespDtos), "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        AssertUtils.notNull(customerRespDto.getStatusId(), "\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
        CustomerStatusRespDto customerStatusRespDto = (CustomerStatusRespDto)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryById(customerRespDto.getStatusId()));
        AssertUtils.notNull(customerStatusRespDto, "\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
        AssertUtil.assertEqual(1, customerStatusRespDto.getAccountStatus(), "\u5ba2\u6237\u8d26\u53f7\u5df2\u7981\u7528");
        AssertUtil.assertEqual(1, customerStatusRespDto.getRecordStatus(), "\u5ba2\u6237\u8d26\u53f7\u5df2\u505c\u7528");
        Long merchantId = addSaleOrderParams.getOrganizationId();
        AssertUtils.notNull(merchantId, "\u9500\u552e\u7ec4\u7ec7ID\u4e3a\u7a7a");
        ThridOrganizationReqDto thridOrganizationReqDto = new ThridOrganizationReqDto();
        thridOrganizationReqDto.setOrgId(merchantId);
        PageInfo orgAdvDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgList(thridOrganizationReqDto));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orgAdvDetailRespDtoPageInfo.getList()), "\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)orgAdvDetailRespDtoPageInfo.getList().get(0);
        List orgAdvDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByOrgCode((List)Lists.newArrayList((Object[])new String[]{addSaleOrderParams.getOrganizationCode()})));
        AssertUtils.notEmpty(orgAdvDetailRespDtos, "\u8d27\u6743\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        addSaleOrderParams.setEasOrgId(((OrgAdvDetailRespDto)orgAdvDetailRespDtos.get(0)).getThirdOrgId());
        addSaleOrderParams.setEasCode(customerRespDto.getEasCode());
        addSaleOrderParams.setThirdPartyId(customerRespDto.getThirdPartyId());
        addSaleOrderParams.setCustomerCode(customerRespDto.getCode());
        ArrayList allGoodsList = Lists.newArrayList();
        List<OrderCenterGoodsVO> goodsList = addSaleOrderParams.getGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            allGoodsList.addAll(goodsList);
        }
        if (CollectionUtils.isNotEmpty(addSaleOrderParams.getGiftList())) {
            allGoodsList.addAll(addSaleOrderParams.getGiftList());
        }
        Set skuCodes = allGoodsList.stream().map(OrderCenterGoodsVO::getGoodsCode).collect(Collectors.toSet());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)Lists.newArrayList(skuCodes)), "\u5546\u54c1SKU\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes((List)Lists.newArrayList(skuCodes)));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos), "\u67e5\u8be2\u5546\u54c1SKU\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Map itemSkuMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k1));
        for (OrderCenterGoodsVO o : goodsList) {
            itemSkuRespDto = (PcpItemRespDto)itemSkuMap.get(o.getGoodsCode());
            AssertUtil.isTrue(Objects.nonNull(itemSkuRespDto), "\u5546\u54c1" + o.getGoodsCode() + "\u4fe1\u606f\u4e0d\u5b58\u5728");
            if (itemSkuRespDto.getItemStatus() != null && itemSkuRespDto.getItemStatus() != 2L) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_STATUS_0.buildBizException(new Object[]{o.getGoodsCode()});
            }
            o.setVolume(BigDecimal.ZERO);
            o.setGoodsId(itemSkuRespDto.getId().toString());
            o.setGoodsSku(o.getGoodsCode());
            if (Objects.isNull(o.getGoodsPrice())) {
                o.setGoodsPrice(itemSkuRespDto.getRecommendPrice());
            }
            o.setGoodsName(itemSkuRespDto.getName());
            if (Objects.nonNull(itemSkuRespDto.getVolume())) {
                itemVolume = itemSkuRespDto.getVolume().multiply(o.getGoodsNum());
                o.setVolume(itemVolume);
            }
            o.setWeight(BigDecimal.ZERO);
            if (!Objects.nonNull(itemSkuRespDto.getGrossWeight())) continue;
            itemWeight = itemSkuRespDto.getGrossWeight().multiply(o.getGoodsNum());
            o.setWeight(itemWeight);
            o.setWeightUnit(itemSkuRespDto.getGrossWeightUnit());
        }
        if (CollectionUtils.isNotEmpty(addSaleOrderParams.getGiftList())) {
            for (OrderCenterGoodsVO o : addSaleOrderParams.getGiftList()) {
                itemSkuRespDto = (PcpItemRespDto)itemSkuMap.get(o.getGoodsCode());
                AssertUtil.isTrue(Objects.nonNull(itemSkuRespDto), "\u5546\u54c1" + o.getGoodsCode() + "\u4fe1\u606f\u4e0d\u5b58\u5728");
                if (itemSkuRespDto.getItemStatus() != null && itemSkuRespDto.getItemStatus() != 2L) {
                    throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_STATUS_0.buildBizException(new Object[]{o.getGoodsCode()});
                }
                o.setVolume(BigDecimal.ZERO);
                o.setGoodsId(itemSkuRespDto.getId().toString());
                o.setGoodsSku(o.getGoodsCode());
                if (Objects.isNull(o.getGoodsPrice())) {
                    o.setGoodsPrice(itemSkuRespDto.getRecommendPrice());
                }
                o.setGoodsName(itemSkuRespDto.getName());
                if (Objects.nonNull(itemSkuRespDto.getVolume())) {
                    itemVolume = itemSkuRespDto.getVolume().multiply(o.getGoodsNum());
                    o.setVolume(itemVolume);
                }
                o.setWeight(BigDecimal.ZERO);
                if (!Objects.nonNull(itemSkuRespDto.getGrossWeight())) continue;
                itemWeight = itemSkuRespDto.getGrossWeight().multiply(o.getGoodsNum());
                o.setWeight(itemWeight);
                o.setWeightUnit(itemSkuRespDto.getGrossWeightUnit());
            }
        }
    }

    private boolean checkPlatformOrderNo(String platformOrderNo) {
        if (StringUtils.isEmpty((CharSequence)platformOrderNo)) {
            return false;
        }
        return platformOrderNo.length() <= 40;
    }

    @Override
    public RestResponse<Object> appointBatchSaleOrder(@Valid AppointBatchSaleOrderParams appointBatchSaleOrderParams) {
        SplitOrderByBatchReqDto reqDto = new SplitOrderByBatchReqDto();
        BeanUtil.copyProperties((Object)appointBatchSaleOrderParams, (Object)reqDto, (String[])new String[0]);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitOrderByAppointBatch(ParamConverter.convertToLong((Object)appointBatchSaleOrderParams.getSaleOrderId()), reqDto)));
    }

    @Override
    public RestResponse<Object> assignStatusSyncSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        return new RestResponse();
    }

    @Override
    public RestResponse<String> batchSplitSaleOrder(@Valid BatchSplitSaleOrderParams batchSplitSaleOrderParams) {
        if (CollectionUtils.isEmpty(batchSplitSaleOrderParams.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BatchSplitOrderReqDto reqDto = new BatchSplitOrderReqDto();
        BeanUtils.copyProperties((Object)batchSplitSaleOrderParams, (Object)reqDto);
        List list = batchSplitSaleOrderParams.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        reqDto.setOrderIdList(list);
        logger.info("[\u6279\u91cf\u62c6\u5355]\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        StringBuilder exceptionBuilder = new StringBuilder("\u62c6\u5355\u4efb\u52a1\u5171\u8ba1");
        exceptionBuilder.append(reqDto.getOrderIdList().size()).append("\u5355\uff1b");
        Integer successCount = 0;
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : reqDto.getOrderIdList()) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitOrderBySku(orderId, reqDto.getSplitSku()));
                Integer n = successCount;
                Integer n2 = successCount = Integer.valueOf(successCount + 1);
            }
            catch (Exception e) {
                logger.error("[\u6279\u91cf\u62c6\u5355]\u5f02\u5e38\uff1a", (Throwable)e);
                errMessageMap.put(orderId, e.getMessage());
                orderIdOfexceptionList.add(orderId);
            }
        }
        exceptionBuilder.append("\u6210\u529f").append(successCount).append("\u5355\uff1b");
        if (reqDto.getOrderIdList().size() != successCount.intValue()) {
            exceptionBuilder.append("\u5931\u8d25").append(reqDto.getOrderIdList().size() - successCount).append("\u5355\uff1b");
            List orderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)orderIdOfexceptionList));
            AssertUtils.notEmpty(orderRespDtos, "\u8ba2\u5355\u6570\u636e\u5f02\u5e38");
            for (SaleOrderRespDto orderRespDto : orderRespDtos) {
                exceptionBuilder.append("\u5931\u8d25\u8ba2\u5355\u53f7\uff1a").append(orderRespDto.getSaleOrderNo()).append((String)errMessageMap.get(orderRespDto.getId())).append("; \n");
            }
            throw new BizException(PcpTradeExceptionCode.SPLIT_ORDER_FAIL.getCode(), exceptionBuilder.toString());
        }
        return new RestResponse((Object)exceptionBuilder.toString());
    }

    @Override
    public RestResponse<Object> bunchCodeAuditSaleOrder(@Valid BunchCodeAuditSaleOrderParams bunchCodeAuditSaleOrderParams) {
        if (CollectionUtil.isEmpty(bunchCodeAuditSaleOrderParams.getOrderIdList())) {
            throw new BizException("\u4e32\u7801\u5ba1\u6838ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> orderIdList = bunchCodeAuditSaleOrderParams.getOrderIdList();
        List idList = orderIdList.stream().map(o -> ParamConverter.convertToLong((Object)o)).collect(Collectors.toList());
        if (idList.size() == 1) {
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.codeCheck((Long)idList.get(0), bunchCodeAuditSaleOrderParams.getOperaionType())));
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : idList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.codeCheck(orderId, bunchCodeAuditSaleOrderParams.getOperaionType()));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u53d6\u6d88\u6307\u6d3e]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, idList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> cancelAssignSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        List<String> orderIdList = orderOperationVO.getOrderIdList();
        if (CollectionUtil.isEmpty(orderIdList)) {
            throw new BizException("\u53d6\u6d88\u6307\u6d3eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List idList = orderIdList.stream().map(o -> ParamConverter.convertToLong((Object)o)).collect(Collectors.toList());
        if (idList.size() == 1) {
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.cancelAppoint((Long)idList.get(0))));
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : idList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.cancelAppoint(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u53d6\u6d88\u6307\u6d3e]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, idList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    private void getItemList(AddSaleOrderParams addSaleOrderParams, BizSaleOrderReqDto reqDto) {
        ArrayList itemReqDtos = new ArrayList();
        List<OrderCenterGoodsVO> goodsList = addSaleOrderParams.getGoodsList();
        goodsList.forEach(o -> {
            SaleOrderItemReqDto itemReqDto = new SaleOrderItemReqDto();
            BeanUtils.copyProperties((Object)o, (Object)itemReqDto);
            itemReqDto.setBatchNo(o.getBatch());
            itemReqDto.setItemName(o.getGoodsName());
            itemReqDto.setItemCode(o.getGoodsCode());
            itemReqDto.setSkuCode(o.getGoodsSku());
            itemReqDto.setItemNum(o.getGoodsNum());
            itemReqDto.setGift(o.getIsGiftFlag() != null ? Integer.valueOf(o.getIsGiftFlag().toString()) : null);
            itemReqDto.setItemId(StringUtils.isNotBlank((CharSequence)o.getGoodsId()) ? Long.valueOf(o.getGoodsId()) : null);
            itemReqDto.setPrice(o.getGoodsPrice());
            itemReqDto.setClaimPrice(o.getClaimPrice());
            if (addSaleOrderParams.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_REISSUE.getBusinessType()) || addSaleOrderParams.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_POSTING.getBusinessType())) {
                itemReqDto.setSettleRate(o.getSettleRate());
                itemReqDto.setOrderTotalAmount(o.getClaimTotalAmount());
            }
            if (this.isOutOrder(SaleOrderTypeEnum.enumOf((String)reqDto.getOrderType()).getDesc())) {
                itemReqDto.setSalePrice(BigDecimal.ZERO);
                itemReqDto.setPrice(BigDecimal.ZERO);
            }
            itemReqDtos.add(itemReqDto);
        });
        reqDto.setItemList(itemReqDtos);
        List<OrderCenterGoodsVO> giftList = addSaleOrderParams.getGiftList();
        List<Object> giftItemReqDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty(giftList)) {
            giftItemReqDtos = giftList.stream().map(o -> {
                SaleOrderItemReqDto itemReqDto = new SaleOrderItemReqDto();
                BeanUtils.copyProperties((Object)o, (Object)itemReqDto);
                itemReqDto.setBatchNo(o.getBatch());
                itemReqDto.setItemName(o.getGoodsName());
                itemReqDto.setItemCode(o.getGoodsCode());
                itemReqDto.setSkuCode(o.getGoodsSku());
                itemReqDto.setItemNum(o.getGoodsNum());
                itemReqDto.setGift(o.getIsGiftFlag() != null ? Integer.valueOf(o.getIsGiftFlag().toString()) : null);
                itemReqDto.setItemId(StringUtils.isNotBlank((CharSequence)o.getGoodsId()) ? Long.valueOf(o.getGoodsId()) : null);
                itemReqDto.setPrice(o.getGoodsPrice());
                itemReqDto.setClaimPrice(o.getClaimPrice());
                if (this.isOutOrder(SaleOrderTypeEnum.enumOf((String)reqDto.getOrderType()).getDesc())) {
                    itemReqDto.setSalePrice(BigDecimal.ZERO);
                    itemReqDto.setPrice(BigDecimal.ZERO);
                }
                return itemReqDto;
            }).collect(Collectors.toList());
        }
        reqDto.setGiftList(giftItemReqDtos);
    }

    private void getSaleOrderAddrReqDto(AddSaleOrderParams addSaleOrderParams, BizSaleOrderReqDto reqDto) {
        SaleOrderAddrReqDto saleOrderAddrReqDto = new SaleOrderAddrReqDto();
        com.dtyunxi.cis.pms.biz.model.AddressVO addressVO = addSaleOrderParams.getOrderAddress();
        BeanUtils.copyProperties((Object)addressVO, (Object)saleOrderAddrReqDto);
        saleOrderAddrReqDto.setCounty(addressVO.getDistrict());
        saleOrderAddrReqDto.setCountyCode(addressVO.getDistrictCode());
        saleOrderAddrReqDto.setReceiveAddress(addressVO.getDetailAddress());
        saleOrderAddrReqDto.setReceiveName(addSaleOrderParams.getDeliveryName());
        saleOrderAddrReqDto.setReceivePhone(addSaleOrderParams.getDeliveryPhone());
        saleOrderAddrReqDto.setPostcode(addSaleOrderParams.getPostcode());
        reqDto.setOrderAddrReqDto(saleOrderAddrReqDto);
    }

    @Override
    public RestResponse<Object> cancelDeliverySaleOrder(@Valid OrderOperationVO orderOperationVO) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> cancelSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.cancelOrder((Long)orderIdList.get(0), orderOperationVO.getCancelReason())));
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.cancelOrder(orderId, orderOperationVO.getCancelReason()));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u53d6\u6d88\u8ba2\u5355]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    private void throwExceptoinMessage(List<Long> orderIdOfexceptionList, String message, Map<Long, String> errMessageMap, Integer successNum, Integer failNum) {
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds(orderIdOfexceptionList));
        StringBuilder messageBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
            for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                messageBuilder.append("\u5185\u90e8\u9500\u552e\u8ba2\u5355\uff1a").append(saleOrderRespDto.getSaleOrderNo());
                if (StringUtils.isNotEmpty((CharSequence)saleOrderRespDto.getEasOrderNo())) {
                    messageBuilder.append(",EAS\u5355\u53f7\uff1a").append(saleOrderRespDto.getEasOrderNo());
                }
                messageBuilder.append(errMessageMap.get(saleOrderRespDto.getId())).append("; \n");
            }
        }
        throw new BizException(PcpTradeExceptionCode.BATCH_OPT_EXCEPTION.getCode(), String.format(message, successNum, failNum, messageBuilder.toString()));
    }

    @Override
    public RestResponse<Object> changeSaleOrderLogicalWarehouse(@Valid ChangeSaleOrderLogicalWarehouseParams changeSaleOrderLogicalWarehouseParams) {
        ModifyLogicalWarehouseReqDto modifyLogicalWarehouseReqDto = new ModifyLogicalWarehouseReqDto();
        modifyLogicalWarehouseReqDto.setLogicalWarehouseCode(changeSaleOrderLogicalWarehouseParams.getLogicalWarehouseCode());
        modifyLogicalWarehouseReqDto.setLogicalWarehouseId(Long.valueOf(changeSaleOrderLogicalWarehouseParams.getLogicalWarehouseId()));
        List orderIdList = changeSaleOrderLogicalWarehouseParams.getOrderIdList().stream().map(orderId -> Long.valueOf(orderId)).collect(Collectors.toList());
        modifyLogicalWarehouseReqDto.setOrderIdList(orderIdList);
        RestResponseHelper.extractData((RestResponse)this.saleOrderApi.changeLogicalWarehouse(modifyLogicalWarehouseReqDto));
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds(orderIdList));
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            if (!Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode())) continue;
            OrderOperationVO orderOperationVO = new OrderOperationVO();
            orderOperationVO.setOrderIdList(Lists.newArrayList((Object[])new String[]{saleOrderRespDto.getId() + ""}));
            if (Objects.equals(changeSaleOrderLogicalWarehouseParams.getNegativeValidateFlag(), YesOrNoEnum.YES.getCode())) {
                logger.info("\u5f85\u914d\u8d27\u72b6\u6001\u6307\u5b9a\u53d1\u8d27\u4ed3\u5e76\u8d85\u5e93\u5b58\u53d1\u8d27");
                this.advancePick(orderOperationVO);
                continue;
            }
            logger.info("\u5f85\u914d\u8d27\u72b6\u6001\u6307\u5b9a\u53d1\u8d27\u4ed3\u5e76\u914d\u8d27");
            this.distributionSaleOrder(orderOperationVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> confirmReceiveSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.confirmReceiptGoods((Long)orderIdList.get(0))));
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.confirmReceiptGoods(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u786e\u8ba4\u6536\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> confirmSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.checkOrder((Long)orderIdList.get(0)));
            this.sendAutoDisPatchMsg((Long)orderIdList.get(0));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.checkOrder(orderId));
                this.sendAutoDisPatchMsg(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u64cd\u4f5c\u8ba2\u5355\u786e\u8ba4]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public void sendAutoDisPatchMsg(Long orderId) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)orderId);
        logger.info("\u81ea\u52a8-\u786e\u8ba4\u8ba2\u5355id={}", (Object)orderId);
        this.commonsMqService.sendDelaySingleMessage("ORDER_AUTO_DISPATCH", (Object)messageVo, Long.valueOf(3L));
    }

    @Override
    public void autoDisPatch(Long orderId) {
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{orderId})));
        SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)saleOrderRespDtos.get(0);
        if (Objects.equals(saleOrderRespDto.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
            logger.info("\u9ea6\u4f18\u8ba2\u5355\u4e0d\u5339\u914d\u81ea\u52a8\u914d\u8d27\u7b56\u7565");
            OrderOperationVO orderOperationVO = new OrderOperationVO();
            orderOperationVO.setOrderIdList(Lists.newArrayList((Object[])new String[]{orderId + ""}));
            this.distributionSaleOrder(orderOperationVO);
            return;
        }
        SaleOrderOptLogReqDto saleOrderOptLogReqDto = new SaleOrderOptLogReqDto();
        saleOrderOptLogReqDto.setSaleOrderId(orderId);
        saleOrderOptLogReqDto.setOptTime(new Date());
        String optPerson = StringUtils.isNotBlank((CharSequence)ServiceContext.getContext().getRequestUserCode()) ? ServiceContext.getContext().getRequestUserCode() : "system";
        saleOrderOptLogReqDto.setOptPerson(optPerson);
        saleOrderOptLogReqDto.setOptType("\u81ea\u52a8\u914d\u8d27");
        String content = "\u672a\u5339\u914d\u5230\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u89c4\u5219";
        DistributionClueSuitActReqDto suitActReqDto = new DistributionClueSuitActReqDto();
        suitActReqDto.setCustomerId(saleOrderRespDto.getCustomerId());
        suitActReqDto.setOrderType(saleOrderRespDto.getOrderType());
        suitActReqDto.setOrganizationId(saleOrderRespDto.getOrganizationId());
        DistributionClueActRespDto clueActRespDto = (DistributionClueActRespDto)RestResponseHelper.extractData((RestResponse)this.distributionClueQueryApi.querySuitClueByOrder(suitActReqDto));
        logger.info("\u81ea\u52a8-\u914d\u8d27\uff08\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\uff09id={},\u81ea\u52a8\u914d\u8d27\u7b56\u7565={}", (Object)orderId, JSON.toJSON((Object)clueActRespDto));
        if (Objects.isNull(clueActRespDto)) {
            saleOrderOptLogReqDto.setOptContent(content);
            try {
                this.saleOrderOptLogApi.addSaleOrderOptLog(saleOrderOptLogReqDto);
            }
            catch (Exception e) {
                logger.info("\u81ea\u52a8\u914d\u8d27\u5339\u914d\u7b56\u7565\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            return;
        }
        content = "\u5339\u914d\u5230\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u89c4\u5219" + clueActRespDto.getClueName() + "\u3010" + clueActRespDto.getClueCode() + "\u3011";
        saleOrderOptLogReqDto.setOptContent(content);
        try {
            this.saleOrderOptLogApi.addSaleOrderOptLog(saleOrderOptLogReqDto);
        }
        catch (Exception e) {
            logger.info("\u81ea\u52a8\u914d\u8d27\u5339\u914d\u7b56\u7565\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        if (Objects.equals(clueActRespDto.getClueSettings(), 1)) {
            try {
                this.orderTagRecordApi.saveLjddTagByOrder(orderId);
            }
            catch (Exception e) {
                logger.info("\u81ea\u52a8\u914d\u8d27\u5339\u914d\u7b56\u7565\u6253\u6807\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            logger.info("\u81ea\u52a8-\u914d\u8d27\uff08\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\uff09id={},\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u9700\u8981\u7b49\u5f85\u914d\u8d27", (Object)orderId);
            return;
        }
        OrderOperationVO orderOperationVO = new OrderOperationVO();
        orderOperationVO.setOrderIdList(Lists.newArrayList((Object[])new String[]{orderId + ""}));
        this.distributionSaleOrder(orderOperationVO);
    }

    @Override
    public void autoSync(Long orderId) {
        Boolean autoSync = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.SALES_ORDER_AUTO_SYNC.getGroupCode(), DictEnum.SALES_ORDER_AUTO_SYNC.getCode()).getData()).map(DictDto::getValue).map(Integer::parseInt).map(YesOrNoEnum::isYes).orElse(false);
        logger.info("\u81ea\u52a8-\u7ee7\u7eed\u53d1\u8d27\uff08\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\uff09id={},autoSync={}", (Object)orderId, (Object)autoSync);
        if (!autoSync.booleanValue()) {
            return;
        }
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{orderId})));
        SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)saleOrderRespDtos.get(0);
        if (Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.SPLIT.getCode())) {
            logger.info("\u81ea\u52a8-\u7ee7\u7eed\u53d1\u8d27\u8ba2\u5355\u72b6\u6001\u662f\u88ab\u62c6\u5206");
            return;
        }
        String orderTypeDictValue = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "ORDER_AUTO_SYNC_ORDER_TYPE").getData()).map(DictDto::getValue).orElse(null);
        logger.info("\u81ea\u52a8-\u7ee7\u7eed\u53d1\u8d27\uff08\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\uff09id={},orderTypeDictValue={}", (Object)orderId, (Object)orderTypeDictValue);
        Boolean autoSyncFalg = false;
        if (StringUtils.isNotEmpty((CharSequence)orderTypeDictValue)) {
            Map map = (Map)JSON.parseObject((String)orderTypeDictValue, Map.class);
            String check = map.get("check").toString();
            if (Objects.equals(check, "1")) {
                List orderTypeList = (List)map.get("orderType");
                if (CollectionUtils.isEmpty((Collection)orderTypeList) || orderTypeList.contains(saleOrderRespDto.getOrderType())) {
                    autoSyncFalg = true;
                }
            } else {
                autoSyncFalg = true;
            }
        }
        logger.info("\u81ea\u52a8-\u7ee7\u7eed\u53d1\u8d27\uff08\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\uff09id={},autoSyncFalg={}", (Object)orderId, (Object)autoSyncFalg);
        if (!autoSyncFalg.booleanValue()) {
            return;
        }
        OrderOperationVO orderOperationVO = new OrderOperationVO();
        orderOperationVO.setOrderIdList(Lists.newArrayList((Object[])new String[]{orderId + ""}));
        this.continueDeliverySaleOrder(orderOperationVO);
    }

    @Override
    public RestResponse<Object> continueDeliverySaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.continueDeliver((Long)orderIdList.get(0)));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.continueDeliver(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u64cd\u4f5c\u8ba2\u5355\u540c\u6b65]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> distributionSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds(orderIdList));
        if (saleOrderRespDtos.size() == 1) {
            this.singlePick((SaleOrderRespDto)saleOrderRespDtos.get(0), orderOperationVO.getCompletePickFlag(), orderOperationVO.getAutoPickFlag());
            if (!Objects.equals(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
                this.sendAutoSyncMsg(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getId());
            }
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            try {
                this.singlePick(saleOrderRespDto, orderOperationVO.getCompletePickFlag(), orderOperationVO.getAutoPickFlag());
                if (Objects.equals(saleOrderRespDto.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) continue;
                this.sendAutoSyncMsg(saleOrderRespDto.getId());
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(saleOrderRespDto.getId());
                errMessageMap.put(saleOrderRespDto.getId(), e.getMessage());
                logger.error("[\u6279\u91cf\u914d\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    private void sendAutoSyncMsg(Long id) {
        OrderTagRecordReqDto orderTagRecordReqDto = new OrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(id);
        orderTagRecordReqDto.setTagCode("GSLJ");
        PageInfo orderTagRecordRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderTagRecordQueryApi.queryByPage(JSON.toJSONString((Object)orderTagRecordReqDto), Integer.valueOf(1), Integer.valueOf(10)));
        if (CollectionUtils.isNotEmpty((Collection)orderTagRecordRespDtoPageInfo.getList())) {
            logger.info("\u62e6\u622a\u7b49\u5f85\u6807\u7b7e\u8ba2\u5355\u4e0d\u81ea\u52a8\u540c\u6b65\uff0corderId={}", (Object)id);
            return;
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)id);
        this.commonsMqService.sendDelaySingleMessage("ORDER_AUTO_SYNC", (Object)messageVo, Long.valueOf(30L));
    }

    public void singlePick(SaleOrderRespDto saleOrder, Integer completePickFlag, Boolean autoPickFlag) {
        if (Objects.equals(saleOrder.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
            if (Objects.equals(saleOrder.getAllotType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType())) {
                logger.info("bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u5bfb\u6e90\u53d1\u8d27={}", (Object)saleOrder.getId());
                this.bcAutoSourceDelivery(saleOrder);
            } else if (Objects.equals(saleOrder.getAllotType(), AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType())) {
                if (Objects.equals(saleOrder.getIfSourceWarehouseSpilt(), 1)) {
                    logger.info("[bc\u540c\u7ec4\u7ec7\u8c03\u62e8\u914d\u8d27]\u8ba2\u5355\uff08{}\uff09\u8d70\u5bfb\u6e90\u8fdb\u884c\u914d\u8d27", (Object)saleOrder.getSaleOrderNo());
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.autoArrangeWarehouseBySource(saleOrder.getId()));
                } else {
                    logger.info("[bc\u540c\u7ec4\u7ec7\u8c03\u62e8\u914d\u8d27]\u8ba2\u5355\uff08{}\uff09\u8d70\u6307\u5b9a\u903b\u8f91\u4ed3\u914d\u8d27", (Object)saleOrder.getSaleOrderNo());
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.arrangeWarehouseForDeliver(saleOrder.getId(), new ArrayList()));
                }
            } else if (Objects.equals(saleOrder.getAllotType(), AllotTypeEnum.MAIYOU_CB_SAME_ORG_ALLOT.getType())) {
                logger.info("[cb\u540c\u7ec4\u7ec7\u8c03\u62e8\u914d\u8d27]\u8ba2\u5355\uff08{}\uff09\u8d70\u6307\u5b9a\u6279\u6b21\u8fdb\u884c\u914d\u8d27", (Object)saleOrder.getSaleOrderNo());
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.arrangeWarehouseByAppoint(saleOrder.getId()));
            } else {
                logger.info("cc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u76f4\u63a5\u53d1\u8d27={}", (Object)saleOrder.getId());
                try {
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.maiyouCCAllotPick(saleOrder.getId()));
                }
                catch (Exception e) {
                    logger.info("cc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u76f4\u63a5\u53d1\u8d27\u5f02\u5e38={}", (Object)e.getMessage());
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            logger.info("\u9ea6\u4f18\u8ba2\u5355\u4e0d\u8fdb\u884c\u5bfb\u6e90\u914d\u8d27\u64cd\u4f5c");
            return;
        }
        this.cacheService.setCache("SALE_ORDER_SPLIT_INTERCEPT_GROUP", saleOrder.getSaleOrderNo(), (Object)autoPickFlag, SALE_ORDER_INTRANSIT_TIME.intValue());
        String optLabel = saleOrder.getOptLabel();
        if (OrderOptLabelUtils.containsLabel(optLabel, OrderOptLabelEnum.APPOINT_BATCH.getCode()).booleanValue() || OrderOptLabelUtils.containsLabel(optLabel, OrderOptLabelEnum.MODIFY_LOGICAL_WAREHOUSE.getCode()).booleanValue()) {
            logger.info("[\u6279\u91cf\u914d\u8d27]\u8ba2\u5355\uff08{}\uff09\u8d70\u6307\u5b9a\u6279\u6b21\u8fdb\u884c\u914d\u8d27", (Object)saleOrder.getSaleOrderNo());
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.arrangeWarehouseByAppoint(saleOrder.getId()));
        } else if (Objects.equals(completePickFlag, YesOrNoEnum.YES.getCode())) {
            logger.info("[\u6279\u91cf\u914d\u8d27]\u8ba2\u5355\uff08{}\uff09\u8d70\u5bfb\u6e90\u8fdb\u884c\u6574\u5355\u914d\u8d27", (Object)saleOrder.getSaleOrderNo());
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.completeArrangeWarehouseBySource(saleOrder.getId()));
        } else {
            logger.info("[\u6279\u91cf\u914d\u8d27]\u8ba2\u5355\uff08{}\uff09\u8d70\u5bfb\u6e90\u8fdb\u884c\u914d\u8d27", (Object)saleOrder.getSaleOrderNo());
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.autoArrangeWarehouseBySource(saleOrder.getId()));
        }
    }

    private void bcAutoSourceDelivery(SaleOrderRespDto saleOrder) {
        SourcingOrderResultVO sourcingOrderResultVO = this.systemSettingSourcingOrderLogService.saleOrderSource(Lists.newArrayList((Object[])new String[]{saleOrder.getSaleOrderNo()}));
        logger.info("bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u5bfb\u6e90\u7ed3\u679c={}", JSON.toJSON((Object)sourcingOrderResultVO));
        if (CollectionUtils.isNotEmpty(sourcingOrderResultVO.getSuccessList())) {
            ArrayList list = Lists.newArrayList();
            for (ReplenishmentSourcingOrderVO replenishmentSourcingOrderVO : sourcingOrderResultVO.getSuccessList()) {
                SplitOrderBySourceInfoReqDto splitOrderReqDto = new SplitOrderBySourceInfoReqDto();
                splitOrderReqDto.setSaleOrderId(replenishmentSourcingOrderVO.getOrderId());
                splitOrderReqDto.setSaleOrderNo(replenishmentSourcingOrderVO.getSaleOrderNo());
                splitOrderReqDto.setIntransitPreemptFlag(replenishmentSourcingOrderVO.getIntransitPreemptFlag());
                splitOrderReqDto.setDeliveryType(replenishmentSourcingOrderVO.getDeliveryType());
                splitOrderReqDto.setDeliveryLogicWarehouseCode(replenishmentSourcingOrderVO.getOutLogicWarehouseCode());
                splitOrderReqDto.setDeliveryLogicWarehouseId(replenishmentSourcingOrderVO.getOutLogicWarehouseId());
                splitOrderReqDto.setDeliveryLogicWarehouseName(replenishmentSourcingOrderVO.getOutLogicWarehouseName());
                splitOrderReqDto.setTransferLogicWarehouseCode(replenishmentSourcingOrderVO.getTransferLogicWarehouseCode());
                splitOrderReqDto.setTransferLogicWarehouseId(replenishmentSourcingOrderVO.getTransferLogicWarehouseId());
                splitOrderReqDto.setTransferLogicWarehouseName(replenishmentSourcingOrderVO.getTransferLogicWarehouseName());
                splitOrderReqDto.setInLogicWarehouseCode(replenishmentSourcingOrderVO.getInLogicWarehouseCode());
                splitOrderReqDto.setInLogicWarehouseId(replenishmentSourcingOrderVO.getInLogicWarehouseId());
                splitOrderReqDto.setInLogicWarehouseName(replenishmentSourcingOrderVO.getInLogicWarehouseName());
                ArrayList goodsList = Lists.newArrayList();
                for (ReplenishmentSourcingOrderItemVO sourcingOrderItemVO : replenishmentSourcingOrderVO.getItemList()) {
                    SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
                    splitOrderItemReqDto.setDeliveryItemBatchNo(sourcingOrderItemVO.getDeliveryItemBatchNo());
                    splitOrderItemReqDto.setGoodsCode(sourcingOrderItemVO.getItemCode());
                    splitOrderItemReqDto.setGoodsId(sourcingOrderItemVO.getItemId());
                    splitOrderItemReqDto.setIsGiftFlag(Integer.valueOf(0));
                    splitOrderItemReqDto.setGoodsNum(sourcingOrderItemVO.getDeliveryItemNum());
                    splitOrderItemReqDto.setGoodsSku(sourcingOrderItemVO.getItemSkuCode());
                    splitOrderItemReqDto.setOriginalOrderGoodsId(sourcingOrderItemVO.getOrderItemId());
                    splitOrderItemReqDto.setWarehouseItemNum(sourcingOrderItemVO.getWarehouseItemNum());
                    splitOrderItemReqDto.setZtDeliveryWarehouseItemNum(sourcingOrderItemVO.getZtDeliveryWarehouseItemNum());
                    splitOrderItemReqDto.setZtWarehouseItemNum(sourcingOrderItemVO.getZtWarehouseItemNum());
                    goodsList.add(splitOrderItemReqDto);
                }
                splitOrderReqDto.setGoodsList((List)goodsList);
                list.add(splitOrderReqDto);
            }
            try {
                logger.info("bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u9500\u552e\u5355\u53d1\u8d27\u5165\u53c2={}", JSON.toJSON((Object)list));
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.sourceDeliveryAndTransferMaiyou(saleOrder.getId(), (List)list));
            }
            catch (Exception e) {
                logger.info("bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u9500\u552e\u5355\u53d1\u8d27\u5f02\u5e38={}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (CollectionUtils.isNotEmpty(sourcingOrderResultVO.getFailList())) {
            List<SourcingOrderFailResultVO> failList = sourcingOrderResultVO.getFailList();
            SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
            saleOrderReqDto.setId(saleOrder.getId());
            saleOrderReqDto.setInterceptInfo(failList.get(0).getErrorMsg());
            logger.info("\u66f4\u65b0\u9ea6\u4f18\u8c03\u62e8\u8865\u8d27\u5355\u5bfb\u6e90\u5f02\u5e38={}", JSON.toJSON((Object)saleOrderReqDto));
            RestResponseHelper.extractData((RestResponse)this.saleOrderApi.modifySaleOrder(saleOrderReqDto));
        }
    }

    @Override
    public RestResponse<PageInfo<OrderCenterGoodsVO>> getSaleOrderAddGoodsListPage(@Valid GetSaleOrderAddGoodsListPageParams getSaleOrderAddGoodsListPageParams) {
        CargoStorageTotalReqDto reqDto = new CargoStorageTotalReqDto();
        BeanUtils.copyProperties((Object)getSaleOrderAddGoodsListPageParams, (Object)reqDto);
        reqDto.setChannelId(getSaleOrderAddGoodsListPageParams.getOrderChannelId() != null ? Long.valueOf(getSaleOrderAddGoodsListPageParams.getOrderChannelId()) : null);
        reqDto.setCargoName(getSaleOrderAddGoodsListPageParams.getGoodsName());
        reqDto.setCargoCode(getSaleOrderAddGoodsListPageParams.getGoodsCode());
        reqDto.setWarehouseCode(getSaleOrderAddGoodsListPageParams.getChannelWarehouseCode());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.channelInventoryQueryApi.queryInventoryItemSku(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            List skuCodeList = respDtoPageInfo.getList().stream().map(CargoStorageTotalRespDto::getLongCode).distinct().collect(Collectors.toList());
            List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(skuCodeList));
            Map<Object, Object> itemInfoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
                itemInfoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k2));
            }
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            Map<Object, Object> finalItemInfoMap = itemInfoMap;
            List list = respDtoPageInfo.getList().stream().map(o -> this.getOrderCenterGoodsVO((CargoStorageTotalRespDto)o, (Map<String, PcpItemRespDto>)finalItemInfoMap)).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    private OrderCenterGoodsVO getOrderCenterGoodsVO(CargoStorageTotalRespDto o, Map<String, PcpItemRespDto> itemInfoMap) {
        OrderCenterGoodsVO vo = new OrderCenterGoodsVO();
        BeanUtils.copyProperties((Object)o, (Object)vo);
        vo.setGoodsId(String.valueOf(o.getId()));
        vo.setGoodsName(o.getCargoName());
        vo.setGoodsCode(o.getCargoCode());
        vo.setGoodsSku(o.getLongCode());
        vo.setAvailableInventory(o.getAvailable());
        if (o.getItemType() != null) {
            if (ItemTypeEnum.GIFT.getCode().equals(o.getItemType())) {
                vo.setIsGiftFlag(new BigDecimal(IsGiftFlagEnum.YES.getCode()));
            } else {
                vo.setIsGiftFlag(new BigDecimal(IsGiftFlagEnum.NO.getCode()));
            }
        }
        vo.setGoodsPrice(o.getPrice());
        vo.setChannelWarehouseCode(o.getWarehouseCode());
        if (!itemInfoMap.isEmpty() && itemInfoMap.containsKey(o.getLongCode())) {
            PcpItemRespDto pcpItemRespDto = itemInfoMap.get(o.getLongCode());
            vo.setGoodsPrice(pcpItemRespDto.getRecommendPrice());
            vo.setClaimPrice(pcpItemRespDto.getClaimPrice());
            vo.setRecommendPrice(pcpItemRespDto.getRecommendPrice());
        }
        return vo;
    }

    @Override
    public RestResponse<SaleOrderCountVO> getSaleOrderCount(@Valid GetSaleOrderCountParams getSaleOrderCountParams) {
        String[] orderNos;
        String[] split;
        com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto reqDto = new com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto();
        BeanUtils.copyProperties((Object)getSaleOrderCountParams, (Object)reqDto, (String[])new String[]{"orderLevelList"});
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getSaleOrderCreateTimeStart())) {
            reqDto.setSaleOrderCreateTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getSaleOrderCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getSaleOrderCreateTimeEnd())) {
            reqDto.setSaleOrderCreateTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getSaleOrderCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getDeliveryTimeEnd())) {
            reqDto.setDeliveryTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getDeliveryTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getDeliveryTimeStart())) {
            reqDto.setDeliveryTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getDeliveryTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getUpdateTimeStart())) {
            reqDto.setUpdateTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getUpdateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getUpdateTimeEnd())) {
            reqDto.setUpdateTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getUpdateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getBizDateStart())) {
            reqDto.setBizDateStart(DateUtil.parse((String)(getSaleOrderCountParams.getBizDateStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getBizDateEnd())) {
            reqDto.setBizDateEnd(DateUtil.parse((String)(getSaleOrderCountParams.getBizDateEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getSaleOrderCountParams.getSaleOrderStatus())) {
            split = getSaleOrderCountParams.getSaleOrderStatus().split(",");
            List<String> saleOrderStatusList = Arrays.asList(split);
            reqDto.setSaleOrderStatus(null);
            reqDto.setSaleOrderStatusList(saleOrderStatusList);
        }
        if (StringUtils.isNotEmpty((CharSequence)getSaleOrderCountParams.getOrderSource())) {
            split = getSaleOrderCountParams.getOrderSource().split(",");
            List orderSourceList = Arrays.asList(split).stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList());
            reqDto.setOrderSource(null);
            reqDto.setOrderSourceList(orderSourceList);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo())).length > 1) {
            reqDto.setOrderNoList(Arrays.asList(orderNos));
            reqDto.setOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getEasOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getEasOrderNo())).length > 1) {
            reqDto.setEasOrderNoList(Arrays.asList(orderNos));
            reqDto.setEasOrderNo(null);
        }
        reqDto.setOrderLevelList(getSaleOrderCountParams.getOrderLevelList());
        reqDto.setStringCodeResultList(getSaleOrderCountParams.getStringCodeResultList());
        reqDto.setEasVerifyStatusList(getSaleOrderCountParams.getEasVerifyStatusList());
        reqDto.setTagCodeList(getSaleOrderCountParams.getTagCodeList());
        reqDto.setOrganizationIdList(getSaleOrderCountParams.getOrganizationIdList());
        SaleOrderCountRespDto respDto = (SaleOrderCountRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.queryByCount(reqDto));
        SaleOrderCountVO vo = new SaleOrderCountVO();
        if (respDto != null) {
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<List<DeliveryInfoVo>> getSaleOrderDeliveryInfo(@Valid String no, @Valid String id) {
        if (StringUtils.isBlank((CharSequence)no)) {
            throw new BizException("\u8ba2\u5355no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List dtos = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(no));
        if (CollectionUtils.isNotEmpty((Collection)dtos)) {
            List list = dtos.stream().map(o -> {
                DeliveryInfoVo vo = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                if (o.getConsignmentType() != null) {
                    vo.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return vo;
            }).collect(Collectors.toList());
            return new RestResponse(list);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<SaleOrderVO> getSaleOrderDetail(@Valid String no, @Valid String id) {
        BizSaleOrderRespDto respDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(no));
        logger.info("\u5f53\u524d\u8ba2\u5355:{}\u67e5\u8be2\u5230\u8ba2\u5355\u8be6\u60c5\u4e3a:{}", (Object)no, (Object)JSON.toJSONString((Object)respDto));
        if (respDto != null) {
            List relatedOrderList;
            SaleOrderVO vo = new SaleOrderVO();
            BeanUtils.copyProperties((Object)respDto, (Object)vo);
            vo.setOrderTags(respDto.getTagList());
            vo.setOrderLevel(respDto.getOrderLevel());
            vo.setOrderRemark(respDto.getRemark());
            vo.setDeliveryName(respDto.getDeliveryCompany());
            SaleOrderAddrRespDto orderAddrRespDto = respDto.getOrderAddrRespDto();
            if (orderAddrRespDto != null) {
                this.getSaleOrderAddrRespDto(vo, orderAddrRespDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)(relatedOrderList = respDto.getRelatedOrderList()))) {
                this.getRelatedOrderList(vo, relatedOrderList, respDto.getOrderLevel());
            }
            if (respDto.getSaleCreateTime() != null) {
                vo.setSaleOrderCreateTime(DateUtil.format((Date)respDto.getSaleCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (respDto.getConfirmReceiveTime() != null) {
                vo.setConfirmReceiveTime(DateUtil.format((Date)respDto.getConfirmReceiveTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (respDto.getPlatformCreateTime() != null) {
                vo.setPlatformCreateTime(DateUtil.format((Date)respDto.getPlatformCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setPayStatus(ParamConverter.convertToString((Object)respDto.getPayStatus()));
            if (respDto.getPayTime() != null) {
                vo.setPayTime(DateUtil.format((Date)respDto.getPayTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setPayableAmount(respDto.getOrderTotalAmount());
            this.getOrderSteps(respDto, vo);
            vo.setOrderType(ParamConverter.convertToString((Object)respDto.getOrderType()));
            vo.setOrderSource(ParamConverter.convertToString((Object)respDto.getOrderSource()));
            vo.setSaleOrderStatus(respDto.getOrderStatus());
            vo.setPayStatus(ParamConverter.convertToString((Object)respDto.getPayStatus()));
            vo.setAllowSplitFlag(ParamConverter.convertToString((Object)respDto.getAllowSplitFlag()));
            vo.setOrderChannelName(respDto.getChannelName());
            vo.setOrderChannelId(ParamConverter.convertToString((Object)respDto.getChannelId()));
            vo.setDeliveryLogicalWarehouseCode(respDto.getLogicalWarehouseCode());
            vo.setDeliveryLogicalWarehouseId(ParamConverter.convertToString((Object)respDto.getLogicalWarehouseId()));
            vo.setDeliveryLogicalWarehouseName(respDto.getLogicalWarehouseName());
            vo.setPlatformOrderId(ParamConverter.convertToString((Object)respDto.getPlatformOrderId()));
            this.getOrderPreRespDtoList(respDto, vo);
            return new RestResponse((Object)vo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<List<OrderCenterBatchVo>> getSaleOrderGoodsBatchList(@Valid GetOrderCenterBatchListParams getOrderCenterBatchListParams) {
        CsInventoryBatchQueryReqDto csInventoryBatchQueryReqDto = new CsInventoryBatchQueryReqDto();
        csInventoryBatchQueryReqDto.setBatchLike(getOrderCenterBatchListParams.getBatchWord());
        csInventoryBatchQueryReqDto.setLongCode(getOrderCenterBatchListParams.getGoodsSku());
        csInventoryBatchQueryReqDto.setWarehouseCode(getOrderCenterBatchListParams.getWarehouseCode());
        csInventoryBatchQueryReqDto.setGtZero(getOrderCenterBatchListParams.getIsGtZero());
        List csInventoryBatchQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryBatchInfo(csInventoryBatchQueryReqDto));
        ArrayList<Object> result = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInventoryBatchQueryRespDtos)) {
            result = new ArrayList(csInventoryBatchQueryRespDtos.stream().map(o -> {
                OrderCenterBatchVo orderCenterBatchVo = new OrderCenterBatchVo();
                orderCenterBatchVo.setId(ParamConverter.convertToString((Object)o.getId()));
                orderCenterBatchVo.setBatchNo(ParamConverter.convertToString((Object)o.getBatch()));
                orderCenterBatchVo.setBatchId(ParamConverter.convertToString((Object)o.getId()));
                return orderCenterBatchVo;
            }).collect(Collectors.toMap(OrderCenterBatchVo::getBatchNo, Function.identity(), (o, o1) -> o)).values());
        }
        return new RestResponse(result);
    }

    private PageInfo<CsDeliveryResultOrderRespDto> getCsDeliveryResultOrderRespDtoPageInfo(String saleOrderNo) {
        CsDeliveryResultOrderQueryDto csDeliveryResultOrderQueryDto = new CsDeliveryResultOrderQueryDto();
        csDeliveryResultOrderQueryDto.setPreOrderNo(saleOrderNo);
        csDeliveryResultOrderQueryDto.setPageNum(Integer.valueOf(1));
        csDeliveryResultOrderQueryDto.setPageSize(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByPage(csDeliveryResultOrderQueryDto));
        return pageInfo;
    }

    private void getOrderPreRespDtoList(BizSaleOrderRespDto respDto, SaleOrderVO vo) {
        List orderPreRespDtoList;
        ArrayList<RelationBillVO> relationOrderVOList = new ArrayList<RelationBillVO>();
        OrderReqDto orderReqDto = new OrderReqDto();
        orderReqDto.setLinkOrderNo(respDto.getSaleOrderNo());
        orderReqDto.setSourceType(SourceTypeEnum.PICK.code);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderQueryApi.queryByPage(JSON.toJSONString((Object)orderReqDto), Integer.valueOf(1), Integer.valueOf(2000)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(o -> {
                RelationBillVO relationOrderVO = new RelationBillVO();
                relationOrderVO.setBillNo(o.getSgOrderNo());
                relationOrderVO.setBillType("source_order");
                relationOrderVO.setBillStatus(o.getSgStatus());
                relationOrderVO.setBillId(o.getId());
                relationOrderVO.setCreateTime(o.getCreateTime());
                relationOrderVOList.add(relationOrderVO);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(orderPreRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.handlePreDocumentInfoByOrderNo(respDto.getSaleOrderNo()))))) {
            orderPreRespDtoList.forEach(o -> {
                RelationBillVO relationOrderVO = new RelationBillVO();
                relationOrderVO.setBillNo(o.getDocumentNo());
                relationOrderVO.setBillType(o.getDocumentType());
                relationOrderVO.setBillStatus(o.getOrderStatus());
                relationOrderVO.setCreateTime(o.getCreateTime());
                relationOrderVOList.add(relationOrderVO);
            });
        }
        relationOrderVOList.sort(Comparator.comparing(RelationBillVO::getCreateTime).reversed());
        vo.setRelationBillList(relationOrderVOList);
    }

    private void getOrderSteps(BizSaleOrderRespDto respDto, SaleOrderVO vo) {
        List statusLogRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryOrderStatus(respDto.getId()));
        if (CollectionUtils.isNotEmpty((Collection)statusLogRespDtos)) {
            List<OrderStepVO> orderSteps = statusLogRespDtos.stream().map(o -> {
                OrderStepVO orderStepVO = new OrderStepVO();
                orderStepVO.setOrderStatus(o.getOrderStatus());
                orderStepVO.setHandleTime(o.getOptDate() != null ? DateUtil.format((Date)o.getOptDate(), (String)DatePattern.DATETIME_PATTERN_HHMM.getPattern()) : null);
                return orderStepVO;
            }).collect(Collectors.toList());
            vo.setOrderSteps(orderSteps);
        }
    }

    private void getRelatedOrderList(SaleOrderVO vo, List<RelatedOrderRespDto> relatedOrderList, Integer orderLevel) {
        List otherOrderList = relatedOrderList.stream().filter(o -> o.getMainOrder() == false).collect(Collectors.toList());
        if (orderLevel != null && SaleOrderLevelEnum.CHILD.getType().equals(orderLevel)) {
            List relationMainOrder = relatedOrderList.stream().filter(o -> o.getMainOrder()).collect(Collectors.toList());
            SimpleOrderVO simpleOrderVO = new SimpleOrderVO();
            if (CollectionUtils.isNotEmpty(relationMainOrder)) {
                simpleOrderVO.setOrderStatus(((RelatedOrderRespDto)relationMainOrder.get(0)).getOrderStatus());
                simpleOrderVO.setOrderNo(((RelatedOrderRespDto)relationMainOrder.get(0)).getSaleOrderNo());
                simpleOrderVO.setLockStatus(((RelatedOrderRespDto)relationMainOrder.get(0)).getLockStatus());
                vo.setMainOrder(simpleOrderVO);
            }
            if (CollectionUtils.isNotEmpty(otherOrderList)) {
                List<SimpleOrderVO> orderVOS = otherOrderList.stream().filter(o -> !vo.getSaleOrderNo().equals(o.getSaleOrderNo())).map(o -> {
                    SimpleOrderVO orderVO = new SimpleOrderVO();
                    orderVO.setOrderNo(o.getSaleOrderNo());
                    orderVO.setOrderStatus(o.getOrderStatus());
                    orderVO.setLockStatus(o.getLockStatus());
                    return orderVO;
                }).collect(Collectors.toList());
                vo.setOtherOrderList(orderVOS);
            }
        }
        if (orderLevel != null && SaleOrderLevelEnum.MAIN.getType().equals(orderLevel) && CollectionUtils.isNotEmpty(otherOrderList)) {
            List<SimpleOrderVO> orderVOS = otherOrderList.stream().map(o -> {
                SimpleOrderVO orderVO = new SimpleOrderVO();
                orderVO.setOrderNo(o.getSaleOrderNo());
                orderVO.setOrderStatus(o.getOrderStatus());
                orderVO.setLockStatus(o.getLockStatus());
                return orderVO;
            }).collect(Collectors.toList());
            vo.setOtherOrderList(orderVOS);
        }
        if (CollectionUtils.isNotEmpty(otherOrderList)) {
            List<SimpleOrderVO> splitOrderList = otherOrderList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrignalOrderNo()) && vo.getSaleOrderNo().equals(o.getOrignalOrderNo())).map(o -> {
                SimpleOrderVO orderVO = new SimpleOrderVO();
                orderVO.setOrderNo(o.getSaleOrderNo());
                orderVO.setOrderStatus(o.getOrderStatus());
                orderVO.setLockStatus(o.getLockStatus());
                return orderVO;
            }).collect(Collectors.toList());
            vo.setSplitOrderList(splitOrderList);
        }
    }

    private void getSaleOrderAddrRespDto(SaleOrderVO vo, SaleOrderAddrRespDto orderAddrRespDto) {
        com.dtyunxi.cis.pms.biz.model.AddressVO addressVO = DtoExchangeUtils.createDtoBySource(orderAddrRespDto, com.dtyunxi.cis.pms.biz.model.AddressVO.class);
        addressVO.setDistrict(orderAddrRespDto.getCounty());
        addressVO.setDistrictCode(orderAddrRespDto.getCountyCode());
        addressVO.setDetailAddress(orderAddrRespDto.getReceiveAddress());
        vo.setOrderAddress(addressVO);
        vo.setDeliveryName(orderAddrRespDto.getReceiveName());
        vo.setDeliveryPhone(orderAddrRespDto.getReceivePhone());
    }

    @Override
    public RestResponse<PageInfo<OrderCenterGoodsVO>> getSaleOrderGoodsListPage(@Valid GetSaleOrderGoodsListPageParams getSaleOrderGoodsListPageParams) {
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryByPage(Long.valueOf(getSaleOrderGoodsListPageParams.getOrderId()), getSaleOrderGoodsListPageParams.getPageNum(), getSaleOrderGoodsListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            List skuCodes = respDtoPageInfo.getList().stream().map(SaleOrderItemRespDto::getSkuCode).collect(Collectors.toList());
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            itemExtendReqDto.setItemCodeList(skuCodes);
            List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
            Map itemExtendDtoMap = itemExtendRespDtos.stream().collect(Collectors.toMap(ItemExtendRespDto::getItemCode, Function.identity(), (e1, e2) -> e1));
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List goodsVOList = respDtoPageInfo.getList().stream().map(o -> this.getOrderCenterGoodsVO((SaleOrderItemRespDto)o, (ItemExtendRespDto)itemExtendDtoMap.get(o.getSkuCode()))).collect(Collectors.toList());
            pageInfo.setList(goodsVOList);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse((Object)pageInfo);
    }

    private OrderCenterGoodsVO getOrderCenterGoodsVO(SaleOrderItemRespDto o, ItemExtendRespDto itemExtendRespDto) {
        OrderCenterGoodsVO vo = new OrderCenterGoodsVO();
        BeanUtils.copyProperties((Object)o, (Object)vo);
        vo.setGoodsId(String.valueOf(o.getItemId()));
        vo.setGoodsCode(o.getItemCode());
        vo.setGoodsName(o.getItemName());
        vo.setGoodsSku(o.getSkuCode());
        vo.setGoodsNum(o.getItemNum());
        vo.setGoodsPrice(o.getSalePrice());
        vo.setBatch(o.getBatchNo());
        vo.setRdcInfo(o.getRdc());
        vo.setVolume(o.getVolume());
        vo.setWeight(o.getWeight());
        vo.setOutItemNum(o.getOutItemNum());
        vo.setLogicalWarehouseName(o.getLogicalWarehouseName());
        vo.setIsGiftFlag(ParamConverter.convertToBigDecimal((Object)o.getGift()));
        vo.setDeliveryItemBatchNo(o.getDeliveryItemBatchNo());
        vo.setIntegral(o.getIntegral());
        vo.setDiscountAmount(o.getDiscountAmount());
        vo.setPayAmount(o.getPayAmount());
        if (itemExtendRespDto != null) {
            vo.setBigBox(itemExtendRespDto.getBigBox());
        }
        return vo;
    }

    @Override
    public RestResponse<SaleOrderGoodsNumVO> getSaleOrderGoodsNum(@Valid String no, @Valid String id) {
        SaleOrderItemSummaryRespDto respDto = (SaleOrderItemSummaryRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.querySummary(Long.valueOf(id)));
        SaleOrderGoodsNumVO vo = new SaleOrderGoodsNumVO();
        if (respDto != null) {
            vo.setGoodsTotalNum(ParamConverter.convertToBigDecimal((Object)respDto.getGoodsTotalNum()));
            vo.setJoinBoxNum(ParamConverter.convertToBigDecimal((Object)respDto.getJoinBoxNum()));
            vo.setSkuTotalNum(ParamConverter.convertToBigDecimal((Object)respDto.getSkuTotalNum()));
            vo.setTotalBoxNum(ParamConverter.convertToBigDecimal((Object)respDto.getTotalBoxNum()));
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<SaleOrderVO>> getSaleOrderListPage(com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams getSaleOrderListPageParams) {
        PageInfo saleOrderRespDtoPageInfo = new PageInfo();
        if (this.saleOrderEsQuery.booleanValue()) {
            GetSaleOrderListPageEsParams params = new GetSaleOrderListPageEsParams();
            BeanUtil.copyProperties((Object)getSaleOrderListPageParams, (Object)params, (String[])new String[0]);
        } else {
            logger.info("\u8fdb\u5165\u62a5\u8868\u67e5\u8be2");
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.querySaleOrderListPage(getSaleOrderListPageParams));
            CubeBeanUtils.copyProperties((Object)saleOrderRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList lists = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                pageInfo.getList().forEach(resp -> {
                    SaleOrderExtRespEsVo vo = new SaleOrderExtRespEsVo();
                    BeanUtils.copyProperties((Object)resp, (Object)((Object)vo));
                    if (ObjectUtil.isNotEmpty((Object)resp.getOrderAddress())) {
                        AddressVO addressVO = new AddressVO();
                        BeanUtils.copyProperties((Object)resp.getOrderAddress(), (Object)addressVO);
                        vo.setOrderAddress(addressVO);
                    }
                    vo.setOrderTags(resp.getOrderTags());
                    lists.add(vo);
                });
            }
            saleOrderRespDtoPageInfo.setList(lists);
        }
        if (saleOrderRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)saleOrderRespDtoPageInfo.getList())) {
            List orderNoList = saleOrderRespDtoPageInfo.getList().stream().map(SaleOrderRespEsVo::getSaleOrderNo).collect(Collectors.toList());
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)saleOrderRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            saleOrderRespDtoPageInfo.getList().forEach(dto -> {
                SaleOrderVO saleOrderVO = new SaleOrderVO();
                CubeBeanUtils.copyProperties((Object)saleOrderVO, (Object)dto, (String[])new String[0]);
                com.dtyunxi.cis.pms.biz.model.AddressVO addressVO = new com.dtyunxi.cis.pms.biz.model.AddressVO();
                if (dto.getOrderAddress() != null) {
                    AddressVO orderAddress = dto.getOrderAddress();
                    BeanUtils.copyProperties((Object)orderAddress, (Object)addressVO);
                }
                saleOrderVO.setOrderTags(Optional.ofNullable(dto.getOrderTags()).map(tags -> tags.stream().map(t -> (OrderTagRecordRespDto)BeanUtil.copyProperties((Object)t, OrderTagRecordRespDto.class, (String[])new String[0])).collect(Collectors.toList())).orElse(Lists.newArrayList()));
                if (this.saleOrderEsQuery.booleanValue()) {
                    saleOrderVO.setOrderChannelName(dto.getChannelName());
                }
                saleOrderVO.setOrderAddress(addressVO);
                saleOrderVO.setSplitSourceOrder(dto.getOriginalOrderNo());
                saleOrderVO.setSaleOrderStatus(dto.getOrderStatus());
                saleOrderVO.setAllowSplitFlag(dto.getAllowSplitFlag() == null ? null : dto.getAllowSplitFlag().toString());
                saleOrderVO.setWmsNo(dto.getEasOrderNo());
                if (StringUtils.isNotBlank((CharSequence)dto.getSplitPlatformNo())) {
                    saleOrderVO.setWmsNo(dto.getSplitPlatformNo());
                }
                dtoList.add(saleOrderVO);
            });
            pageInfo.setList(dtoList);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    private void getLogisticsInfo(Map<String, List<CsWmsShippingInfoReqDto>> finalWmsShippingMap, SaleOrderVO saleOrderVO) {
        List<CsWmsShippingInfoReqDto> orderWmsShippingList = finalWmsShippingMap.get(saleOrderVO.getSaleOrderNo());
        if (CollectionUtils.isNotEmpty(orderWmsShippingList)) {
            String shippingNo = null;
            String logisticsType = null;
            String estimatedTime = null;
            String shippingCompanyName = null;
            for (CsWmsShippingInfoReqDto csWmsShippingInfoReqDto : orderWmsShippingList) {
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingNo())) {
                    shippingNo = StringUtils.isNotEmpty(shippingNo) ? shippingNo + "," + csWmsShippingInfoReqDto.getShippingNo() : csWmsShippingInfoReqDto.getShippingNo();
                }
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getLogisticsType())) {
                    logisticsType = StringUtils.isNotEmpty(logisticsType) ? logisticsType + "," + csWmsShippingInfoReqDto.getLogisticsType() : csWmsShippingInfoReqDto.getLogisticsType();
                }
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingCompanyName())) {
                    shippingCompanyName = StringUtils.isNotEmpty(shippingCompanyName) ? shippingCompanyName + "," + csWmsShippingInfoReqDto.getShippingCompanyName() : csWmsShippingInfoReqDto.getShippingCompanyName();
                }
                if (!Objects.nonNull(csWmsShippingInfoReqDto.getEstimatedTime())) continue;
                if (StringUtils.isNotEmpty(estimatedTime)) {
                    estimatedTime = estimatedTime + DateTimeUtils.getDateTimeStr(csWmsShippingInfoReqDto.getEstimatedTime());
                    continue;
                }
                estimatedTime = DateTimeUtils.getDateTimeStr(csWmsShippingInfoReqDto.getEstimatedTime());
            }
            saleOrderVO.setLogisticsNo(shippingNo);
            saleOrderVO.setLogisticsCompany(shippingCompanyName);
            saleOrderVO.setDeliveryWay(logisticsType);
            saleOrderVO.setEstimatedTime(estimatedTime);
        }
    }

    @Override
    public RestResponse<PageInfo<SaleOrderLogVO>> getSaleOrderLog(@ApiParam(value="") @Valid @RequestBody(required=false) GetSaleOrderLogListPageParams getSaleOrderLogListPageParams) {
        if (getSaleOrderLogListPageParams.getId() == null) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderOptLogReqDto reqDto = new SaleOrderOptLogReqDto();
        reqDto.setSaleOrderId(getSaleOrderLogListPageParams.getId());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.saleOrderOptLogQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getSaleOrderLogListPageParams.getPageNum(), getSaleOrderLogListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            SaleOrderLogVO vo = new SaleOrderLogVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setOperationType(o.getOptType());
            vo.setOperationContent(o.getOptContent());
            vo.setCreatePerson(o.getOptPerson());
            vo.setUpdatePerson(o.getOptPerson());
            if (o.getOptTime() != null) {
                vo.setOperationTime(DateUtil.format((Date)o.getOptTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<OrderCenterLogicalWarehouseVO>> getSaleOrderLogicalWarehouseList(@Valid GetOrderCenterLogicalWarehouseListParams getOrderCenterLogicalWarehouseListParams) {
        CsInventoryWarehouseQueryReqDto csInventoryWarehouseQueryReqDto = new CsInventoryWarehouseQueryReqDto();
        csInventoryWarehouseQueryReqDto.setBatch(getOrderCenterLogicalWarehouseListParams.getBatchNo());
        csInventoryWarehouseQueryReqDto.setLongCode(getOrderCenterLogicalWarehouseListParams.getGoodsSku());
        List csInventoryWarehouseQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryWarehouseInfo(csInventoryWarehouseQueryReqDto));
        List<Object> result = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInventoryWarehouseQueryRespDtos)) {
            result = csInventoryWarehouseQueryRespDtos.stream().map(o -> {
                OrderCenterLogicalWarehouseVO orderCenterLogicalWarehouseVO = new OrderCenterLogicalWarehouseVO();
                orderCenterLogicalWarehouseVO.setId(ParamConverter.convertToString((Object)o.getId()));
                orderCenterLogicalWarehouseVO.setLogicalWarehouseCode(o.getWarehouseCode());
                orderCenterLogicalWarehouseVO.setLogicalWarehouseName(o.getWarehouseName());
                orderCenterLogicalWarehouseVO.setLogicalWarehouseId(ParamConverter.convertToString((Object)o.getWarehouseId()));
                return orderCenterLogicalWarehouseVO;
            }).collect(Collectors.toList());
        }
        return new RestResponse(result);
    }

    @Override
    public RestResponse<Object> handleSplitSaleOrder(@Valid HandleSplitSaleOrderParams handleSplitSaleOrderParams) {
        logger.info("\u624b\u5de5\u62c6\u5355\u5e94\u7528\u5c42\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)handleSplitSaleOrderParams));
        SplitOrderReqDto reqDto = new SplitOrderReqDto();
        BeanUtils.copyProperties((Object)handleSplitSaleOrderParams, (Object)reqDto);
        if (StringUtils.isBlank((CharSequence)handleSplitSaleOrderParams.getSaleOrderId())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(handleSplitSaleOrderParams.getOrderList())) {
            throw new BizException("\u62c6\u5206\u5b50\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqDto.setSaleOrderId(ParamConverter.convertToLong((Object)handleSplitSaleOrderParams.getSaleOrderId()));
        ArrayList<SplitChildOrderReqDto> orderList = new ArrayList<SplitChildOrderReqDto>();
        handleSplitSaleOrderParams.getOrderList().forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getLogicalWarehouseCode()) && CollectionUtils.isNotEmpty(o.getGoodsList())) {
                SplitChildOrderReqDto childOrderReqDto = new SplitChildOrderReqDto();
                List itemReqDtoList = o.getGoodsList().stream().map(dto -> {
                    SplitOrderItemReqDto itemReqDto = new SplitOrderItemReqDto();
                    BeanUtils.copyProperties((Object)dto, (Object)itemReqDto);
                    itemReqDto.setIsGiftFlag(ParamConverter.convertToInteger((Object)dto.getIsGiftFlag()));
                    itemReqDto.setGoodsId(ParamConverter.convertToLong((Object)dto.getGoodsId()));
                    itemReqDto.setOriginalOrderGoodsId(ParamConverter.convertToLong((Object)dto.getOriginalOrderGoodsId()));
                    return itemReqDto;
                }).collect(Collectors.toList());
                childOrderReqDto.setGoodsList(itemReqDtoList);
                orderList.add(childOrderReqDto);
            }
        });
        Map<String, List<SaleChildOrderVO>> warehouseGroup = handleSplitSaleOrderParams.getOrderList().stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getLogicalWarehouseCode())).collect(Collectors.groupingBy(SaleChildOrderVO::getLogicalWarehouseCode));
        for (List<SaleChildOrderVO> saleChildOrderVOS : warehouseGroup.values()) {
            SplitChildOrderReqDto childOrderReqDto = new SplitChildOrderReqDto();
            SaleChildOrderVO saleChildOrderVO = saleChildOrderVOS.get(0);
            SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseId(saleChildOrderVO.getLogicalWarehouseId());
            logicWarehouse.setDeliveryLogicWarehouseCode(saleChildOrderVO.getLogicalWarehouseCode());
            logicWarehouse.setDeliveryLogicWarehouseName(saleChildOrderVO.getLogicalWarehouseName());
            childOrderReqDto.setLogicWarehouse(logicWarehouse);
            ArrayList allItemList = Lists.newArrayList();
            saleChildOrderVOS.forEach(o -> allItemList.addAll(o.getGoodsList()));
            Map orderItemMap = allItemList.stream().collect(Collectors.toMap(OrderCenterGoodsVO::getOriginalOrderGoodsId, Function.identity(), (v1, v2) -> {
                v1.setGoodsNum(v1.getGoodsNum().add(v2.getGoodsNum()));
                return v1;
            }));
            List itemReqDtoList = orderItemMap.values().stream().map(dto -> {
                SplitOrderItemReqDto itemReqDto = new SplitOrderItemReqDto();
                BeanUtils.copyProperties((Object)dto, (Object)itemReqDto);
                itemReqDto.setIsGiftFlag(ParamConverter.convertToInteger((Object)dto.getIsGiftFlag()));
                itemReqDto.setGoodsId(ParamConverter.convertToLong((Object)dto.getGoodsId()));
                itemReqDto.setOriginalOrderGoodsId(ParamConverter.convertToLong((Object)dto.getOriginalOrderGoodsId()));
                return itemReqDto;
            }).collect(Collectors.toList());
            childOrderReqDto.setGoodsList(itemReqDtoList);
            orderList.add(childOrderReqDto);
        }
        reqDto.setOrderList(orderList);
        logger.info("\u624b\u5de5\u62c6\u5355\u5e94\u7528\u5c42\u8f6c\u6362\u540e\u6570\u636e\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitOrder(ParamConverter.convertToLong((Object)handleSplitSaleOrderParams.getSaleOrderId()), reqDto)));
    }

    @Override
    public RestResponse<Object> outWarehouseSaleOrder(@Valid OutWarehouseParams outWarehouseParams) {
        CsOutDeliveryReqDto reqDto = new CsOutDeliveryReqDto();
        if (CollectionUtils.isEmpty(outWarehouseParams.getOrderNoList())) {
            throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqDto.setOrderNo(outWarehouseParams.getOrderNoList().get(0));
        reqDto.setShippingCode(outWarehouseParams.getLogisticsNo());
        reqDto.setShippingCompany(outWarehouseParams.getLogisticsCompany());
        reqDto.setTotalQuantity(outWarehouseParams.getTotalBoxNum());
        reqDto.setMergeQuantity(outWarehouseParams.getJoinBoxNum());
        reqDto.setShippingCompanyCode(outWarehouseParams.getLogisticsCode());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csPcpInventoryExposedApi.outDelivery(reqDto)));
    }

    @Override
    public RestResponse<Object> postingStatusSyncSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> reAuditSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.backCheck(Long.valueOf(orderOperationVO.getOrderIdList().get(0))));
        if (saleOrderRespDto != null && !SaleOrderSourceEnum.CREATE.getType().equals(saleOrderRespDto.getOrderSource()) && saleOrderRespDto.getPlatformOrderId() != null) {
            PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
            pcpOrderReqDto.setId(saleOrderRespDto.getPlatformOrderId());
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpOrderApi.abolishPcpOrder(pcpOrderReqDto)));
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> resetSaleOrderStatus(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.resetOrder((Long)orderIdList.get(0)));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.resetOrder(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u91cd\u7f6e\u72b6\u6001]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> syncSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> unlockSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.unlock((Long)orderIdList.get(0)));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.unlock(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u624b\u5de5\u89e3\u9501]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateOrderRemark(@Valid OrderOperationVO orderOperationVO) {
        SaleOrderReqDto reqDto = new SaleOrderReqDto();
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqDto.setId(Long.valueOf(orderOperationVO.getOrderIdList().get(0)));
        reqDto.setRemark(orderOperationVO.getOrderRemark());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.saleOrderApi.changeOrderRemark(reqDto)));
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams params = new com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams)JSON.parseObject((String)commonReqDto.getFilter(), com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.getSaleOrderListPage((com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams)re));
            PageInfo page = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)page);
            List<Object> list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list = respDtoPageInfo.getList().stream().map(o -> {
                    List stringList = o.getOrderTags().stream().map(OrderTagRecordRespDto::getTagName).collect(Collectors.toList());
                    String strip = StringUtils.strip((String)stringList.toString(), (String)"[]");
                    ExportOrderCenterSaleOrderVO vo = new ExportOrderCenterSaleOrderVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setOrderSource(SaleOrderSourceEnum.enumOf((Integer)Integer.valueOf(o.getOrderSource())).getDesc());
                    vo.setOrderLevel(SaleOrderLevelEnum.enumOf((Integer)o.getOrderLevel()).getDesc());
                    vo.setAssignStatus(AssignStatusEnum.getDescByCode(o.getAssignStatus()));
                    vo.setOrderBizType(YesOrNoEnum.getDescByCode((int)o.getOrderBizType()));
                    vo.setEasVerifyStatus(EasVerifyStatusEnum.enumOf((Integer)o.getEasVerifyStatus()).getDesc());
                    try {
                        if (Objects.nonNull(o.getEasVerifyTime())) {
                            vo.setEasVerifyTimeStr(DateTimeUtils.getDateTimeStr(o.getEasVerifyTime()));
                        }
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u8d22\u5ba1\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                    }
                    vo.setOrderAddress(o.getOrderAddress().getDetailAddress());
                    vo.setProvince(o.getOrderAddress().getProvince());
                    vo.setCity(o.getOrderAddress().getCity());
                    vo.setOrderChannelName(o.getOrderChannelName());
                    vo.setRegionCode(o.getRegionCode());
                    vo.setOrderTags(strip);
                    vo.setRegionName(o.getRegionName());
                    vo.setDistrict(o.getOrderAddress().getDistrict());
                    vo.setOrderChannelName(o.getOrderChannelName());
                    vo.setGoodsTotalNum(o.getGoodsTotalNum() == null ? null : o.getGoodsTotalNum().intValue() + "");
                    vo.setTotalBoxNum(o.getTotalBoxNum() == null ? null : o.getTotalBoxNum().intValue() + "");
                    vo.setJoinBoxNum(o.getJoinBoxNum() == null ? null : o.getJoinBoxNum().intValue() + "");
                    vo.setAllowSplitFlag(Objects.equals(o.getAllowSplitFlag(), "1") ? "\u662f" : "\u5426");
                    vo.setIfButtThirdParty(YesOrNoEnum.getDescByCode(o.getIfButtThirdParty()));
                    vo.setPostingStatus(YesOrNoEnum.getDescByCode(o.getIfPullFinance()));
                    vo.setBatchInverted(YesOrNoEnum.getDescByCode(o.getBatchInverted()));
                    vo.setVolume(o.getVolume());
                    vo.setWeight(vo.getWeight());
                    vo.setDocumentNo(vo.getDocumentNo());
                    vo.setDeliveryLogicalWarehouseName(o.getLogicalWarehouseName());
                    vo.setOnlineFlag(Objects.equals(o.getIsOnline(), 0) ? "\u7ebf\u4e0b" : "\u7ebf\u4e0a");
                    vo.setPhysicsWarehouseName(o.getPhysicsWarehouseName());
                    vo.setSaleChannel(o.getSaleChannel());
                    vo.setInterceptInfo(o.getInterceptInfo());
                    vo.setDeliveryTime(o.getDeliveryTime());
                    vo.setStoragePlaceName(o.getStoragePlaceName());
                    try {
                        vo.setReadCodeResult(StringCodeResultEum.enumOf((String)o.getStringCodeResult()).getDesc());
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u4e32\u7801\u72b6\u6001\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setReadCodeResult(o.getStringCodeResult());
                    }
                    try {
                        if (Objects.nonNull(o.getStringCodeTime())) {
                            vo.setStringCodeTime(DateTimeUtils.getDateTimeStr(o.getStringCodeTime()));
                        }
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u4e32\u7801\u66f4\u65b0\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                    }
                    try {
                        if (Objects.nonNull(o.getBizDate())) {
                            vo.setBizDateStr(DateTimeUtils.getDateTimeStr(o.getBizDate()));
                        }
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u4e1a\u52a1\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                    }
                    try {
                        vo.setSaleOrderStatus(SaleOrderStatusEnum.forCode((String)o.getSaleOrderStatus()).getDesc());
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setSaleOrderStatus(o.getSaleOrderStatus());
                    }
                    if (o.getBunchCodeFlag() != null) {
                        vo.setReadCodeResult(BunchCodeFlagEnum.getDescByCode(o.getBunchCodeFlag()));
                    }
                    vo.setSplitSourceOrder(o.getOriginalOrderNo());
                    try {
                        vo.setOrderType(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setOrderType(o.getOrderType());
                    }
                    return vo;
                }).collect(Collectors.toList());
            }
            page.setList((List)list);
            return page;
        }, params, ExportOrderCenterSaleOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u8fdb\u5165\u9500\u552e\u5355\u5bfc\u5165");
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportSaleOrderDto.class);
        logger.info("\u8fdb\u5165\u9500\u552e\u5355\u5bfc\u5165\u8868\u683c\u6570\u636e:{}", (Object)JSON.toJSONString((Object)list));
        return RestResponseHelper.extractData(this.doImportCheckOrder(list));
    }

    @Override
    public RestResponse<Map<String, Object>> doImportCheckOrder(List<ImportSaleOrderDto> list) {
        List csBusinessTypeList;
        List customerStatueList;
        Set platformOrderNos = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getPlatformOrderNo())).map(ImportSaleOrderDto::getPlatformOrderNo).collect(Collectors.toSet());
        Set<Object> saleOrderPlatformMap = new HashSet();
        if (CollectionUtils.isNotEmpty(platformOrderNos)) {
            PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
            platformOrderQueryReqDto.setPlatformOrderNoList(new ArrayList(platformOrderNos));
            logger.info("\u67e5\u8be2\u5e73\u53f0\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)platformOrderQueryReqDto));
            List platformOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(platformOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)platformOrderRespDtos)) {
                saleOrderPlatformMap = platformOrderRespDtos.stream().map(PlatformOrderRespDto::getPlatformOrderNo).collect(Collectors.toSet());
            }
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setPlatformOrderNoList(new ArrayList(platformOrderNos));
            logger.info("\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saleOrderQueryReqDto));
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                Set salePlatformOrderSet = saleOrderRespDtos.stream().map(SaleOrderRespDto::getPlatformOrderNo).collect(Collectors.toSet());
                saleOrderPlatformMap.addAll(salePlatformOrderSet);
            }
        }
        Set customerCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode())).map(ImportSaleOrderDto::getCustomerCode).collect(Collectors.toSet());
        Map<Object, Object> customerMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
            searchReqDto.setCodeInList(new ArrayList(customerCodes));
            logger.info("\u67e5\u8be2\u5ba2\u6237\u7f16\u7801\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)searchReqDto));
            List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(new ArrayList(customerCodes)));
            if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                customerMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        Map<Object, Object> customerStatusMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerCodes) && CollectionUtils.isNotEmpty((Collection)(customerStatueList = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(null))))) {
            customerStatusMap = customerStatueList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        Set orderChannelCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getOrderChannelCode())).map(ImportSaleOrderDto::getOrderChannelCode).collect(Collectors.toSet());
        Map<Object, Object> channelDtoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(orderChannelCodes)) {
            PcpOrderChannelReqDto pcpOrderChannelReqDto = new PcpOrderChannelReqDto();
            pcpOrderChannelReqDto.setChannelCodes(new ArrayList(orderChannelCodes));
            logger.info("\u67e5\u8be2\u8ba2\u5355\u6e20\u9053\u7f16\u7801\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pcpOrderChannelReqDto));
            PageInfo channelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryByPage(JSON.toJSONString((Object)pcpOrderChannelReqDto), Integer.valueOf(1), Integer.valueOf(orderChannelCodes.size())));
            if (CollectionUtils.isNotEmpty((Collection)channelRespDtoPageInfo.getList())) {
                channelDtoMap = channelRespDtoPageInfo.getList().stream().collect(Collectors.toMap(PcpOrderChannelRespDto::getChannelCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        Set channelWarehouseCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getChannelWarehouseCode())).map(ImportSaleOrderDto::getChannelWarehouseCode).collect(Collectors.toSet());
        Map<Object, Object> channelWarehouseMap = new HashMap();
        if (CollectionUtils.isNotEmpty(channelWarehouseCodes)) {
            logger.info("\u67e5\u8be2\u8ba2\u5355\u6e20\u9053\u4ed3\u7f16\u7801\u5165\u53c2:{}", (Object)JSON.toJSONString(channelWarehouseCodes));
            List channelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes(channelWarehouseCodes));
            if (CollectionUtils.isNotEmpty((Collection)channelWarehouseRespDtos)) {
                channelWarehouseMap = channelWarehouseRespDtos.stream().collect(Collectors.toMap(ChannelWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        List logicalWarehouseCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getLogicalWarehouseCode())).map(ImportSaleOrderDto::getLogicalWarehouseCode).distinct().collect(Collectors.toList());
        Map<Object, Object> logicWarehousePageRespDtoMap = new HashMap();
        Map logicChannelWarehouseMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logicalWarehouseCodes)) {
            CsLogicWarehouseParamQueryDto logicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
            logicWarehouseParamQueryDto.setWarehouseCodeList(logicalWarehouseCodes);
            List csLogicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(logicWarehouseParamQueryDto));
            logicWarehousePageRespDtoMap = Optional.ofNullable(csLogicWarehousePageRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, Function.identity(), (e1, e2) -> e1));
            logicChannelWarehouseMap = (Map)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByLogicWarehouseCodes(new HashSet(logicalWarehouseCodes)));
        }
        List storagePlaceCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getStoragePlace())).map(ImportSaleOrderDto::getStoragePlace).distinct().collect(Collectors.toList());
        Map<Object, Object> virtualWarehouseRespDtoHashMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(storagePlaceCodes)) {
            VirtualWarehouseListReqDto virtualWarehouseListReqDto = new VirtualWarehouseListReqDto();
            virtualWarehouseListReqDto.setVirtualWarehouseCodes(storagePlaceCodes);
            virtualWarehouseListReqDto.setChannelWarehouseCodes(new ArrayList(channelWarehouseCodes));
            List virtualWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryByList(virtualWarehouseListReqDto));
            virtualWarehouseRespDtoHashMap = Optional.ofNullable(virtualWarehouseRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(VirtualWarehouseRespDto::getWarehouseCode, Function.identity(), (e1, e2) -> e1));
        }
        List easDefaultWarehouseCodeList = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getEasDefaultWarehouseCode())).map(ImportSaleOrderDto::getEasDefaultWarehouseCode).distinct().collect(Collectors.toList());
        Map<Object, Object> easDefaultWarehouseMap = new HashMap();
        if (CollectionUtils.isNotEmpty(easDefaultWarehouseCodeList)) {
            logger.info("EAS\u9ed8\u8ba4\u903b\u8f91\u4ed3\uff1a{}", (Object)JSON.toJSONString(easDefaultWarehouseCodeList));
            CsLogicWarehouseParamQueryDto queryDto = new CsLogicWarehouseParamQueryDto();
            queryDto.setWarehouseCodeList(easDefaultWarehouseCodeList);
            List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(queryDto));
            easDefaultWarehouseMap = Optional.ofNullable(respDtoList).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, Function.identity(), (e1, e2) -> e1));
        }
        List organizationCodes = list.stream().filter(Objects::nonNull).map(ImportSaleOrderDto::getOrganizationCode).distinct().collect(Collectors.toList());
        List orgAdvDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByOrgCode(organizationCodes));
        Map<String, OrgAdvDetailRespDto> orgAdvDetailRespDtoMap = orgAdvDetailRespDtos.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getCode, e -> e, (e1, e2) -> e1));
        ArrayList addressList = Lists.newArrayList();
        for (ImportSaleOrderDto importDto : list) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince()) && !addressList.contains(importDto.getProvince())) {
                addressList.add(importDto.getProvince());
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCity()) && !addressList.contains(importDto.getCity())) {
                addressList.add(importDto.getCity());
            }
            if (!StringUtils.isNotEmpty((CharSequence)importDto.getCounty()) || addressList.contains(importDto.getCounty())) continue;
            addressList.add(importDto.getCounty());
        }
        Map<Object, Object> areaDtoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)addressList)) {
            PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
            pcpRegionReqDto.setNameList((List)addressList);
            logger.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pcpRegionReqDto));
            List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
            if (CollectionUtils.isNotEmpty((Collection)addressAreaList)) {
                areaDtoMap = addressAreaList.stream().collect(Collectors.toMap(PcpRegionRespDto::getName, Function.identity(), (k1, k2) -> k1));
            }
        }
        Set itemSkuCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getSkuCode())).map(ImportSaleOrderDto::getSkuCode).collect(Collectors.toSet());
        Map<Object, Object> itemInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(itemSkuCodes)) {
            logger.info("\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5165\u53c2:{}", (Object)JSON.toJSONString(itemSkuCodes));
            List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes((List)Lists.newArrayList(itemSkuCodes)));
            itemInfoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> costCenterMap = new HashMap();
        Set costCenterCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCostCenterCode())).map(ImportSaleOrderDto::getCostCenterCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(costCenterCodes)) {
            CostCenterReqDto costCenterReqDto = new CostCenterReqDto();
            costCenterReqDto.setCostCenterCodes((List)Lists.newArrayList(costCenterCodes));
            costCenterReqDto.setPageNum(Integer.valueOf(1));
            costCenterReqDto.setPageSize(Integer.valueOf(costCenterCodes.size()));
            logger.info("\u67e5\u8be2\u6210\u672c\u4e2d\u5fc3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)costCenterReqDto));
            PageInfo costCenterRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.costCenterQueryApi.queryByPageByPost(costCenterReqDto));
            if (CollectionUtils.isNotEmpty((Collection)costCenterRespDtoPageInfo.getList())) {
                costCenterMap = costCenterRespDtoPageInfo.getList().stream().collect(Collectors.toMap(CostCenterRespDto::getCostCenterCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        Set businessTypeNameSet = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getBusinessTypeName())).map(ImportSaleOrderDto::getBusinessTypeName).collect(Collectors.toSet());
        Map<Object, Object> csBusinessTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(businessTypeNameSet) && CollectionUtils.isNotEmpty((Collection)(csBusinessTypeList = (List)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryListByType("other_out"))))) {
            csBusinessTypeMap = csBusinessTypeList.stream().collect(Collectors.toMap(CsBusinessTypeRespDto::getBusinessTypeName, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        HashSet checkPlatformOrderSet = Sets.newHashSet();
        HashMap<String, Integer> onlyMap = new HashMap<String, Integer>();
        HashMap<String, BizSaleOrderReqDto> addSaleOrderMap = new HashMap<String, BizSaleOrderReqDto>();
        HashMap<String, List<ImportSaleOrderDto>> successSaleOrderMap = new HashMap<String, List<ImportSaleOrderDto>>();
        for (ImportSaleOrderDto importSaleOrderDto : list) {
            PcpItemRespDto pcpItemRespDto;
            BizSaleOrderReqDto bizSaleOrderReqDto = new BizSaleOrderReqDto();
            CubeBeanUtils.copyProperties((Object)bizSaleOrderReqDto, (Object)((Object)importSaleOrderDto), (String[])new String[]{"costCenterCode"});
            bizSaleOrderReqDto.setRemark(importSaleOrderDto.getOrderRemark());
            bizSaleOrderReqDto.setSellerRemark(importSaleOrderDto.getSellerRemark());
            bizSaleOrderReqDto.setPayTime(new Date());
            StringBuffer errorMsg = new StringBuffer();
            if (StringUtils.isBlank((CharSequence)importSaleOrderDto.getOrganizationCode())) {
                errorMsg.append("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u53c2\u6570\u9519\u8bef;");
            } else {
                OrgAdvDetailRespDto orgDto = orgAdvDetailRespDtoMap.get(importSaleOrderDto.getOrganizationCode());
                if (orgDto == null) {
                    errorMsg.append("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u53c2\u6570\u9519\u8bef");
                } else {
                    importSaleOrderDto.setOrganizationId(orgDto.getId());
                    importSaleOrderDto.setOrganizationName(orgDto.getName());
                    bizSaleOrderReqDto.setOrganizationId(orgDto.getId());
                    bizSaleOrderReqDto.setOrganizationName(orgDto.getName());
                    bizSaleOrderReqDto.setEasOrgId(orgDto.getThirdOrgId());
                }
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getPlatformOrderNo())) {
                errorMsg.append("\u6e20\u9053\u8ba2\u5355\u53f7\u4e3a\u7a7a;");
            } else {
                if (!this.checkPlatformOrderNo(importSaleOrderDto.getPlatformOrderNo())) {
                    errorMsg.append("\u6e20\u9053\u5355\u53f7\u957f\u5ea6\u4e0d\u5e94\u8d85\u8fc740\u4f4d;");
                }
                if (saleOrderPlatformMap.contains(importSaleOrderDto.getPlatformOrderNo())) {
                    errorMsg.append("\u6e20\u9053\u8ba2\u5355\u53f7\u5df2\u5728\u7cfb\u7edf\u5b58\u5728;");
                }
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getCustomerCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a;");
            } else if (customerMap.isEmpty() || !customerMap.containsKey(importSaleOrderDto.getCustomerCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u9519\u8bef;");
            } else {
                CustomerRespDto pcpCustomerRespDto = (CustomerRespDto)customerMap.get(importSaleOrderDto.getCustomerCode());
                boolean flag = true;
                if (customerStatusMap.isEmpty() || !customerStatusMap.containsKey(pcpCustomerRespDto.getStatusId())) {
                    errorMsg.append("\u5ba2\u6237\u72b6\u6001\u9519\u8bef;");
                    flag = false;
                } else {
                    CustomerStatusRespDto customerStatusRespDto = (CustomerStatusRespDto)customerStatusMap.get(pcpCustomerRespDto.getStatusId());
                    if (Objects.equals(0, customerStatusRespDto.getAccountStatus())) {
                        errorMsg.append("\u5ba2\u6237\u8d26\u53f7\u5df2\u7981\u7528;");
                        flag = false;
                    }
                }
                if (flag) {
                    bizSaleOrderReqDto.setCustomerId(pcpCustomerRespDto.getId());
                    bizSaleOrderReqDto.setCustomerName(pcpCustomerRespDto.getName());
                    bizSaleOrderReqDto.setCustomerCode(pcpCustomerRespDto.getCode());
                    bizSaleOrderReqDto.setEasCode(pcpCustomerRespDto.getEasCode());
                    bizSaleOrderReqDto.setThirdPartyId(pcpCustomerRespDto.getThirdPartyId());
                }
            }
            boolean checkChanneFlag = true;
            if (!this.isClaimOrder(importSaleOrderDto.getOrderTypeStr())) {
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getOrderChannelCode())) {
                    errorMsg.append("\u8ba2\u5355\u6e20\u9053\u7f16\u7801\u53c2\u6570\u9519\u8bef;");
                    checkChanneFlag = false;
                } else if (channelDtoMap.isEmpty() || !channelDtoMap.containsKey(importSaleOrderDto.getOrderChannelCode())) {
                    errorMsg.append("\u8ba2\u5355\u6e20\u9053\u7f16\u7801\u53c2\u6570\u9519\u8bef;");
                    checkChanneFlag = false;
                } else {
                    PcpOrderChannelRespDto pcpOrderChannelRespDto = (PcpOrderChannelRespDto)channelDtoMap.get(importSaleOrderDto.getOrderChannelCode());
                    bizSaleOrderReqDto.setChannelCode(importSaleOrderDto.getOrderChannelCode());
                    bizSaleOrderReqDto.setChannelId(pcpOrderChannelRespDto.getId());
                    bizSaleOrderReqDto.setChannelName(pcpOrderChannelRespDto.getChannelName());
                }
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getChannelWarehouseCode())) {
                    errorMsg.append("\u6e20\u9053\u4ed3\u7f16\u7801\u4e3a\u7a7a;");
                    checkChanneFlag = false;
                }
                if (checkChanneFlag) {
                    if (channelWarehouseMap.isEmpty() || !channelWarehouseMap.containsKey(importSaleOrderDto.getChannelWarehouseCode())) {
                        errorMsg.append("\u6e20\u9053\u4ed3\u7f16\u7801\u9519\u8bef;");
                    } else {
                        Set channelWarehouseOrderChannelCodes;
                        ChannelWarehouseRespDto csChannelWarehouseRespDto = (ChannelWarehouseRespDto)channelWarehouseMap.get(importSaleOrderDto.getChannelWarehouseCode());
                        if (!Objects.equals(csChannelWarehouseRespDto.getWarehouseStatus(), CsValidFlagEnum.ENABLE.getCode())) {
                            errorMsg.append("\u6e20\u9053\u4ed3\u672a\u542f\u7528;");
                        }
                        if ((channelWarehouseOrderChannelCodes = csChannelWarehouseRespDto.getOrderChannelCodes()).isEmpty()) {
                            errorMsg.append("\u6e20\u9053\u4ed3\u672a\u5173\u8054\u8ba2\u5355\u6e20\u9053\u4fe1\u606f;");
                        } else if (!channelWarehouseOrderChannelCodes.contains(importSaleOrderDto.getOrderChannelCode())) {
                            errorMsg.append("\u6e20\u9053\u4ed3\u4e0e\u8ba2\u5355\u6e20\u9053\u5173\u8054\u4fe1\u606f\u9519\u8bef;");
                        }
                        bizSaleOrderReqDto.setChannelWarehouseId(csChannelWarehouseRespDto.getId());
                        bizSaleOrderReqDto.setChannelWarehouseCode(csChannelWarehouseRespDto.getWarehouseCode());
                        bizSaleOrderReqDto.setChannelWarehouseName(csChannelWarehouseRespDto.getWarehouseName());
                    }
                }
            } else if (StringUtils.isBlank((CharSequence)importSaleOrderDto.getLogicalWarehouseCode()) || !logicWarehousePageRespDtoMap.containsKey(importSaleOrderDto.getLogicalWarehouseCode())) {
                errorMsg.append("\u6307\u5b9a\u53d1\u8d27\u4ed3\u7f16\u7801\u53c2\u6570\u9519\u8bef;");
            } else {
                CsLogicWarehousePageRespDto csLogicWarehousePageRespDto = (CsLogicWarehousePageRespDto)logicWarehousePageRespDtoMap.get(importSaleOrderDto.getLogicalWarehouseCode());
                bizSaleOrderReqDto.setLogicalWarehouseId(csLogicWarehousePageRespDto.getId());
                bizSaleOrderReqDto.setLogicalWarehouseName(csLogicWarehousePageRespDto.getWarehouseName());
                importSaleOrderDto.setLogicalWarehouseId(csLogicWarehousePageRespDto.getId());
                importSaleOrderDto.setLogicalWarehouseName(csLogicWarehousePageRespDto.getWarehouseName());
                if (!logicChannelWarehouseMap.containsKey(importSaleOrderDto.getLogicalWarehouseCode())) {
                    errorMsg.append("\u6307\u5b9a\u53d1\u8d27\u4ed3\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u6e20\u9053\u4ed3\u4fe1\u606f;");
                } else {
                    ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)((List)logicChannelWarehouseMap.get(importSaleOrderDto.getLogicalWarehouseCode())).get(0);
                    bizSaleOrderReqDto.setChannelWarehouseId(channelWarehouseRespDto.getId());
                    bizSaleOrderReqDto.setChannelWarehouseCode(channelWarehouseRespDto.getWarehouseCode());
                    bizSaleOrderReqDto.setChannelWarehouseName(channelWarehouseRespDto.getWarehouseName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importSaleOrderDto.getIsOnlineStr())) {
                SaleOnlineStatusEnum saleOnlineStatusEnum = SaleOnlineStatusEnum.enumOfDesc((String)importSaleOrderDto.getIsOnlineStr());
                if (Objects.isNull(saleOnlineStatusEnum)) {
                    errorMsg.append("\u7ebf\u4e0a\u7ebf\u4e0b\u9519\u8bef;");
                } else {
                    bizSaleOrderReqDto.setIsOnline(saleOnlineStatusEnum.getType());
                }
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getOrderTypeStr())) {
                errorMsg.append("\u8ba2\u5355\u7c7b\u578b\u4e3a\u7a7a;");
            } else {
                SaleOrderTypeEnum saleOrderTypeEnum = SaleOrderTypeEnum.enumOfDesc((String)importSaleOrderDto.getOrderTypeStr());
                if (Objects.isNull(saleOrderTypeEnum) || SaleOrderTypeEnum.COMMON_ORDER.getType().equals(saleOrderTypeEnum.getType())) {
                    errorMsg.append("\u8ba2\u5355\u7c7b\u578b\u9519\u8bef;");
                } else {
                    if (this.isYyjOrder(saleOrderTypeEnum) && StringUtils.isBlank((CharSequence)importSaleOrderDto.getPlatformParentOrderNo())) {
                        errorMsg.append("\u8425\u517b\u5bb6\u7236\u5355\u53f7\u5fc5\u586b;");
                    }
                    bizSaleOrderReqDto.setOrderType(saleOrderTypeEnum.getType());
                    if (Objects.equals(importSaleOrderDto.getOrderTypeStr(), SaleOrderTypeEnum.PRESALE_ORDER.getDesc())) {
                        bizSaleOrderReqDto.setOrderType(SaleOrderTypeEnum.PRESALE_ORDER.getType());
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importSaleOrderDto.getEasDefaultWarehouseCode())) {
                CsLogicWarehousePageRespDto warehouse = (CsLogicWarehousePageRespDto)easDefaultWarehouseMap.get(importSaleOrderDto.getEasDefaultWarehouseCode());
                if (ObjectUtil.isEmpty((Object)warehouse)) {
                    errorMsg.append("EAS\u9ed8\u8ba4\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728;");
                } else {
                    bizSaleOrderReqDto.setEasDefaultWarehouseName(warehouse.getWarehouseName());
                    bizSaleOrderReqDto.setEasDefaultWarehouseCode(warehouse.getWarehouseCode());
                    importSaleOrderDto.setEasDefaultWarehouseName(warehouse.getWarehouseName());
                }
            }
            if (!this.isClaimOrder(importSaleOrderDto.getOrderTypeStr())) {
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getAllowSplitFlagStr())) {
                    errorMsg.append("\u662f\u5426\u63a5\u53d7\u62c6\u5355\u53c2\u6570\u9519\u8bef;");
                } else {
                    YesOrNoEnum splitStatusEnum = YesOrNoEnum.enumOfDesc(importSaleOrderDto.getAllowSplitFlagStr());
                    if (Objects.isNull((Object)splitStatusEnum)) {
                        errorMsg.append("\u662f\u5426\u63a5\u53d7\u62c6\u5355\u53c2\u6570\u9519\u8bef;");
                    } else {
                        bizSaleOrderReqDto.setAllowSplitFlag(splitStatusEnum.getCode());
                        if (YesOrNoEnum.NO.getCode().equals(splitStatusEnum.getCode()) && !virtualWarehouseRespDtoHashMap.containsKey(importSaleOrderDto.getStoragePlace())) {
                            errorMsg.append("\u4f9b\u8d27\u4ed3\u7f16\u7801\u53c2\u6570\u9519\u8bef;");
                        }
                        if (StringUtils.isNotBlank((CharSequence)importSaleOrderDto.getStoragePlace())) {
                            VirtualWarehouseRespDto virtualWarehouseRespDto = (VirtualWarehouseRespDto)virtualWarehouseRespDtoHashMap.get(importSaleOrderDto.getStoragePlace());
                            if (virtualWarehouseRespDto == null) {
                                errorMsg.append("\u4f9b\u8d27\u4ed3\u7f16\u7801\u53c2\u6570\u9519\u8bef;");
                            } else {
                                if (checkChanneFlag && StringUtils.isNotBlank((CharSequence)bizSaleOrderReqDto.getStoragePlace()) && (CollectionUtils.isEmpty((Collection)virtualWarehouseRespDto.getChannelWarehouseCodes()) || !virtualWarehouseRespDto.getChannelWarehouseCodes().contains(bizSaleOrderReqDto.getChannelWarehouseCode()))) {
                                    errorMsg.append("\u6e20\u9053\u4ed3\u672a\u5173\u8054\u4f9b\u8d27\u4ed3;");
                                }
                                importSaleOrderDto.setStoragePlaceId(virtualWarehouseRespDto.getId());
                                importSaleOrderDto.setStoragePlaceName(virtualWarehouseRespDto.getWarehouseName());
                                bizSaleOrderReqDto.setStoragePlaceId(virtualWarehouseRespDto.getId());
                                bizSaleOrderReqDto.setStoragePlaceName(virtualWarehouseRespDto.getWarehouseName());
                            }
                        }
                    }
                }
            } else {
                importSaleOrderDto.setAllowSplitFlagStr(YesOrNoEnum.NO.getDesc());
                bizSaleOrderReqDto.setAllowSplitFlag(YesOrNoEnum.YES.getCode());
            }
            if (!this.isClaimOrder(importSaleOrderDto.getOrderTypeStr())) {
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getIfButtThirdPartyStr())) {
                    errorMsg.append("\u662f\u5426\u5bf9\u63a5\u4e2d\u53f0/EAS\u53c2\u6570\u9519\u8bef;");
                } else {
                    YesOrNoEnum ffButtThirdPartyEnum = YesOrNoEnum.enumOfDesc(importSaleOrderDto.getIfButtThirdPartyStr());
                    if (Objects.isNull((Object)ffButtThirdPartyEnum)) {
                        errorMsg.append("\u662f\u5426\u5bf9\u63a5\u4e2d\u53f0/EAS\u53c2\u6570\u9519\u8bef;");
                    } else {
                        bizSaleOrderReqDto.setIfButtThirdParty(ffButtThirdPartyEnum.getCode());
                    }
                }
            } else {
                importSaleOrderDto.setIfButtThirdPartyStr(YesOrNoEnum.YES.getDesc());
                bizSaleOrderReqDto.setIfButtThirdParty(YesOrNoEnum.YES.getCode());
            }
            if (this.isOutOrder(importSaleOrderDto.getOrderTypeStr())) {
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getCostCenterCode())) {
                    errorMsg.append("\u6210\u672c\u4e2d\u5fc3\u53c2\u6570\u5fc5\u586b;");
                }
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getBusinessTypeName())) {
                    errorMsg.append("\u4e8b\u52a1\u7c7b\u578b\u53c2\u6570\u5fc5\u586b;");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getCostCenterCode())) {
                if (!costCenterMap.containsKey(importSaleOrderDto.getCostCenterCode())) {
                    errorMsg.append("\u6210\u672c\u4e2d\u5fc3\u4fe1\u606f\u672a\u5339\u914d;");
                } else {
                    CostCenterRespDto costCenterRespDto = (CostCenterRespDto)costCenterMap.get(importSaleOrderDto.getCostCenterCode());
                    bizSaleOrderReqDto.setCostCenter(costCenterRespDto.getId() + "");
                    bizSaleOrderReqDto.setCostCenterCode(costCenterRespDto.getCostCenterCode());
                    bizSaleOrderReqDto.setCostCenterName(costCenterRespDto.getCostCenterName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getBusinessTypeName())) {
                if (!csBusinessTypeMap.containsKey(importSaleOrderDto.getBusinessTypeName())) {
                    errorMsg.append("\u4e8b\u52a1\u7c7b\u578b\u4fe1\u606f\u672a\u5339\u914d;");
                } else {
                    CsBusinessTypeRespDto csBusinessTypeRespDto = (CsBusinessTypeRespDto)csBusinessTypeMap.get(importSaleOrderDto.getBusinessTypeName());
                    bizSaleOrderReqDto.setBusinessTypeId(csBusinessTypeRespDto.getId());
                    bizSaleOrderReqDto.setBusinessTypeName(csBusinessTypeRespDto.getBusinessTypeName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getEasVerifyStatusStr())) {
                if (Objects.equals(importSaleOrderDto.getEasVerifyStatusStr(), "\u672a\u9a8c\u8bc1")) {
                    bizSaleOrderReqDto.setEasVerifyStatus(EasVerifyStatusEnum.NO.getType());
                } else if (Objects.equals(importSaleOrderDto.getEasVerifyStatusStr(), "\u9a8c\u8bc1\u901a\u8fc7")) {
                    bizSaleOrderReqDto.setEasVerifyStatus(EasVerifyStatusEnum.YES.getType());
                } else if (Objects.equals(importSaleOrderDto.getEasVerifyStatusStr(), "\u65e0\u9700\u9a8c\u8bc1")) {
                    bizSaleOrderReqDto.setEasVerifyStatus(EasVerifyStatusEnum.NOT_VERIFY.getType());
                } else {
                    errorMsg.append("EAS\u9a8c\u8bc1\u72b6\u6001\u53c2\u6570\u9519\u8bef;");
                }
            }
            if (!this.isClaimOrder(importSaleOrderDto.getOrderTypeStr())) {
                YesOrNoEnum yesOrNoEnum = YesOrNoEnum.enumOfDesc(importSaleOrderDto.getOrderBizTypeStr());
                if (yesOrNoEnum == null) {
                    errorMsg.append("\u662f\u5426\u4fe1\u63a7\u540e\u7f6e\u53c2\u6570\u9519\u8bef;");
                } else {
                    bizSaleOrderReqDto.setOrderBizType(yesOrNoEnum.getCode());
                }
            } else {
                importSaleOrderDto.setOrderBizTypeStr(YesOrNoEnum.NO.getDesc());
                bizSaleOrderReqDto.setOrderBizType(YesOrNoEnum.NO.getCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getOrderRemark()) && importSaleOrderDto.getOrderRemark().length() > 200) {
                errorMsg.append("\u8ba2\u5355\u5907\u6ce8\u5b57\u6570\u8d85\u8fc7200;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getSellerRemark()) && importSaleOrderDto.getSellerRemark().length() > 200) {
                errorMsg.append("\u5546\u5bb6\u5907\u6ce8\u5b57\u6570\u8d85\u8fc7200;");
            }
            boolean addressCheckFlag = true;
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getReceiveName())) {
                errorMsg.append("\u6536\u8d27\u4eba\u4e3a\u7a7a;");
                addressCheckFlag = false;
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getReceivePhone())) {
                errorMsg.append("\u6536\u8d27\u4eba\u7535\u8bdd\u4e3a\u7a7a;");
                addressCheckFlag = false;
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getProvince())) {
                errorMsg.append("\u6536\u8d27\u5730\u5740\u7701\u4e3a\u7a7a;");
                addressCheckFlag = false;
            } else if (areaDtoMap.isEmpty() || !areaDtoMap.containsKey(importSaleOrderDto.getProvince())) {
                errorMsg.append("\u6536\u8d27\u5730\u5740\u7701\u6570\u636e\u9519\u8bef;");
                addressCheckFlag = false;
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getCity())) {
                errorMsg.append("\u6536\u8d27\u5730\u5740\u5e02\u4e3a\u7a7a;");
                addressCheckFlag = false;
            } else if (areaDtoMap.isEmpty() || !areaDtoMap.containsKey(importSaleOrderDto.getCity())) {
                errorMsg.append("\u6536\u8d27\u5730\u5740\u5e02\u6570\u636e\u9519\u8bef;");
                addressCheckFlag = false;
            }
            if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getCounty()) && (areaDtoMap.isEmpty() || !areaDtoMap.containsKey(importSaleOrderDto.getCounty()))) {
                errorMsg.append("\u6536\u8d27\u5730\u5740\u533a\u6570\u636e\u9519\u8bef;");
                addressCheckFlag = false;
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getReceiveAddress())) {
                errorMsg.append("\u6536\u8d27\u5730\u5740\u4e3a\u7a7a;");
                addressCheckFlag = false;
            }
            if (addressCheckFlag) {
                SaleOrderAddrReqDto orderAddrReqDto = new SaleOrderAddrReqDto();
                orderAddrReqDto.setReceiveName(importSaleOrderDto.getReceiveName());
                orderAddrReqDto.setReceivePhone(importSaleOrderDto.getReceivePhone());
                orderAddrReqDto.setReceiveAddress(importSaleOrderDto.getReceiveAddress());
                orderAddrReqDto.setProvince(importSaleOrderDto.getProvince());
                orderAddrReqDto.setProvinceCode(((PcpRegionRespDto)areaDtoMap.get(importSaleOrderDto.getProvince())).getCode());
                orderAddrReqDto.setCity(importSaleOrderDto.getCity());
                orderAddrReqDto.setCityCode(((PcpRegionRespDto)areaDtoMap.get(importSaleOrderDto.getCity())).getCode());
                orderAddrReqDto.setCounty(importSaleOrderDto.getCounty());
                if (StringUtils.isNotEmpty((CharSequence)importSaleOrderDto.getCounty()) && areaDtoMap.containsKey(importSaleOrderDto.getCounty())) {
                    orderAddrReqDto.setCountyCode(((PcpRegionRespDto)areaDtoMap.get(importSaleOrderDto.getCounty())).getCode());
                }
                bizSaleOrderReqDto.setOrderAddrReqDto(orderAddrReqDto);
            }
            boolean itemCheckFlag = true;
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getSkuCode())) {
                errorMsg.append("\u5546\u54c1\u957f\u7f16\u7801\u4e3a\u7a7a;");
                itemCheckFlag = false;
            } else if (itemInfoMap.isEmpty() || !itemInfoMap.containsKey(importSaleOrderDto.getSkuCode())) {
                errorMsg.append("\u5546\u54c1\u957f\u7f16\u7801\u9519\u8bef;");
                itemCheckFlag = false;
            } else {
                pcpItemRespDto = (PcpItemRespDto)itemInfoMap.get(importSaleOrderDto.getSkuCode());
                if (pcpItemRespDto.getItemStatus() == null || pcpItemRespDto.getItemStatus() != 2L) {
                    errorMsg.append("\u5546\u54c1\u72b6\u6001\u5df2\u5931\u6548;");
                    itemCheckFlag = false;
                }
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getItemNum())) {
                errorMsg.append("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a;");
                itemCheckFlag = false;
            } else if (!ImportCheckUtils.checkNum(importSaleOrderDto.getItemNum())) {
                errorMsg.append("\u5546\u54c1\u6570\u91cf\u683c\u5f0f\u9519\u8bef:\u5e94\u4e3a1-99999999\u8303\u56f4\u5185\u7684\u6574\u6570;");
                itemCheckFlag = false;
            }
            if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getIfGiftStr())) {
                errorMsg.append("\u662f\u5426\u8d60\u54c1\u4e3a\u7a7a;");
                itemCheckFlag = false;
            } else {
                YesOrNoEnum giftEnum = YesOrNoEnum.enumOfDesc(importSaleOrderDto.getIfGiftStr());
                if (Objects.isNull((Object)giftEnum)) {
                    errorMsg.append("\u662f\u5426\u8d60\u54c1\u9519\u8bef;");
                    itemCheckFlag = false;
                }
            }
            if (itemCheckFlag) {
                pcpItemRespDto = (PcpItemRespDto)itemInfoMap.get(importSaleOrderDto.getSkuCode());
                SaleOrderItemReqDto saleOrderItemReqDto = new SaleOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)saleOrderItemReqDto, (Object)pcpItemRespDto, (String[])new String[]{"id"});
                saleOrderItemReqDto.setItemId(pcpItemRespDto.getId());
                saleOrderItemReqDto.setItemCode(pcpItemRespDto.getItemCode());
                saleOrderItemReqDto.setItemName(pcpItemRespDto.getName());
                saleOrderItemReqDto.setSkuCode(pcpItemRespDto.getItemCode());
                saleOrderItemReqDto.setOrganizationId(bizSaleOrderReqDto.getOrganizationId());
                saleOrderItemReqDto.setOrganizationCode(bizSaleOrderReqDto.getOrganizationCode());
                saleOrderItemReqDto.setOrganizationName(bizSaleOrderReqDto.getOrganizationName());
                saleOrderItemReqDto.setLogicalWarehouseId(bizSaleOrderReqDto.getLogicalWarehouseId());
                saleOrderItemReqDto.setLogicalWarehouseCode(bizSaleOrderReqDto.getLogicalWarehouseCode());
                saleOrderItemReqDto.setLogicalWarehouseName(bizSaleOrderReqDto.getLogicalWarehouseName());
                saleOrderItemReqDto.setChannelWarehouseCode(bizSaleOrderReqDto.getChannelWarehouseCode());
                BigDecimal itemNum = new BigDecimal(importSaleOrderDto.getItemNum());
                saleOrderItemReqDto.setItemNum(itemNum);
                if (StringUtils.isEmpty((CharSequence)importSaleOrderDto.getPrice()) || StringUtils.isBlank((CharSequence)importSaleOrderDto.getPrice()) || !this.checkDecimal(importSaleOrderDto.getPrice()) || !this.checkDecimal(importSaleOrderDto.getDiscountAmount())) {
                    errorMsg.append("\u5355\u4ef7/\u6298\u6263\u989d\u53c2\u6570\u9519\u8bef");
                } else {
                    BigDecimal price = new BigDecimal(importSaleOrderDto.getPrice());
                    BigDecimal discountAmount = new BigDecimal(importSaleOrderDto.getDiscountAmount());
                    saleOrderItemReqDto.setSalePrice(price);
                    saleOrderItemReqDto.setPrice(price);
                    if (this.isOutOrder(importSaleOrderDto.getOrderTypeStr())) {
                        saleOrderItemReqDto.setSalePrice(BigDecimal.ZERO);
                        saleOrderItemReqDto.setPrice(BigDecimal.ZERO);
                    }
                    BigDecimal totalAmount = price.multiply(itemNum);
                    saleOrderItemReqDto.setOrderTotalAmount(totalAmount);
                    saleOrderItemReqDto.setPayAmount(totalAmount.subtract(discountAmount));
                    saleOrderItemReqDto.setLineAmount(totalAmount.subtract(discountAmount));
                    saleOrderItemReqDto.setDiscountAmount(discountAmount);
                }
                saleOrderItemReqDto.setVolume(BigDecimal.ZERO);
                if (Objects.nonNull(pcpItemRespDto.getVolume())) {
                    BigDecimal itemVolume = pcpItemRespDto.getVolume().multiply(itemNum);
                    saleOrderItemReqDto.setVolume(itemVolume);
                }
                saleOrderItemReqDto.setWeight(BigDecimal.ZERO);
                if (Objects.nonNull(pcpItemRespDto.getGrossWeight())) {
                    BigDecimal itemWeight = pcpItemRespDto.getGrossWeight().multiply(itemNum);
                    saleOrderItemReqDto.setWeight(itemWeight);
                    saleOrderItemReqDto.setWeightUnit(pcpItemRespDto.getGrossWeightUnit());
                }
                if (Objects.equals(importSaleOrderDto.getIfGiftStr(), YesOrNoEnum.YES.getDesc())) {
                    bizSaleOrderReqDto.setGiftList(Collections.singletonList(saleOrderItemReqDto));
                } else {
                    bizSaleOrderReqDto.setItemList(Collections.singletonList(saleOrderItemReqDto));
                }
            }
            if (checkPlatformOrderSet.contains(importSaleOrderDto.getPlatformOrderNo())) {
                errorMsg.append("\u8ba2\u5355\u7eac\u5ea6\u5b58\u5728\u9519\u8bef\u4fe1\u606f;");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
                if (StringUtils.isNotBlank((CharSequence)importSaleOrderDto.getPlatformOrderNo())) {
                    checkPlatformOrderSet.add(importSaleOrderDto.getPlatformOrderNo());
                    this.removeSaleOrderMap(importSaleOrderDto.getPlatformOrderNo(), successSaleOrderMap, addSaleOrderMap, msgList);
                }
                importSaleOrderDto.setErrorMsg(errorMsg.toString());
                ImportSaleOrderResultDto resultDto = new ImportSaleOrderResultDto();
                CubeBeanUtils.copyProperties((Object)((Object)resultDto), (Object)((Object)importSaleOrderDto), (String[])new String[0]);
                resultDto.setMsg(importSaleOrderDto.getErrorMsg());
                msgList.add(resultDto);
                continue;
            }
            int combineHashCode = this.getCombineStr(importSaleOrderDto);
            if (onlyMap.containsKey(importSaleOrderDto.getPlatformOrderNo())) {
                logger.info("\u5e73\u53f0\u5355\u53f7\u6821\u9a8c\u5408\u5355\u4fe1\u606f");
                Integer oldOnlyHashCode = (Integer)onlyMap.get(importSaleOrderDto.getPlatformOrderNo());
                if (!Objects.equals(combineHashCode, oldOnlyHashCode)) {
                    logger.info("\u5e73\u53f0\u5355\u53f7\u6821\u9a8c\u5408\u5355\u4fe1\u606f\u9519\u8bef:{},{}", (Object)oldOnlyHashCode, (Object)combineHashCode);
                    if (StringUtils.isNotBlank((CharSequence)importSaleOrderDto.getPlatformOrderNo())) {
                        checkPlatformOrderSet.add(importSaleOrderDto.getPlatformOrderNo());
                        this.removeSaleOrderMap(importSaleOrderDto.getPlatformOrderNo(), successSaleOrderMap, addSaleOrderMap, msgList);
                    }
                    importSaleOrderDto.setErrorMsg("\u8ba2\u5355\u7ef4\u5ea6\u5408\u5355\u6761\u4ef6\u4e0d\u4e00\u81f4;");
                    ImportSaleOrderResultDto resultDto = new ImportSaleOrderResultDto();
                    CubeBeanUtils.copyProperties((Object)((Object)resultDto), (Object)((Object)importSaleOrderDto), (String[])new String[0]);
                    resultDto.setMsg(importSaleOrderDto.getErrorMsg());
                    msgList.add(resultDto);
                    continue;
                }
                if (!addSaleOrderMap.isEmpty() && addSaleOrderMap.containsKey(importSaleOrderDto.getPlatformOrderNo())) {
                    BizSaleOrderReqDto saleOrderReqDto = (BizSaleOrderReqDto)addSaleOrderMap.get(importSaleOrderDto.getPlatformOrderNo());
                    logger.info("\u5408\u5e76\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)saleOrderReqDto));
                    ArrayList itemList = new ArrayList();
                    itemList = CollectionUtils.isEmpty((Collection)saleOrderReqDto.getItemList()) ? itemList : new ArrayList(saleOrderReqDto.getItemList());
                    ArrayList giftList = new ArrayList();
                    ArrayList arrayList = giftList = CollectionUtils.isEmpty((Collection)saleOrderReqDto.getGiftList()) ? giftList : new ArrayList(saleOrderReqDto.getGiftList());
                    if (CollectionUtils.isNotEmpty((Collection)bizSaleOrderReqDto.getItemList())) {
                        ArrayList bizSaleOrderReqDtoItemList = new ArrayList(bizSaleOrderReqDto.getItemList());
                        itemList.addAll(bizSaleOrderReqDtoItemList);
                    }
                    bizSaleOrderReqDto.setItemList(itemList);
                    if (CollectionUtils.isNotEmpty((Collection)bizSaleOrderReqDto.getGiftList())) {
                        ArrayList bizGiftList = new ArrayList(bizSaleOrderReqDto.getGiftList());
                        giftList.addAll(bizSaleOrderReqDto.getGiftList());
                    }
                    bizSaleOrderReqDto.setGiftList(giftList);
                }
            } else {
                onlyMap.put(importSaleOrderDto.getPlatformOrderNo(), combineHashCode);
            }
            bizSaleOrderReqDto.setOrderSource(SaleOrderSourceEnum.IMPORT.getType());
            addSaleOrderMap.put(importSaleOrderDto.getPlatformOrderNo(), bizSaleOrderReqDto);
            if (!successSaleOrderMap.isEmpty() && successSaleOrderMap.containsKey(importSaleOrderDto.getPlatformOrderNo())) {
                List importSaleOrderDtos = (List)successSaleOrderMap.get(importSaleOrderDto.getPlatformOrderNo());
                importSaleOrderDtos.add(importSaleOrderDto);
                successSaleOrderMap.put(importSaleOrderDto.getPlatformOrderNo(), importSaleOrderDtos);
                continue;
            }
            successSaleOrderMap.put(importSaleOrderDto.getPlatformOrderNo(), Lists.newArrayList((Object[])new ImportSaleOrderDto[]{importSaleOrderDto}));
        }
        ArrayList successList = Lists.newArrayList();
        for (List importSaleOrderDtos : successSaleOrderMap.values()) {
            successList.addAll(importSaleOrderDtos);
        }
        saveList = Lists.newArrayList(addSaleOrderMap.values());
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("saveList", saveList);
        hashMap.put("msgList", msgList);
        hashMap.put("successList", successList);
        return new RestResponse((Object)hashMap);
    }

    private boolean checkDecimal(String price) {
        return ImportCheckUtils.checkAmount(price);
    }

    private void removeSaleOrderMap(String platformOrderNo, Map<String, List<ImportSaleOrderDto>> successSaleOrderMap, Map<String, BizSaleOrderReqDto> addSaleOrderMap, List<ImportSaleOrderResultDto> msgList) {
        if (!successSaleOrderMap.isEmpty() && successSaleOrderMap.containsKey(platformOrderNo)) {
            List<ImportSaleOrderDto> importSaleOrderDtos = successSaleOrderMap.get(platformOrderNo);
            for (ImportSaleOrderDto importSaleOrderDto : importSaleOrderDtos) {
                ImportSaleOrderResultDto successResultDto = new ImportSaleOrderResultDto();
                CubeBeanUtils.copyProperties((Object)((Object)successResultDto), (Object)((Object)importSaleOrderDto), (String[])new String[0]);
                successResultDto.setMsg("\u8ba2\u5355\u7eac\u5ea6\u5b58\u5728\u9519\u8bef\u4fe1\u606f;");
                msgList.add(successResultDto);
            }
            successSaleOrderMap.remove(platformOrderNo);
        }
        if (!addSaleOrderMap.isEmpty() && addSaleOrderMap.containsKey(platformOrderNo)) {
            addSaleOrderMap.remove(platformOrderNo);
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object successList = map.get("successList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            for (BizSaleOrderReqDto bizSaleOrderReqDto : saveList) {
                try {
                    bizSaleOrderReqDto.setPlatformCreateTime(new Date());
                    bizSaleOrderReqDto.setCreatePerson(commonReqDto.getOperator());
                    bizSaleOrderReqDto.setUpdatePerson(commonReqDto.getOperator());
                    RestResponseHelper.extractData((RestResponse)this.saleOrderApi.addSaleOrder(bizSaleOrderReqDto));
                }
                catch (Exception e) {
                    logger.info("\u5e73\u53f0\u5355\u5bfc\u5165\u5931\u8d25:{}", (Object)bizSaleOrderReqDto.getPlatformOrderNo());
                    logger.info(e.getMessage(), (Throwable)e);
                    this.setSuccessListErrorMsg(map, bizSaleOrderReqDto.getPlatformOrderNo(), "\u65b0\u589e\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        Object msgObj = map.get("msgList");
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u9500\u552e\u8ba2\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportSaleOrderResultDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private void setSuccessListErrorMsg(Map<String, Object> map, String platformOrderNo, String errorMsg) {
        Object successObject = map.get("successList");
        if (successObject == null) {
            logger.info("\u5bfc\u5165\u6210\u529fdto\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        List successList = (List)successObject;
        if (CollectionUtils.isEmpty(successList = successList.stream().filter(dto -> Objects.equals(dto.getPlatformOrderNo(), platformOrderNo)).collect(Collectors.toList()))) {
            logger.info("\u672a\u7b5b\u9009\u51fa:{}\u5355\u53f7\u7684\u6210\u529f\u4fe1\u606f", (Object)platformOrderNo);
            return;
        }
        Object msgObj = map.get("msgList");
        List<ImportSaleOrderResultDto> msgList = Lists.newArrayList();
        if (msgObj != null) {
            msgList = (List)msgObj;
        }
        for (ImportSaleOrderDto importSaleOrderDto : successList) {
            ImportSaleOrderResultDto resultDto = new ImportSaleOrderResultDto();
            CubeBeanUtils.copyProperties((Object)((Object)resultDto), (Object)((Object)importSaleOrderDto), (String[])new String[0]);
            resultDto.setMsg(errorMsg);
            msgList.add(resultDto);
        }
        map.put("msgList", msgList);
    }

    private int getCombineStr(ImportSaleOrderDto importDto) {
        String combineOrders = importDto.getPlatformOrderNo().concat(Optional.ofNullable(importDto.getCustomerCode()).orElse("")).concat(Optional.ofNullable(importDto.getOrderChannelCode()).orElse("")).concat(Optional.ofNullable(importDto.getChannelWarehouseCode()).orElse("")).concat(Optional.ofNullable(importDto.getDefaultLogicalWarehouseCode()).orElse("")).concat(Optional.ofNullable(importDto.getOrderTypeStr()).orElse("")).concat(Optional.ofNullable(importDto.getAllowSplitFlagStr()).orElse("")).concat(Optional.ofNullable(importDto.getReceiveName()).orElse("")).concat(Optional.ofNullable(importDto.getReceivePhone()).orElse("")).concat(Optional.ofNullable(importDto.getProvince()).orElse("")).concat(Optional.ofNullable(importDto.getCity()).orElse("")).concat(Optional.ofNullable(importDto.getCounty()).orElse("")).concat(Optional.ofNullable(importDto.getReceiveAddress()).orElse(""));
        logger.info("\u5408\u5355\u6761\u4ef6\u5b57\u7b26\u4e32:{}", (Object)combineOrders);
        return combineOrders.hashCode();
    }

    private BigDecimal calItemsAmount(List<SaleOrderItemReqDto> itemList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (SaleOrderItemReqDto orderItem : itemList) {
            AssertUtils.notNull(orderItem.getPrice(), String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            AssertUtils.notNull(orderItem.getItemNum(), String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            totalAmount = totalAmount.add(orderItem.getPrice().multiply(orderItem.getItemNum()));
        }
        return totalAmount;
    }

    @Override
    public RestResponse<Object> invalidOrder(OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.invalidOrder((Long)orderIdList.get(0)));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.invalidOrder(orderId));
                this.orderInvalidToEas(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u53d6\u6d88\u8ba2\u5355]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> modifySaleOrderAddress(@ApiParam(value="") @Valid @RequestBody(required=false) SaleOrderAddrReqDto reqDto) {
        this.saleOrderOptApi.modifyAddress(reqDto.getOrderId(), reqDto);
        return new RestResponse();
    }

    private boolean isClaimOrder(String orderTypeStr) {
        SaleOrderTypeEnum saleOrderTypeEnum = SaleOrderTypeEnum.enumOfDesc((String)orderTypeStr);
        return saleOrderTypeEnum != null && (SaleOrderTypeEnum.CLAIM_POSTING.getType().equals(saleOrderTypeEnum.getType()) || SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(saleOrderTypeEnum.getType()));
    }

    private boolean isYyjOrder(SaleOrderTypeEnum saleOrderTypeEnum) {
        return SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType().equals(saleOrderTypeEnum.getType()) || SaleOrderTypeEnum.ACTIVITY_ORDER.getType().equals(saleOrderTypeEnum.getType()) || SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType().equals(saleOrderTypeEnum.getType());
    }

    private boolean isOutOrder(String orderTypeStr) {
        SaleOrderTypeEnum saleOrderTypeEnum = SaleOrderTypeEnum.enumOfDesc((String)orderTypeStr);
        if (saleOrderTypeEnum == null) {
            return false;
        }
        return saleOrderTypeEnum != null && (SaleOrderTypeEnum.OTHER_OUT_STOCK.getType().equals(saleOrderTypeEnum.getType()) || SaleOrderTypeEnum.REPLENISH_ORDER.getType().equals(saleOrderTypeEnum.getType()) || SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType().equals(saleOrderTypeEnum.getType()) || SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType().equals(saleOrderTypeEnum.getType()));
    }

    private void orderInvalidToEas(Long id) {
        try {
            logger.info("\u9500\u552e\u8ba2\u5355\u4f5c\u5e9f\u901a\u77e5EAS\u66f4\u65b0\u72b6\u6001\uff1a{}", (Object)id);
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{id})));
            if (CollectionUtil.isNotEmpty((Collection)saleOrderRespDtos) && StringUtils.isNotBlank((CharSequence)((SaleOrderRespDto)saleOrderRespDtos.get(0)).getEasOrderNo()) && ((SaleOrderRespDto)saleOrderRespDtos.get(0)).getChannelCode().equals("CSP")) {
                ExternalDispatchBaseVo baseVo = new ExternalDispatchBaseVo();
                CancelOrderReqDto reqDto = new CancelOrderReqDto();
                reqDto.setSyscSystemType("PCP");
                reqDto.setFnumber(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getEasOrderNo());
                reqDto.setBillName(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getEasOrderNo());
                reqDto.setBillType(EASBillTypeEnum.IMPORT_UN_001_TYPE_310.code);
                baseVo.setData((Object)reqDto);
                baseVo.setExternalDispatchBaseEnum(ExternalDispatchBaseEnum.API_EAS001);
                this.commonsMqService.sendSingleMessage(ExternalDispatchBaseEnum.API_EAS001.getTopicKey(), ExternalDispatchBaseEnum.API_EAS001.getTagKey(), (Object)JSON.toJSONString((Object)baseVo));
            }
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8ba2\u5355\u4f5c\u5e9f\u901a\u77e5EAS\u66f4\u65b0\u72b6\u6001\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public RestResponse<SaleOrderStringCodeCountRespDto> getStringCodeByCount(@Valid GetSaleOrderCountParams getSaleOrderCountParams) {
        String[] orderNos;
        String[] split;
        com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto reqDto = new com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto();
        BeanUtils.copyProperties((Object)getSaleOrderCountParams, (Object)reqDto, (String[])new String[]{"orderLevelList"});
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getSaleOrderCreateTimeStart())) {
            reqDto.setSaleOrderCreateTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getSaleOrderCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getSaleOrderCreateTimeEnd())) {
            reqDto.setSaleOrderCreateTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getSaleOrderCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getDeliveryTimeEnd())) {
            reqDto.setDeliveryTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getDeliveryTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getDeliveryTimeStart())) {
            reqDto.setDeliveryTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getDeliveryTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getUpdateTimeStart())) {
            reqDto.setUpdateTimeStart(DateUtil.parse((String)(getSaleOrderCountParams.getUpdateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getUpdateTimeEnd())) {
            reqDto.setUpdateTimeEnd(DateUtil.parse((String)(getSaleOrderCountParams.getUpdateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getBizDateStart())) {
            reqDto.setBizDateStart(DateUtil.parse((String)(getSaleOrderCountParams.getBizDateStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getSaleOrderCountParams.getBizDateEnd())) {
            reqDto.setBizDateEnd(DateUtil.parse((String)(getSaleOrderCountParams.getBizDateEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getSaleOrderCountParams.getSaleOrderStatus())) {
            split = getSaleOrderCountParams.getSaleOrderStatus().split(",");
            List<String> saleOrderStatusList = Arrays.asList(split);
            reqDto.setSaleOrderStatus(null);
            reqDto.setSaleOrderStatusList(saleOrderStatusList);
        }
        if (StringUtils.isNotEmpty((CharSequence)getSaleOrderCountParams.getOrderSource())) {
            split = getSaleOrderCountParams.getOrderSource().split(",");
            List orderSourceList = Arrays.asList(split).stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList());
            reqDto.setOrderSource(null);
            reqDto.setOrderSourceList(orderSourceList);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo())).length > 1) {
            reqDto.setOrderNoList(Arrays.asList(orderNos));
            reqDto.setOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getEasOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getEasOrderNo())).length > 1) {
            reqDto.setEasOrderNoList(Arrays.asList(orderNos));
            reqDto.setEasOrderNo(null);
        }
        reqDto.setOrderLevelList(getSaleOrderCountParams.getOrderLevelList());
        reqDto.setStringCodeResultList(getSaleOrderCountParams.getStringCodeResultList());
        reqDto.setEasVerifyStatusList(getSaleOrderCountParams.getEasVerifyStatusList());
        reqDto.setTagCodeList(getSaleOrderCountParams.getTagCodeList());
        reqDto.setOrganizationIdList(getSaleOrderCountParams.getOrganizationIdList());
        SaleOrderStringCodeCountRespDto respDto = (SaleOrderStringCodeCountRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.queryStringCodeByCount(reqDto));
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<Object> splitPick(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitPick((Long)orderIdList.get(0)));
            this.sendAutoSyncMsg((Long)orderIdList.get(0));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitPick(orderId));
                this.sendAutoSyncMsg(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u62c6\u5355\u914d\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> notSplitPick(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.notSplitPick((Long)orderIdList.get(0)));
            this.sendAutoSyncMsg((Long)orderIdList.get(0));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.notSplitPick(orderId));
                this.sendAutoSyncMsg(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u4e0d\u62c6\u5355\u914d\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> doPcpStatusLock(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds(orderIdList));
        List deliveryOrderList = saleOrderRespDtos.stream().filter(dto -> Objects.equals(dto.getLockStatus(), LockStatusEnum.UNLOCK.getType())).collect(Collectors.toList());
        Map<String, List<CsOutNoticeOrderRespDto>> outNoticeOrderMap = new HashMap<String, List<CsOutNoticeOrderRespDto>>();
        if (CollectionUtils.isNotEmpty(deliveryOrderList)) {
            List delvierySaleOrderNoList = deliveryOrderList.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
            List csOutNoticeOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList(delvierySaleOrderNoList));
            outNoticeOrderMap = ((List)Optional.ofNullable(csOutNoticeOrderRespDtos).orElse(new ArrayList())).stream().filter(dto -> Objects.equals(dto.getOrderStatus(), BaseOrderStatusEnum.ONO_WAIT_OUT.getCode())).collect(Collectors.groupingBy(CsOutNoticeOrderRespDto::getRelevanceNo));
        }
        if (saleOrderRespDtos.size() == 1 && Objects.nonNull(outNoticeOrderMap)) {
            this.cancelWmsOrder((SaleOrderRespDto)saleOrderRespDtos.get(0), outNoticeOrderMap);
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusLock(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getId()));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            Long orderId = saleOrderRespDto.getId();
            try {
                this.cancelWmsOrder(saleOrderRespDto, outNoticeOrderMap);
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusLock(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u6302\u8d77]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    private void cancelWmsOrder(SaleOrderRespDto saleOrderRespDto, Map<String, List<CsOutNoticeOrderRespDto>> outNoticeOrderMap) {
        if (outNoticeOrderMap.containsKey(saleOrderRespDto.getSaleOrderNo())) {
            List<CsOutNoticeOrderRespDto> csOutNoticeOrderRespDtos = outNoticeOrderMap.get(saleOrderRespDto.getSaleOrderNo());
            CsOutNoticeOrderRespDto csOutNoticeOrderRespDto = csOutNoticeOrderRespDtos.get(0);
            WmsBaseRespDto wmsBaseRespDto = this.wmsAble.cancelWmsOutOrder(csOutNoticeOrderRespDto);
            if (wmsBaseRespDto.isSuccess()) {
                logger.info("WMS\u53d6\u6d88\u6210\u529f\uff0c\u53d6\u6d88\u51fa\u5e93\u5355\u53f7.{}", (Object)csOutNoticeOrderRespDto.getDocumentNo());
                RestResponseHelper.extractData((RestResponse)this.csPcpInventoryExposedApi.cancelPhysicsOrder(saleOrderRespDto.getSaleOrderNo()));
            } else {
                throw new BizException("\u53d6\u6d88WMS\u5355\u636e\u5931\u8d25:" + wmsBaseRespDto.getContent());
            }
        }
    }

    @Override
    public RestResponse<Object> doPcpStatusUnLock(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLock((Long)orderIdList.get(0)));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLock(orderId));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u89e3\u6302]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> batchMarkingTag(OrderTagRecordAddBatchReqDto orderTagRecordAddBatchReqDto) {
        return this.orderTagRecordApi.addBatchOrderTagRecord(orderTagRecordAddBatchReqDto);
    }

    @Override
    public RestResponse<LogisticsInfoRespDto> queryLogisticsInfoReqDto(String shippingCode) {
        return this.csLogisticsInfoQueryApi.queryLogisticsInfoReqDto(shippingCode);
    }

    @Override
    public RestResponse<Object> advancePick(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        if (orderIdList.size() == 1) {
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.advancePick((Long)orderIdList.get(0)));
            this.sendAutoSyncMsg((Long)orderIdList.get(0));
            return new RestResponse();
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.advancePick(orderId));
                this.sendAutoSyncMsg(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u9884\u6536\u914d\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> saleOrderSplitDelivery(@Valid SplitOrderBySourceInfoReqDto reqDto) {
        SaleOrderPartSplitDeliveryVo saleOrderPartSplitDeliveryVo = null;
        reqDto.setAsync(true);
        String pickSaleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.partSplitPick(reqDto.getSaleOrderId(), reqDto));
        logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406\u62c6\u5355\u540e\u8fd4\u56de\u7ed3\u679c:{}", (Object)pickSaleOrderNo);
        Long orderId = reqDto.getSaleOrderId();
        String resultMsg = "";
        if (StringUtils.isNotEmpty((CharSequence)pickSaleOrderNo)) {
            List childSaleOrderList;
            saleOrderPartSplitDeliveryVo = new SaleOrderPartSplitDeliveryVo();
            saleOrderPartSplitDeliveryVo.setMainOrderNo(reqDto.getSaleOrderNo());
            saleOrderPartSplitDeliveryVo.setPickChildOrderNo(pickSaleOrderNo);
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setOriginalOrderNo(reqDto.getSaleOrderNo());
            saleOrderQueryReqDto.setOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406\u62c6\u5355\u540e\u6839\u636e\u4e3b\u5355\u67e5\u8be2\u5f85\u914d\u8d27\u5b50\u5355\u7ed3\u679c:{}", (Object)saleOrderRespDtos.size());
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos) && CollectionUtils.isNotEmpty(childSaleOrderList = saleOrderRespDtos.stream().filter(dto -> !Objects.equals(dto.getSaleOrderNo(), pickSaleOrderNo)).collect(Collectors.toList()))) {
                orderId = ((SaleOrderRespDto)childSaleOrderList.get(0)).getId();
                saleOrderPartSplitDeliveryVo.setDeliveryChildOrderNo(((SaleOrderRespDto)childSaleOrderList.get(0)).getSaleOrderNo());
                resultMsg = "\u4e3b\u5355:" + saleOrderPartSplitDeliveryVo.getMainOrderNo() + ",\u5b50\u5355:" + saleOrderPartSplitDeliveryVo.getDeliveryChildOrderNo() + ",\u53d1\u8d27\u6210\u529f";
            }
        }
        try {
            Long finalOrderId = orderId;
            CompletableFuture.runAsync(() -> {
                Void cfr_ignored_0 = (Void)RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.continueDeliver(finalOrderId));
            });
        }
        catch (Exception e) {
            logger.info("\u7ee7\u7eed\u53d1\u8d27\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        RestResponse restResponse = new RestResponse();
        restResponse.setData((Object)pickSaleOrderNo);
        restResponse.setResultMsg(resultMsg);
        return restResponse;
    }

    @Override
    public RestResponse<SaleOrderPartSplitDeliveryVo> saleTransferSplit(@Valid SplitOrderBySourceInfoReqDto reqDto) {
        List mainSaleOrderList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getSaleOrderId()})));
        if (CollectionUtils.isEmpty((Collection)mainSaleOrderList)) {
            throw PcpTradeExceptionCode.MUTIL_SALE_ORDER_NOT_EXCEPTION.buildBizException(new Object[]{reqDto.getSaleOrderNo()});
        }
        SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)mainSaleOrderList.get(0);
        SaleOrderPartSplitDeliveryVo resultVo = new SaleOrderPartSplitDeliveryVo();
        resultVo.setMainOrderNo(reqDto.getSaleOrderNo());
        resultVo.setMainOrderId(reqDto.getSaleOrderId());
        if (reqDto.getSgSourceNum().compareTo(saleOrderRespDto.getGoodsTotalNum()) != 0) {
            resultVo.setSplitFlag(Boolean.TRUE);
            SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
            splitOrderReqDto.setSaleOrderId(reqDto.getSaleOrderId());
            splitOrderReqDto.setSaleOrderNo(reqDto.getSaleOrderNo());
            splitOrderReqDto.setInitOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
            splitOrderReqDto.setInitOmsOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
            splitOrderReqDto.setOriOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
            splitOrderReqDto.setSplitNotDeliveryFlag(Boolean.TRUE.booleanValue());
            ArrayList orderList = Lists.newArrayList();
            SplitChildOrderReqDto splitChildOrderReqDto = new SplitChildOrderReqDto();
            splitChildOrderReqDto.setGoodsList(reqDto.getGoodsList());
            SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseCode(reqDto.getDeliveryLogicWarehouseCode());
            logicWarehouse.setDeliveryLogicWarehouseName(reqDto.getDeliveryLogicWarehouseName());
            logicWarehouse.setDeliveryLogicWarehouseId(reqDto.getDeliveryLogicWarehouseId());
            splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
            orderList.add(splitChildOrderReqDto);
            splitOrderReqDto.setOrderList((List)orderList);
            logger.info("\u9500\u552e\u8c03\u62e8\u62c6\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitOrder(reqDto.getSaleOrderId(), splitOrderReqDto));
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setOriginalOrderNo(reqDto.getSaleOrderNo());
            saleOrderQueryReqDto.setOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                List childOrderIdList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
                List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds(childOrderIdList));
                Map<Long, List<SaleOrderItemRespDto>> orderItemMap = saleOrderItemRespDtos.stream().collect(Collectors.groupingBy(SaleOrderItemRespDto::getOrderId));
                for (SaleOrderRespDto orderRespDto : saleOrderRespDtos) {
                    boolean pickChildFlag = this.checkSelectOrder(reqDto, orderRespDto, orderItemMap.get(orderRespDto.getId()));
                    logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u62c6\u5355\u662f\u5426\u9009\u4e2d\u7684\u8ba2\u5355:{},{}", (Object)orderRespDto.getSaleOrderNo(), (Object)pickChildFlag);
                    if (pickChildFlag) {
                        resultVo.setDeliveryChildOrderId(orderRespDto.getId());
                        resultVo.setDeliveryChildOrderNo(orderRespDto.getSaleOrderNo());
                        continue;
                    }
                    resultVo.setPickChildOrderId(orderRespDto.getId());
                    resultVo.setPickChildOrderNo(orderRespDto.getSaleOrderNo());
                }
            }
        }
        return new RestResponse((Object)resultVo);
    }

    private boolean checkSelectOrder(SplitOrderBySourceInfoReqDto reqDto, SaleOrderRespDto orderRespDto, List<SaleOrderItemRespDto> itemRespDtos) {
        if (!Objects.equals(orderRespDto.getLogicalWarehouseCode(), reqDto.getDeliveryLogicWarehouseCode())) {
            logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u62c6\u5355\u5224\u65ad:\u5bfb\u6e90\u53d1\u8d27\u4ed3\u548c\u5b50\u5355\u53d1\u8d27\u903b\u8f91\u4ed3\u4e0d\u540c:{}", (Object)orderRespDto.getSaleOrderNo());
            return false;
        }
        if (orderRespDto.getGoodsTotalNum().compareTo(reqDto.getSgSourceNum()) != 0) {
            logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u62c6\u5355\u5224\u65ad:\u5bfb\u6e90\u603b\u6570\u91cf\u548c\u5b50\u5355\u603b\u6570\u91cf\u4e0d\u540c:{}", (Object)orderRespDto.getSaleOrderNo());
            return false;
        }
        List goodsList = reqDto.getGoodsList();
        Map<Long, BigDecimal> originalOrderIdMap = goodsList.stream().collect(Collectors.toMap(SplitOrderItemReqDto::getOriginalOrderGoodsId, SplitOrderItemReqDto::getGoodsNum, (v1, v2) -> {
            v1 = v1.add((BigDecimal)v2);
            return v1;
        }));
        logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u5bfb\u6e90\u62c6\u5355\u5546\u54c1\u603b\u6570:{}", (Object)JSON.toJSONString(originalOrderIdMap));
        Map<Long, BigDecimal> childOriginalOrderIdMap = itemRespDtos.stream().collect(Collectors.toMap(SaleOrderItemRespDto::getOriginalOrderItemId, SaleOrderItemRespDto::getItemNum, (v1, v2) -> {
            v1 = v1.add((BigDecimal)v2);
            return v1;
        }));
        logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u62c6\u5355\u5b50\u5355\u5546\u54c1\u603b\u6570:{}", (Object)JSON.toJSONString(childOriginalOrderIdMap));
        for (Long childOrderItemId : childOriginalOrderIdMap.keySet()) {
            BigDecimal sgItemNum;
            if (!originalOrderIdMap.containsKey(childOrderItemId)) {
                logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u62c6\u5355\u5224\u65ad:\u5bfb\u6e90\u5546\u54c1\u548c\u5b50\u5355\u5546\u54c1id:{} \u4e0d\u540c:{}", (Object)childOrderItemId);
                return false;
            }
            BigDecimal childItemNum = childOriginalOrderIdMap.get(childOrderItemId);
            if (childItemNum.compareTo(sgItemNum = originalOrderIdMap.get(childOrderItemId)) == 0) continue;
            logger.info("\u8ba2\u5355\u9884\u5206\u914d\u7ba1\u7406-\u62c6\u5355\u5224\u65ad:\u5bfb\u6e90\u5546\u54c1\u603b\u6570\u91cf:{}\u548c\u5b50\u5355\u5546\u54c1\u603b\u6570\u91cf:{}\u4e0d\u540c:{}", (Object)sgItemNum, (Object)childItemNum);
            return false;
        }
        return true;
    }

    @Override
    public RestResponse<SourceDeliveryRespDto> batchSourceDeliveryAndTransfer(List<SplitOrderBySourceInfoReqDto> sourceOrderList) {
        if (CollectionUtils.isEmpty(sourceOrderList)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SourceDeliveryRespDto respDto = new SourceDeliveryRespDto();
        ArrayList resultVoList = Lists.newArrayList();
        Map<Long, List<SplitOrderBySourceInfoReqDto>> saleOrderMap = sourceOrderList.stream().collect(Collectors.groupingBy(SplitOrderBySourceInfoReqDto::getSaleOrderId));
        ExecutorService executorService = Executors.newWorkStealingPool(12);
        ArrayList<CompletableFuture<SourceDeliveryResultVo>> futureList = new ArrayList<CompletableFuture<SourceDeliveryResultVo>>(saleOrderMap.size());
        ServiceContext context = ServiceContext.getContext();
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        for (Long orderId : saleOrderMap.keySet()) {
            futureList.add(CompletableFuture.supplyAsync(() -> this.sourceDeliveryAndTransfer(orderId, saleOrderMap, context), executorService));
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        futureList.forEach(r -> {
            try {
                SourceDeliveryResultVo resultVo = (SourceDeliveryResultVo)r.get();
                if (resultVo != null) {
                    resultVoList.add(resultVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u9ad8\u7ea7\u5bfb\u6e90\u53d1\u8d27\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        });
        logger.info("\u6267\u884c\u7ed3\u679c\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)resultVoList));
        respDto.setTotalNum(resultVoList.size());
        List<SourceDeliveryResultVo> failList = resultVoList.stream().filter(dto -> !Objects.equals("\u64cd\u4f5c\u6210\u529f", dto.getResultMsg())).collect(Collectors.toList());
        respDto.setFailNum(failList.size());
        respDto.setResultList(failList);
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<SourceDeliveryRespDto> batchSourceDeliveryAndTransferMaiyou(List<SplitOrderBySourceInfoReqDto> sourceOrderList) {
        if (CollectionUtils.isEmpty(sourceOrderList)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SourceDeliveryRespDto respDto = new SourceDeliveryRespDto();
        ArrayList resultVoList = Lists.newArrayList();
        Map<Long, List<SplitOrderBySourceInfoReqDto>> saleOrderMap = sourceOrderList.stream().collect(Collectors.groupingBy(SplitOrderBySourceInfoReqDto::getSaleOrderId));
        ExecutorService executorService = Executors.newWorkStealingPool(12);
        ArrayList<CompletableFuture<SourceDeliveryResultVo>> futureList = new ArrayList<CompletableFuture<SourceDeliveryResultVo>>(saleOrderMap.size());
        ServiceContext context = ServiceContext.getContext();
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        for (Long orderId : saleOrderMap.keySet()) {
            futureList.add(CompletableFuture.supplyAsync(() -> this.sourceDeliveryAndTransferMaiyou(orderId, saleOrderMap, context), executorService));
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        futureList.forEach(r -> {
            try {
                SourceDeliveryResultVo resultVo = (SourceDeliveryResultVo)r.get();
                if (resultVo != null) {
                    resultVoList.add(resultVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u9ea6\u4f18\u9ad8\u7ea7\u5bfb\u6e90\u53d1\u8d27\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        });
        logger.info("\u6267\u884c\u7ed3\u679c\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)resultVoList));
        respDto.setTotalNum(resultVoList.size());
        List<SourceDeliveryResultVo> failList = resultVoList.stream().filter(dto -> !Objects.equals("\u64cd\u4f5c\u6210\u529f", dto.getResultMsg())).collect(Collectors.toList());
        respDto.setFailNum(failList.size());
        respDto.setResultList(failList);
        return new RestResponse((Object)respDto);
    }

    private SourceDeliveryResultVo sourceDeliveryAndTransfer(Long orderId, Map<Long, List<SplitOrderBySourceInfoReqDto>> saleOrderMap, ServiceContext context) {
        List<SplitOrderBySourceInfoReqDto> splitOrderBySourceInfoReqDtos = saleOrderMap.get(orderId);
        String saleOrderNo = splitOrderBySourceInfoReqDtos.get(0).getSaleOrderNo();
        SourceDeliveryResultVo sourceDeliveryResultVo = new SourceDeliveryResultVo();
        sourceDeliveryResultVo.setSaleOrderNo(saleOrderNo);
        sourceDeliveryResultVo.setResultMsg("\u64cd\u4f5c\u6210\u529f");
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        try {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
            logger.info("\u9ad8\u7ea7\u5bfb\u6e90\u53d1\u8d27:{}", (Object)orderId);
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.sourceDeliveryAndTransfer(orderId, saleOrderMap.get(orderId)));
        }
        catch (Exception e) {
            sourceDeliveryResultVo.setResultMsg(e.getMessage());
            logger.error("[\u9ad8\u7ea7\u5bfb\u6e90\u53d1\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return sourceDeliveryResultVo;
    }

    private SourceDeliveryResultVo sourceDeliveryAndTransferMaiyou(Long orderId, Map<Long, List<SplitOrderBySourceInfoReqDto>> saleOrderMap, ServiceContext context) {
        List<SplitOrderBySourceInfoReqDto> splitOrderBySourceInfoReqDtos = saleOrderMap.get(orderId);
        String saleOrderNo = splitOrderBySourceInfoReqDtos.get(0).getSaleOrderNo();
        SourceDeliveryResultVo sourceDeliveryResultVo = new SourceDeliveryResultVo();
        sourceDeliveryResultVo.setSaleOrderNo(saleOrderNo);
        sourceDeliveryResultVo.setResultMsg("\u64cd\u4f5c\u6210\u529f");
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        try {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
            logger.info("\u9ea6\u4f18\u9ad8\u7ea7\u5bfb\u6e90\u53d1\u8d27:{}", (Object)orderId);
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.sourceDeliveryAndTransferMaiyou(orderId, saleOrderMap.get(orderId)));
        }
        catch (Exception e) {
            sourceDeliveryResultVo.setResultMsg(e.getMessage());
            logger.error("[\u9ea6\u4f18\u9ad8\u7ea7\u5bfb\u6e90\u53d1\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return sourceDeliveryResultVo;
    }

    @Override
    public RestResponse<List<SaleOrderItemInventoryRespDto>> queryInventoryZtByCargo(List<CargoInventoryReqDto> cargoInventoryReqDtos) {
        Map map;
        Integer status;
        List logicInventoryRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryInventoryByCargo(cargoInventoryReqDtos));
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)logicInventoryRespDtos, SaleOrderItemInventoryRespDto.class);
        String inTransitInventorySwitch = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "IN_TRANSIT_INVENTORY_SWITCH").getData()).map(DictDto::getValue).orElse(null);
        logger.info("\u67e5\u8be2\u53ef\u552e\u5728\u9014\u5e93\u5b58\u5f00\u5173\u901a\u7528\u914d\u7f6e:{}", (Object)inTransitInventorySwitch);
        if (!Objects.equals(inTransitInventorySwitch, "1")) {
            return new RestResponse((Object)resultList);
        }
        String ztSaleStockDictValue = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "INVENTORY_AVAILABLE_IN_TRANSIT_DAY").getData()).map(DictDto::getValue).orElse(null);
        logger.info("\u67e5\u8be2\u53ef\u552e\u5728\u9014\u5e93\u5b58\u901a\u7528\u914d\u7f6e:{}", (Object)ztSaleStockDictValue);
        Integer day = 0;
        if (StringUtils.isNotEmpty((CharSequence)ztSaleStockDictValue) && Objects.equals(status = Integer.valueOf((map = (Map)JSON.parseObject((String)ztSaleStockDictValue, Map.class)).get("status").toString()), 1)) {
            day = Integer.valueOf(map.get("day").toString());
        }
        Set cargoCodeSet = cargoInventoryReqDtos.stream().map(CargoInventoryReqDto::getCargoCode).collect(Collectors.toSet());
        Set warehouseCodes = cargoInventoryReqDtos.stream().map(CargoInventoryReqDto::getWarehouseCode).collect(Collectors.toSet());
        IntransitCargoQueryDto queryDto = new IntransitCargoQueryDto();
        queryDto.setLogicWarehouseCodes((List)Lists.newArrayList(warehouseCodes));
        queryDto.setCargoCodes((List)Lists.newArrayList(cargoCodeSet));
        queryDto.setConfigDay(day);
        logger.info("\u67e5\u8be2\u5728\u9014\u4ed3\u5e93\u5b58\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        List intransitCargoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryIntransitCargoNum(queryDto));
        logger.info("\u83b7\u53d6\u5728\u9014\u4ed3\u5e93\u5b58\u7ed3\u679c==>{}", (Object)JSON.toJSONString((Object)intransitCargoRespDtos));
        if (CollectionUtils.isEmpty((Collection)intransitCargoRespDtos)) {
            return new RestResponse((Object)resultList);
        }
        List logicWarehouseCodes = resultList.stream().map(LogicInventoryRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
        DgLogicWarehousePageReqDto reqDto = new DgLogicWarehousePageReqDto();
        reqDto.setWarehouseCodes(logicWarehouseCodes);
        List dgLogicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryList(reqDto));
        Map<String, IntransitCargoRespDto> intransitCargoRespDtoMap = this.getStringIntransitCargoRespDtoMap(intransitCargoRespDtos);
        for (SaleOrderItemInventoryRespDto respDto : resultList) {
            DgLogicWarehouseDto intransitWarehouseDto;
            String key;
            DgLogicWarehouseDto logicWarehouseDto = dgLogicWarehouseDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)respDto.getWarehouseCode())).findFirst().orElse(null);
            if (null == logicWarehouseDto) continue;
            DgLogicWarehousePageReqDto intransitReqDto = new DgLogicWarehousePageReqDto();
            intransitReqDto.setSubordinateLogicWarehouseId(logicWarehouseDto.getId());
            List intransitWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryList(intransitReqDto));
            if (CollectionUtils.isEmpty((Collection)intransitWarehouseDtoList) || !intransitCargoRespDtoMap.containsKey(key = (intransitWarehouseDto = (DgLogicWarehouseDto)intransitWarehouseDtoList.get(0)).getWarehouseCode() + "_" + respDto.getItemLongCode())) continue;
            IntransitCargoRespDto intransitCargoRespDto = intransitCargoRespDtoMap.get(key);
            CubeBeanUtils.copyProperties((Object)((Object)respDto), (Object)intransitCargoRespDto, (String[])new String[0]);
        }
        return new RestResponse((Object)resultList);
    }

    private Map<String, IntransitCargoRespDto> getStringIntransitCargoRespDtoMap(List<IntransitCargoRespDto> intransitCargoRespDtoList) {
        Map<String, List<IntransitCargoRespDto>> intransitCargoMap = intransitCargoRespDtoList.stream().collect(Collectors.groupingBy(o -> o.getIntransitWarehouseCode() + "_" + o.getCargoCode()));
        HashMap resultMap = Maps.newHashMap();
        for (Map.Entry<String, List<IntransitCargoRespDto>> entry : intransitCargoMap.entrySet()) {
            IntransitCargoRespDto entryValue = entry.getValue().get(0);
            IntransitCargoRespDto intransitCargoRespDto = (IntransitCargoRespDto)BeanUtil.copyProperties((Object)entryValue, IntransitCargoRespDto.class, (String[])new String[0]);
            BigDecimal num = BigDecimal.ZERO;
            Date planArriveTime = null;
            HashSet carLicenseNoList = Sets.newHashSet();
            HashSet transferNoList = Sets.newHashSet();
            for (IntransitCargoRespDto dto : entry.getValue()) {
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)dto.getNum());
                if (null != planArriveTime && null != dto.getPlanArriveTime() && planArriveTime.compareTo(dto.getPlanArriveTime()) < 0) {
                    planArriveTime = dto.getPlanArriveTime();
                } else if (null == planArriveTime) {
                    planArriveTime = dto.getPlanArriveTime();
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getCarLicenseNo())) {
                    carLicenseNoList.add(dto.getCarLicenseNo());
                }
                if (!StringUtils.isNotBlank((CharSequence)dto.getTransferOrderNo())) continue;
                transferNoList.add(dto.getTransferOrderNo());
            }
            intransitCargoRespDto.setBatch(null);
            intransitCargoRespDto.setNum(num);
            intransitCargoRespDto.setPlanArriveTime(planArriveTime);
            intransitCargoRespDto.setCarLicenseNo(StringUtils.join((Iterable)carLicenseNoList, (String)","));
            intransitCargoRespDto.setTransferOrderNo(StringUtils.join((Iterable)transferNoList, (String)","));
            resultMap.put(entry.getKey(), intransitCargoRespDto);
        }
        return resultMap;
    }

    @Override
    public RestResponse<SaleOrderCheckStockResponseVo> checkSaleItemStock(@Valid ChangeSaleOrderLogicalWarehouseParams changeSaleOrderLogicalWarehouseParams) {
        Long saleOrderId = Long.valueOf(changeSaleOrderLogicalWarehouseParams.getOrderIdList().get(0));
        List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds((List)Lists.newArrayList((Object[])new Long[]{saleOrderId})));
        Set skuCodeSet = saleOrderItemRespDtos.stream().map(SaleOrderItemRespDto::getSkuCode).collect(Collectors.toSet());
        ArrayList cargoInventoryReqDtos = Lists.newArrayList();
        for (String skuCode : skuCodeSet) {
            CargoInventoryReqDto cargoInventoryReqDto = new CargoInventoryReqDto();
            cargoInventoryReqDto.setCargoCode(skuCode);
            cargoInventoryReqDto.setWarehouseCode(changeSaleOrderLogicalWarehouseParams.getLogicalWarehouseCode());
            cargoInventoryReqDtos.add(cargoInventoryReqDto);
        }
        List itemInventoryRespDtos = (List)RestResponseHelper.extractData(this.queryInventoryZtByCargo(cargoInventoryReqDtos));
        Map<String, SaleOrderItemInventoryRespDto> inventoryRespDtoMap = itemInventoryRespDtos.stream().collect(Collectors.toMap(LogicInventoryRespDto::getItemLongCode, k1 -> k1, (v1, v2) -> {
            v1.setAvailable(v1.getAvailable().add(v1.getAvailable()));
            v1.setNum(v1.getNum().add(v1.getNum()));
            return v1;
        }));
        Map<String, SaleOrderItemRespDto> saleOrderItemMap = saleOrderItemRespDtos.stream().collect(Collectors.toMap(SaleOrderItemRespDto::getSkuCode, k1 -> k1, (v1, v2) -> {
            v1.setItemNum(v1.getItemNum().add(v2.getItemNum()));
            return v1;
        }));
        SaleOrderCheckStockResponseVo resultVo = new SaleOrderCheckStockResponseVo();
        StringBuffer failMsg = new StringBuffer();
        boolean logicStockFlag = false;
        boolean ztStockFlag = false;
        for (SaleOrderItemRespDto saleOrderItemRespDto : saleOrderItemMap.values()) {
            SaleOrderItemInventoryRespDto inventoryRespDto = inventoryRespDtoMap.get(saleOrderItemRespDto.getSkuCode());
            if (saleOrderItemRespDto.getItemNum().compareTo(inventoryRespDto.getAvailable()) <= 0) continue;
            logicStockFlag = true;
            BigDecimal totalStockNum = inventoryRespDto.getAvailable().add(inventoryRespDto.getNum());
            if (saleOrderItemRespDto.getItemNum().compareTo(totalStockNum) <= 0) continue;
            BigDecimal stockout = saleOrderItemRespDto.getItemNum().subtract(totalStockNum);
            ztStockFlag = true;
            failMsg.append("\u5546\u54c1").append(saleOrderItemRespDto.getSkuCode()).append("\uff0c").append("\u8ba2\u5355\u6240\u9700").append(saleOrderItemRespDto.getItemNum().intValue()).append("\uff0c").append("\u53ef\u7528\u5e93\u5b58").append(inventoryRespDto.getAvailable().intValue()).append("\uff0c").append("\u5728\u9014\u5e93\u5b58").append(inventoryRespDto.getNum().intValue()).append("\uff0c").append("\u7f3a\u8d27").append(stockout.intValue());
        }
        if (logicStockFlag && ztStockFlag) {
            resultVo.setStockFlag(0);
        }
        if (!logicStockFlag && !ztStockFlag) {
            resultVo.setStockFlag(1);
        }
        if (logicStockFlag && !ztStockFlag) {
            resultVo.setStockFlag(2);
        }
        resultVo.setStocFailMsg(failMsg.toString());
        return new RestResponse((Object)resultVo);
    }

    @Override
    public RestResponse<SourceDeliveryRespDto> batchSourceDelivery(List<SplitOrderBySourceInfoReqDto> sourceOrderList) {
        if (CollectionUtils.isEmpty(sourceOrderList)) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SourceDeliveryRespDto respDto = new SourceDeliveryRespDto();
        ArrayList resultVoList = Lists.newArrayList();
        Map<Long, List<SplitOrderBySourceInfoReqDto>> saleOrderMap = sourceOrderList.stream().collect(Collectors.groupingBy(SplitOrderBySourceInfoReqDto::getSaleOrderId));
        ExecutorService executorService = Executors.newWorkStealingPool(12);
        ArrayList<CompletableFuture<SourceDeliveryResultVo>> futureList = new ArrayList<CompletableFuture<SourceDeliveryResultVo>>(saleOrderMap.size());
        ServiceContext context = ServiceContext.getContext();
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        for (Long orderId : saleOrderMap.keySet()) {
            futureList.add(CompletableFuture.supplyAsync(() -> this.sourceDelivery(orderId, saleOrderMap, context, reqId), executorService));
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        futureList.forEach(r -> {
            try {
                SourceDeliveryResultVo resultVo = (SourceDeliveryResultVo)r.get();
                if (resultVo != null) {
                    resultVoList.add(resultVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u9884\u5bfb\u6e90\u53d1\u8d27\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        });
        logger.info("\u6267\u884c\u7ed3\u679c\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)resultVoList));
        respDto.setTotalNum(resultVoList.size());
        List<SourceDeliveryResultVo> failList = resultVoList.stream().filter(dto -> !Objects.equals("\u64cd\u4f5c\u6210\u529f", dto.getResultMsg())).collect(Collectors.toList());
        respDto.setFailNum(failList.size());
        respDto.setResultList(failList);
        return new RestResponse((Object)respDto);
    }

    private SourceDeliveryResultVo sourceDelivery(Long orderId, Map<Long, List<SplitOrderBySourceInfoReqDto>> saleOrderMap, ServiceContext context, String reqId) {
        List<SplitOrderBySourceInfoReqDto> splitOrderBySourceInfoReqDtos = saleOrderMap.get(orderId);
        String saleOrderNo = splitOrderBySourceInfoReqDtos.get(0).getSaleOrderNo();
        SourceDeliveryResultVo sourceDeliveryResultVo = new SourceDeliveryResultVo();
        sourceDeliveryResultVo.setSaleOrderNo(saleOrderNo);
        sourceDeliveryResultVo.setResultMsg("\u64cd\u4f5c\u6210\u529f");
        try {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
            logger.info("\u9884\u5bfb\u6e90\u53d1\u8d27:{}", (Object)orderId);
            Set logicWarehouseCodeSet = splitOrderBySourceInfoReqDtos.stream().map(SplitOrderBySourceInfoReqDto::getDeliveryLogicWarehouseCode).collect(Collectors.toSet());
            if (logicWarehouseCodeSet.size() == 1) {
                ModifyLogicalWarehouseReqDto logicalWarehouseReqDto = new ModifyLogicalWarehouseReqDto();
                SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto = splitOrderBySourceInfoReqDtos.get(0);
                logicalWarehouseReqDto.setOrderIdList((List)Lists.newArrayList((Object[])new Long[]{orderId}));
                logicalWarehouseReqDto.setSaleOrderNo(saleOrderNo);
                this.cacheService.setCache(SALE_ORDER_INTRANSIT_GROUP, saleOrderNo, (Object)splitOrderBySourceInfoReqDto.getIntransitPreemptFlag(), SALE_ORDER_INTRANSIT_TIME.intValue());
                Map<String, Boolean> saleItemInMap = this.setSaleOrderZtFlag(saleOrderNo, splitOrderBySourceInfoReqDto);
                saleItemInMap.put("sourceDeliveryFlag_" + saleOrderNo, true);
                this.setSaleItemIntranst(saleOrderNo, saleItemInMap);
                logicalWarehouseReqDto.setLogicalWarehouseId(splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseId());
                logicalWarehouseReqDto.setLogicalWarehouseCode(splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode());
                logicalWarehouseReqDto.setLogicalWarehouseName(splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseName());
                List goodsList = splitOrderBySourceInfoReqDto.getGoodsList();
                RestResponseHelper.extractData((RestResponse)this.saleOrderApi.changeLogicalWarehouse(logicalWarehouseReqDto));
                OrderOperationVO orderOperationVO = new OrderOperationVO();
                orderOperationVO.setOrderIdList(Lists.newArrayList((Object[])new String[]{orderId + ""}));
                logger.info("\u9884\u5bfb\u6e90\u53d1\u8d27\u8c03\u7528\u53d1\u8d27\u65b9\u6cd5{}", JSON.toJSON((Object)orderOperationVO));
                this.distributionSaleOrder(orderOperationVO);
            } else {
                SplitOrderReqDto reqDto = new SplitOrderReqDto();
                reqDto.setSaleOrderId(orderId);
                reqDto.setSourceDeliveryFlag(Boolean.TRUE.booleanValue());
                reqDto.setInitOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
                reqDto.setInitOmsOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                ArrayList orderList = Lists.newArrayList();
                this.cacheService.setCache(SALE_ORDER_INTRANSIT_GROUP, saleOrderNo, (Object)splitOrderBySourceInfoReqDtos.get(0).getIntransitPreemptFlag(), SALE_ORDER_INTRANSIT_TIME.intValue());
                Map<String, List<SplitOrderBySourceInfoReqDto>> warehouseGroup = splitOrderBySourceInfoReqDtos.stream().collect(Collectors.groupingBy(SplitOrderBySourceInfoReqDto::getDeliveryLogicWarehouseCode));
                HashMap<String, Boolean> saleItemInMap = new HashMap<String, Boolean>();
                for (List<SplitOrderBySourceInfoReqDto> sourceInfoReqDtos : warehouseGroup.values()) {
                    SplitChildOrderReqDto childOrderReqDto = new SplitChildOrderReqDto();
                    SplitOrderBySourceInfoReqDto bySourceInfoReqDto = sourceInfoReqDtos.get(0);
                    SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
                    logicWarehouse.setDeliveryLogicWarehouseId(bySourceInfoReqDto.getDeliveryLogicWarehouseId());
                    logicWarehouse.setDeliveryLogicWarehouseCode(bySourceInfoReqDto.getDeliveryLogicWarehouseCode());
                    logicWarehouse.setDeliveryLogicWarehouseName(bySourceInfoReqDto.getDeliveryLogicWarehouseName());
                    childOrderReqDto.setLogicWarehouse(logicWarehouse);
                    childOrderReqDto.setOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
                    List orderItemResultList = bySourceInfoReqDto.getGoodsList();
                    childOrderReqDto.setGoodsList(bySourceInfoReqDto.getGoodsList());
                    saleItemInMap.putAll(this.setSaleOrderZtFlag(saleOrderNo, bySourceInfoReqDto));
                    orderList.add(childOrderReqDto);
                }
                saleItemInMap.put("sourceDeliveryFlag_" + saleOrderNo, false);
                this.setSaleItemIntranst(saleOrderNo, saleItemInMap);
                reqDto.setOrderList((List)orderList);
                logger.info("\u9884\u5bfb\u6e90\u53d1\u8d27\u8c03\u7528\u62c6\u5355\u53d1\u8d27\u65b9\u6cd5{}", JSON.toJSON((Object)reqDto));
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.splitOrder(orderId, reqDto));
            }
        }
        catch (Exception e) {
            this.delSaleIntranst(saleOrderNo);
            sourceDeliveryResultVo.setResultMsg(e.getMessage());
            logger.error("[\u9884\u5bfb\u6e90\u53d1\u8d27]\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return sourceDeliveryResultVo;
    }

    private Map<String, Boolean> setSaleOrderZtFlag(String saleOrderNo, SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto) {
        Map<String, Boolean> saleItemInMap = splitOrderBySourceInfoReqDto.getGoodsList().stream().collect(Collectors.toMap(i -> i.getOriginalOrderGoodsId() + "_" + splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode(), result -> Objects.nonNull(result.getZtDeliveryWarehouseItemNum()) && result.getZtDeliveryWarehouseItemNum().compareTo(BigDecimal.ZERO) > 0, (k1, k2) -> k1 != false ? k1 : k2));
        return saleItemInMap;
    }

    public void delSaleIntranst(String saleOrderNo) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)saleOrderNo)) {
            return;
        }
        boolean b = this.cacheService.delCache(SALE_ORDER_INTRANSIT_GROUP, saleOrderNo);
        this.cacheService.delCache(SALE_ORDER_ITEM_INTRANSIT_GROUP, saleOrderNo);
        logger.info("\u5220\u9664\u7f13\u5b58\u6570\u636e={},{}", (Object)saleOrderNo, (Object)b);
    }

    public void setSaleItemIntranst(String saleOrderNo, Map<String, Boolean> saleItemMap) {
        this.cacheService.setCache(SALE_ORDER_ITEM_INTRANSIT_GROUP, saleOrderNo, (Object)JSONObject.toJSONString(saleItemMap), SALE_ORDER_INTRANSIT_TIME.intValue());
    }

    @Override
    public RestResponse<Object> retractSaleOrder(@Valid OrderOperationVO orderOperationVO) {
        if (CollectionUtils.isEmpty(orderOperationVO.getOrderIdList())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderIdList = orderOperationVO.getOrderIdList().stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderIds(orderIdList));
        List saleOrderNos = saleOrderRespDtos.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        saleTransferOrderReqDto.setSaleOrderNos(saleOrderNos);
        List saleTransferOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.queryByParam(saleTransferOrderReqDto));
        Map<Object, Object> saleTransferMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleTransferOrderRespDtos)) {
            saleTransferMap = saleTransferOrderRespDtos.stream().collect(Collectors.toMap(SaleTransferOrderRespDto::getSaleOrderNo, SaleTransferOrderRespDto::getTransferOrderNo));
        }
        if (orderIdList.size() == 1) {
            return this.doRetractTransfer((SaleOrderRespDto)saleOrderRespDtos.get(0), (String)saleTransferMap.get(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getSaleOrderNo()));
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            Long orderId = saleOrderRespDto.getId();
            try {
                this.doRetractTransfer(saleOrderRespDto, (String)saleTransferMap.get(saleOrderRespDto.getSaleOrderNo()));
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                logger.error("[\u6279\u91cf\u56de\u64a4\u8ba2\u5355]\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761 \n \u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap, orderIdList.size() - orderIdOfexceptionList.size(), orderIdOfexceptionList.size());
        }
        return new RestResponse();
    }

    private RestResponse<Object> doRetractTransfer(SaleOrderRespDto saleOrderRespDto, String transferNo) {
        AssertUtil.assertNotBlank(transferNo, "\u5173\u8054\u8c03\u62e8\u4fe1\u606f\u4e0d\u5b58\u5728");
        CsTransferOrderRespDto respDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(transferNo));
        RestResponseHelper.extractData(this.finishedGoodsInventoryTransferOrderService.getTransferOrderWithdraw(respDto.getId()));
        CsTransferOrderRespDto dto = new CsTransferOrderRespDto();
        dto.setId(respDto.getId());
        dto.setOrderStatus(CsTransferOrderEnum.Status.CANCELED.getCode());
        RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.modifyTransferOrder(dto));
        RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLockAndSystem(saleOrderRespDto.getSaleOrderNo()));
        SaleTransferOrderReqDto reqDto = new SaleTransferOrderReqDto();
        reqDto.setTransferOrderNo(respDto.getTransferOrderNo());
        RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.removeSaleTransferOrderByParam(reqDto));
        this.saleTransferExtApi.delByOrderId(saleOrderRespDto.getId());
        return new RestResponse();
    }
}

