/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AuditFinishedGoodsInventoryOrderParams;
import com.dtyunxi.cis.pms.biz.model.BelongBussinessTypeBody;
import com.dtyunxi.cis.pms.biz.model.BussinessOrderTypeBody;
import com.dtyunxi.cis.pms.biz.model.BussinessTypeVO;
import com.dtyunxi.cis.pms.biz.model.CloseFinishedGoodsInventoryOrderParams;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsGroupItemVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsGroupVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetFinishedGoodsInventoryGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetFinishedGoodsInventoryGoodsListParams;
import com.dtyunxi.cis.pms.biz.model.GetGoodsListByWarehouse;
import com.dtyunxi.cis.pms.biz.model.GetInventoryGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GoodsBatchNoVO;
import com.dtyunxi.cis.pms.biz.model.PutStatusBody;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryService;
import com.dtyunxi.cis.pms.biz.service.impl.DispatchEasInventoryAllotImpl;
import com.dtyunxi.cis.pms.biz.service.impl.ExternalE3ParamsBuild;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.ICsOtherStorageOrderQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalE3Api;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSOtherAddReqDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsPhysicsInventoryBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsBatchAdjustmentOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsBatchAdjustmentOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderDetailQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderDetailQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsBusinessTypeApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IItemBlackDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBusinessTypeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTakeStockOrderItemQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryBalanceQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryOtherBatchDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsPhysicsInventoryBalanceQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBatchAdjustmentOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderDetailInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsTakeStockOrderResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderAuditResultEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.WarehouseCorrespondingSystemEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IShareGoodsOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IShareGoodsOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailBatchRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistPageReqDto;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RefreshScope
@Service
public class FinishedGoodsInventoryServiceServiceImpl
implements FinishedGoodsInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(FinishedGoodsInventoryServiceServiceImpl.class);
    @Value(value="${ifAllotToEas:true}")
    private boolean ifAllotToEas;
    @Resource
    private ICsInPlannedOrderApi csInPlannedOrderApi;
    @Resource
    private ICsInPlannedOrderDetailQueryApi csInPlannedOrderDetailQueryApi;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;
    @Resource
    private ICsBusinessTypeApi csBusinessTypeApi;
    @Resource
    private ICsBusinessTypeApi csBusinessTypeQueryApi;
    @Resource
    private ICsOtherStorageOrderDetailApi csOtherStorageOrderDetailQueryApi;
    @Resource
    private ICsOtherStorageOrderQueryApi csOtherStorageOrderQueryApi;
    @Resource
    private ICsLogicInventoryBalanceQueryApi csLogicInventoryBalanceQueryApi;
    @Resource
    private ICsPhysicsInventoryBalanceQueryApi csPhysicsInventoryBalanceQueryApi;
    @Resource
    private ICsBatchAdjustmentOrderApi csBatchAdjustmentOrderApi;
    @Resource
    private ICsBatchAdjustmentOrderDetailApi csBatchAdjustmentOrderDetailQueryApi;
    @Resource
    private ICsOutPlannedOrderApi csOutPlannedOrderApi;
    @Resource
    private ICsOutPlannedOrderDetailQueryApi csOutPlannedOrderDetailQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private DispatchEasInventoryAllotImpl dispatchEasInventoryAllot;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private IShareGoodsOrderApi iCsShareGoodsOrderApi;
    @Resource
    private IShareGoodsOrderDetailApi iCsShareGoodsOrderDetailQueryApi;
    @Resource
    private IVirtualInventoryApi iVirtualInventoryQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private IExternalE3Api externalE3Api;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private ExternalE3ParamsBuild externalE3ParamsBuild;
    @Resource
    private ICsOutResultOrderQueryApi iCsOutResultOrderQueryApi;
    @Resource
    private IItemBlackDetailApi itemBlackDetailApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedApi;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailApi;

    @Override
    public RestResponse<Object> addBussinessOrderType(@Valid BussinessOrderTypeBody bussinessOrderTypeBody) {
        CsBusinessTypeReqDto reqDto = new CsBusinessTypeReqDto();
        BeanUtils.copyProperties((Object)bussinessOrderTypeBody, (Object)reqDto);
        reqDto.setBusinessTypeName(bussinessOrderTypeBody.getLabel());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csBusinessTypeApi.addCsBusinessType(reqDto)));
    }

    @Override
    public RestResponse<CsOutPlannedOrderResultRespDto> auditFinishedGoodsInventoryOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        if (StringUtils.isBlank((CharSequence)auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.equals(1, auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            this.checkBlackDtoList(auditFinishedGoodsInventoryOrderParams);
        }
        FinishedGoodsInventoryTypeEnum statusByCode = FinishedGoodsInventoryTypeEnum.getStatusByCode(auditFinishedGoodsInventoryOrderParams.getType());
        switch (statusByCode) {
            case ALLOT_BC_EFFICACY: 
            case ALLOT_LOSE_EFFICACY: 
            case ALLOT_OUT: 
            case INSPECTION_QUALIFIED: 
            case INSPECTION_UNQUALIFIED: 
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: 
            case INTERNAL_DEAL_BA: 
            case INTERNAL_DEAL_RETURN_BA: 
            case SALE_RETURN_INTERNAL_DEAL_BA: 
            case INTERNAL_ALLOT: 
            case INTERNAL_EXPORT_DEAL: 
            case CC_ALLOT: 
            case CB_ALLOT: 
            case BC_ALLOT: 
            case ALLOT_LOGIC_OUT: 
            case CLAIM_ALLOT: 
            case BORROW_ALLOT: 
            case ALLOT_SALE: 
            case ALLOT_SALE_BH: 
            case ALLOT_IN_ONLY: 
            case ALLOT_OUT_ONLY: 
            case MAIYOU_ALLOT_OUT: 
            case MAIYOU_BC_ALLOT: 
            case MAIYOU_BC_SAME_ORG_ALLOT: 
            case MAIYOU_CB_SAME_ORG_ALLOT: {
                this.auditAllot(auditFinishedGoodsInventoryOrderParams);
                break;
            }
            case BATCH_ADJUST: {
                this.auditBatchAdjust(auditFinishedGoodsInventoryOrderParams);
                break;
            }
            case PURCHASE: 
            case OUTSOURCE: 
            case PRODUCTION: 
            case PRODUCTION_MATERIALS_RETURN: {
                this.csInPlannedOrderAudit(auditFinishedGoodsInventoryOrderParams);
                break;
            }
            case PURCHASE_REFUND: 
            case PRODUCT_REPAIR: 
            case OUTSOURCE_REFUND: 
            case PRODUCTION_MATERIALS: {
                return this.csOutPlannedOrderAudit(auditFinishedGoodsInventoryOrderParams);
            }
            case OTHER_IN: {
                break;
            }
            case OTHER_OUT: {
                break;
            }
            case DISTRIBUTE_ORDER: {
                List<String> errorList = this.auditDistributeOrder(auditFinishedGoodsInventoryOrderParams);
                if (!CollectionUtils.isNotEmpty(errorList)) break;
                RestResponse restResponse = new RestResponse();
                restResponse.setResultCode("10001");
                restResponse.setResultMsg(String.join((CharSequence)";", errorList));
                return restResponse;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7c7b\u578b\u9519\u8bef");
            }
        }
        return new RestResponse();
    }

    private void checkBlackDtoList(AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        ArrayList typeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.CB_ALLOT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode()});
        if (typeList.contains(auditFinishedGoodsInventoryOrderParams.getType())) {
            List itemDetailList = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailApi.queryListByTransferOrderNo(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
            CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
            ItemBlacklistPageReqDto itemBlacklistPageReqDto = new ItemBlacklistPageReqDto();
            itemBlacklistPageReqDto.setPhysicsWarehouseCode(csTransferOrderRespDto.getInPhysicsWarehouseCode());
            List itemBlackDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemBlackDetailApi.queryPhysicsItemBlack(itemBlacklistPageReqDto));
            if (CollectionUtils.isEmpty((Collection)itemBlackDtoList)) {
                return;
            }
            String ruleNo = ((ItemBlacklistDto)itemBlackDtoList.get(0)).getRuleNo();
            List skuCodeList = itemBlackDtoList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getBatch())).collect(Collectors.toList());
            List skuCodes = skuCodeList.stream().map(ItemBlacklistDto::getSkuCode).collect(Collectors.toList());
            List batchDtos = Optional.ofNullable(itemBlackDtoList.stream().filter(o -> Objects.equals(0, o.getConfigureRules())).collect(Collectors.toList())).orElse(Lists.newArrayList());
            List appointBatchDtos = Optional.ofNullable(itemBlackDtoList.stream().filter(o -> Objects.equals(1, o.getConfigureRules())).collect(Collectors.toList())).orElse(Lists.newArrayList());
            Map skuCodeBatchMap = batchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
            Map appointBatchDtoMap = appointBatchDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
            ArrayList msgSkuCodeList = Lists.newArrayList();
            for (CsTransferOrderDetailRespDto logicInventoryRespDto : itemDetailList) {
                String key = String.format("%s_%s", logicInventoryRespDto.getLongCode(), logicInventoryRespDto.getBatch());
                String batchEnd = logicInventoryRespDto.getBatch().substring(logicInventoryRespDto.getBatch().length() - 1);
                String skuCodeKey = logicInventoryRespDto.getLongCode() + "_" + batchEnd;
                if (skuCodes.contains(logicInventoryRespDto.getLongCode())) {
                    msgSkuCodeList.add(logicInventoryRespDto.getLongCode());
                    continue;
                }
                if (appointBatchDtoMap.containsKey(key)) {
                    msgSkuCodeList.add(logicInventoryRespDto.getLongCode());
                    continue;
                }
                if (!skuCodeBatchMap.containsKey(skuCodeKey)) continue;
                msgSkuCodeList.add(logicInventoryRespDto.getLongCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)msgSkuCodeList)) {
                throw new BizException(String.format("\u521b\u5efa\u5931\u8d25,%s\u547d\u4e2d\u8c03\u5165\u4ed3\u9ed1\u540d\u5355\u89c4\u5219\u3010%s\u3011\u8bf7\u91cd\u65b0\u914d\u7f6e\u8c03\u62e8\u5546\u54c1", JSON.toJSONString((Object)msgSkuCodeList), ruleNo));
            }
        }
    }

    private List<String> auditDistributeOrder(AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        ArrayList<ShareGoodsOrderAuditReqDto> auditReqDtos = new ArrayList<ShareGoodsOrderAuditReqDto>();
        List<String> strings = Arrays.asList(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo().split(","));
        for (int i = 0; i < strings.size(); ++i) {
            ShareGoodsOrderAuditReqDto reqDto = new ShareGoodsOrderAuditReqDto();
            reqDto.setRemark(auditFinishedGoodsInventoryOrderParams.getAuditReason());
            if (YesNoEnum.NO.getValue().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
                reqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode());
            } else if (YesNoEnum.YES.getValue().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
                reqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
            }
            reqDto.setOrderNo(strings.get(i));
            auditReqDtos.add(reqDto);
        }
        return (List)RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderApi.batchAuditShareGoodsOrder(auditReqDtos));
    }

    private void auditAllot(AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        logger.info("\u5ba1\u6838\u8c03\u62e8\u5355\u662f\u5426\u63a8\u9001EAS\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)auditFinishedGoodsInventoryOrderParams));
        CsAuditReqDto reqDto = new CsAuditReqDto();
        reqDto.setBusinessOrderNo(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo());
        reqDto.setRemark(auditFinishedGoodsInventoryOrderParams.getAuditReason());
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(reqDto.getBusinessOrderNo()));
        AssertUtil.assertNotNull(transferOrder, "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728\uff01");
        if (YesOrNoEnum.NO.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            reqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode());
            if (Objects.equals(transferOrder.getType(), FinishedGoodsInventoryTypeEnum.MAIYOU_BC_ALLOT.getCode()) && StringUtils.isNotBlank((CharSequence)transferOrder.getSaleOrderNo()) && StringUtils.isNotBlank((CharSequence)transferOrder.getSecondTransferOrderNo())) {
                throw new com.dtyunxi.exceptions.BizException("\u4e2d\u8f6c\u8c03\u62e8\u5355" + transferOrder.getSecondTransferOrderNo() + "\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5ba1\u6838\u4e0d\u901a\u8fc7");
            }
        } else {
            reqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
        }
        if (YesOrNoEnum.YES.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult()) && this.ifAllotToEas && !CsPcpBusinessTypeEnum.cAllotList().contains(auditFinishedGoodsInventoryOrderParams.getType())) {
            if (StringUtils.isNotBlank((CharSequence)transferOrder.getSourceSystem()) && transferOrder.getSourceSystem().equals("EAS")) {
                logger.info("EAS\u53d1\u8d77\uff0c\u4e0d\u9700\u8981\u518d\u63a8\u9001EAS");
            } else if (StringUtils.equals((CharSequence)transferOrder.getInPhysicsWarehouseCode(), (CharSequence)transferOrder.getOutPhysicsWarehouseCode())) {
                this.dispatchEasInventoryAllot.create(reqDto.getBusinessOrderNo(), transferOrder);
            } else {
                logger.info("\u8de8\u7269\u7406\u4ed3\uff0c\u4e0d\u8fdb\u884cEAS\u4ea4\u4e92\uff0c\u901a\u8fc7\u8c03\u6574\u5355\u5904\u7406");
            }
        } else if (YesOrNoEnum.YES.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult()) && (auditFinishedGoodsInventoryOrderParams.getType().equals(FinishedGoodsInventoryTypeEnum.CC_ALLOT.getCode()) || auditFinishedGoodsInventoryOrderParams.getType().equals(FinishedGoodsInventoryTypeEnum.CB_ALLOT.getCode()))) {
            logger.info("cc\u3001cb\u8c03\u62e8\u5ba1\u6838\u901a\u8fc7\u9700\u8981\u8bf7\u6c42E3");
            this.requestE3OtherAddReqDto(auditFinishedGoodsInventoryOrderParams);
        }
        RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.auditTransferOrder(reqDto));
    }

    private void requestE3OtherAddReqDto(AuditFinishedGoodsInventoryOrderParams params) {
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(params.getBussinessOrderNo()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        List transferOrderItems = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryListByTransferOrderNo(transferOrder.getTransferOrderNo()));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)transferOrderItems), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355\u660e\u7ec6");
        CsLogicWarehouseRespDto warehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(transferOrder.getOutLogicWarehouseCode()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)warehouse), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u4ed3\u5e93");
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)(!CsWarehouseTypeEnum.TCBJ_C.getCode().equals(warehouse.getWarehouseType()) ? 1 : 0)), "\u5355\u636e\u7c7b\u578b\u5f02\u5e38\uff0c\u8c03\u62e8\u51fa\u4ed3\u975eC\u4ed3");
        AssertUtil.isFalse(StringUtils.isBlank((CharSequence)warehouse.getWarehouseCorrespondingSystem()), "\u8c03\u62e8\u51fa\u5e93\u4ed3\u5e93\u672a\u6807\u8bc6\u5bf9\u5e94E3\u7cfb\u7edf");
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)WarehouseCorrespondingSystemEnum.getByCode((String)warehouse.getWarehouseCorrespondingSystem())), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684E3\u7cfb\u7edf\u6807\u8bc6");
        WarehouseCorrespondingSystemEnum systemEnum = WarehouseCorrespondingSystemEnum.getByCode((String)warehouse.getWarehouseCorrespondingSystem());
        E3BSOtherAddReqDto e3BSOtherAddReqDto = new E3BSOtherAddReqDto();
        e3BSOtherAddReqDto.setDjbh(transferOrder.getTransferOrderNo());
        e3BSOtherAddReqDto.setLxdj(transferOrder.getTransferOrderNo());
        e3BSOtherAddReqDto.setCkdm(transferOrder.getOutLogicWarehouseCode());
        e3BSOtherAddReqDto.setGhsdm(warehouse.getCargoEscheatageId());
        e3BSOtherAddReqDto.setZdr(transferOrder.getCreatePerson());
        e3BSOtherAddReqDto.setZdrq(DateUtil.format((Date)transferOrder.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        e3BSOtherAddReqDto.setBz(transferOrder.getRemark());
        e3BSOtherAddReqDto.setDetail(this.externalE3ParamsBuild.buildDetailList2(transferOrderItems, systemEnum));
        switch (systemEnum) {
            case E3_BS: {
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.bsOtherOutAdd(e3BSOtherAddReqDto, transferOrder.getTransferOrderNo()));
                break;
            }
            case E3_MY: {
                String myCkdm = transferOrder.getOutLogicWarehouseCode().substring(transferOrder.getOutLogicWarehouseCode().lastIndexOf(".") + 1);
                e3BSOtherAddReqDto.setCkdm(myCkdm);
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.myOtherOutAdd(e3BSOtherAddReqDto, transferOrder.getTransferOrderNo()));
                break;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException("-1", "\u975eE3\u7cfb\u7edf\u6807\u8bc6");
            }
        }
    }

    private RestResponse<CsOutPlannedOrderResultRespDto> csOutPlannedOrderAudit(AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        CsOutPlannedOrderAuditReqDto adjustReqDto = new CsOutPlannedOrderAuditReqDto();
        adjustReqDto.setOrderNo(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo());
        adjustReqDto.setRemark(auditFinishedGoodsInventoryOrderParams.getAuditReason());
        if (YesOrNoEnum.NO.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            adjustReqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode());
        } else if (YesOrNoEnum.YES.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            adjustReqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.auditRetreatOrder(adjustReqDto)));
    }

    private void auditBatchAdjust(AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        CsBatchAdjustmentOrderAuditReqDto adjustReqDto = new CsBatchAdjustmentOrderAuditReqDto();
        adjustReqDto.setOrderNo(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo());
        adjustReqDto.setRemark(auditFinishedGoodsInventoryOrderParams.getAuditReason());
        if (YesOrNoEnum.NO.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            adjustReqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode());
        } else if (YesOrNoEnum.YES.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            adjustReqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
        }
        RestResponseHelper.extractData((RestResponse)this.csBatchAdjustmentOrderApi.auditBatchAdjustmentOrder(adjustReqDto));
    }

    private void csInPlannedOrderAudit(AuditFinishedGoodsInventoryOrderParams auditFinishedGoodsInventoryOrderParams) {
        CsInPlannedOrderAuditReqDto reqDto = new CsInPlannedOrderAuditReqDto();
        BeanUtils.copyProperties((Object)auditFinishedGoodsInventoryOrderParams, (Object)reqDto);
        reqDto.setOrderNo(auditFinishedGoodsInventoryOrderParams.getBussinessOrderNo());
        if (YesOrNoEnum.NO.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            reqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode());
        } else if (YesOrNoEnum.YES.getCode().equals(auditFinishedGoodsInventoryOrderParams.getAuditResult())) {
            reqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
        }
        reqDto.setRemark(auditFinishedGoodsInventoryOrderParams.getAuditReason());
        RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.auditPlannedOrder(reqDto));
    }

    @Override
    public RestResponse<Object> changeBussinessOrderTypeStauts(String id, @Valid PutStatusBody putStatusBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new com.dtyunxi.exceptions.BizException("\u4e1a\u52a1\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsBusinessTypeReqDto reqDto = new CsBusinessTypeReqDto();
        reqDto.setId(Long.valueOf(id));
        BeanUtils.copyProperties((Object)putStatusBody, (Object)reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csBusinessTypeApi.modifyCsBusinessTypeStatus(reqDto)));
    }

    @Override
    public RestResponse<Object> deleteBussinessOrderType(String id, @Valid BelongBussinessTypeBody belongBussinessTypeBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new com.dtyunxi.exceptions.BizException("\u4e1a\u52a1\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csBusinessTypeApi.removeCsBusinessType(id)));
    }

    @Override
    public RestResponse<Object> closeFinishedGoodsInventoryOrder(@ApiParam(value="") @Valid @RequestBody(required=false) CloseFinishedGoodsInventoryOrderParams closeFinishedGoodsInventoryOrderParams) {
        if (StringUtils.isBlank((CharSequence)closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FinishedGoodsInventoryTypeEnum statusByCode = FinishedGoodsInventoryTypeEnum.getStatusByCode(closeFinishedGoodsInventoryOrderParams.getType());
        switch (statusByCode) {
            case ALLOT_BC_EFFICACY: 
            case ALLOT_LOSE_EFFICACY: 
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: {
                RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.closeTransferOrder(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case BATCH_ADJUST: {
                RestResponseHelper.extractData((RestResponse)this.csBatchAdjustmentOrderApi.cancelByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case PURCHASE: {
                RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.cancelByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case OUTSOURCE: {
                RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.cancelByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case PRODUCTION: {
                RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.cancelByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case PURCHASE_REFUND: {
                RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.cancelByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case OUTSOURCE_REFUND: {
                RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.cancelByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case OTHER_IN: {
                break;
            }
            case OTHER_OUT: {
                break;
            }
            case DISTRIBUTE_ORDER: {
                RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderApi.cancelShareGoodsOrder(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7c7b\u578b\u9519\u8bef");
            }
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<BussinessTypeVO>> getBussinessOrderTypeList(@Valid BelongBussinessTypeBody belongBussinessTypeBody) {
        CsBusinessTypeReqDto reqDto = new CsBusinessTypeReqDto();
        reqDto.setType(belongBussinessTypeBody.getType());
        reqDto.setStatus(Integer.valueOf(0));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), belongBussinessTypeBody.getPageNum(), belongBussinessTypeBody.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BussinessTypeVO vo = new BussinessTypeVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setLabel(o.getBusinessTypeName());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsInventoryGoodsVO>> getFinishedGoodsInventoryGoodsList(@ApiParam(value="") @Valid @RequestBody(required=false) GetFinishedGoodsInventoryGoodsListParams getFinishedGoodsInventoryGoodsListParams) {
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsGroupVO>> getFinishedGoodsInventoryGoodsListGroupByBatch(@ApiParam(value="") @Valid @RequestBody(required=false) GetFinishedGoodsInventoryGoodsListParams getFinishedGoodsInventoryGoodsListParams) {
        if (StringUtils.isBlank((CharSequence)getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageInfo pageInfo = new PageInfo();
        if (FinishedGoodsInventoryTypeEnum.ALLOT_BC_EFFICACY.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.ALLOT_LOSE_EFFICACY.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.INTERNAL_DEAL_RETURN.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.ALLOT_OUT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.INTERNAL_DEAL.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.INTERNAL_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.INSPECTION_QUALIFIED.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.INSPECTION_UNQUALIFIED.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.ALLOT_SALE_BH.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.ALLOT_SALE.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.ALLOT_LOGIC_OUT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.CLAIM_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.BORROW_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.IN_TRANSIT_TRANSFER.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.BC_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.CB_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.ALLOT_OUT_ONLY.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.CC_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.MAIYOU_ALLOT_OUT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.MAIYOU_CB_SAME_ORG_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType()) || FinishedGoodsInventoryTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(getFinishedGoodsInventoryGoodsListParams.getType())) {
            PageInfo csTransferOrderDetailResponseDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryDetailListByTransferOrderNo(getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo(), getFinishedGoodsInventoryGoodsListParams.getPageNum(), getFinishedGoodsInventoryGoodsListParams.getPageSize()));
            if (CollectionUtils.isNotEmpty((Collection)csTransferOrderDetailResponseDtoPageInfo.getList())) {
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csTransferOrderDetailResponseDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List list = csTransferOrderDetailResponseDtoPageInfo.getList().stream().map(o -> {
                    String key;
                    FinishedGoodsGroupVO vo = new FinishedGoodsGroupVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    Long cargoId = o.getCargoId();
                    vo.setGoodsId(ParamConverter.convertToString((Object)cargoId));
                    vo.setGoodsLongCode(o.getLongCode());
                    vo.setGoodsName(o.getCargoName());
                    vo.setPlanQuantity(o.getQuantity() != null ? Integer.parseInt(o.getQuantity().setScale(0, 1).toString()) : 0);
                    if (o.getDoneDeliveryQuantity() != null) {
                        vo.setOutQuantity(ParamConverter.convertToString((Object)o.getDoneDeliveryQuantity().setScale(0, 1)));
                    }
                    if (o.getDoneReceiveQuantity() != null) {
                        vo.setInQuantity(ParamConverter.convertToString((Object)o.getDoneReceiveQuantity().setScale(0, 1)));
                    }
                    if (StringUtils.isNotBlank((CharSequence)o.getAvailableInventory())) {
                        BigDecimal availableInventory = ParamConverter.convertToBigDecimal((Object)o.getAvailableInventory()).setScale(0, 1);
                        vo.setAvailableInventory(availableInventory);
                    }
                    vo.setGoodsSpec(o.getSpecification());
                    List csOutResultOrderDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iCsOutResultOrderQueryApi.queryDetailByRelevanceNo(o.getTransferOrderNo()));
                    HashMap filterRepeatMap = Maps.newHashMap();
                    for (CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto : csOutResultOrderDetailRespDtoList) {
                        key = String.format("%s_%s", csOutResultOrderDetailRespDto.getLongCode(), csOutResultOrderDetailRespDto.getBatch());
                        CsOutResultOrderDetailRespDto dto = (CsOutResultOrderDetailRespDto)filterRepeatMap.get(key);
                        if (null == dto) {
                            filterRepeatMap.put(key, csOutResultOrderDetailRespDto);
                            continue;
                        }
                        dto.setWeight(BigDecimalUtils.add((BigDecimal)dto.getWeight(), (BigDecimal)csOutResultOrderDetailRespDto.getWeight()));
                        dto.setVolume(BigDecimalUtils.add((BigDecimal)dto.getVolume(), (BigDecimal)csOutResultOrderDetailRespDto.getVolume()));
                    }
                    ArrayList resultOrderDetailList = Lists.newArrayList(filterRepeatMap.values());
                    Map collect = resultOrderDetailList.stream().collect(Collectors.toMap(r -> r.getLongCode() + r.getRelevanceNo(), Function.identity(), (k1, k3) -> k1));
                    if (collect.containsKey(key = o.getLongCode() + o.getTransferOrderNo())) {
                        vo.setWmsVolume(((CsOutResultOrderDetailRespDto)collect.get(key)).getVolume());
                        vo.setWmsWeight(((CsOutResultOrderDetailRespDto)collect.get(key)).getWeight());
                    }
                    vo.setVolume(o.getVolume());
                    vo.setWeight(o.getWeight());
                    vo.setEffectiveTime(null != o.getProduceTime() ? DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : o.getProductDate());
                    vo.setInvalidTime(null != o.getExpireTime() ? DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : o.getDueDate());
                    ArrayList<FinishedGoodsGroupItemVO> batchList = new ArrayList<FinishedGoodsGroupItemVO>();
                    Map collectBatch = resultOrderDetailList.stream().collect(Collectors.toMap(r -> r.getLongCode() + r.getBatch() + r.getRelevanceNo() + r.getDocumentNo(), Function.identity()));
                    if (CollectionUtils.isNotEmpty((Collection)o.getBatchList())) {
                        o.getBatchList().forEach(i -> {
                            String keyBatch = o.getLongCode() + i.getBatch() + o.getTransferOrderNo() + i.getInResultNo();
                            FinishedGoodsGroupItemVO batchVo = new FinishedGoodsGroupItemVO();
                            if (StringUtils.isNotBlank((CharSequence)i.getInResultNo()) && i.getInResultNo().equals("-")) {
                                keyBatch = o.getLongCode() + i.getBatch() + o.getTransferOrderNo() + i.getOutResultNo();
                            }
                            if (collectBatch.containsKey(keyBatch)) {
                                batchVo.setWmsVolume(String.valueOf(((CsOutResultOrderDetailRespDto)collectBatch.get(keyBatch)).getVolume()));
                                batchVo.setWmsWeight(String.valueOf(((CsOutResultOrderDetailRespDto)collectBatch.get(keyBatch)).getWeight()));
                            }
                            if (i.getProduceTime() != null) {
                                batchVo.setProduceTime(i.getProduceTime());
                            }
                            if (i.getExpireTime() != null) {
                                batchVo.setExpireTime(i.getExpireTime());
                            }
                            batchVo.setBatchNo(i.getBatch());
                            batchVo.setOutOrderNo(i.getOutResultNo());
                            if (i.getDoneDeliveryQuantity() != null) {
                                batchVo.setOutQuantity(ParamConverter.convertToString((Object)i.getDoneDeliveryQuantity().setScale(0, 1)));
                            }
                            batchVo.setInOrderNo(i.getInResultNo());
                            if (i.getDoneReceiveQuantity() != null) {
                                batchVo.setInQuantity(ParamConverter.convertToString((Object)i.getDoneReceiveQuantity().setScale(0, 1)));
                            }
                            batchList.add(batchVo);
                        });
                    } else {
                        FinishedGoodsGroupItemVO batchVo = new FinishedGoodsGroupItemVO();
                        batchVo.setBatchNo(o.getBatch());
                        batchList.add(batchVo);
                    }
                    vo.setBatchList(batchList);
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(list);
            }
        } else {
            CsOutNoticeOrderDetailInfoQueryReqDto queryDto = new CsOutNoticeOrderDetailInfoQueryReqDto();
            BeanUtils.copyProperties((Object)getFinishedGoodsInventoryGoodsListParams, (Object)queryDto);
            queryDto.setRelevanceNo(getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo());
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.groupingPage(queryDto));
            logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u8be6\u7ec6\u4fe1\u606frespDtoPageInfo:{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List list = respDtoPageInfo.getList().stream().map(o -> {
                    FinishedGoodsGroupVO vo = new FinishedGoodsGroupVO();
                    BeanUtils.copyProperties((Object)o, (Object)vo);
                    vo.setGoodsLongCode(o.getSkuCode());
                    vo.setGoodsName(o.getSkuName());
                    vo.setGoodsSpec(o.getSpecification());
                    vo.setInQuantity(String.valueOf(Optional.ofNullable(o.getDoneQuantity()).orElse(BigDecimal.ZERO)));
                    vo.setPlanQuantity(o.getPlanQuantity() != null ? Integer.parseInt(o.getPlanQuantity().setScale(0, 1).toString()) : 0);
                    vo.setDoneQuantity(o.getDoneQuantity() != null ? Integer.parseInt(o.getDoneQuantity().setScale(0, 1).toString()) : 0);
                    vo.setWaitQuantity(o.getWaitQuantity() != null ? Integer.parseInt(o.getWaitQuantity().setScale(0, 1).toString()) : 0);
                    vo.setEffectiveTime(null != o.getProduceTime() ? o.getProduceTime() : null);
                    vo.setInvalidTime(null != o.getExpireTime() ? o.getExpireTime() : null);
                    List csOutResultOrderDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryDetailByRelevanceNo(o.getRelevanceNo()));
                    BigDecimal wmsWeight = new BigDecimal(0);
                    BigDecimal wmsVolume = new BigDecimal(0);
                    for (CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto : csOutResultOrderDetailRespDtos) {
                        if (!vo.getGoodsLongCode().equals(csOutResultOrderDetailRespDto.getLongCode())) continue;
                        wmsWeight = csOutResultOrderDetailRespDto.getWeight();
                        wmsVolume = csOutResultOrderDetailRespDto.getVolume();
                    }
                    vo.setWmsWeight(wmsWeight);
                    vo.setWmsVolume(wmsVolume);
                    List batchRespDtos = o.getDetailBatchRespDtoList();
                    if (CollectionUtils.isNotEmpty((Collection)batchRespDtos)) {
                        ArrayList<FinishedGoodsGroupItemVO> batchList = new ArrayList<FinishedGoodsGroupItemVO>();
                        for (int i = 0; i < batchRespDtos.size(); ++i) {
                            CsOutNoticeOrderDetailBatchRespDto batchRespDto = (CsOutNoticeOrderDetailBatchRespDto)batchRespDtos.get(i);
                            FinishedGoodsGroupItemVO batchVo = new FinishedGoodsGroupItemVO();
                            BeanUtils.copyProperties((Object)batchRespDto, (Object)batchVo);
                            batchVo.setBatchNo(batchRespDto.getBatch());
                            batchVo.setDoneQuantity(batchRespDto.getDoneQuantity() != null ? Integer.parseInt(batchRespDto.getDoneQuantity().setScale(0, 1).toString()) : 0);
                            batchVo.setOrderNo(batchRespDto.getInOutResultOrderNo());
                            batchVo.setWmsVolume(String.valueOf(wmsVolume));
                            batchVo.setWmsWeight(String.valueOf(wmsWeight));
                            batchList.add(batchVo);
                        }
                        vo.setBatchList(batchList);
                    }
                    return vo;
                }).collect(Collectors.toList());
                pageInfo.setList(list);
            } else {
                FinishedGoodsInventoryTypeEnum statusByCode = FinishedGoodsInventoryTypeEnum.getStatusByCode(getFinishedGoodsInventoryGoodsListParams.getType());
                switch (statusByCode) {
                    case ALLOT_BC_EFFICACY: 
                    case ALLOT_LOSE_EFFICACY: 
                    case INSPECTION_QUALIFIED: 
                    case INSPECTION_UNQUALIFIED: 
                    case INTERNAL_DEAL: 
                    case ALLOT_SALE: {
                        break;
                    }
                    case ALLOT_SALE_BH: {
                        break;
                    }
                    case ALLOT_OUT: 
                    case MAIYOU_ALLOT_OUT: {
                        break;
                    }
                    case CHECK_STOCK: {
                        break;
                    }
                    case BATCH_ADJUST: {
                        break;
                    }
                    case PURCHASE: {
                        this.getCsInPlannedOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    case OUTSOURCE: {
                        this.getCsInPlannedOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    case PRODUCTION: 
                    case PRODUCTION_MATERIALS_RETURN: {
                        this.getCsInPlannedOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    case PURCHASE_REFUND: {
                        this.getCsOutPlannedOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    case OUTSOURCE_REFUND: {
                        this.getCsOutPlannedOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    case OTHER_IN: 
                    case OTHER_OUT: {
                        this.getStorageOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    case PRODUCT_REPAIR: 
                    case PRODUCTION_MATERIALS: {
                        this.getCsOutPlannedOrderPageInfo(getFinishedGoodsInventoryGoodsListParams, (PageInfo<FinishedGoodsGroupVO>)pageInfo);
                        break;
                    }
                    default: {
                        throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7c7b\u578b\u9519\u8bef");
                    }
                }
            }
        }
        this.joinVolumeAndSpec((PageInfo<FinishedGoodsGroupVO>)pageInfo);
        return new RestResponse((Object)pageInfo);
    }

    private void joinVolumeAndSpec(PageInfo<FinishedGoodsGroupVO> pageInfo) {
        List itemLongCodes;
        List pcpItemRespDtos;
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && CollectionUtils.isNotEmpty((Collection)(pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(itemLongCodes = pageInfo.getList().stream().map(FinishedGoodsGroupVO::getGoodsLongCode).distinct().collect(Collectors.toList())))))) {
            Map<String, PcpItemRespDto> itemMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            for (FinishedGoodsGroupVO finishedGoodsGroupVO : pageInfo.getList()) {
                PcpItemRespDto pcpItemRespDto = itemMap.get(finishedGoodsGroupVO.getGoodsLongCode());
                if (null == pcpItemRespDto) continue;
                finishedGoodsGroupVO.setGoodsSpec(pcpItemRespDto.getSpecification());
                BigDecimal volume = null == pcpItemRespDto.getVolume() ? BigDecimal.ZERO : pcpItemRespDto.getVolume().multiply(BigDecimal.valueOf(finishedGoodsGroupVO.getPlanQuantity().intValue())).setScale(4, RoundingMode.DOWN);
                finishedGoodsGroupVO.setVolume(volume);
            }
        }
    }

    private void getCsTransferOrderDetailPageInfo(GetFinishedGoodsInventoryGoodsListParams getFinishedGoodsInventoryGoodsListParams, PageInfo<FinishedGoodsGroupVO> pageInfo) {
        PageInfo transferOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryByPage(getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo(), getFinishedGoodsInventoryGoodsListParams.getPageNum(), getFinishedGoodsInventoryGoodsListParams.getPageSize()));
        if (CollectionUtils.isNotEmpty((Collection)transferOrderDetailRespDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)transferOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = transferOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsGroupVO vo = new FinishedGoodsGroupVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                BeanUtils.copyProperties((Object)o, (Object)vo);
                Long cargoId = o.getCargoId();
                vo.setGoodsId(ParamConverter.convertToString((Object)cargoId));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setPlanQuantity(o.getQuantity() != null ? Integer.parseInt(o.getQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(0);
                vo.setWaitQuantity(0);
                vo.setAvailableInventory(ParamConverter.convertToBigDecimal((Object)o.getAvailableInventory()));
                vo.setGoodsSpec(o.getSpecification());
                vo.setVolume(o.getVolume());
                ArrayList<FinishedGoodsGroupItemVO> batchList = new ArrayList<FinishedGoodsGroupItemVO>(1);
                FinishedGoodsGroupItemVO batchVo = new FinishedGoodsGroupItemVO();
                batchVo.setBatchNo(o.getBatch());
                batchList.add(batchVo);
                vo.setBatchList(batchList);
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getCsInPlannedOrderPageInfo(GetFinishedGoodsInventoryGoodsListParams getFinishedGoodsInventoryGoodsListParams, PageInfo<FinishedGoodsGroupVO> pageInfo) {
        CsInPlannedOrderPageQueryDto queryDto = new CsInPlannedOrderPageQueryDto();
        BeanUtils.copyProperties((Object)getFinishedGoodsInventoryGoodsListParams, (Object)queryDto);
        queryDto.setOrderNo(getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderDetailQueryApi.queryItemDetailPageInfo(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsGroupVO vo = new FinishedGoodsGroupVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                Long cargoId = o.getCargoId();
                vo.setGoodsId(ParamConverter.convertToString((Object)cargoId));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setPlanQuantity(o.getPlanQuantity() != null ? Integer.parseInt(o.getPlanQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(o.getDoneQuantity() != null ? Integer.parseInt(o.getDoneQuantity().setScale(0, 1).toString()) : 0);
                vo.setWaitQuantity(o.getWaitQuantity() != null ? Integer.parseInt(o.getWaitQuantity().setScale(0, 1).toString()) : 0);
                vo.setItemStatus(o.getItemStatus());
                this.getItemInfo(vo, o.getBatch());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getCsOutPlannedOrderPageInfo(GetFinishedGoodsInventoryGoodsListParams getFinishedGoodsInventoryGoodsListParams, PageInfo<FinishedGoodsGroupVO> pageInfo) {
        CsOutPlannedOrderPageQueryDto queryDto = new CsOutPlannedOrderPageQueryDto();
        BeanUtils.copyProperties((Object)getFinishedGoodsInventoryGoodsListParams, (Object)queryDto);
        queryDto.setOrderNo(getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderDetailQueryApi.queryItemDetailPageInfo(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsGroupVO vo = new FinishedGoodsGroupVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                Long cargoId = o.getCargoId();
                vo.setGoodsId(ParamConverter.convertToString((Object)cargoId));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setPlanQuantity(o.getPlanQuantity() != null ? Integer.parseInt(o.getPlanQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(o.getDoneQuantity() != null ? Integer.parseInt(o.getDoneQuantity().setScale(0, 1).toString()) : 0);
                vo.setWaitQuantity(o.getWaitQuantity() != null ? Integer.parseInt(o.getWaitQuantity().setScale(0, 1).toString()) : 0);
                vo.setItemStatus(o.getItemStatus());
                this.getItemInfo(vo, o.getBatch());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getStorageOrderPageInfo(GetFinishedGoodsInventoryGoodsListParams getFinishedGoodsInventoryGoodsListParams, PageInfo<FinishedGoodsGroupVO> pageInfo) {
        PageInfo storageOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderDetailQueryApi.queryByPage(getFinishedGoodsInventoryGoodsListParams.getBussinessOrderNo(), getFinishedGoodsInventoryGoodsListParams.getPageNum(), getFinishedGoodsInventoryGoodsListParams.getPageSize()));
        if (CollectionUtils.isNotEmpty((Collection)storageOrderDetailRespDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)storageOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = storageOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsGroupVO vo = new FinishedGoodsGroupVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setGoodsSpec(o.getSpecification());
                vo.setVolume(o.getVolume());
                vo.setPlanQuantity(o.getQuantity() != null ? Integer.parseInt(o.getQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(o.getFinishQuantity() != null ? Integer.parseInt(o.getFinishQuantity().setScale(0, 1).toString()) : 0);
                if (o.getQuantity() != null && o.getFinishQuantity() != null) {
                    vo.setWaitQuantity(Integer.parseInt(o.getQuantity().subtract(o.getFinishQuantity()).setScale(0, 1).toString()));
                }
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getItemInfo(FinishedGoodsGroupVO vo, String batch) {
        ArrayList<FinishedGoodsGroupItemVO> batchList = new ArrayList<FinishedGoodsGroupItemVO>(1);
        FinishedGoodsGroupItemVO batchVo = new FinishedGoodsGroupItemVO();
        batchVo.setBatchNo(batch);
        batchList.add(batchVo);
        vo.setBatchList(batchList);
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsInventoryGoodsVO>> getFinishedGoodsInventoryGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetFinishedGoodsInventoryGoodsListPageParams getFinishedGoodsInventoryGoodsListPageParams) {
        if (StringUtils.isBlank((CharSequence)getFinishedGoodsInventoryGoodsListPageParams.getBussinessOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FinishedGoodsInventoryTypeEnum statusByCode = FinishedGoodsInventoryTypeEnum.getStatusByCode(getFinishedGoodsInventoryGoodsListPageParams.getType());
        PageInfo pageInfo = new PageInfo();
        switch (statusByCode) {
            case ALLOT_BC_EFFICACY: 
            case ALLOT_LOSE_EFFICACY: 
            case ALLOT_OUT: 
            case INSPECTION_QUALIFIED: 
            case INSPECTION_UNQUALIFIED: 
            case INTERNAL_DEAL: 
            case MAIYOU_ALLOT_OUT: {
                break;
            }
            case CHECK_STOCK: {
                this.getCheckStockPage(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case PURCHASE: {
                this.getCsInPlannedOrderPage(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case OUTSOURCE: {
                this.getCsInPlannedOrderPage(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case PRODUCTION: {
                this.getCsInPlannedOrderPage(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case PURCHASE_REFUND: {
                this.getCsOutPlannedOrderPage(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case OUTSOURCE_REFUND: {
                this.getCsOutPlannedOrderPage(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case OTHER_IN: {
                this.getStorageOrderDetail(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case OTHER_OUT: {
                this.getStorageOrderDetail(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            case DISTRIBUTE_ORDER: {
                this.getDistributeOrderGoodsList(getFinishedGoodsInventoryGoodsListPageParams, (PageInfo<FinishedGoodsInventoryGoodsVO>)pageInfo);
                break;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7c7b\u578b\u9519\u8bef");
            }
        }
        return new RestResponse((Object)pageInfo);
    }

    private void getDistributeOrderGoodsList(GetFinishedGoodsInventoryGoodsListPageParams getFinishedGoodsInventoryGoodsListPageParams, PageInfo<FinishedGoodsInventoryGoodsVO> pageInfo) {
        ShareGoodsOrderDetailReqDto shareGoodsOrderDetailReqDto = new ShareGoodsOrderDetailReqDto();
        shareGoodsOrderDetailReqDto.setOrderNo(getFinishedGoodsInventoryGoodsListPageParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderDetailQueryApi.queryByPage(JSON.toJSONString((Object)shareGoodsOrderDetailReqDto), getFinishedGoodsInventoryGoodsListPageParams.getPageNum(), getFinishedGoodsInventoryGoodsListPageParams.getPageSize()));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsLongCode(o.getSkuCode());
                vo.setGoodsName(o.getSkuName());
                if (o.getInventoryQuantity() != null) {
                    vo.setAvailableInventory(ParamConverter.convertToInteger((Object)o.getInventoryQuantity().setScale(0).toString()));
                }
                if (o.getQuantity() != null) {
                    vo.setDistributeQuantity(ParamConverter.convertToInteger((Object)o.getQuantity().setScale(0).toString()));
                }
                vo.setGoodsId(String.valueOf(o.getId()));
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getCsOutPlannedOrderPage(GetFinishedGoodsInventoryGoodsListPageParams getFinishedGoodsInventoryGoodsListPageParams, PageInfo<FinishedGoodsInventoryGoodsVO> pageInfo) {
        CsOutPlannedOrderPageQueryDto queryDto = new CsOutPlannedOrderPageQueryDto();
        BeanUtils.copyProperties((Object)getFinishedGoodsInventoryGoodsListPageParams, (Object)queryDto);
        queryDto.setOrderNo(getFinishedGoodsInventoryGoodsListPageParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderDetailQueryApi.queryItemDetailPageInfo(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setBatchNo(o.getBatch());
                if (o.getProduceTime() != null) {
                    vo.setEffectiveTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getExpireTime() != null) {
                    vo.setInvalidTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                vo.setPlanQuantity(o.getPlanQuantity() != null ? Integer.parseInt(o.getPlanQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(o.getDoneQuantity() != null ? Integer.parseInt(o.getDoneQuantity().setScale(0, 1).toString()) : 0);
                vo.setWaitQuantity(o.getWaitQuantity() != null ? Integer.parseInt(o.getWaitQuantity().setScale(0, 1).toString()) : 0);
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getCheckStockPage(GetFinishedGoodsInventoryGoodsListPageParams getFinishedGoodsInventoryGoodsListPageParams, PageInfo<FinishedGoodsInventoryGoodsVO> pageInfo) {
        CsInventoryTakeStockOrderItemQueryDto stockOrderItemQueryDto = new CsInventoryTakeStockOrderItemQueryDto();
        BeanUtils.copyProperties((Object)getFinishedGoodsInventoryGoodsListPageParams, (Object)stockOrderItemQueryDto);
        stockOrderItemQueryDto.setOrderNo(getFinishedGoodsInventoryGoodsListPageParams.getBussinessOrderNo());
    }

    private void getStorageOrderDetail(GetFinishedGoodsInventoryGoodsListPageParams getFinishedGoodsInventoryGoodsListPageParams, PageInfo<FinishedGoodsInventoryGoodsVO> pageInfo) {
        PageInfo storageOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderDetailQueryApi.queryByPage(getFinishedGoodsInventoryGoodsListPageParams.getBussinessOrderNo(), getFinishedGoodsInventoryGoodsListPageParams.getPageNum(), getFinishedGoodsInventoryGoodsListPageParams.getPageSize()));
        if (CollectionUtils.isNotEmpty((Collection)storageOrderDetailRespDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)storageOrderDetailRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = storageOrderDetailRespDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setGoodsSpec(o.getSpecification());
                vo.setVolume(ParamConverter.convertToString((Object)o.getVolume()));
                vo.setPlanQuantity(o.getQuantity() != null ? Integer.parseInt(o.getQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(o.getFinishQuantity() != null ? Integer.parseInt(o.getFinishQuantity().setScale(0, 1).toString()) : 0);
                if (o.getQuantity() != null && o.getFinishQuantity() != null) {
                    vo.setWaitQuantity(Integer.parseInt(o.getQuantity().subtract(o.getFinishQuantity()).setScale(0, 1).toString()));
                }
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    private void getCsInPlannedOrderPage(GetFinishedGoodsInventoryGoodsListPageParams getFinishedGoodsInventoryGoodsListPageParams, PageInfo<FinishedGoodsInventoryGoodsVO> pageInfo) {
        CsInPlannedOrderPageQueryDto queryDto = new CsInPlannedOrderPageQueryDto();
        BeanUtils.copyProperties((Object)getFinishedGoodsInventoryGoodsListPageParams, (Object)queryDto);
        queryDto.setOrderNo(getFinishedGoodsInventoryGoodsListPageParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderDetailQueryApi.queryItemDetailPageInfo(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            CubeBeanUtils.copyProperties(pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setBatchNo(o.getBatch());
                if (o.getProduceTime() != null) {
                    vo.setEffectiveTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getExpireTime() != null) {
                    vo.setInvalidTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                vo.setPlanQuantity(o.getPlanQuantity() != null ? Integer.parseInt(o.getPlanQuantity().setScale(0, 1).toString()) : 0);
                vo.setDoneQuantity(o.getDoneQuantity() != null ? Integer.parseInt(o.getDoneQuantity().setScale(0, 1).toString()) : 0);
                vo.setWaitQuantity(o.getWaitQuantity() != null ? Integer.parseInt(o.getWaitQuantity().setScale(0, 1).toString()) : 0);
                vo.setBillGoodsStatus(o.getItemStatus());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
        }
    }

    @Override
    public RestResponse<List<GoodsBatchNoVO>> getGoodsBatchNos(@NotNull @ApiParam(value="\u5546\u54c1id", required=true) @Valid @RequestParam(value="goodsLongCode", required=true) String goodsLongCode, @NotNull @ApiParam(value="\u4ed3\u5e93\u7c7b\u578b", required=true) @Valid @RequestParam(value="warehouseType", required=true) String warehouseType, @NotNull @ApiParam(value="\u4ed3\u5e93\u7f16\u7801", required=true) @Valid @RequestParam(value="warehouseCode", required=true) String warehouseCode, @ApiParam(value="\u6279\u6b21\u53f7") @Valid @RequestParam(value="batchNo", required=false) String batchNo, @ApiParam(value="\u539f\u6279\u6b21\u53f7") @Valid @RequestParam(value="oldBatchNo", required=false) String oldBatchNo) {
        CsLogicInventoryQueryOtherBatchDto queryDto = new CsLogicInventoryQueryOtherBatchDto();
        queryDto.setLongCode(goodsLongCode);
        queryDto.setWarehouseCode(warehouseCode);
        queryDto.setExcludeBatch(oldBatchNo);
        queryDto.setFuzzyQueryBatch(batchNo);
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(2000));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryOtherByBatch(queryDto));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse();
        }
        List list = respDtoPageInfo.getList().stream().map(o -> {
            GoodsBatchNoVO goodsBatchNoVO = new GoodsBatchNoVO();
            BeanUtils.copyProperties((Object)o, (Object)goodsBatchNoVO);
            goodsBatchNoVO.setBatchNo(o.getBatch());
            goodsBatchNoVO.setBatchId(ParamConverter.convertToString((Object)o.getId()));
            if (o.getProduceTime() != null) {
                goodsBatchNoVO.setEffectiveTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (o.getExpireTime() != null) {
                goodsBatchNoVO.setInvalidTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            return goodsBatchNoVO;
        }).collect(Collectors.toList());
        return new RestResponse(list);
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsInventoryGoodsVO>> getInventoryGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryGoodsListPageParams getInventoryGoodsListPageParams) {
        CsPhysicsWarehouseDetailRespDto warehouseDetailRespDto;
        CsLogicInventoryQueryDto queryDto = new CsLogicInventoryQueryDto();
        BeanUtils.copyProperties((Object)getInventoryGoodsListPageParams, (Object)queryDto);
        queryDto.setLongCode(getInventoryGoodsListPageParams.getGoodsLongCode());
        queryDto.setCargoCode(getInventoryGoodsListPageParams.getGoodsLongCode());
        queryDto.setBatch(getInventoryGoodsListPageParams.getBatch());
        queryDto.setCargoName(getInventoryGoodsListPageParams.getGoodsName());
        queryDto.setWarehouseCode(getInventoryGoodsListPageParams.getWarehouseCode());
        queryDto.setWareHouseFilter(getInventoryGoodsListPageParams.getWareHouseFilter());
        if (StringUtils.isNotBlank((CharSequence)getInventoryGoodsListPageParams.getOwnPhysicalWarehouseId()) && ObjectUtil.isNotEmpty((Object)(warehouseDetailRespDto = (CsPhysicsWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryDetailById(Long.valueOf(getInventoryGoodsListPageParams.getOwnPhysicalWarehouseId())))))) {
            queryDto.setInWarehouseCode(warehouseDetailRespDto.getWarehouseCode());
        }
        List transferOrderGoodsLongCodes = null;
        if (StringUtils.isNotBlank((CharSequence)getInventoryGoodsListPageParams.getTransferOrderNo())) {
            List<CsTransferOrderDetailRespDto> detailRespDtos = this.getDetailTransferOrderGoodsLongCodes(getInventoryGoodsListPageParams.getTransferOrderNo());
            transferOrderGoodsLongCodes = detailRespDtos.stream().map(CsTransferOrderDetailRespDto::getLongCode).distinct().collect(Collectors.toList());
            List batchs = detailRespDtos.stream().map(CsTransferOrderDetailRespDto::getBatch).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(transferOrderGoodsLongCodes)) {
                return new RestResponse((Object)new PageInfo());
            }
            queryDto.setLongCodes(transferOrderGoodsLongCodes);
            queryDto.setBatchList(batchs);
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(queryDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        List longCodes = respDtoPageInfo.getList().stream().map(CsLogicInventoryRespDto::getLongCode).collect(Collectors.toList());
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
        Map<Object, Object> itemRespDtoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
            itemRespDtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        Map<Object, Object> finalItemRespDtoMap = itemRespDtoMap;
        List list = respDtoPageInfo.getList().stream().map(o -> {
            PcpItemRespDto pcpItemRespDto;
            FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsName(o.getCargoName());
            vo.setBatchNo(o.getBatch());
            if (o.getProduceTime() != null) {
                vo.setEffectiveTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (o.getExpireTime() != null) {
                vo.setInvalidTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = (PcpItemRespDto)finalItemRespDtoMap.get(o.getLongCode())))) {
                vo.setGoodsSpec(pcpItemRespDto.getSpecification());
                vo.setVolume(ParamConverter.convertToString((Object)pcpItemRespDto.getVolume()));
                vo.setWeight(ParamConverter.convertToString((Object)pcpItemRespDto.getQuantity()));
            }
            vo.setAvailableQuantity(o.getAvailable() != null ? Integer.parseInt(o.getAvailable().setScale(0, 1).toString()) : 0);
            vo.setAvailableInventory(o.getAvailable() != null ? Integer.parseInt(o.getAvailable().setScale(0, 1).toString()) : 0);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsInventoryGoodsVO>> getInventoryGoodsListPageByWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) GetGoodsListByWarehouse getGoodsListByWarehouse) {
        List<String> transferOrderGoodsLongCodes = null;
        if (StringUtils.isNotBlank((CharSequence)getGoodsListByWarehouse.getTransferOrderNo()) && CollectionUtils.isEmpty(transferOrderGoodsLongCodes = this.getTransferOrderGoodsLongCodes(getGoodsListByWarehouse.getTransferOrderNo()))) {
            return new RestResponse((Object)new PageInfo());
        }
        if (WarehouseTypeEnum.PHYSICS.getCode().equals(getGoodsListByWarehouse.getWarehouseType())) {
            CsPhysicsInventoryBalanceQueryDto queryDto = new CsPhysicsInventoryBalanceQueryDto();
            BeanUtils.copyProperties((Object)getGoodsListByWarehouse, (Object)queryDto);
            queryDto.setLongCode(getGoodsListByWarehouse.getGoodsLongCode());
            queryDto.setCargoName(getGoodsListByWarehouse.getGoodsName());
            queryDto.setBalanceDate(getGoodsListByWarehouse.getBookTime());
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csPhysicsInventoryBalanceQueryApi.queryByPage(queryDto));
            PageInfo pageInfo = new PageInfo();
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse((Object)pageInfo);
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setBatchNo(o.getBatch());
                if (o.getExpireTime() != null) {
                    vo.setInvalidTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getProduceTime() != null) {
                    vo.setEffectiveTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                vo.setBookQuantity(o.getBalance() != null ? Integer.parseInt(o.getBalance().setScale(0, 1).toString()) : 0);
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        if (WarehouseTypeEnum.LOGIC.getCode().equals(getGoodsListByWarehouse.getWarehouseType())) {
            CsLogicInventoryBalanceQueryDto queryDto = new CsLogicInventoryBalanceQueryDto();
            BeanUtils.copyProperties((Object)getGoodsListByWarehouse, (Object)queryDto);
            queryDto.setLongCode(getGoodsListByWarehouse.getGoodsLongCode());
            queryDto.setCargoName(getGoodsListByWarehouse.getGoodsName());
            queryDto.setBalanceDate(getGoodsListByWarehouse.getBookTime());
            if (CollectionUtils.isNotEmpty(transferOrderGoodsLongCodes)) {
                queryDto.setFilterLongCodes(transferOrderGoodsLongCodes);
            }
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryBalanceQueryApi.queryByPage(queryDto));
            PageInfo pageInfo = new PageInfo();
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse((Object)pageInfo);
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                FinishedGoodsInventoryGoodsVO vo = new FinishedGoodsInventoryGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setBatchNo(o.getBatch());
                if (o.getExpireTime() != null) {
                    vo.setInvalidTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getProduceTime() != null) {
                    vo.setEffectiveTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                vo.setBookQuantity(o.getBalance() != null ? Integer.parseInt(o.getBalance().setScale(0, 1).toString()) : 0);
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        throw new com.dtyunxi.exceptions.BizException("\u4ed3\u5e93\u7c7b\u578b\u9519\u8bef");
    }

    @Override
    public RestResponse<CsTakeStockOrderResultRespDto> submitFinishedGoodsInventoryOrder(@ApiParam(value="") @Valid @RequestBody(required=false) CloseFinishedGoodsInventoryOrderParams closeFinishedGoodsInventoryOrderParams) {
        if (StringUtils.isBlank((CharSequence)closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo())) {
            throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FinishedGoodsInventoryTypeEnum statusByCode = FinishedGoodsInventoryTypeEnum.getStatusByCode(closeFinishedGoodsInventoryOrderParams.getType());
        PageInfo pageInfo = new PageInfo();
        switch (statusByCode) {
            case ALLOT_BC_EFFICACY: 
            case ALLOT_LOSE_EFFICACY: 
            case ALLOT_OUT: 
            case INSPECTION_QUALIFIED: 
            case INSPECTION_UNQUALIFIED: 
            case INTERNAL_DEAL: 
            case MAIYOU_ALLOT_OUT: {
                break;
            }
            case BATCH_ADJUST: {
                RestResponseHelper.extractData((RestResponse)this.csBatchAdjustmentOrderApi.submitBatchAdjustmentOrder(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case PURCHASE: {
                RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.submitByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case OUTSOURCE: {
                RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.submitByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case PRODUCTION: {
                RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderApi.submitByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case PURCHASE_REFUND: {
                RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.submitByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case OUTSOURCE_REFUND: {
                RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.submitByOrderNo(closeFinishedGoodsInventoryOrderParams.getBussinessOrderNo()));
                break;
            }
            case OTHER_IN: {
                break;
            }
            case OTHER_OUT: {
                break;
            }
            default: {
                throw new com.dtyunxi.exceptions.BizException("\u5355\u636e\u7c7b\u578b\u9519\u8bef");
            }
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateBussinessOrderTypeList(String id, @Valid BussinessOrderTypeBody bussinessOrderTypeBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new com.dtyunxi.exceptions.BizException("\u4e1a\u52a1\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsBusinessTypeReqDto reqDto = new CsBusinessTypeReqDto();
        BeanUtils.copyProperties((Object)bussinessOrderTypeBody, (Object)reqDto);
        reqDto.setId(Long.valueOf(id));
        reqDto.setBusinessTypeName(bussinessOrderTypeBody.getLabel());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csBusinessTypeApi.modifyCsBusinessType(reqDto)));
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsInventoryGoodsVO>> getGoodsListByVirtualWarehose(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryGoodsListPageParams getInventoryGoodsListPageParams) {
        List<String> transferOrderGoodsLongCodes = null;
        if (StringUtils.isNotBlank((CharSequence)getInventoryGoodsListPageParams.getTransferOrderNo()) && CollectionUtils.isEmpty(transferOrderGoodsLongCodes = this.getTransferOrderGoodsLongCodes(getInventoryGoodsListPageParams.getTransferOrderNo()))) {
            return new RestResponse((Object)new PageInfo());
        }
        InventoryQueryReqDto pageQueryDto = new InventoryQueryReqDto();
        pageQueryDto.setCargoCode(getInventoryGoodsListPageParams.getGoodsCode());
        pageQueryDto.setCargoName(getInventoryGoodsListPageParams.getGoodsName());
        pageQueryDto.setWarehouseCodeEq(getInventoryGoodsListPageParams.getWarehouseCode());
        pageQueryDto.setPageNum(getInventoryGoodsListPageParams.getPageNum());
        pageQueryDto.setPageSize(getInventoryGoodsListPageParams.getPageSize());
        PageInfo virtualDtoInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iVirtualInventoryQueryApi.queryByPage(pageQueryDto));
        if (virtualDtoInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)virtualDtoInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = virtualDtoInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse((Object)pageInfo);
        }
        ArrayList virtualInventoryVOS = new ArrayList(list.size());
        list.forEach(vo -> {
            FinishedGoodsInventoryGoodsVO virtualInventoryVO = DtoExchangeUtils.createDtoBySource(vo, FinishedGoodsInventoryGoodsVO.class);
            virtualInventoryVO.setGoodsLongCode(vo.getLongCode());
            virtualInventoryVO.setGoodsCode(vo.getCargoCode());
            virtualInventoryVO.setGoodsName(vo.getCargoName());
            virtualInventoryVO.setAvailableInventory(Integer.parseInt(vo.getAvailable().setScale(0, 1).toString()));
            virtualInventoryVOS.add(virtualInventoryVO);
        });
        pageInfo.setList(virtualInventoryVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<FinishedGoodsInventoryGoodsVO>> queryItemPageParams(GetInventoryGoodsListPageParams params) {
        return this.getInventoryGoodsListPage(params);
    }

    private List<String> getTransferOrderGoodsLongCodes(String transferOrderNo) {
        try {
            logger.info("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u5546\u54c1\u957f\u7f16\u7801\u5217\u8868, transferOrderNo: {}", (Object)transferOrderNo);
            PageInfo transferOrderDetails = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailApi.queryByPage(transferOrderNo, Integer.valueOf(1), Integer.valueOf(1000)));
            if (transferOrderDetails == null || CollectionUtils.isEmpty((Collection)transferOrderDetails.getList())) {
                logger.warn("\u8c03\u62e8\u5355\u53f7: {} \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u660e\u7ec6", (Object)transferOrderNo);
                return Lists.newArrayList();
            }
            List<String> goodsLongCodes = transferOrderDetails.getList().stream().map(CsTransferOrderDetailRespDto::getLongCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            logger.info("\u8c03\u62e8\u5355\u53f7: {} \u5305\u542b\u7684\u5546\u54c1\u957f\u7f16\u7801: {}", (Object)transferOrderNo, goodsLongCodes);
            return goodsLongCodes;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u5546\u54c1\u957f\u7f16\u7801\u5931\u8d25, transferOrderNo: {}", (Object)transferOrderNo, (Object)e);
            return Lists.newArrayList();
        }
    }

    private List<CsTransferOrderDetailRespDto> getDetailTransferOrderGoodsLongCodes(String transferOrderNo) {
        try {
            logger.info("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u5546\u54c1\u957f\u7f16\u7801\u5217\u8868, transferOrderNo: {}", (Object)transferOrderNo);
            PageInfo transferOrderDetails = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailApi.queryByPage(transferOrderNo, Integer.valueOf(1), Integer.valueOf(1000)));
            if (transferOrderDetails == null || CollectionUtils.isEmpty((Collection)transferOrderDetails.getList())) {
                logger.warn("\u8c03\u62e8\u5355\u53f7: {} \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u660e\u7ec6", (Object)transferOrderNo);
                return Lists.newArrayList();
            }
            return transferOrderDetails.getList();
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u5546\u54c1\u957f\u7f16\u7801\u5931\u8d25, transferOrderNo: {}", (Object)transferOrderNo, (Object)e);
            return Lists.newArrayList();
        }
    }
}

