/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.logistic.LogisticErrorDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLogisticDocumentDto;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFinLogisticsReportApi;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportQueryListDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticsReportRespDto;
import com.dtyunxi.tcbj.api.query.IFinLogisticsReportQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logistic_report_statement")
public class LogisticsReportStatementServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    @Resource
    private IFinLogisticsReportApi finLogisticsReportApi;
    @Resource
    private IFinLogisticsReportQueryApi finLogisticsReportQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateLogisticDocumentDto.class);
        HashMap dataMap = Maps.newHashMap();
        HashSet codeSet = Sets.newHashSet();
        list.forEach(i -> {
            String code = String.format("%s", i.getOutNoticeCode());
            if (dataMap.containsKey(code)) {
                codeSet.add(code);
            } else {
                dataMap.put(code, i);
            }
        });
        ArrayList saveList = Lists.newArrayList();
        ArrayList msgList = Lists.newArrayList();
        List outNoticeCodes = list.stream().map(TemplateLogisticDocumentDto::getOutNoticeCode).collect(Collectors.toList());
        FinLogisticsReportQueryListDto finLogisticsReportQueryListDto = new FinLogisticsReportQueryListDto();
        finLogisticsReportQueryListDto.setOutNoticeCodeList((List)Lists.newArrayList(outNoticeCodes));
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByList(finLogisticsReportQueryListDto));
        Map dtoMap = respDtos.stream().collect(Collectors.toMap(FinLogisticsReportRespDto::getOutNoticeCode, Function.identity(), (k1, k3) -> k1));
        list.forEach(i -> {
            LogisticErrorDto msgDto = new LogisticErrorDto();
            BeanUtils.copyProperties((Object)i, (Object)msgDto);
            FinLogisticsReportDto saveDto = new FinLogisticsReportDto();
            if (CollectionUtil.isEmpty((Map)dtoMap) || !dtoMap.containsKey(i.getOutNoticeCode())) {
                msgDto.setMsg("\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
            } else {
                FinLogisticsReportRespDto dto = (FinLogisticsReportRespDto)dtoMap.get(i.getOutNoticeCode());
                saveDto.setId(dto.getId());
                saveDto.setOilPrice(dto.getOilPrice());
                saveDto.setDeliveryAmount(dto.getDeliveryAmount());
                saveDto.setUnloadAmount(dto.getUnloadAmount());
                saveDto.setSpecialAmount(dto.getSpecialAmount());
            }
            String code = String.format("%s", i.getOutboundCode());
            if (codeSet.contains(code)) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u6570\u636e\u91cd\u590d");
                } else {
                    msgDto.setMsg(String.format("%s%s", msgDto.getMsg(), "\u3001\u6570\u636e\u91cd\u590d"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)i.getChargeMode())) {
                if (Objects.equals("\u5b9a\u4ef7", i.getChargeMode())) {
                    if (StringUtils.isBlank((CharSequence)i.getTotalTransportAmount())) {
                        if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                            msgDto.setMsg("\u8ba1\u8d39\u7c7b\u578b\u4e3a\u5b9a\u4ef7\u65f6\uff0c\u8fd0\u8d39\u5408\u8ba1\u5fc5\u987b\u586b\u5199");
                        } else {
                            msgDto.setMsg(String.format("%s%s", msgDto.getMsg(), "\u3001\u8ba1\u8d39\u7c7b\u578b\u4e3a\u5b9a\u4ef7\u65f6\uff0c\u8fd0\u8d39\u5408\u8ba1\u5fc5\u987b\u586b\u5199"));
                        }
                    } else {
                        saveDto.setChargeMode("5");
                        saveDto.setTotalTransportAmount(new BigDecimal(i.getTotalTransportAmount()));
                    }
                } else if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u8ba1\u8d39\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u586b\u5199\u5b9a\u4ef7");
                } else {
                    msgDto.setMsg(String.format("%s%s", msgDto.getMsg(), "\u3001\u8ba1\u4ef7\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u586b\u5199\u5b9a\u4ef7"));
                }
            }
            saveDto.setOutNoticeCode(i.getOutNoticeCode());
            saveDto.setOutboundCode(i.getOutNoticeCode());
            if (StringUtils.isNotEmpty((CharSequence)i.getChargeMode())) {
                saveDto.setChargeMode(i.getChargeMode());
            }
            if (StringUtils.isNotEmpty((CharSequence)i.getDeliveryAmount())) {
                saveDto.setDeliveryAmount(new BigDecimal(i.getDeliveryAmount()));
            }
            if (StringUtils.isNotEmpty((CharSequence)i.getSpecialType())) {
                saveDto.setSpecialType(i.getSpecialType());
            }
            if (StringUtils.isNotEmpty((CharSequence)i.getSpecialAmount())) {
                saveDto.setSpecialAmount(new BigDecimal(i.getSpecialAmount()));
            }
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                msgList.add(msgDto);
            } else {
                if (!Objects.equals("5", saveDto.getChargeMode())) {
                    BigDecimal totalTransportAmount = BigDecimal.ZERO;
                    if (saveDto.getOilPrice() != null) {
                        totalTransportAmount = totalTransportAmount.add(saveDto.getOilPrice());
                    }
                    if (saveDto.getDeliveryAmount() != null) {
                        totalTransportAmount = totalTransportAmount.add(saveDto.getDeliveryAmount());
                    }
                    if (saveDto.getUnloadAmount() != null) {
                        totalTransportAmount = totalTransportAmount.add(saveDto.getUnloadAmount());
                    }
                    if (saveDto.getSpecialAmount() != null) {
                        totalTransportAmount = totalTransportAmount.add(saveDto.getSpecialAmount());
                    }
                    saveDto.setTotalTransportAmount(totalTransportAmount);
                    saveDto.setShareAmount(saveDto.getTotalTransportAmount());
                }
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.finLogisticsReportApi.importLogisticsReport(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5355\u636e\u8d39\u7528\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, LogisticErrorDto.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

