/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.helper.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.OperationalTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.OrderSrcEnum;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.ChannelWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.SubmitOtherOutBody;
import com.dtyunxi.cis.pms.biz.model.SubmitOtherOutBodyGoodsList;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryOtherHelper;
import com.dtyunxi.cis.pms.biz.service.helper.meta.InventoryOtherMetaVo;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.EsOtherStorageOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.CsOtherStorageOrderRespVo;
import com.dtyunxi.tcbj.api.query.ICostCenterQueryApi;
import com.dtyunxi.tcbj.api.query.IInventoryCheckApi;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsBusinessTypeApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBusinessTypeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderAuditResultEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryOtherHelperImpl
implements InventoryOtherHelper {
    private static final Logger log = LoggerFactory.getLogger(InventoryOtherHelperImpl.class);
    @Resource
    private ICsBusinessTypeApi csBusinessTypeQueryApi;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private IPCPCustomerQueryApi customerQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private ICostCenterQueryApi costCenterQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ILogicInventoryQueryApi logicInventoryQueryApi;
    @Resource
    private IInventoryCheckApi inventoryCheckApi;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseQueryApi;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    private final FetchDataService<PCPCustomerSearchReqDto, PCPCustomerRespDto> customerFetch = req -> (PageInfo)this.customerQueryApi.queryPCPCustomerDetailByPage(req).getData();
    private final FetchDataService<LogicWarehouseReqDto, LogicWarehouseRespDto> fetchWarehouse = req -> (PageInfo)this.logicWarehouseQueryApi.queryByPageByPost(req).getData();
    private final FetchDataService<CostCenterReqDto, CostCenterRespDto> fetchCostCenter = req -> (PageInfo)this.costCenterQueryApi.queryByPageByPost(req).getData();
    private final FetchDataService<EsOtherStorageOrderListPageParams, CsOtherStorageOrderRespVo> fetchCostCenters = req -> (PageInfo)this.inventoryEsReportQueryApi.getOtherOutList(req).getData();

    @Override
    public Map<String, CsBusinessTypeRespDto> getTypeNameMap(String type) {
        return this.getTypeRespDtoPageInfo(type).stream().collect(Collectors.toMap(CsBusinessTypeRespDto::getBusinessTypeName, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public Map<String, CsBusinessTypeRespDto> getEnableTypeNameMap(String type) {
        return this.getTypeRespDtoPageInfo(type).stream().filter(re -> YesOrNoEnum.isYes(re.getStatus()) == false).collect(Collectors.toMap(CsBusinessTypeRespDto::getBusinessTypeName, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public Map<String, CsBusinessTypeRespDto> getTypeMap(String type) {
        return this.getTypeRespDtoPageInfo(type).stream().collect(Collectors.toMap(CsBusinessTypeRespDto::getType, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public Map<Long, CsBusinessTypeRespDto> getTypeIdMap(String type) {
        return this.getTypeRespDtoPageInfo(type).stream().collect(Collectors.toMap(CsBusinessTypeRespDto::getId, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public Map<String, CostCenterRespDto> getCostCenterByCodes(Set<String> codeSet) {
        return this.loadCostCenters(codeSet).stream().collect(Collectors.toMap(CostCenterRespDto::getCostCenterCode, Function.identity(), (o, o1) -> o));
    }

    private List<CostCenterRespDto> loadCostCenters(Set<String> codeSet) {
        CostCenterReqDto costCenterReqDto = new CostCenterReqDto();
        costCenterReqDto.setCostCenterCodes(new ArrayList<String>(codeSet));
        return this.fetchCostCenter.fetchAll(costCenterReqDto);
    }

    private List<CsBusinessTypeRespDto> getTypeRespDtoPageInfo(String type) {
        CsBusinessTypeReqDto reqDto = new CsBusinessTypeReqDto();
        reqDto.setType(type);
        return Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), Integer.valueOf(1), Integer.valueOf(10000)))).getList()).orElse(Lists.newArrayList());
    }

    @Override
    public String codeGenerate(String prefix) {
        return this.codeGenerateUtil.generateNo(prefix, 4);
    }

    @Override
    public InventoryOtherMetaVo getInventoryOtherMetaVo(Set<String> whCodes, Set<String> itemCodes, Set<String> customerCodes, Set<String> costCodes, String type, Set<String> thirdOrderCodes) {
        return new InventoryOtherMetaVo().build(() -> Optional.ofNullable(customerCodes).map(code -> {
            PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
            searchReqDto.setCodeInList(new ArrayList(customerCodes));
            return this.customerFetch.fetchAll(searchReqDto).stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerCode, PCPCustomerRespDto::getCustomerName, (o, o1) -> o));
        }).orElse(new HashMap(0)), () -> Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(new ArrayList(itemCodes)))).map(itemList -> itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (o, o1) -> o))).orElse(Maps.newHashMap()), () -> {
            LogicWarehouseReqDto csLogicWarehouseParamQueryDto = new LogicWarehouseReqDto();
            csLogicWarehouseParamQueryDto.setWarehouseCodes(new ArrayList(whCodes));
            csLogicWarehouseParamQueryDto.setWarehouseStatus(ChannelWarehouseVO.WarehouseStatusEnum.ENABLE.getValue());
            return this.fetchWarehouse.fetchAll(csLogicWarehouseParamQueryDto).stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (o, o1) -> o));
        }, () -> Optional.ofNullable(costCodes).filter(CollectionUtils::isNotEmpty).map(this::getCostCenterByCodes).orElse(Maps.newHashMap()), () -> this.getEnableTypeNameMap(type), () -> Optional.ofNullable(thirdOrderCodes).filter(CollectionUtils::isNotEmpty).map(this::getTransferOrder).orElse(Maps.newHashMap()));
    }

    private Map<String, CsOtherStorageOrderRespVo> getTransferOrder(Set<String> strings) {
        EsOtherStorageOrderListPageParams Params = new EsOtherStorageOrderListPageParams();
        Params.setPreOrderNoList(new ArrayList<String>(strings));
        Map<String, CsOtherStorageOrderRespVo> collect = this.fetchCostCenters.fetchAll(Params).stream().collect(Collectors.toMap(CsOtherStorageOrderRespVo::getPreOrderNo, Function.identity(), (o, o1) -> o));
        return collect;
    }

    @Override
    public void submitSplit(SubmitOtherOutBody submitOtherOutBody, InventoryOtherHelper.SubmitEvent event) {
        this.dataPreProcessor(submitOtherOutBody, this.isCheckInventory(submitOtherOutBody, event));
        this.saveHandler(submitOtherOutBody, event);
    }

    private boolean isCheckInventory(SubmitOtherOutBody submitOtherOutBody, InventoryOtherHelper.SubmitEvent event) {
        return InventoryOtherHelper.SubmitEvent.AUDIT.equals((Object)event) && CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode().equals(submitOtherOutBody.getAuditResult());
    }

    private void saveHandler(SubmitOtherOutBody submitOtherOutBody, InventoryOtherHelper.SubmitEvent event) {
        submitOtherOutBody.setRelationBussinessOrderNo(Optional.ofNullable(submitOtherOutBody.getRelationBussinessOrderNo()).orElse(this.codeGenerate("QTOBT")));
        if (event.getCode().equals(InventoryOtherHelper.SubmitEvent.AUDIT.getCode()) && submitOtherOutBody.getAuditResult().equals(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode())) {
            this.checkChannelInventory(submitOtherOutBody);
        }
        this.buildMergeOrder(submitOtherOutBody);
        List<SubmitOtherOutBody> SubmitOtherOutBodyList = this.otherOutOrderSeparate(submitOtherOutBody);
        AtomicBoolean first = new AtomicBoolean(true);
        ArrayList errorMsgList = Lists.newArrayList();
        SubmitOtherOutBodyList.forEach(body -> {
            String errorMsg = this.doSave((SubmitOtherOutBody)body, event, body.getGoodsList(), first);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                errorMsgList.add(errorMsg);
            }
        });
        this.otherOutMergeToWms(submitOtherOutBody, SubmitOtherOutBodyList, event);
        if (CollectionUtils.isNotEmpty((Collection)errorMsgList)) {
            throw new BizException(StringUtils.join((Iterable)errorMsgList, (String)","));
        }
    }

    private void checkChannelInventory(SubmitOtherOutBody submitOtherOutBody) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u6e20\u9053\u4ed3\u5e93\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)submitOtherOutBody));
        String value = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "OTHER_OUT_OTHER_CHANNEL_CHECK").getData()).map(DictDto::getValue).orElse("0");
        if (!value.equals("1")) {
            log.info("\u63a7\u5236\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u6821\u9a8c");
            return;
        }
        List collect = submitOtherOutBody.getGoodsList().stream().map(good -> {
            InventoryCheckItem item = new InventoryCheckItem();
            item.setLongCode(good.getGoodsLongCode());
            item.setBatch(good.getBatch());
            item.setTargetInventory(new BigDecimal(good.getOutQuantity()));
            item.setLogicWarehouseCode(StringUtils.isNotBlank((CharSequence)good.getWarehouseCode()) ? good.getWarehouseCode() : submitOtherOutBody.getLogicalWarehouseCode());
            return item;
        }).collect(Collectors.toList());
        InventoryCheckReqDto reqDto = new InventoryCheckReqDto();
        reqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
        reqDto.setItems(collect);
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u6e20\u9053\u4ed3\u5e93\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        InventoryCheckRespDto inventoryCheckRespDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.batchCheckForShare(reqDto));
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u6e20\u9053\u4ed3\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        if (!inventoryCheckRespDto.isCheckResult()) {
            String msg = inventoryCheckRespDto.getItems().stream().filter(c -> !c.isCheckResult()).map(InventoryCheckItem::getCheckReason).collect(Collectors.joining(";")).replaceAll(";", "\n");
            throw new BizException("-1", "\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + msg);
        }
    }

    private void otherOutMergeToWms(SubmitOtherOutBody submitOtherOutBody, List<SubmitOtherOutBody> SubmitOtherOutBodyList, InventoryOtherHelper.SubmitEvent event) {
        log.info("\u65b0\u589e\u3001\u7f16\u8f91\u3001\u5ba1\u6838\u89e6\u53d1\u63a8\u9001\u5408\u5355\uff1a{}", (Object)JSON.toJSONString((Object)submitOtherOutBody));
        if (event.getCode().equals(InventoryOtherHelper.SubmitEvent.AUDIT.getCode()) || ObjectUtil.isNotEmpty((Object)submitOtherOutBody.getOperationalType()) && submitOtherOutBody.getOperationalType().equals(OperationalTypeEnum.SUBMIT.getCode())) {
            log.info("\u7f16\u8f91\u6216\u5ba1\u6838\u7684\u65f6\u5019\u9700\u8981\u89e6\u53d1\uff1a{}", (Object)JSON.toJSONString(SubmitOtherOutBodyList));
            List<String> mergeOrderList = SubmitOtherOutBodyList.stream().map(SubmitOtherOutBody::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList()).stream().map(SubmitOtherOutBodyGoodsList::getMergeOrder).distinct().collect(Collectors.toList());
            if (!mergeOrderList.contains(submitOtherOutBody.getMergeOrderNo())) {
                mergeOrderList.add(submitOtherOutBody.getMergeOrderNo());
            }
            mergeOrderList.forEach(order -> this.commonsMqService.sendSingleMessage("OTHER_OUT_ORDER_MERGE_TO_WMS", order));
        }
    }

    private List<SubmitOtherOutBody> otherOutOrderSeparate(SubmitOtherOutBody submitOtherOutBody) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u62c6\u5355\uff1a{}", (Object)JSON.toJSONString((Object)submitOtherOutBody));
        ArrayList<SubmitOtherOutBody> list = new ArrayList<SubmitOtherOutBody>();
        CsOtherStorageOrderRespDto csOtherStorage = null;
        if (ObjectUtil.isNotEmpty((Object)submitOtherOutBody.getId())) {
            csOtherStorage = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryById(submitOtherOutBody.getId()));
        }
        Map<String, List<SubmitOtherOutBodyGoodsList>> warehouseMaps = submitOtherOutBody.getGoodsList().stream().collect(Collectors.groupingBy(SubmitOtherOutBodyGoodsList::getWarehouseCode));
        warehouseMaps.forEach((k, v) -> {
            SubmitOtherOutBody body = new SubmitOtherOutBody();
            BeanUtils.copyProperties((Object)submitOtherOutBody, (Object)body);
            body.setLogicalWarehouseCode(null);
            body.setLogicalWarehouseName(null);
            body.setGoodsList((List<SubmitOtherOutBodyGoodsList>)v);
            list.add(body);
        });
        if (ObjectUtil.isNotEmpty((Object)submitOtherOutBody.getId())) {
            boolean ifHave = false;
            for (SubmitOtherOutBody o : list) {
                if (!o.getGoodsList().get(0).getWarehouseCode().equals(csOtherStorage.getWarehouseCode())) {
                    o.setId(null);
                    o.setBussinessOrderNo(null);
                    continue;
                }
                ifHave = true;
            }
            if (!ifHave) {
                ((SubmitOtherOutBody)list.get(0)).setId(csOtherStorage.getId());
                ((SubmitOtherOutBody)list.get(0)).setBussinessOrderNo(csOtherStorage.getStorageOrderNo());
            }
        }
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u62c6\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(list));
        return list;
    }

    private void buildMergeOrder(SubmitOtherOutBody submitOtherOutBody) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u751f\u6210\u5408\u5e76\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)submitOtherOutBody));
        List logicWarehouseCodes = submitOtherOutBody.getGoodsList().stream().map(SubmitOtherOutBodyGoodsList::getWarehouseCode).distinct().collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCodes(logicWarehouseCodes);
        List dgLogicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(logicWarehousePageReqDto));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)dgLogicWarehouseDtoList), "\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + logicWarehouseCodes);
        Map warehouseRespMap = dgLogicWarehouseDtoList.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        log.info("\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dgLogicWarehouseDtoList));
        String oldKey = "";
        String oldMergeOrder = "";
        if (ObjectUtil.isNotEmpty((Object)submitOtherOutBody.getId())) {
            CsOtherStorageOrderRespDto csOtherStorageOrderDto = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryById(submitOtherOutBody.getId()));
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)csOtherStorageOrderDto), "\u627e\u4e0d\u5230\u539f\u5355\u636e\u4fe1\u606f\uff1a" + csOtherStorageOrderDto.getStorageOrderNo());
            DgLogicWarehousePageReqDto oldLogicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
            oldLogicWarehousePageReqDto.setWarehouseCode(csOtherStorageOrderDto.getWarehouseCode());
            List oldWarehouseList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(oldLogicWarehousePageReqDto));
            DgLogicWarehouseDto oldWarehouse = (DgLogicWarehouseDto)oldWarehouseList.get(0);
            oldKey = String.format("%s%s", oldWarehouse.getPhysicsWarehouseCode(), oldWarehouse.getOrganizationCode());
            oldMergeOrder = csOtherStorageOrderDto.getMergeOrderNo();
            submitOtherOutBody.setMergeOrderNo(csOtherStorageOrderDto.getMergeOrderNo());
        }
        HashMap<String, String> mergeOrderMap = new HashMap<String, String>();
        for (SubmitOtherOutBodyGoodsList good : submitOtherOutBody.getGoodsList()) {
            DgLogicWarehouseDto warehouseRespDto = (DgLogicWarehouseDto)warehouseRespMap.get(good.getWarehouseCode());
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)warehouseRespDto), "\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + good.getWarehouseCode());
            String key = String.format("%s%s", warehouseRespDto.getPhysicsWarehouseCode(), warehouseRespDto.getOrganizationCode());
            if (StringUtils.isNotBlank((CharSequence)oldKey) && oldKey.equals(key)) {
                good.setMergeOrder(oldMergeOrder);
                continue;
            }
            if (!CsLogicWarehouseQualityEnum.QUALIFIED.getCode().equals(warehouseRespDto.getWarehouseQuality())) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)mergeOrderMap.get(good.getWarehouseCode())))) {
                    good.setMergeOrder((String)mergeOrderMap.get(good.getWarehouseCode()));
                    continue;
                }
                good.setMergeOrder(this.codeGenerateUtil.generateNo("HD", 4));
                mergeOrderMap.put(good.getWarehouseCode(), good.getMergeOrder());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)mergeOrderMap.get(key)))) {
                good.setMergeOrder((String)mergeOrderMap.get(key));
                continue;
            }
            good.setMergeOrder(this.codeGenerateUtil.generateNo("HD", 4));
            mergeOrderMap.put(key, good.getMergeOrder());
        }
    }

    private String doSave(SubmitOtherOutBody submitOtherOutBody, InventoryOtherHelper.SubmitEvent event, List<SubmitOtherOutBodyGoodsList> v, AtomicBoolean first) {
        String errorMsg = "";
        SubmitOtherOutBody outBody = (SubmitOtherOutBody)BeanUtil.copyProperties((Object)submitOtherOutBody, SubmitOtherOutBody.class, (String[])new String[0]);
        outBody.setGoodsList(v);
        CsOtherStorageOrderComboReqDto reqDto = new CsOtherStorageOrderComboReqDto();
        SubmitOtherOutBodyGoodsList submitOtherOutBodyGood = v.get(0);
        outBody.setLogicalWarehouseCode(submitOtherOutBodyGood.getWarehouseCode());
        outBody.setLogicalWarehouseName(submitOtherOutBodyGood.getWarehouseName());
        this.getOtherOut(outBody, reqDto);
        switch (event) {
            case SAVE: {
                this.submitSave(submitOtherOutBody, reqDto);
                break;
            }
            case EDIT: {
                this.submitEdit(submitOtherOutBody, reqDto, first);
                break;
            }
            case AUDIT: {
                if (reqDto.getCsOtherStorageOrderReqDto().getType().equals(CsOtherStorageOrderEnum.InOrOut.OUT.getCode())) {
                    errorMsg = this.submitAuditExt(submitOtherOutBody, reqDto, first);
                    break;
                }
                errorMsg = this.submitAudit(submitOtherOutBody, reqDto, first);
                break;
            }
        }
        return errorMsg;
    }

    private void submitEdit(SubmitOtherOutBody submitOtherOutBody, CsOtherStorageOrderComboReqDto reqDto, AtomicBoolean first) {
        if (first.get()) {
            first.set(false);
            try {
                RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.modifyCsOtherStorageOrder(reqDto));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5176\u4ed6\u51fa\u7f16\u8f91\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)reqDto));
            }
            submitOtherOutBody.setId(null);
        } else {
            try {
                reqDto.getCsOtherStorageOrderReqDto().setStorageOrderNo(null);
                reqDto.getCsOtherStorageOrderReqDto().setId(null);
                RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.addCsOtherStorageOrder(reqDto));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5176\u4ed6\u51fa\u7f16\u8f91\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)reqDto));
            }
        }
    }

    private String submitAuditExt(SubmitOtherOutBody submitOtherOutBody, CsOtherStorageOrderComboReqDto reqDto, AtomicBoolean first) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u5ba1\u6838\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.addCsOtherStorageOrder(reqDto));
        return this.doAudit(submitOtherOutBody, reqDto, id);
    }

    private String submitAudit(SubmitOtherOutBody submitOtherOutBody, CsOtherStorageOrderComboReqDto reqDto, AtomicBoolean first) {
        if (first.get()) {
            first.set(false);
            return this.doAudit(submitOtherOutBody, reqDto, submitOtherOutBody.getId());
        }
        reqDto.getCsOtherStorageOrderReqDto().setStorageOrderNo(null);
        reqDto.getCsOtherStorageOrderReqDto().setId(null);
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.addCsOtherStorageOrder(reqDto));
        return this.doAudit(submitOtherOutBody, reqDto, id);
    }

    private String doAudit(SubmitOtherOutBody submitOtherOutBody, CsOtherStorageOrderComboReqDto reqDto, Long id) {
        String errorMsg = "";
        CsOtherStorageOrderAuditReqDto audit = new CsOtherStorageOrderAuditReqDto();
        audit.setOtherStorageOrderNoId(id);
        audit.setAuditResult(submitOtherOutBody.getAuditResult());
        audit.setRemark(submitOtherOutBody.getAuditReason());
        audit.setCsOtherStorageOrderComboReqDto(reqDto);
        audit.getCsOtherStorageOrderComboReqDto().getCsOtherStorageOrderReqDto().setId(id);
        try {
            RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.auditCsOtherStorageOrder(audit));
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            e.printStackTrace();
            log.error("\u5176\u4ed6\u51fa\u5ba1\u6838\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)audit));
        }
        return errorMsg;
    }

    private void submitSave(SubmitOtherOutBody submitOtherOutBody, CsOtherStorageOrderComboReqDto reqDto) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u64cd\u4f5csubmitSave\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (OperationalTypeEnum.SAVE.getCode().equals(submitOtherOutBody.getOperationalType())) {
            try {
                RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.saveCsOtherStorageOrder(reqDto));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5176\u4ed6\u51fa\u65b0\u589e\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)reqDto));
            }
        } else {
            try {
                RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.addCsOtherStorageOrder(reqDto));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5176\u4ed6\u51fa\u65b0\u589e\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)reqDto));
            }
        }
    }

    private void dataPreProcessor(SubmitOtherOutBody submitOtherOutBody, boolean checkInventory) {
        log.info("dataPreProcessor\u5176\u4ed6\u51fa\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)submitOtherOutBody));
        submitOtherOutBody.setGoodsList(new ArrayList<SubmitOtherOutBodyGoodsList>(submitOtherOutBody.getGoodsList().stream().collect(Collectors.toMap(this::degreeKey, Function.identity(), (o, o1) -> {
            o.setOutQuantity(String.valueOf(Long.parseLong(o.getOutQuantity()) + Long.parseLong(o1.getOutQuantity())));
            return o;
        })).values()));
        log.info("dataPreProcessor\u5546\u54c1\u884c\u5904\u7406\uff1a{}", (Object)JSON.toJSONString(submitOtherOutBody.getGoodsList()));
        if (checkInventory) {
            List<CargoInventoryReqDto> req = submitOtherOutBody.getGoodsList().stream().map(cargo -> {
                CargoInventoryReqDto reqDto = new CargoInventoryReqDto();
                reqDto.setBatch(cargo.getBatch());
                reqDto.setWarehouseCode(cargo.getWarehouseCode());
                reqDto.setCargoCode(cargo.getGoodsLongCode());
                return reqDto;
            }).collect(Collectors.toList());
            Map<String, BigDecimal> inventoryCheck = this.loadInventory(req);
            boolean arr = submitOtherOutBody.getGoodsList().stream().allMatch(re -> Optional.ofNullable(inventoryCheck.get(this.degreeKey((SubmitOtherOutBodyGoodsList)re))).filter(inventory -> Long.parseLong(re.getOutQuantity()) <= inventory.longValue()).isPresent());
            AssertUtil.isTrue(arr, "\u5b58\u5728\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
    }

    @Override
    public Map<String, BigDecimal> loadInventory(List<CargoInventoryReqDto> req) {
        return ((List)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryInventoryByCargo(req))).stream().collect(Collectors.toMap(this::degreeKey, LogicInventoryRespDto::getAvailable, (o, o1) -> o1));
    }

    private String degreeKey(SubmitOtherOutBodyGoodsList v) {
        return this.degreeKey(v.getWarehouseCode(), Optional.ofNullable(v.getBatch()).orElse(""), v.getGoodsLongCode());
    }

    private String degreeKey(LogicInventoryRespDto v) {
        return this.degreeKey(v.getWarehouseCode(), Optional.ofNullable(v.getBatch()).orElse(""), v.getItemLongCode());
    }

    @Override
    public String degreeKey(String wareCode, String batch, String longCode) {
        return wareCode + "_" + Optional.ofNullable(batch).filter(StringUtils::isNotBlank).orElse("") + "_" + longCode;
    }

    @Override
    public void getOtherOut(SubmitOtherOutBody submitOtherOutBody, CsOtherStorageOrderComboReqDto reqDto) {
        CsOtherStorageOrderReqDto csOtherStorageOrderReqDto = new CsOtherStorageOrderReqDto();
        BeanUtils.copyProperties((Object)submitOtherOutBody, (Object)csOtherStorageOrderReqDto);
        csOtherStorageOrderReqDto.setStorageOrderNo(submitOtherOutBody.getBussinessOrderNo());
        csOtherStorageOrderReqDto.setOrderSrc(OrderSrcEnum.PCP.getDesc());
        csOtherStorageOrderReqDto.setType(CsPcpBusinessTypeEnum.OTHER_OUT.getCode());
        csOtherStorageOrderReqDto.setBusinessType(ParamConverter.convertToLong((Object)submitOtherOutBody.getBussinessOrderType()));
        csOtherStorageOrderReqDto.setBusinessTypeName(submitOtherOutBody.getBussinessOrderTypeName());
        csOtherStorageOrderReqDto.setWarehouseCode(submitOtherOutBody.getLogicalWarehouseCode());
        csOtherStorageOrderReqDto.setWarehouseName(submitOtherOutBody.getLogicalWarehouseName());
        csOtherStorageOrderReqDto.setOrganizationId(ParamConverter.convertToLong((Object)submitOtherOutBody.getCargoRightId()));
        csOtherStorageOrderReqDto.setOrganization(submitOtherOutBody.getCargoRightName());
        csOtherStorageOrderReqDto.setCustomerCode(submitOtherOutBody.getCustomerCode());
        csOtherStorageOrderReqDto.setCustomerName(submitOtherOutBody.getCustomerName());
        csOtherStorageOrderReqDto.setConsignee(submitOtherOutBody.getConsigneeName());
        csOtherStorageOrderReqDto.setPhone(submitOtherOutBody.getConsigneePhone());
        csOtherStorageOrderReqDto.setMessage(submitOtherOutBody.getSummary());
        csOtherStorageOrderReqDto.setExternalOrderNo(submitOtherOutBody.getExternalOrderNo());
        csOtherStorageOrderReqDto.setPreOrderNo(submitOtherOutBody.getRelationBussinessOrderNo());
        csOtherStorageOrderReqDto.setCostCenterCode(submitOtherOutBody.getCostCenterCode());
        csOtherStorageOrderReqDto.setBudgetItemId(submitOtherOutBody.getBudgetItemId());
        csOtherStorageOrderReqDto.setBudgetItemCode(submitOtherOutBody.getBudgetItemCode());
        csOtherStorageOrderReqDto.setIsSendEas(submitOtherOutBody.getIsSendEas());
        csOtherStorageOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        csOtherStorageOrderReqDto.setMergeOrderNo(submitOtherOutBody.getGoodsList().get(0).getMergeOrder());
        AddressVO address = submitOtherOutBody.getConsigneeAddress();
        if (address != null) {
            csOtherStorageOrderReqDto.setProvinceName(address.getProvince());
            csOtherStorageOrderReqDto.setProvinceCode(address.getProvinceCode());
            csOtherStorageOrderReqDto.setCityName(address.getCity());
            csOtherStorageOrderReqDto.setCityCode(address.getCityCode());
            csOtherStorageOrderReqDto.setAreaName(address.getDistrict());
            csOtherStorageOrderReqDto.setAreaCode(address.getDistrictCode());
            csOtherStorageOrderReqDto.setAddress(address.getDetailAddress());
        }
        csOtherStorageOrderReqDto.setBizDate(submitOtherOutBody.getBizDate());
        reqDto.setCsOtherStorageOrderReqDto(csOtherStorageOrderReqDto);
        List<SubmitOtherOutBodyGoodsList> goodsList = submitOtherOutBody.getGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            List list = goodsList.stream().map(o -> {
                CsOtherStorageOrderDetailReqDto dto = new CsOtherStorageOrderDetailReqDto();
                BeanUtils.copyProperties((Object)o, (Object)dto);
                dto.setLongCode(o.getGoodsLongCode());
                dto.setBatch(o.getBatch());
                dto.setCargoName(o.getGoodsName());
                dto.setSpecification(o.getGoodsSpec());
                dto.setVolume(o.getVolume() != null ? ParamConverter.convertToBigDecimal((Object)o.getVolume()) : BigDecimal.ZERO);
                dto.setWeight(o.getWeight() != null ? ParamConverter.convertToBigDecimal((Object)o.getWeight()) : BigDecimal.ZERO);
                dto.setQuantity(o.getOutQuantity() != null ? ParamConverter.convertToBigDecimal((Object)o.getOutQuantity()) : BigDecimal.ZERO);
                return dto;
            }).collect(Collectors.toList());
            reqDto.setDetailList(list);
        }
    }

    @Override
    public void otherOutOrderAddCheckChannel(CsOtherStorageOrderComboReqDto reqDto) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u65b0\u589e\u6821\u9a8c\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        String value = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "OTHER_OUT_OTHER_CHANNEL_CHECK").getData()).map(DictDto::getValue).orElse("0");
        if (value.equals("1")) {
            InventoryCheckReqDto inventoryCheckReqDto = new InventoryCheckReqDto();
            inventoryCheckReqDto.setLogicWarehouseCode(reqDto.getCsOtherStorageOrderReqDto().getWarehouseCode());
            inventoryCheckReqDto.setItems(reqDto.getDetailList().stream().map(r -> {
                InventoryCheckItem inventoryCheckItem = new InventoryCheckItem();
                inventoryCheckItem.setBatch(r.getBatch());
                inventoryCheckItem.setLongCode(r.getLongCode());
                inventoryCheckItem.setTargetInventory(r.getQuantity());
                return inventoryCheckItem;
            }).collect(Collectors.toList()));
            inventoryCheckReqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
            log.info("\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)inventoryCheckReqDto));
            InventoryCheckRespDto inventoryCheckRespDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.checkForShare(inventoryCheckReqDto));
            log.info("\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
            if (!inventoryCheckRespDto.isCheckResult()) {
                String msg = inventoryCheckRespDto.getItems().stream().filter(c -> !c.isCheckResult()).map(InventoryCheckItem::getCheckReason).collect(Collectors.joining(";")).replaceAll(";", "\n");
                throw new BizException("-1", "\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + msg);
            }
        } else {
            log.info("\u63a7\u5236\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u6821\u9a8c");
        }
    }
}

