/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cis.pms.biz.dto.request.RegenerateTasksReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.RegenerateTasksRespDto;
import com.dtyunxi.cis.pms.biz.service.IRegenerateTasksService;
import com.dtyunxi.cis.pms.dao.das.RegenerateTasksDas;
import com.dtyunxi.cis.pms.dao.eo.RegenerateTasksEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegenerateTasksServiceImpl
implements IRegenerateTasksService {
    @Resource
    private RegenerateTasksDas regenerateTasksDas;

    @Override
    public Long addRegenerateTasks(RegenerateTasksReqDto addReqDto) {
        RegenerateTasksEo regenerateTasksEo = new RegenerateTasksEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)regenerateTasksEo);
        this.regenerateTasksDas.insert((BaseEo)regenerateTasksEo);
        return regenerateTasksEo.getId();
    }

    @Override
    public void modifyRegenerateTasks(RegenerateTasksReqDto modifyReqDto) {
        RegenerateTasksEo regenerateTasksEo = new RegenerateTasksEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)regenerateTasksEo);
        this.regenerateTasksDas.updateSelective((BaseEo)regenerateTasksEo);
    }

    @Override
    public void modify(String id, String regenerateMonth, String feeModule) {
        if (!NumberUtil.isNumber((CharSequence)id)) {
            return;
        }
        RegenerateTasksEo eo = new RegenerateTasksEo();
        eo.setId(Long.valueOf(id));
        eo.setRegenerateMonth(regenerateMonth);
        eo.setFeeModule(feeModule);
        this.regenerateTasksDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRegenerateTasks(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.regenerateTasksDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public RegenerateTasksRespDto queryById(Long id) {
        RegenerateTasksEo regenerateTasksEo = (RegenerateTasksEo)this.regenerateTasksDas.selectByPrimaryKey(id);
        RegenerateTasksRespDto regenerateTasksRespDto = new RegenerateTasksRespDto();
        DtoHelper.eo2Dto((BaseEo)regenerateTasksEo, (BaseVo)regenerateTasksRespDto);
        return regenerateTasksRespDto;
    }

    @Override
    public PageInfo<RegenerateTasksRespDto> queryByPage(RegenerateTasksReqDto filter, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ExtQueryChainWrapper wrapper = this.regenerateTasksDas.filter();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)filter.getRegenerateMonth()), (Object)"regenerate_month", (Object)filter.getRegenerateMonth());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)filter.getMenuModule()), (Object)"menu_module", (Object)filter.getMenuModule());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)filter.getFeeModule()), (Object)"fee_module", (Object)filter.getFeeModule());
        wrapper.eq(Objects.nonNull(filter.getStatus()), (Object)"status", (Object)filter.getStatus());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getPhysicsWarehouseName()), (Object)"physics_warehouse_name", (Object)filter.getPhysicsWarehouseName());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getLogisticsCompanyName()), (Object)"logistics_company_name", (Object)filter.getLogisticsCompanyName());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getCarrierName()), (Object)"carrier_name", (Object)filter.getCarrierName());
        wrapper.like(StrUtil.isNotBlank((CharSequence)filter.getCreatedByName()), (Object)"create_person", (Object)filter.getCreatedByName());
        wrapper.orderByDesc((Object)"create_time");
        PageInfo eoPageInfo = new PageInfo(wrapper.list());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RegenerateTasksRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

