/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.ServiceContext;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TasksUtils {
    private static final Logger log = LoggerFactory.getLogger(TasksUtils.class);
    public static final String REGENERATE_TASKS_ID = "regenerate_tasks_id";
    public static final String REGENERATE_TASKS_INVOKE_TAG = "REGENERATE_TASKS_INVOKE_TAG";

    public static void setTasksId(Object tasksId) {
        if (Objects.isNull(tasksId)) {
            return;
        }
        MDC.put((String)REGENERATE_TASKS_ID, (String)StrUtil.toString((Object)tasksId));
    }

    public static void removeTasksId() {
        MDC.remove((String)REGENERATE_TASKS_ID);
    }

    public static String getTasksId() {
        try {
            String tasksId = MDC.get((String)REGENERATE_TASKS_ID);
            if (StrUtil.isBlank((CharSequence)tasksId)) {
                return TasksUtils.getTasksIdByContext();
            }
            return tasksId;
        }
        catch (Exception e) {
            log.error("getTasksIdError:{}", (Object)e.getMessage());
            return TasksUtils.getTasksIdByContext();
        }
    }

    public static String getTasksIdByContext() {
        try {
            return ServiceContext.getContext().getAttachment(REGENERATE_TASKS_ID);
        }
        catch (Exception e) {
            log.error("getTasksIdByContextError:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static Object[] convertArguments(Method method, String[] paramValues) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] converted = new Object[Math.min(paramValues.length, paramTypes.length)];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = TasksUtils.convertValue(paramValues[i], paramTypes[i]);
        }
        return converted;
    }

    private static Object convertValue(String value, Class<?> targetType) {
        if (value == null) {
            return null;
        }
        try {
            if (targetType == String.class) {
                return value;
            }
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return Integer.parseInt(value);
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return Long.parseLong(value);
            }
            if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                return Boolean.parseBoolean(value);
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return Double.parseDouble(value);
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (targetType == LocalDate.class) {
                return LocalDate.parse(value);
            }
            if (targetType == LocalDateTime.class) {
                return LocalDateTime.parse(value);
            }
            return Convert.convert(targetType, (Object)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("\u65e0\u6cd5\u5c06 '%s' \u8f6c\u6362\u4e3a %s \u7c7b\u578b", value, targetType.getName()));
        }
    }
}

