/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.DeriveTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.LogStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostChargingExportDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostReportImportDto;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostChargingApi;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_cost_charging_report")
public class ExpressCostChargingServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOrderService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostChargingServiceImpl.class);
    @Resource
    private IExpressCostChargingApi expressCostChargingApi;
    private static final BigDecimal EER_NUM = new BigDecimal("-1");

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ExpressCostReportQueryDto params = new ExpressCostReportQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (ExpressCostReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), ExpressCostReportQueryDto.class);
        }
        logger.info("\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)params));
        ArrayList resultList = Lists.newArrayList();
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(3000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.expressCostChargingApi.queryByPage(params));
        logger.info("\u67e5\u8be2\u7684\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        long total = pageInfo.getTotal();
        long maxpage = total / 3000L + 1L;
        while ((long)params.getPageNum().intValue() <= maxpage && ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            logger.info("\u5206\u6279\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)params));
            ArrayList list = Lists.newArrayList();
            list.addAll(pageInfo.getList().stream().map(o -> {
                ExpressCostChargingExportDto vo = new ExpressCostChargingExportDto();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (o.getUpdateTime() != null) {
                    vo.setLastUpdateTime(dateFormat.format(o.getUpdateTime()));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getUpdatePerson())) {
                    vo.setLastUpdatePerson(o.getUpdatePerson());
                }
                if (o.getAbnormal() != null) {
                    vo.setAbnormal(Optional.ofNullable(LogStatusEnum.getStatusByCode(String.valueOf(o.getAbnormal()))).orElse(String.valueOf(o.getAbnormal())));
                }
                vo.setChargeMode(Optional.ofNullable(o.getChargeMode()).filter(ObjectUtils::isNotEmpty).map(businessType -> {
                    switch (businessType) {
                        case 1: {
                            return "\u6a21\u677f1";
                        }
                        case 2: {
                            return "\u6a21\u677f2";
                        }
                        case 3: {
                            return "\u6a21\u677f3";
                        }
                        case 4: {
                            return "\u6a21\u677f4";
                        }
                        case 5: {
                            return "\u6a21\u677f5";
                        }
                        case 6: {
                            return "\u6a21\u677f6";
                        }
                        case 7: {
                            return "\u6a21\u677f7";
                        }
                        case 8: {
                            return "\u6a21\u677f8";
                        }
                        case 9: {
                            return "\u6a21\u677f9";
                        }
                    }
                    return o.getBusinessType();
                }).orElse(""));
                vo.setAdjustmentType(Optional.ofNullable(o.getAdjustmentType()).filter(StringUtils::isNotEmpty).map(businessType -> {
                    switch (businessType) {
                        case "1": {
                            return "\u589e\u52a0";
                        }
                        case "2": {
                            return "\u51cf\u5c11";
                        }
                    }
                    return o.getAdjustmentType();
                }).orElse(""));
                vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    if (ObjectUtils.isNotEmpty((Object)DeriveTypeEnum.getMsgByCode(o.getBusinessType()))) {
                        return String.valueOf(DeriveTypeEnum.getMsgByCode(o.getBusinessType()));
                    }
                    return o.getBusinessType();
                }).orElse(""));
                Optional.ofNullable(o.getIfRepeat()).ifPresent(p -> vo.setRepeatStr(p == 1 ? "\u662f" : "\u5426"));
                Optional.ofNullable(o.getMasterOrder()).ifPresent(p -> vo.setMasterOrderStr(p == 1 ? "\u662f" : "\u5426"));
                vo.setFirstPrice(this.formatValue(o.getFirstPricePer()));
                vo.setContinuedOne(this.formatValue(o.getContinuedOnePer()));
                vo.setContinuedTwo(this.formatValue(o.getContinuedTwoPer()));
                vo.setContinuedThree(this.formatValue(o.getContinuedThreePer()));
                vo.setContinuedFour(this.formatValue(o.getContinuedFourPer()));
                vo.setContinuedFreight(this.formatValue(o.getContinuedFreight()));
                vo.setTotalFreight(this.formatValue(o.getTotalFreight()));
                vo.setApportionWeight(this.formatValue(o.getApportionWeight()));
                vo.setAllocationQuantity(this.formatValue(o.getAllocationQuantity()));
                vo.setOrgTotalFreight(this.formatValue(o.getOrgTotalFreight()));
                return vo;
            }).collect(Collectors.toList()));
            resultList.addAll(list);
            logger.info("\u5206\u6279\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)list));
            if ((long)params.getPageNum().intValue() == maxpage) {
                logger.info("\u7ed3\u675f\u5206\u6279\u67e5\u8be2\uff1a{}", (Object)maxpage);
                break;
            }
            params.setPageNum(Integer.valueOf(params.getPageNum() + 1));
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.expressCostChargingApi.queryByPage(params));
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)resultList, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    private String formatValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.compareTo(EER_NUM) == 0 ? "\u5f02\u5e38" : value.stripTrailingZeros().toPlainString();
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        ExpressCostReportQueryDto params = new ExpressCostReportQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (ExpressCostReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), ExpressCostReportQueryDto.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        return Math.toIntExact(Optional.ofNullable(this.expressCostChargingApi.queryByPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    public void setMsg(ExpressCostReportImportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg(errorMsg);
        } else {
            msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), errorMsg));
        }
    }
}

