/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportSortingBillReportVO;
import com.dtyunxi.cis.pms.biz.model.SortingBillReportListPageReqDtoNew;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSortingReportSortingBillReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.SortingBillRespDto;
import com.dtyunxi.tcbj.api.query.ISortingBillQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_sorting_bill_report_place_export")
public class ExportSortingBillPlaceReportImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ExportSortingBillPlaceReportImpl.class);
    @Resource
    private ReportCenterSortingReportSortingBillReportService billReportService;
    @Resource
    private ISortingBillQueryApi billApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        SortingBillReportListPageReqDtoNew billReportListPageReqDtoNew = (SortingBillReportListPageReqDtoNew)((Object)JSON.parseObject((String)commonReqDto.getFilter(), SortingBillReportListPageReqDtoNew.class));
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                log.info("\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)re));
                RestResponse<PageInfo<SortingBillRespDto>> pageInfoRestResponse = this.billReportService.getSortingBillReportListPage((SortingBillReportListPageReqDtoNew)((Object)re));
                PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List<Object> list = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                    list = respDtoPageInfo.getList().stream().map(o -> {
                        ExportSortingBillReportVO vo = new ExportSortingBillReportVO();
                        BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                        return vo;
                    }).collect(Collectors.toList());
                    waitPlaceIdList.addAll(respDtoPageInfo.getList().stream().map(SortingBillRespDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                pageInfo.setList((List)list);
                return pageInfo;
            }, billReportListPageReqDtoNew, ExportSortingBillReportVO.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u5206\u62e3\u8d26\u5355\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    feeReportPlaceUpdateReqDto.setModuleRecordIdList(waitPlaceIdList);
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u5206\u62e3\u8d26\u5355\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    this.billApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5206\u62e3\u8d26\u5355\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u5206\u62e3\u8d26\u5355\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        SortingBillReportListPageReqDtoNew sortingBillRespDto = (SortingBillReportListPageReqDtoNew)((Object)JSON.parseObject((String)commonReqDto.getFilter(), SortingBillReportListPageReqDtoNew.class));
        sortingBillRespDto.setPageSize(1);
        sortingBillRespDto.setPageNum(1);
        RestResponse<PageInfo<SortingBillRespDto>> pageInfoRestResponse = this.billReportService.getSortingBillReportListPage(sortingBillRespDto);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode outerJsonNode = objectMapper.readTree(filter);
            JsonNode paramsNode = outerJsonNode.path("params");
            if (!paramsNode.isTextual()) {
                log.error("params \u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5b57\u7b26\u4e32");
                return;
            }
            JsonNode innerParamsNode = objectMapper.readTree(paramsNode.asText());
            String time = innerParamsNode.path("placedFlagDate").asText();
            if (time == null || time.trim().isEmpty()) {
                log.error("placedFlagDate\u5b57\u6bb5\u4e0d\u5b58\u5728");
                return;
            }
            ((ObjectNode)outerJsonNode).put("time", time);
            commonReqDto.setFilter(outerJsonNode.toString());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790JSON\u5931\u8d25", (Throwable)e);
        }
    }
}

