/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.OrderTagReportVo;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderTagExtendEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderTagStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderTagQueryApi;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_order_tag_report")
public class ExportOrderTagReportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(ExportOrderTagReportServiceImpl.class);
    @Resource
    private IOrderTagQueryApi orderTagQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u6807\u7b7e\u7ba1\u7406\u5217\u8868\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        OrderTagReqDto reqDto = new OrderTagReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            reqDto = (OrderTagReqDto)JSON.parseObject((String)commonReqDto.getFilter(), OrderTagReqDto.class);
        }
        OrderTagReqDto finalReqDto = reqDto;
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderTagQueryApi.queryByPageInfo(finalReqDto));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(dto -> {
                OrderTagReportVo vo = new OrderTagReportVo();
                BeanUtils.copyProperties((Object)dto, (Object)((Object)vo));
                vo.setCreateTimeStr(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? DateUtil.format((Date)dto.getCreateTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
                vo.setUpdateTimeStr(ObjectUtil.isNotEmpty((Object)dto.getUpdateTime()) ? DateUtil.format((Date)dto.getUpdateTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
                vo.setStatusStr(ObjectUtil.isNotEmpty((Object)dto.getTagStatus()) ? OrderTagStatusEnum.enumOf((Integer)dto.getTagStatus()).getDesc() : null);
                vo.setExtendStr(ObjectUtil.isNotEmpty((Object)dto.getExtend()) ? OrderTagExtendEnum.enumOf((Integer)dto.getExtend()).getDesc() : null);
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, reqDto, OrderTagReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u6807\u7b7e\u7ba1\u7406\u5217\u8868\u5bfc\u51fa\u603b\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        OrderTagReqDto reqDto = new OrderTagReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            reqDto = (OrderTagReqDto)JSON.parseObject((String)commonReqDto.getFilter(), OrderTagReqDto.class);
        }
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        return Math.toIntExact(Optional.ofNullable(this.orderTagQueryApi.queryByPageInfo(reqDto).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

