/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportNoVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterDailyDeliveryReportService;
import com.dtyunxi.cis.pms.biz.service.impl.ImportDailyDeliveryReportNoImpl;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_report_no_2")
public class ImportDailyDeliveryReportNo2Impl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportDailyDeliveryReportNo2Impl.class);
    @Autowired
    private ImportDailyDeliveryReportNoImpl importDailyDeliveryReportNoImpl;
    @Resource
    private ReportCenterDailyDeliveryReportService deliveryReportService;
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        return this.importDailyDeliveryReportNoImpl.verifyImportFileOperationCommon(result, commonReqDto, respDto);
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        String errorMsgUrl;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        List saveList = (List)saveObj;
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        List<Object> bookkeepingMonthList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)saveList)) {
            bookkeepingMonthList = saveList.stream().map(ImportDailyDeliveryReportNoVO::getOrderShippingTime).map(this::formatDateTime).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            log.info("\u5bfc\u5165\u62a5\u8868\u65e5\u671fbookkeepingMonthList\uff1a{}", (Object)JSON.toJSONString((Object)bookkeepingMonthList));
        }
        if (StrUtil.isNotBlank((CharSequence)(errorMsgUrl = this.importDailyDeliveryReportNoImpl.executeImportFileOperationCommon(result, commonReqDto, respDto, map)))) {
            log.info("\u5bfc\u5165\u5b58\u5728\u9519\u8bef\u4fe1\u606f");
            return errorMsgUrl;
        }
        for (String bookkeepingMonth : bookkeepingMonthList) {
            FeeGenerateReqDto feeGenerateReqDto = new FeeGenerateReqDto();
            feeGenerateReqDto.setBookkeepingMonth(bookkeepingMonth);
            feeGenerateReqDto.setFeeType(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
            feeGenerateReqDto.setMenuModule("\u5feb\u9012\u539f\u59cb\u660e\u7ec6-\u65e0\u539f\u5355\u5bfc\u5165");
            try {
                log.info("\u5f00\u59cb\u751f\u6210\u5feb\u9012\u8d39\u7528\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
                this.deliveryReportService.generateInsurance(feeGenerateReqDto);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u5feb\u9012\u8d39\u7528\u5931\u8d25", (Throwable)e);
            }
        }
        return errorMsgUrl;
    }

    public String formatDateTime(String input) {
        if (StrUtil.isBlank((CharSequence)input)) {
            return null;
        }
        return StrUtil.sub((CharSequence)StrUtil.replace((CharSequence)input, (CharSequence)"/", (CharSequence)"-"), (int)0, (int)7);
    }
}

