/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.DeliveryNoticeOrderVO;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetDeliveryNoticeOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillDeliveryNoticeOrderService;
import com.dtyunxi.cis.search.api.dto.request.GetDeliveryNoticeOrderPageParams;
import com.dtyunxi.cis.search.api.query.delivery.EsDeliveryOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryNoticeOrderQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillDeliveryNoticeOrderServiceServiceImpl
implements InventoryCenterBillDeliveryNoticeOrderService {
    @Resource
    private ICsDeliveryNoticeOrderQueryApi csDeliveryNoticeOrderQueryApi;
    @Resource
    private EsDeliveryOrderQueryApi esDeliveryOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private IDeliveryNoticeOrderQueryApi deliveryNoticeOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;

    @Override
    public RestResponse<DeliveryNoticeOrderVO> getDeliveryNoticeOrderDetail(@ApiParam(value="\u53d1\u8d27\u901a\u77e5\u5355") @Valid @RequestParam(value="deliveryNoticeNo", required=false) String deliveryNoticeNo) {
        List respDtos;
        CsDeliveryNoticeOrderRespDto respDto = (CsDeliveryNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryNoticeOrderQueryApi.queryVersionSecondByDocumentNo(deliveryNoticeNo));
        DeliveryNoticeOrderVO vo = new DeliveryNoticeOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryTakeDeliveryInformation(deliveryNoticeNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        this.getRelateBillInfo(respDto, vo);
        vo.setBusinessOrderNo(respDto.getPreOrderNo());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryLogicalWarehouseCode(respDto.getWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getDeliveryPhysicsWarehouseCode());
        vo.setDeliveryPhysicalWarehouseName(respDto.getDeliveryPhysicsWarehouseName());
        vo.setReceiveLogicalWarehouseCode(respDto.getReceiveWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getReceiveWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getReceivePhysicsWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getReceivePhysicsWarehouseName());
        vo.setSummary(StringUtils.isBlank((CharSequence)respDto.getTotalQuantity()) ? BigDecimal.ZERO : new BigDecimal(respDto.getTotalQuantity()));
        vo.setTotalSku(StringUtils.isBlank((CharSequence)respDto.getSkuNum()) ? BigDecimal.ZERO : new BigDecimal(respDto.getSkuNum()));
        vo.setTotalBoxesNum(respDto.getTotalCartons() == null ? BigDecimal.ZERO : respDto.getTotalCartons());
        vo.setMixBoxesNum(StringUtils.isBlank((CharSequence)respDto.getMergeQuantity()) ? BigDecimal.ZERO : new BigDecimal(respDto.getMergeQuantity()));
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        return new RestResponse((Object)vo);
    }

    private void getRelateBillInfo(CsDeliveryNoticeOrderRespDto respDto, DeliveryNoticeOrderVO vo) {
        List relOrderInfoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoList)) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setOrderType(o.getOrderType());
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderType(bizSaleRefundRespDto.getRefundType());
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(saleRefundAddrRespDto.getProvince() + saleRefundAddrRespDto.getCity() + saleRefundAddrRespDto.getCounty() + saleRefundAddrRespDto.getReceiveAddress());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderType(o.getOrderType());
                            relateBillInfoVO.setOrderStatus(o.getOrderStatus());
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(orderAddrRespDto.getProvince() + orderAddrRespDto.getCity() + orderAddrRespDto.getCounty() + orderAddrRespDto.getReceiveAddress());
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setOrderType(o.getOrderType());
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    relateBillInfoVO.setOrderStatus(o.getOrderStatus());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
    }

    @Override
    public RestResponse<PageInfo<DeliveryNoticeOrderVO>> getDeliveryNoticeOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetDeliveryNoticeOrderListPageParams getDeliveryNoticeOrderListPageParams) {
        if (!this.esQuery.booleanValue()) {
            PageInfo respDtoPageInfo = new PageInfo();
            PageInfo pageInfo = new PageInfo();
            DeliveryNoticeOrderReqDto reqDto = new DeliveryNoticeOrderReqDto();
            BeanUtils.copyProperties((Object)getDeliveryNoticeOrderListPageParams, (Object)reqDto);
            reqDto.setBusinessType(getDeliveryNoticeOrderListPageParams.getBusinessType());
            reqDto.setOrderNo(getDeliveryNoticeOrderListPageParams.getDocumentNo());
            reqDto.setOrderStatus(getDeliveryNoticeOrderListPageParams.getDocumentStatus());
            reqDto.setWarehouseName(getDeliveryNoticeOrderListPageParams.getDeliveryLogicalWarehouseName());
            reqDto.setReceiveWarehouseName(getDeliveryNoticeOrderListPageParams.getReceiveLogicalWarehouseName());
            if (StringUtils.isNotBlank((CharSequence)getDeliveryNoticeOrderListPageParams.getStartTime()) && StringUtils.isNotBlank((CharSequence)getDeliveryNoticeOrderListPageParams.getEndTime())) {
                reqDto.setCreateBeginTime(DateUtil.parse((String)(getDeliveryNoticeOrderListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                reqDto.setCreateEndTime(DateUtil.parse((String)(getDeliveryNoticeOrderListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            reqDto.setOrderType("delivery");
            respDtoPageInfo = (PageInfo)this.deliveryNoticeOrderQueryApi.queryByPage(reqDto).getData();
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList deliveryNoticeOrderVOS = new ArrayList(respDtoPageInfo.getList().size());
            respDtoPageInfo.getList().forEach(o -> {
                DeliveryNoticeOrderVO deliveryNoticeOrderVO = DtoExchangeUtils.createDtoBySource(o, DeliveryNoticeOrderVO.class);
                if (Objects.nonNull(o.getCreateTime())) {
                    deliveryNoticeOrderVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                deliveryNoticeOrderVO.setDocumentStatus(o.getOrderStatus());
                deliveryNoticeOrderVO.setBusinessOrderNo(o.getRelevanceNo());
                deliveryNoticeOrderVO.setExternalOrderNo(o.getExternalOrderNo());
                deliveryNoticeOrderVO.setDeliveryLogicalWarehouseCode(o.getWarehouseCode());
                deliveryNoticeOrderVO.setDeliveryLogicalWarehouseName(o.getWarehouseName());
                deliveryNoticeOrderVO.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
                deliveryNoticeOrderVO.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
                if (ObjectUtil.isNotEmpty((Object)o.getTotalSku())) {
                    deliveryNoticeOrderVO.setTotalSku(new BigDecimal(o.getTotalSku()));
                }
                deliveryNoticeOrderVOS.add(deliveryNoticeOrderVO);
            });
            pageInfo.setList(deliveryNoticeOrderVOS);
            return new RestResponse((Object)pageInfo);
        }
        PageInfo respVoPageInfo = new PageInfo();
        PageInfo pageInfo = new PageInfo();
        GetDeliveryNoticeOrderPageParams pageQueryDto = DtoExchangeUtils.createDtoBySource(getDeliveryNoticeOrderListPageParams, GetDeliveryNoticeOrderPageParams.class);
        pageQueryDto.setOrderNo(getDeliveryNoticeOrderListPageParams.getDocumentNo());
        pageQueryDto.setWarehouse(getDeliveryNoticeOrderListPageParams.getDeliveryLogicalWarehouseName());
        pageQueryDto.setReceiveWarehouse(getDeliveryNoticeOrderListPageParams.getReceiveLogicalWarehouseName());
        pageQueryDto.setOrderStatus(getDeliveryNoticeOrderListPageParams.getDocumentStatus());
        respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esDeliveryOrderQueryApi.queryDeliveryNoticeOrderPage(pageQueryDto));
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse();
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList();
        ArrayList deliveryNoticeOrderVOS = new ArrayList(list.size());
        list.forEach(p -> {
            DeliveryNoticeOrderVO deliveryNoticeOrderVO = DtoExchangeUtils.createDtoBySource(p, DeliveryNoticeOrderVO.class);
            deliveryNoticeOrderVO.setCreateTime(DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            deliveryNoticeOrderVO.setBusinessOrderNo(p.getRelevanceNo());
            deliveryNoticeOrderVO.setDocumentStatus(p.getOrderStatus());
            deliveryNoticeOrderVO.setExternalOrderNo(p.getExternalOrderNo());
            deliveryNoticeOrderVO.setDeliveryLogicalWarehouseCode(p.getDeliveryLogicWarehouseCode());
            deliveryNoticeOrderVO.setDeliveryLogicalWarehouseName(p.getDeliveryLogicWarehouseName());
            deliveryNoticeOrderVO.setReceiveLogicalWarehouseCode(p.getReceiveLogicWarehouseCode());
            deliveryNoticeOrderVO.setReceiveLogicalWarehouseName(p.getReceiveLogicWarehouseName());
            deliveryNoticeOrderVO.setBizDateStr(ObjectUtil.isNotEmpty((Object)p.getBizDate()) ? DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            deliveryNoticeOrderVOS.add(deliveryNoticeOrderVO);
        });
        pageInfo.setList(deliveryNoticeOrderVOS);
        return new RestResponse((Object)pageInfo);
    }
}

