/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.annotation.OptLog;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogReqDto;
import com.dtyunxi.cis.pms.biz.service.opt.IOptLogTypeService;
import com.dtyunxi.cis.pms.biz.utils.SpelUtil;
import com.dtyunxi.rest.RestResponse;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OptLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(OptLogAspect.class);
    @Autowired
    private IOptLogTypeService optLogTypeService;

    @Around(value="@annotation(optLog)")
    public Object addOptLog(ProceedingJoinPoint joinPoint, OptLog optLog) throws Throwable {
        Object result = null;
        Object[] args = joinPoint.getArgs();
        logger.info("\u65b9\u6cd5\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)args[0]));
        try {
            result = joinPoint.proceed(args);
        }
        catch (Throwable throwable) {
            logger.error("\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38\uff1a{}", (Object)throwable.getMessage(), (Object)throwable);
            throw throwable;
        }
        return result;
    }

    private void addLog(OptLog optLog, String optNo) {
        OptLogReqDto optLogReqDto = new OptLogReqDto();
        optLogReqDto.setOptOrderType(optLog.optOrderType().getCode());
        optLogReqDto.setType(optLog.type().getCode());
        optLogReqDto.setOptTime(new Date());
        optLogReqDto.setOptPerson(ServiceContext.getContext().getRequestUserCode());
        optLogReqDto.setOptNo(optNo);
        this.optLogTypeService.getOptLogTypeCode(optLogReqDto.getOptOrderType()).addOptLog(optLogReqDto);
    }

    @AfterReturning(returning="response", pointcut="@annotation(optLog)")
    public void doAfterResult(JoinPoint joinPoint, RestResponse response, OptLog optLog) {
        logger.info("\u63a5\u53e3\u8bf7\u6c42\u6210\u529f\u540e\u8fd4\u56de\u7684\u4fe1\u606f\uff1a{},\u8bf7\u6c42\u7684\u7ec4\u88c5\u53c2\u6570", JSON.toJSON((Object)response), JSON.toJSON((Object)optLog));
        String optNo = "";
        if (Objects.equals(OptLogTypeEnum.ADD.getCode(), optLog.type().getCode()) && Objects.nonNull(response.getData())) {
            optNo = response.getData().toString();
            logger.info("\u65b0\u589e\u65b9\u6cd5\u8fd4\u56de\u5355\u53f7/id\uff1a{}", (Object)optNo);
        }
        if (Objects.equals(OptLogTypeEnum.UPD.getCode(), optLog.type().getCode())) {
            optNo = this.getOptNo(joinPoint, optLog);
            logger.info("\u66f4\u65b0\u65b9\u6cd5\u8bf7\u6c42\u5355\u53f7/id\uff1a{}", (Object)optNo);
        }
        this.addLog(optLog, optNo);
    }

    private String getOptNo(JoinPoint joinPoint, OptLog optLog) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        Object[] arguments = joinPoint.getArgs();
        String key = optLog.optNo();
        return SpelUtil.parse(key, targetMethod, arguments);
    }
}

