/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.aop;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.annotation.RegenerateTasks;
import com.dtyunxi.cis.pms.biz.dto.request.RegenerateTasksReqDto;
import com.dtyunxi.cis.pms.biz.service.IRegenerateTasksService;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cis.pms.biz.utils.StringJoinUtil;
import com.dtyunxi.cis.pms.biz.utils.TasksUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RegenerateTasksAop {
    private static final Logger log = LoggerFactory.getLogger(RegenerateTasksAop.class);
    @Resource
    private IRegenerateTasksService tasksService;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;

    @Pointcut(value="@annotation(com.dtyunxi.cis.pms.biz.annotation.RegenerateTasks)")
    public void regenerateTasks() {
    }

    @Around(value="regenerateTasks()")
    public Object saveTasks(ProceedingJoinPoint joinPoint) {
        Long tasksId;
        Object tasksReqDto;
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        String declaringClassName = targetMethod.getDeclaringClass().getName();
        log.info("\u91cd\u65b0\u751f\u6210\u4efb\u52a1AOP\uff1a{}", (Object)declaringClassName);
        RegenerateTasks annotation = targetMethod.getAnnotation(RegenerateTasks.class);
        String oldTasksId = TasksUtils.getTasksId();
        log.info("\u91cd\u65b0\u751f\u6210\u4efb\u52a1AOP\uff1aoldTasksId={}", (Object)oldTasksId);
        if (StrUtil.isBlank((CharSequence)oldTasksId)) {
            tasksReqDto = new RegenerateTasksReqDto();
            ((RegenerateTasksReqDto)((Object)tasksReqDto)).setClassName(declaringClassName);
            String methodName = joinPoint.getSignature().getName();
            ((RegenerateTasksReqDto)((Object)tasksReqDto)).setSign(methodName);
            if (Objects.nonNull(annotation)) {
                ((RegenerateTasksReqDto)((Object)tasksReqDto)).setApiExplained(annotation.apiExplained());
                ((RegenerateTasksReqDto)((Object)tasksReqDto)).setMenuModule(annotation.menuModule());
            }
            if (Objects.nonNull(args)) {
                String paramStr = JSON.toJSONString((Object)args);
                ((RegenerateTasksReqDto)((Object)tasksReqDto)).setRequestParam(paramStr);
                if (args.length > 0) {
                    FeeGenerateReqDto reqDto = (FeeGenerateReqDto)args[0];
                    ((RegenerateTasksReqDto)((Object)tasksReqDto)).setCarrierName(StringJoinUtil.safeJoin(reqDto.getTransportTypeList()));
                    ((RegenerateTasksReqDto)((Object)tasksReqDto)).setLogisticsCompanyName(StringJoinUtil.safeJoin(reqDto.getLogisticCompanyList()));
                    ((RegenerateTasksReqDto)((Object)tasksReqDto)).setPhysicsWarehouseName(StringJoinUtil.safeJoin(reqDto.getOutPhysicsWarehouseNameList()));
                    ((RegenerateTasksReqDto)((Object)tasksReqDto)).setBillTypeName(StringJoinUtil.safeJoin(reqDto.getCostTypeList()));
                }
            }
            String taskCode = this.codeGenerateUtil.generateNo("FL", 4);
            ((RegenerateTasksReqDto)((Object)tasksReqDto)).setTaskCode(taskCode);
            tasksId = this.save((RegenerateTasksReqDto)((Object)tasksReqDto));
        } else {
            tasksId = Long.valueOf(oldTasksId);
        }
        try {
            tasksReqDto = joinPoint.proceed();
            return tasksReqDto;
        }
        catch (Throwable throwable) {
            log.error("\u91cd\u65b0\u751f\u6210\u4efb\u52a1\u5f02\u5e38\uff1a" + throwable.getMessage(), throwable);
            this.tasksService.errorModify(tasksId, throwable.getMessage());
            throw new BizException("100000", throwable.getMessage());
        }
        finally {
            TasksUtils.removeTasksId();
        }
    }

    private Long save(RegenerateTasksReqDto eo) {
        try {
            Long tasksId = this.tasksService.addRegenerateTasks(eo);
            if (Objects.nonNull(tasksId)) {
                log.info("\u4fdd\u5b58\u4efb\u52a1\u6210\u529f\uff1a{}", (Object)tasksId);
                TasksUtils.setTasksId(tasksId);
                return tasksId;
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

