/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetPhysicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.LogicWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterWarehouseBasePhysicalService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterWarehouseBasePhysicalServiceServiceImpl
implements InventoryCenterWarehouseBasePhysicalService {
    @Resource
    private ICsPhysicsWarehouseQueryApi csPhysicsWarehouseQueryApi;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseQueryApi;
    @Resource
    private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;

    @Override
    public RestResponse<Object> addPhysicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) PhysicalWarehouseVO physicalWarehouseVO) {
        return new RestResponse();
    }

    @Override
    public RestResponse<PhysicalWarehouseVO> getPhysicalWarehouseById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponse pageInfoRestResponse = this.csPhysicsWarehouseQueryApi.queryByPrimaryKey(Long.valueOf(id));
        CsPhysicsWarehouseRespDto csPhysicsWarehouseRespDto = (CsPhysicsWarehouseRespDto)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (csPhysicsWarehouseRespDto != null) {
            PhysicalWarehouseVO physicalWarehouseVO = DtoExchangeUtils.createDtoBySource(csPhysicsWarehouseRespDto, PhysicalWarehouseVO.class);
            return new RestResponse((Object)physicalWarehouseVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<PhysicalWarehouseVO>> getPhysicalWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetPhysicalWarehouseListPageParams getPhysicalWarehouseListPageParams) {
        CsPhysicsWarehouseQueryDto csPhysicsWarehouseQueryDto = DtoExchangeUtils.createDtoBySource(getPhysicalWarehouseListPageParams, CsPhysicsWarehouseQueryDto.class);
        RestResponse pageInfoRestResponse = this.csPhysicsWarehouseQueryApi.queryByPage(csPhysicsWarehouseQueryDto);
        PageInfo physicsWarehouseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (physicsWarehouseRespDtoPageInfo != null) {
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)physicsWarehouseRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List<PhysicalWarehouseVO> dtoList = DtoExchangeUtils.createDtoListBySource(physicsWarehouseRespDtoPageInfo.getList(), PhysicalWarehouseVO.class);
            dtoPageInfo.setList(dtoList);
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogicWarehouseVO>> getPhysicalWarehouseRelationListPage(@ApiParam(value="", required=true) @PathVariable(value="physicalWarehouseId") Long physicalWarehouseId, @NotNull @ApiParam(value="\u6bcf\u9875\u5927\u5c0f", required=true) @Valid @RequestParam(value="pageSize", required=true) String pageSize, @NotNull @ApiParam(value="\u9875\u7801", required=true) @Valid @RequestParam(value="pageNum", required=true) String pageNum, @ApiParam(value="\u4ed3\u5e93\u7f16\u7801") @Valid @RequestParam(value="logicWarehouseCode", required=false) String logicWarehouseCode) {
        CsRelWarehouseQueryDto csRelWarehouseQueryDto = new CsRelWarehouseQueryDto();
        csRelWarehouseQueryDto.setWarehouseId(physicalWarehouseId);
        csRelWarehouseQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        csRelWarehouseQueryDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseQueryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseQueryDto.setRefWarehouseCode(logicWarehouseCode);
        csRelWarehouseQueryDto.setPageNum(Integer.valueOf(Integer.parseInt(pageNum)));
        csRelWarehouseQueryDto.setPageSize(Integer.valueOf(Integer.parseInt(pageSize)));
        RestResponse pageInfoRestResponse = this.csRelWarehouseQueryApi.queryByPage(csRelWarehouseQueryDto);
        PageInfo csRelWarehouseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo dtoPageInfo = new PageInfo();
        if (csRelWarehouseRespDtoPageInfo != null) {
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)csRelWarehouseRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List csRelWarehouseRespDtoPageInfoList = csRelWarehouseRespDtoPageInfo.getList();
            ArrayList dtoList = Lists.newArrayList();
            for (CsRelWarehouseRespDto csRelWarehouseRespDto : csRelWarehouseRespDtoPageInfoList) {
                LogicWarehouseVO logicWarehouseVO = new LogicWarehouseVO();
                logicWarehouseVO.setWarehouseName(csRelWarehouseRespDto.getRefWarehouseName());
                logicWarehouseVO.setWarehouseCode(csRelWarehouseRespDto.getRefWarehouseCode());
                logicWarehouseVO.setWarehouseStatus(CsLogicWarehouseStatusEnum.ENABLE.getCode());
                dtoList.add(logicWarehouseVO);
            }
            dtoPageInfo.setList((List)dtoList);
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<Object> updatePhysicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) LogicWarehouseVO logicWarehouseVO) {
        return new RestResponse();
    }
}

