/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.service.ExternalDispatchEasService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutEasApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASBizTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASTransactionTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.SyncSystemTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASBillReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASInventoryAllotDetailResult;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderBaseResult;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.SaleOrder;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.SaleOrderEntry;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehousePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderItemApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DispatchEasSaleOrderImpl
implements ExternalDispatchEasService {
    private static final Logger logger = LoggerFactory.getLogger(DispatchEasSaleOrderImpl.class);
    private final List<String> excludeOrderTypes = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.OTHER_OUT_STOCK.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.REPLENISH_ORDER.getType()});
    private final List<String> orderTypes = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.getType(), SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.getType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType(), SaleOrderTypeEnum.CLAIM_POSTING.getType(), SaleOrderTypeEnum.PRESALE_ORDER.getType(), SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType(), SaleOrderTypeEnum.SPECIAL_CHANNEL_ORDER.getType()});
    @Resource
    private IExternalOutEasApi externalOutEasApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ISaleOrderItemApi saleOrderItemApi;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Autowired
    IVirtualWarehouseApi virtualWarehouseApi;

    @Override
    public String getApiCode() {
        return ExternalDispatchBaseEnum.API_EAS008.apiCode;
    }

    @Override
    public Object execute(Object object) {
        logger.info("eas\u9500\u552e\u8ba2\u5355\uff08\u975e\u836f\u4e1a\uff09\u8c03\u5ea6\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)object));
        PcpOrderReqDto reqDto = new PcpOrderReqDto();
        BeanUtil.copyProperties((Object)object, (Object)reqDto, (String[])new String[0]);
        this.directExecute(reqDto);
        return null;
    }

    public void directExecute(PcpOrderReqDto pcpOrder) {
        logger.info("eas\u9500\u552e\u8ba2\u5355\u63a8\u9001\uff1a{}", (Object)JSON.toJSONString((Object)pcpOrder));
        logger.info("easID\uff1a{}", (Object)pcpOrder.getId());
        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(pcpOrder.getSaleOrderNo()));
        if (ObjectUtil.isEmpty((Object)saleOrderRespDto)) {
            throw new BizException("-1", "\u83b7\u53d6\u9500\u552e\u5355\u636e\u4fe1\u606f\u5f02\u5e38");
        }
        if (saleOrderRespDto.getIfButtThirdParty() != 1 || !this.orderTypes.contains(saleOrderRespDto.getOrderType())) {
            logger.info("\u4e0d\u6ee1\u8db3\u63a8\u9001\u6761\u4ef6\uff0c\u4e0d\u6267\u884c\u63a8\u9001EAS");
            return;
        }
        logger.info("\u5355\u636e\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespDto));
        if (StringUtils.isEmpty((CharSequence)saleOrderRespDto.getSendDate())) {
            saleOrderRespDto.setSendDate(DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isEmpty((CharSequence)saleOrderRespDto.getDeliveryDate())) {
            saleOrderRespDto.setDeliveryDate(DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        EASBillReqDto easBillReqDto = new EASBillReqDto();
        easBillReqDto.setSyncSystem(SyncSystemTypeEnum.PCP.code);
        easBillReqDto.setAutoSubmit(Boolean.TRUE);
        if (saleOrderRespDto.getOrderBizType() == 0) {
            easBillReqDto.setAutoAudit(Boolean.TRUE);
        } else {
            easBillReqDto.setAutoAudit(Boolean.FALSE);
        }
        SaleOrder saleOrder = new SaleOrder();
        saleOrder.setPcpSaleId(saleOrderRespDto.getId());
        saleOrder.setSeq(saleOrderRespDto.getSaleOrderNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        saleOrder.setBizDate(ObjectUtil.isNotEmpty((Object)saleOrderRespDto.getSaleCreateTime()) ? simpleDateFormat.format(saleOrderRespDto.getSaleCreateTime()) : null);
        saleOrder.setBizType(EASBizTypeEnum.IMPORT_006_SALE.code);
        saleOrder.setSendBase(null);
        saleOrder.setWhouseBase("ZHIHAI_WMS");
        saleOrder.setCrmId(null);
        saleOrder.setTransactionType(EASTransactionTypeEnum.TYPE_010.code);
        saleOrder.setStorageOrgUnit(saleOrderRespDto.getEasOrgId());
        saleOrder.setIsInTax(null);
        saleOrder.setExchangeRate(null);
        saleOrder.setOrderCustomer(saleOrderRespDto.getCustomerCode());
        saleOrder.setDescription(saleOrderRespDto.getSellerRemark());
        saleOrder.setMemo(saleOrderRespDto.getSellerRemark());
        saleOrder.setCrmId(saleOrderRespDto.getPlatformOrderNo());
        saleOrder.setCustomerOrderNumber(saleOrder.getCrmId());
        saleOrder.setSalePerson("sync_bill_crm");
        if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getEasDefaultWarehouseCode())) {
            saleOrder.setWarehouse(saleOrderRespDto.getEasDefaultWarehouseCode());
        } else if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getStoragePlace())) {
            VirtualWarehouseRespDto dto2;
            VirtualWarehousePageReqDto queryDto = new VirtualWarehousePageReqDto();
            queryDto.setWarehouseCode(saleOrderRespDto.getStoragePlace());
            queryDto.setWarehouseStatus("enable");
            PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApi.queryByPage(queryDto));
            List list = page.getList();
            if (CollectionUtils.isNotEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)(dto2 = (VirtualWarehouseRespDto)list.get(0)).getEasDefaultWarehouseCode())) {
                saleOrder.setWarehouse(dto2.getEasDefaultWarehouseCode());
            }
        }
        if (saleOrderRespDto.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_REISSUE.getBusinessType()) || saleOrderRespDto.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_POSTING.getBusinessType())) {
            if (Strings.isBlank((String)saleOrder.getWarehouse())) {
                saleOrder.setWarehouse(saleOrderRespDto.getDefaultLogicalWarehouseCode());
            }
            if (Strings.isBlank((String)saleOrder.getWarehouse())) {
                saleOrder.setWarehouse(saleOrderRespDto.getLogicalWarehouseCode());
            }
        }
        HashMap<String, Boolean> extendsJsonMap = new HashMap<String, Boolean>();
        if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getOrderType()) && saleOrderRespDto.getOrderType().equals(SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType())) {
            extendsJsonMap.put("isSubComyTrade", true);
        } else {
            extendsJsonMap.put("isSubComyTrade", false);
        }
        saleOrder.setExtendsJsonMap(JSON.toJSONString(extendsJsonMap));
        if (ObjectUtil.isNotEmpty((Object)saleOrderRespDto.getOrderAddrRespDto())) {
            saleOrder.setConsignee(saleOrderRespDto.getOrderAddrRespDto().getReceiveName());
            saleOrder.setRecAddress(saleOrderRespDto.getOrderAddrRespDto().getReceiveAddress());
            saleOrder.setTell(saleOrderRespDto.getOrderAddrRespDto().getReceivePhone());
            saleOrder.setNetAddr(saleOrder.getRecAddress());
            saleOrder.setLinkPerson(saleOrder.getConsignee());
            saleOrder.setAprovince(saleOrderRespDto.getOrderAddrRespDto().getProvince());
            saleOrder.setAcity(saleOrderRespDto.getOrderAddrRespDto().getCity());
            saleOrder.setAcounty(saleOrderRespDto.getOrderAddrRespDto().getCounty());
        }
        String marketChannel = "";
        if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getExtension())) {
            logger.info("\u9ea6\u4f18\u91c7\u8d2d\u5355\u8d4b\u503c\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespDto.getExtension()));
            Map map = (Map)JSON.parseObject((String)saleOrderRespDto.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            if (ObjectUtil.isNotEmpty((Object)map)) {
                saleOrder.setMyPONum((String)map.get("maiyouEasNo"));
                marketChannel = (String)map.get("marketChannel");
            }
        }
        Map<Object, Object> itemMap = new HashMap();
        if ((saleOrderRespDto.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_REISSUE.getBusinessType()) || saleOrderRespDto.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_POSTING.getBusinessType())) && CollectionUtil.isNotEmpty((Collection)saleOrderRespDto.getItemList())) {
            itemMap = saleOrderRespDto.getItemList().stream().collect(Collectors.toMap(SaleOrderItemRespDto::getId, SaleOrderItemRespDto::getClaimPrice, (k1, k2) -> k1));
            logger.info("\u9500\u552e\u5355\u5546\u54c1\u660e\u7ec6\u7d22\u8d54\u4ef7\uff1a{}", (Object)JSON.toJSONString(itemMap));
        }
        ArrayList entries = new ArrayList();
        String finalMarketChannel = marketChannel;
        HashMap finalItemMap = itemMap;
        saleOrderRespDto.getItemList().forEach(dto -> {
            SaleOrderEntry entry = new SaleOrderEntry();
            entry.setSaleDistribution(finalMarketChannel);
            entry.setSubDivisionPlatform(saleOrderRespDto.getSaleChannel());
            entry.setSupplyMode(null);
            entry.setDeliveryDate(saleOrderRespDto.getDeliveryDate());
            entry.setSendDate(saleOrderRespDto.getSendDate());
            entry.setTaxRate(null);
            entry.setTaxPrice(ObjectUtil.isNotEmpty((Object)dto.getSalePrice()) ? dto.getSalePrice().toString() : null);
            entry.setDiscountAmount(ObjectUtil.isNotEmpty((Object)dto.getSettleAmount()) ? dto.getSettleAmount().toString() : null);
            entry.setQty(ObjectUtil.isNotEmpty((Object)dto.getItemNum()) ? dto.getItemNum().toString() : "0");
            entry.setBaseQty(entry.getQty());
            entry.setMaterial(dto.getSkuCode());
            entry.setExtSeq(ObjectUtil.isNotEmpty((Object)dto.getId()) ? dto.getId().toString() : null);
            entry.setIsScore(Boolean.valueOf(dto.getIntegral() != null && dto.getIntegral() == 1));
            entry.setScore(ObjectUtil.isNotEmpty((Object)dto.getTotalScore()) ? dto.getTotalScore().toString() : null);
            entry.setSitePrice(entry.getTaxPrice());
            entry.setWarehouse(saleOrder.getWarehouse());
            if (ObjectUtil.isEmpty((Object)dto.getGift()) || dto.getGift() == 0) {
                entry.setIsPresent(Boolean.valueOf(false));
            } else {
                entry.setIsPresent(Boolean.valueOf(true));
            }
            if (saleOrderRespDto.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_REISSUE.getBusinessType()) || saleOrderRespDto.getOrderType().equals(ExpressBusinessTypeEnum.CLAIM_POSTING.getBusinessType())) {
                logger.info("\u7d22\u8d54\u76f8\u5173\u5355\u636e\uff0c\u4f20\u7d22\u8d54\u5355\u4ef7");
                BigDecimal bigDecimal = (BigDecimal)finalItemMap.get(dto.getId());
                if (null != bigDecimal) {
                    entry.setTaxPrice(bigDecimal.toString());
                    entry.setSitePrice(bigDecimal.toString());
                }
            }
            entry.setMyBeforeDisAmt(dto.getEasOrderTotalAmount());
            entry.setMyPromotionDis(dto.getEasPromotionActivityAmount());
            entry.setMySaleReturnDis(dto.getEasSaleRebateAmount());
            entries.add(entry);
        });
        saleOrder.setEntrys(entries);
        easBillReqDto.setSaleOrders((List)Lists.newArrayList((Object[])new SaleOrder[]{saleOrder}));
        EASOrderBaseResult easOrderBaseResult = null;
        logger.info("\u63a8\u9001\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)easBillReqDto));
        try {
            easOrderBaseResult = (EASOrderBaseResult)RestResponseHelper.extractData((RestResponse)this.externalOutEasApi.saleOrder(easBillReqDto));
            logger.info("\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)easOrderBaseResult));
        }
        catch (Exception e) {
            logger.error("eas\u9500\u552e\u8ba2\u5355\u63a8\u9001\u5931\u8d25\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    public String labourExecute(String orderNo) {
        logger.info("\u624b\u52a8eas\u9500\u552e\u8ba2\u5355\u63a8\u9001\uff1a{}", (Object)orderNo);
        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(orderNo));
        PcpOrderReqDto pcpOrder = new PcpOrderReqDto();
        BeanUtil.copyProperties((Object)saleOrderRespDto, (Object)pcpOrder, (String[])new String[0]);
        ArrayList itemList = new ArrayList();
        CubeBeanUtils.copyCollection(itemList, (Collection)saleOrderRespDto.getItemList(), PlatformOrderItemReqDto.class);
        pcpOrder.setItemReqDtoList(itemList);
        this.directExecute(pcpOrder);
        return "\u8bf7\u6c42\u6210\u529f\uff01";
    }

    private void updateSaleExtension(PcpOrderReqDto pcpOrder, EASOrderBaseResult easOrderBaseResult) {
        logger.info("\u66f4\u65b0\u9500\u552e\u5355\u636e\u53ca\u660e\u7ec6\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)pcpOrder));
        logger.info(JSON.toJSONString((Object)easOrderBaseResult));
        SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
        saleOrderReqDto.setId(pcpOrder.getId());
        saleOrderReqDto.setSaleOrderNo(pcpOrder.getSaleOrderNo());
        saleOrderReqDto.setEasOrderNo(easOrderBaseResult.getOrderNum());
        saleOrderReqDto.setExtension(JSON.toJSONString((Object)Maps.newHashMap().put(EASExtendKeyEnum.SOURCE_ID.code, easOrderBaseResult.getOrderId())));
        this.saleOrderApi.modifySaleOrder(saleOrderReqDto);
        Map resultMap = easOrderBaseResult.getItemList().stream().collect(Collectors.toMap(EASInventoryAllotDetailResult::getOutId, Function.identity(), (k1, k2) -> k1));
        pcpOrder.getItemReqDtoList().forEach(item -> {
            EASInventoryAllotDetailResult detailResultMap = (EASInventoryAllotDetailResult)resultMap.get(item.getId().toString());
            if (ObjectUtil.isNotEmpty((Object)detailResultMap)) {
                SaleOrderItemReqDto saleOrderItemReqDto = new SaleOrderItemReqDto();
                saleOrderItemReqDto.setId(item.getId());
                saleOrderItemReqDto.setExtension(JSON.toJSONString((Object)Maps.newHashMap().put(EASExtendKeyEnum.ENTRY_ID.code, detailResultMap.getId())));
                this.saleOrderItemApi.modifySaleOrderItem(saleOrderItemReqDto);
            }
        });
    }
}

