/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddOutSourceReturnOrderParams;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetOutSourceReturnOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutSourceReturnOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryOutSourceReturnOrderService;
import com.dtyunxi.cis.search.api.dto.request.OutPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class FinishedGoodsInventoryOutSourceReturnOrderServiceServiceImpl
implements FinishedGoodsInventoryOutSourceReturnOrderService {
    @Resource
    private EsPlannedOrderQueryApi esPlannedOrderQueryApi;
    @Resource
    private ICsOutPlannedOrderApi csOutPlannedOrderApi;
    @Resource
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;

    @Override
    public RestResponse<Void> addOutSourceReturnOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddOutSourceReturnOrderParams addOutSourceReturnOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addOutSourceReturnOrderParams, (Object)reqDto);
        this.getOutPlannedOrder(addOutSourceReturnOrderParams, reqDto);
        RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.generateRetreatOrder(reqDto));
        return RestResponse.VOID;
    }

    private void getOutPlannedOrder(AddOutSourceReturnOrderParams addOutSourceReturnOrderParams, CsOutPlannedOrderGenerateReqDto reqDto) {
        Integer submitType = addOutSourceReturnOrderParams.getSubmitType();
        reqDto.setOperateFlag(CsPlannedOrderOperateEnum.DRAFT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(submitType)) {
            reqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        }
        reqDto.setWarehouseCode(addOutSourceReturnOrderParams.getDeliveryLogicalWarehouseCode());
        reqDto.setWarehouseName(addOutSourceReturnOrderParams.getDeliveryLogicalWarehouseName());
        reqDto.setOrderType(CsPlannedOrderTypeEnum.OUTSOURCE_RETREAT.getCode());
        reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.OUTSOURCE_RETREAT.getCode());
        reqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        List<FinishedGoodsInventoryGoodsVO> goodsList = addOutSourceReturnOrderParams.getGoodsList();
        List list = goodsList.stream().map(o -> {
            CsOutPlannedOrderGenerateDetailReqDto dto = new CsOutPlannedOrderGenerateDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setLongCode(o.getGoodsLongCode());
            dto.setBatch(o.getBatchNo());
            dto.setCargoName(o.getGoodsName());
            dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
            dto.setCargoCode(o.getGoodsCode());
            if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            dto.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanQuantity()));
            return dto;
        }).collect(Collectors.toList());
        reqDto.setItemDetailList(list);
    }

    @Override
    public RestResponse<OutSourceReturnOrderVO> getOutSourceReturnOrderDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List<AssociatedDocumentVO> list;
        CsOutPlannedOrderDetailQueryInfoRespDto respDto = (CsOutPlannedOrderDetailQueryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderQueryApi.queryDetailByOrderNo(bussinessOrderNo));
        OutSourceReturnOrderVO vo = new OutSourceReturnOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getOrderNo());
        vo.setBussinessOrderType(respDto.getBusinessType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setExternalOrderNo(respDto.getPlatformOrderNo());
        vo.setDeliveryLogicalWarehouseCode(respDto.getDeliveryWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getDeliveryWarehouseName());
        vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        List relOrderInfoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoList)) {
            list = relOrderInfoList.stream().map(o -> {
                AssociatedDocumentVO associatedDocumentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)associatedDocumentVO);
                return associatedDocumentVO;
            }).collect(Collectors.toList());
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)respDto.getAuditRespDtoList())) {
            list = respDto.getAuditRespDtoList().stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<OutSourceReturnOrderVO>> getOutSourceReturnOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetOutSourceReturnOrderListPageParams getOutSourceReturnOrderListPageParams) {
        OutPlannedOrderPageParams params = new OutPlannedOrderPageParams();
        BeanUtils.copyProperties((Object)getOutSourceReturnOrderListPageParams, (Object)params);
        params.setOrderNo(getOutSourceReturnOrderListPageParams.getBussinessOrderNo());
        params.setBusinessType(getOutSourceReturnOrderListPageParams.getBussinessOrderType());
        params.setOrdeType(CsPlannedOrderTypeEnum.OUTSOURCE_RETREAT.getCode());
        params.setWarehouseCode(getOutSourceReturnOrderListPageParams.getDeliveryLogicalWarehouseCode());
        params.setWarehouseName(getOutSourceReturnOrderListPageParams.getDeliveryLogicalWarehouseName());
        params.setOrderStatus(getOutSourceReturnOrderListPageParams.getBussinessOrderStatus());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esPlannedOrderQueryApi.queryOutPlannedOrderPage(params));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            OutSourceReturnOrderVO vo = new OutSourceReturnOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getBusinessType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setTotalNum(o.getTotalQuantity() != null ? o.getTotalQuantity().intValue() : 0);
            vo.setTotalDoneNum(o.getDoneOutQuantity() != null ? o.getDoneOutQuantity().intValue() : 0);
            vo.setDeliveryLogicalWarehouseCode(o.getDeliveryWarehouseCode());
            vo.setDeliveryLogicalWarehouseName(o.getDeliveryWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Void> updateOutSourceReturnOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddOutSourceReturnOrderParams addOutSourceReturnOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addOutSourceReturnOrderParams, (Object)reqDto);
        reqDto.setOrderNo(addOutSourceReturnOrderParams.getBussinessOrderNo());
        this.getOutPlannedOrder(addOutSourceReturnOrderParams, reqDto);
        RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.editRetreatOrder(reqDto));
        return RestResponse.VOID;
    }
}

