/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddPurchaseReturnOrderParams;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportPurchaseReturnOrderVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetPurchaseReturnOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.PurchaseReturnOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryPurchaseReturnOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.OutPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.dto.response.OutPlannedOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_purchase_return_order")
public class FinishedGoodsInventoryPurchaseReturnOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryPurchaseReturnOrderService {
    @Resource
    private EsPlannedOrderQueryApi esPlannedOrderQueryApi;
    @Resource
    private ICsOutPlannedOrderApi csOutPlannedOrderApi;
    @Resource
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public RestResponse<Void> addPurchaseReturnOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddPurchaseReturnOrderParams addPurchaseReturnOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addPurchaseReturnOrderParams, (Object)reqDto);
        this.getOutPlannedOrder(addPurchaseReturnOrderParams, reqDto);
        RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.generateRetreatOrder(reqDto));
        return RestResponse.VOID;
    }

    private void getOutPlannedOrder(AddPurchaseReturnOrderParams addPurchaseReturnOrderParams, CsOutPlannedOrderGenerateReqDto reqDto) {
        Integer submitType = addPurchaseReturnOrderParams.getSubmitType();
        reqDto.setOperateFlag(CsPlannedOrderOperateEnum.DRAFT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(submitType)) {
            reqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        }
        reqDto.setWarehouseCode(addPurchaseReturnOrderParams.getDeliveryLogicalWarehouseCode());
        reqDto.setWarehouseName(addPurchaseReturnOrderParams.getDeliveryLogicalWarehouseName());
        reqDto.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
        reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.PURCHASE_RETREAT.getCode());
        reqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        List<FinishedGoodsInventoryGoodsVO> goodsList = addPurchaseReturnOrderParams.getGoodsList();
        List list = goodsList.stream().map(o -> {
            CsOutPlannedOrderGenerateDetailReqDto dto = new CsOutPlannedOrderGenerateDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setLongCode(o.getGoodsLongCode());
            dto.setBatch(o.getBatchNo());
            dto.setCargoName(o.getGoodsName());
            dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
            dto.setCargoCode(o.getGoodsCode());
            if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            dto.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanQuantity()));
            return dto;
        }).collect(Collectors.toList());
        reqDto.setItemDetailList(list);
    }

    @Override
    public RestResponse<PurchaseReturnOrderVO> getPurchaseReturnOrderDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List<AssociatedDocumentVO> list;
        CsOutPlannedOrderDetailQueryInfoRespDto respDto = (CsOutPlannedOrderDetailQueryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderQueryApi.queryDetailByOrderNo(bussinessOrderNo));
        PurchaseReturnOrderVO vo = new PurchaseReturnOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getOrderNo());
        vo.setBussinessOrderType(respDto.getBusinessType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setExternalOrderNo(respDto.getPlatformOrderNo());
        vo.setDeliveryLogicalWarehouseCode(respDto.getDeliveryWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getDeliveryWarehouseName());
        vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        List relOrderInfoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoList)) {
            list = relOrderInfoList.stream().map(o -> {
                AssociatedDocumentVO associatedDocumentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)associatedDocumentVO);
                if (o.getCreateTime() != null) {
                    associatedDocumentVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                return associatedDocumentVO;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                Collections.sort(list, (o2, o1) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
            }
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)respDto.getAuditRespDtoList())) {
            list = respDto.getAuditRespDtoList().stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<PurchaseReturnOrderVO>> getPurchaseReturnOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetPurchaseReturnOrderListPageParams getPurchaseReturnOrderListPageParams) {
        PageInfo pageInfo = new PageInfo();
        PageInfo respDtoPageInfo = new PageInfo();
        if (!this.esQuery.booleanValue()) {
            com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams req = new com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams();
            BeanUtils.copyProperties((Object)getPurchaseReturnOrderListPageParams, (Object)req);
            req.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
            PageInfo purchaseOrderVOPageInfo = (PageInfo)this.inventoryEsReportQueryApi.getPurchaseReturnOrderListPage(req).getData();
            if (CollectionUtils.isEmpty((Collection)purchaseOrderVOPageInfo.getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)purchaseOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList list = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)list, (Collection)purchaseOrderVOPageInfo.getList(), OutPlannedOrderVO.class);
            respDtoPageInfo.setList((List)list);
        } else {
            OutPlannedOrderPageParams params = new OutPlannedOrderPageParams();
            BeanUtils.copyProperties((Object)getPurchaseReturnOrderListPageParams, (Object)params);
            params.setOrderNo(getPurchaseReturnOrderListPageParams.getBussinessOrderNo());
            params.setBusinessType(getPurchaseReturnOrderListPageParams.getBussinessOrderType());
            params.setOrdeType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
            params.setWarehouseCode(getPurchaseReturnOrderListPageParams.getDeliveryLogicalWarehouseCode());
            params.setWarehouseName(getPurchaseReturnOrderListPageParams.getDeliveryLogicalWarehouseName());
            params.setOrderStatus(getPurchaseReturnOrderListPageParams.getBussinessOrderStatus());
            respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esPlannedOrderQueryApi.queryOutPlannedOrderPage(params));
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse((Object)pageInfo);
            }
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            PurchaseReturnOrderVO vo = new PurchaseReturnOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getBusinessType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setTotalNum(o.getTotalQuantity() != null ? o.getTotalQuantity().intValue() : 0);
            vo.setTotalDoneNum(o.getDoneOutQuantity() != null ? o.getDoneOutQuantity().intValue() : 0);
            vo.setDeliveryLogicalWarehouseCode(o.getDeliveryWarehouseCode());
            vo.setDeliveryLogicalWarehouseName(o.getDeliveryWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> outPlannedOrderStatusCount(@Valid GetPurchaseReturnOrderListPageParams getPurchaseReturnOrderListPageParams) {
        com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams req = new com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams();
        BeanUtils.copyProperties((Object)getPurchaseReturnOrderListPageParams, (Object)req);
        req.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
        return this.inventoryEsReportQueryApi.outPlannedOrderStatusCount(req);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetPurchaseReturnOrderListPageParams params = new GetPurchaseReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetPurchaseReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetPurchaseReturnOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getPurchaseReturnOrderListPage((GetPurchaseReturnOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportPurchaseReturnOrderVO vo = new ExportPurchaseReturnOrderVO();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setBussinessOrderStatus(Optional.ofNullable(item.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return item.getBussinessOrderStatus();
                }).orElse(""));
                vo.setBussinessOrderType("\u91c7\u8d2d\u4fc3\u9500\u7269\u6599\u9000\u8d27");
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportPurchaseReturnOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetPurchaseReturnOrderListPageParams params = new GetPurchaseReturnOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetPurchaseReturnOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetPurchaseReturnOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getPurchaseReturnOrderListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Void> updatePurchaseReturnOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddPurchaseReturnOrderParams addPurchaseReturnOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addPurchaseReturnOrderParams, (Object)reqDto);
        reqDto.setOrderNo(addPurchaseReturnOrderParams.getBussinessOrderNo());
        this.getOutPlannedOrder(addPurchaseReturnOrderParams, reqDto);
        RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.editRetreatOrder(reqDto));
        return RestResponse.VOID;
    }
}

