/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateConverterUtil {
    private static final DateTimeFormatter STANDARD_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static Date convertToStandardFormat(String inputDate) {
        if (inputDate == null || inputDate.trim().isEmpty()) {
            return null;
        }
        inputDate = inputDate.trim();
        try {
            Pattern pattern;
            Matcher matcher;
            LocalDate localDate = null;
            if (inputDate.matches("\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}")) {
                LocalDateTime dateTime = LocalDateTime.parse(inputDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                localDate = dateTime.toLocalDate();
            } else if (inputDate.matches("\\d{4}/\\d{1,2}/\\d{1,2}\\d{1,2}:\\d{2}:\\d{2}")) {
                Pattern pattern2 = Pattern.compile("(\\d{4})/(\\d{1,2})/(\\d{1,2})(\\d{1,2}):(\\d{2}):(\\d{2})");
                Matcher matcher2 = pattern2.matcher(inputDate);
                if (matcher2.find()) {
                    String year = matcher2.group(1);
                    String month = String.format("%02d", Integer.parseInt(matcher2.group(2)));
                    String day = String.format("%02d", Integer.parseInt(matcher2.group(3)));
                    String formattedDate = year + "-" + month + "-" + day;
                    localDate = LocalDate.parse(formattedDate, STANDARD_DATE_FORMAT);
                }
            } else if (inputDate.matches("\\d{4}/\\d{1,2}/\\d{1,2}")) {
                String[] parts = inputDate.split("/");
                String year = parts[0];
                String month = String.format("%02d", Integer.parseInt(parts[1]));
                String day = String.format("%02d", Integer.parseInt(parts[2]));
                String formattedDate = year + "-" + month + "-" + day;
                localDate = LocalDate.parse(formattedDate, STANDARD_DATE_FORMAT);
            } else if (inputDate.contains("2025") && (matcher = (pattern = Pattern.compile("(\\d{4})/(\\d{1,2})/(\\d{1,2})")).matcher(inputDate)).find()) {
                String year = matcher.group(1);
                String month = String.format("%02d", Integer.parseInt(matcher.group(2)));
                String day = String.format("%02d", Integer.parseInt(matcher.group(3)));
                String formattedDate = year + "-" + month + "-" + day;
                localDate = LocalDate.parse(formattedDate, STANDARD_DATE_FORMAT);
            }
            if (localDate != null) {
                return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            return null;
        }
        catch (DateTimeParseException e) {
            System.err.println("\u65e5\u671f\u89e3\u6790\u9519\u8bef: " + inputDate + " - " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u9519\u8bef: " + inputDate + " - " + e.getMessage());
            return null;
        }
    }
}

