/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.dto.response.BackInfoReqDto;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalServiceImpl
implements ExternalService {
    private static final Logger log = LoggerFactory.getLogger(ExternalServiceImpl.class);
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    ICsWmsApi wmsApi;

    @Override
    public void backMsg(String sendLogId, String resultCode, String resultMsg) {
        BackInfoReqDto dto = new BackInfoReqDto();
        dto.setSendLogId(sendLogId);
        dto.setResultCode(resultCode);
        dto.setResultMsg(resultMsg);
        try {
            this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "YWZX_BACK", (Object)JSON.toJSONString((Object)dto));
        }
        catch (Exception e) {
            log.error("\u56de\u4fe1\u786e\u8ba4\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public String getSendLogId(Map<String, Object> message) {
        if (Objects.isNull(message)) {
            return "10005";
        }
        return Convert.toStr((Object)message.get("sendLogId"), (String)"10005");
    }

    @Override
    public RestResponse<String> outSendBack(Map<String, Object> message) {
        CsWmsOutSendBackReqDto wmsOut = (CsWmsOutSendBackReqDto)BeanUtil.copyProperties(message, CsWmsOutSendBackReqDto.class, (String[])new String[0]);
        String outNoticeOrderNo = wmsOut.getOutNoticeOrderNo();
        wmsOut.setOutNoticeOrderNo(Convert.toStr((Object)message.get("order_no"), (String)outNoticeOrderNo));
        String platformOrderNo = wmsOut.getPlatformOrderNo();
        wmsOut.setPlatformOrderNo(Convert.toStr((Object)message.get("omsordercode"), (String)platformOrderNo));
        BigDecimal totalCartons = wmsOut.getTotalCartons();
        wmsOut.setTotalCartons(Convert.toBigDecimal((Object)message.get("box_qty"), (BigDecimal)totalCartons));
        BigDecimal mergeQuantity = wmsOut.getMergeQuantity();
        wmsOut.setMergeQuantity(Convert.toBigDecimal((Object)message.get("mix_box_qty"), (BigDecimal)mergeQuantity));
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        if (CollectionUtils.isEmpty((Collection)itemReqDtoList)) {
            itemReqDtoList = (List)MapUtil.get(message, (Object)"details", List.class);
        }
        List itemList = itemReqDtoList.stream().map(items -> {
            CsWmsOutSendBackDetailReqDto dto = new CsWmsOutSendBackDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            String skuCode = dto.getSkuCode();
            dto.setSkuCode(Convert.toStr(items.get("sku"), (String)skuCode));
            Object tcbj_warehouse = items.get("tcbj_warehouse");
            String tcbjWarehouse = Convert.toStr(items.get("tcbjWarehouse"));
            dto.setWarehouseCode(Convert.toStr(tcbj_warehouse, (String)tcbjWarehouse));
            return dto;
        }).collect(Collectors.toList());
        ArrayList shippingInfoList = Lists.newArrayList();
        CsWmsShippingInfoReqDto shippingInfo = new CsWmsShippingInfoReqDto();
        shippingInfo.setOutNoticeOrderNo(wmsOut.getOutNoticeOrderNo());
        shippingInfo.setPlatformOrderNo(wmsOut.getPlatformOrderNo());
        shippingInfo.setShippingCompanyCode(Convert.toStr((Object)message.get("shippingCompanyCode")));
        shippingInfo.setShippingCompanyName(Convert.toStr((Object)message.get("shippingCompanyName")));
        shippingInfo.setShippingNo(Convert.toStr((Object)message.get("shipment_code")));
        shippingInfoList.add(shippingInfo);
        wmsOut.setDetailReqDtoList(itemList);
        wmsOut.setShippingInfoReqDtoList((List)shippingInfoList);
        return this.wmsApi.outSendBack(wmsOut);
    }

    @Override
    public RestResponse<String> inSendBack(Map<String, Object> message) {
        CsWmsInSendBackReqDto wmsIn = (CsWmsInSendBackReqDto)BeanUtil.copyProperties(message, CsWmsInSendBackReqDto.class, (String[])new String[0]);
        String inNoticeOrderNo = wmsIn.getInNoticeOrderNo();
        wmsIn.setInNoticeOrderNo(Convert.toStr((Object)message.get("order_no"), (String)inNoticeOrderNo));
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        if (CollectionUtils.isEmpty((Collection)itemReqDtoList)) {
            itemReqDtoList = (List)MapUtil.get(message, (Object)"details", List.class);
        }
        List itemList = itemReqDtoList.stream().map(items -> {
            CsWmsInSendBackDetailReqDto dto = new CsWmsInSendBackDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            String skuCode = dto.getSkuCode();
            dto.setSkuCode(Convert.toStr(items.get("sku"), (String)skuCode));
            Date produceTime = dto.getProduceTime();
            dto.setProduceTime(Convert.toDate(items.get("product_date"), (Date)produceTime));
            Object tcbj_warehouse = items.get("tcbj_warehouse");
            String tcbjWarehouse = Convert.toStr(items.get("tcbjWarehouse"));
            dto.setWarehouseCode(Convert.toStr(tcbj_warehouse, (String)tcbjWarehouse));
            return dto;
        }).collect(Collectors.toList());
        wmsIn.setDetailReqDtoList(itemList);
        return this.wmsApi.inSendBack(wmsIn);
    }
}

