/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.AddDistributeOrder;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.DistributeOrderVo;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetDistributeOrderGoodsListParams;
import com.dtyunxi.cis.pms.biz.model.GetDistributeOrderParams;
import com.dtyunxi.cis.pms.biz.model.GoodsOfDistributeOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryDistributeOrderService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IShareGoodsOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IShareGoodsOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FinishedGoodsInventoryDistributeOrderServiceServiceImpl
implements FinishedGoodsInventoryDistributeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FinishedGoodsInventoryDistributeOrderServiceServiceImpl.class);
    @Resource
    private IShareGoodsOrderApi iCsShareGoodsOrderApi;
    @Resource
    private IShareGoodsOrderDetailApi iCsShareGoodsOrderDetailQueryApi;
    @Resource
    private IShareGoodsOrderApi iCsShareGoodsOrderQueryApi;

    @Override
    public RestResponse<Object> addDistributeOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddDistributeOrder addDistributeOrder) {
        ShareGoodsOrderReqDto reqDto = new ShareGoodsOrderReqDto();
        this.getShareGoodsOrder(reqDto, addDistributeOrder);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderApi.generateShareGoodsOrder(reqDto)));
    }

    private void getShareGoodsOrder(ShareGoodsOrderReqDto reqDto, AddDistributeOrder addDistributeOrder) {
        reqDto.setOrderNo(addDistributeOrder.getBussinessOrderNo());
        reqDto.setOrderStatus(addDistributeOrder.getBussinessOrderStatus());
        reqDto.setSupplyWarehouseCode(addDistributeOrder.getSupplyVirtualWarehoseCode());
        reqDto.setSupplyWarehouseName(addDistributeOrder.getSupplyVirtualWarehoseName());
        reqDto.setReceiveWarehouseCode(addDistributeOrder.getReceiveVirtualWarehoseCode());
        reqDto.setReceiveWarehouseName(addDistributeOrder.getReceiveVirtualWarehoseName());
        reqDto.setTotalQuantity(ParamConverter.convertToBigDecimal((Object)addDistributeOrder.getDistributeQuantityTotal()));
        reqDto.setRemark(addDistributeOrder.getRemark());
        String orderNo = addDistributeOrder.getBussinessOrderNo();
        if (CollectionUtils.isNotEmpty(addDistributeOrder.getGoodsList())) {
            List list = addDistributeOrder.getGoodsList().stream().map(o -> {
                ShareGoodsOrderDetailReqDto dto = new ShareGoodsOrderDetailReqDto();
                dto.setOrderNo(orderNo);
                dto.setSkuCode(o.getGoodsCode());
                dto.setSkuName(o.getGoodsName());
                dto.setQuantity(ParamConverter.convertToBigDecimal((Object)o.getDistributeQuantity()));
                return dto;
            }).collect(Collectors.toList());
            reqDto.setDetailList(list);
        }
    }

    @Override
    public RestResponse<DistributeOrderVo> queryDistributeOrder(@ApiParam(value="", required=true) @PathVariable(value="bussinessOrderNo") String bussinessOrderNo) {
        ShareGoodsOrderRespDto respDto = (ShareGoodsOrderRespDto)RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderQueryApi.queryByOrderNo(bussinessOrderNo));
        logger.info("\u5206\u8d27\u5355\u8be6\u60c5respDto{}", (Object)JSON.toJSONString((Object)respDto));
        if (respDto != null) {
            DistributeOrderVo vo = DtoExchangeUtils.createDtoBySource(respDto, DistributeOrderVo.class);
            vo.setBussinessOrderType(respDto.getBusinessType());
            vo.setCreatePerson(respDto.getCreatePerson());
            vo.setUpdatePerson(respDto.getUpdatePerson());
            vo.setSupplyVirtualWarehoseCode(respDto.getSupplyWarehouseCode());
            vo.setSupplyVirtualWarehoseName(respDto.getSupplyWarehouseName());
            vo.setReceiveVirtualWarehoseCode(respDto.getReceiveWarehouseCode());
            vo.setReceiveVirtualWarehoseName(respDto.getReceiveWarehouseName());
            vo.setRemark(respDto.getRemark());
            vo.setBussinessOrderNo(respDto.getOrderNo());
            vo.setBussinessOrderStatus(respDto.getOrderStatus());
            if (respDto.getOrderAuditList() != null) {
                List<AuditVO> auditRecordList = respDto.getOrderAuditList().stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                    AuditVO dto = new AuditVO();
                    dto.setId(o.getAuditUserId());
                    if (o.getCreateTime() != null) {
                        dto.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                    if (o.getUpdateTime() != null) {
                        dto.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                    dto.setCreatePerson(o.getCreatePerson());
                    dto.setUpdatePerson(o.getUpdatePerson());
                    dto.setAuditResult(o.getAuditResult());
                    dto.setAuditReason(o.getRemark());
                    return dto;
                }).collect(Collectors.toList());
                vo.setAuditRecordList(auditRecordList);
            }
            if (!Objects.isNull(respDto.getTotalQuantity())) {
                vo.setDistributeQuantityTotal(Integer.valueOf(respDto.getTotalQuantity().setScale(0).toString()));
            }
            if (respDto.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (respDto.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return new RestResponse((Object)vo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<DistributeOrderVo>> queryDistributeOrderList(@ApiParam(value="") @Valid @RequestBody(required=false) GetDistributeOrderParams getDistributeOrderParams) {
        ShareGoodsOrderQueryDto queryDto = new ShareGoodsOrderQueryDto();
        BeanUtils.copyProperties((Object)getDistributeOrderParams, (Object)queryDto);
        queryDto.setBusinessType(getDistributeOrderParams.getBussinessOrderType());
        queryDto.setOrderNo(getDistributeOrderParams.getBussinessOrderNo());
        queryDto.setOrderStatus(getDistributeOrderParams.getBussinessOrderStatus());
        queryDto.setSupplyWarehouseCode(getDistributeOrderParams.getSupplyVirtualWarehoseCode());
        queryDto.setSupplyWarehouseName(getDistributeOrderParams.getSupplyVirtualWarehoseName());
        queryDto.setReceiveWarehouseCode(getDistributeOrderParams.getReceiveVirtualWarehoseCode());
        queryDto.setReceiveWarehouseName(getDistributeOrderParams.getReceiveVirtualWarehoseName());
        queryDto.setTotalQuantity(ParamConverter.convertToBigDecimal((Object)getDistributeOrderParams.getDistributeQuantityTotal()));
        queryDto.setCreateTimeStart(getDistributeOrderParams.getCreateStartTime());
        queryDto.setCreateTimeEnd(getDistributeOrderParams.getCreateEndTime());
        queryDto.setPlatformNo(getDistributeOrderParams.getPlatformNo());
        logger.info("\u5206\u8d27\u5355\u4f20\u53c2queryDto:{}", (Object)JSON.toJSONString((Object)queryDto));
        queryDto.setOrderByDesc("create_time");
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderQueryApi.queryByPage(queryDto));
        logger.info("\u5206\u8d27\u5355\u8fd4\u56derespDtoPageInfo:{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            DistributeOrderVo vo = new DistributeOrderVo();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderType(o.getBusinessType());
            vo.setCreatePerson(o.getCreatePerson());
            vo.setUpdatePerson(o.getUpdatePerson());
            vo.setSupplyVirtualWarehoseCode(o.getSupplyWarehouseCode());
            vo.setSupplyVirtualWarehoseName(o.getSupplyWarehouseName());
            vo.setReceiveVirtualWarehoseCode(o.getReceiveWarehouseCode());
            vo.setReceiveVirtualWarehoseName(o.getReceiveWarehouseName());
            vo.setPlatformNo(o.getPlatformNo());
            vo.setRemark(o.getRemark());
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            if (!Objects.isNull(o.getTotalQuantity())) {
                vo.setDistributeQuantityTotal(Integer.valueOf(o.getTotalQuantity().setScale(0).toString()));
            }
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (o.getUpdateTime() != null) {
                vo.setUpdateTime(DateUtil.format((Date)o.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<ShareGoodsOrderCountRespDto> distributeOrdersCount(@Valid GetDistributeOrderParams getDistributeOrderParams) {
        ShareGoodsOrderQueryDto queryDto = new ShareGoodsOrderQueryDto();
        BeanUtils.copyProperties((Object)getDistributeOrderParams, (Object)queryDto);
        queryDto.setBusinessType(getDistributeOrderParams.getBussinessOrderType());
        queryDto.setOrderNo(getDistributeOrderParams.getBussinessOrderNo());
        queryDto.setOrderStatus(getDistributeOrderParams.getBussinessOrderStatus());
        queryDto.setSupplyWarehouseCode(getDistributeOrderParams.getSupplyVirtualWarehoseCode());
        queryDto.setSupplyWarehouseName(getDistributeOrderParams.getSupplyVirtualWarehoseName());
        queryDto.setReceiveWarehouseCode(getDistributeOrderParams.getReceiveVirtualWarehoseCode());
        queryDto.setReceiveWarehouseName(getDistributeOrderParams.getReceiveVirtualWarehoseName());
        queryDto.setTotalQuantity(ParamConverter.convertToBigDecimal((Object)getDistributeOrderParams.getDistributeQuantityTotal()));
        queryDto.setCreateTimeStart(getDistributeOrderParams.getCreateStartTime());
        queryDto.setCreateTimeEnd(getDistributeOrderParams.getCreateEndTime());
        queryDto.setPlatformNo(getDistributeOrderParams.getPlatformNo());
        logger.info("\u5206\u8d27\u5355\u4f20\u53c2queryDto:{}", (Object)JSON.toJSONString((Object)queryDto));
        return this.iCsShareGoodsOrderQueryApi.shareGoodsOrderCount(queryDto);
    }

    @Override
    public RestResponse<Object> updateDistributeOrder(@ApiParam(value="", required=true) @PathVariable(value="bussinessOrderNo") String bussinessOrderNo, @ApiParam(value="") @Valid @RequestBody(required=false) AddDistributeOrder addDistributeOrder) {
        ShareGoodsOrderReqDto reqDto = new ShareGoodsOrderReqDto();
        reqDto.setId(addDistributeOrder.getId());
        this.getShareGoodsOrder(reqDto, addDistributeOrder);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderApi.editShareGoodsOrder(addDistributeOrder.getBussinessOrderNo(), reqDto)));
    }

    @Override
    public RestResponse<PageInfo<GoodsOfDistributeOrderVO>> getDistributeOrderGoodsList(@ApiParam(value="") @Valid @RequestBody(required=false) GetDistributeOrderGoodsListParams getDistributeOrderGoodsListParams) {
        ShareGoodsOrderDetailReqDto shareGoodsOrderDetailReqDto = new ShareGoodsOrderDetailReqDto();
        shareGoodsOrderDetailReqDto.setOrderNo(getDistributeOrderGoodsListParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCsShareGoodsOrderDetailQueryApi.queryByPage(JSON.toJSONString((Object)shareGoodsOrderDetailReqDto), getDistributeOrderGoodsListParams.getPageNum(), getDistributeOrderGoodsListParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            GoodsOfDistributeOrderVO vo = new GoodsOfDistributeOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setGoodsLongCode(o.getSkuCode());
            vo.setGoodsName(o.getSkuName());
            vo.setDistributeQuantity(Integer.valueOf(o.getQuantity().setScale(0).toString()));
            vo.setGoodsId(String.valueOf(o.getId()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }
}

