/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cis.pms.biz.service.IOtherOutOrderMergeToWmsService;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderTagRecordApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferExtApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleTransferTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordAddBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="WMS_CANCEL_COMPLETE")
public class ReceiveDeliveryNoticeCancelProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(ReceiveDeliveryNoticeCancelProcessor.class);
    private static final List<String> maiyouALlotTypeList = Lists.newArrayList((Object[])new String[]{AllotTypeEnum.MAIYOU_BC_ALLOT.getType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType(), AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType(), AllotTypeEnum.MAIYOU_CB_SAME_ORG_ALLOT.getType()});
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private IOtherOutOrderMergeToWmsService otherOutOrderMergeToWmsService;
    @Resource
    private IOrderTagRecordApi orderTagRecordApi;
    @Autowired
    private ISaleTransferExtApi saleTransferExtApi;
    @Autowired
    private ISaleTransferOrderApi saleTransferOrderApi;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo message) {
        List saleTransferOrderRespDtoList;
        SaleTransferOrderReqDto reqDto;
        CsTransferOrderRespDto transferOrderRespDto;
        CsOutNoticeOrderRespDto noticeOrderRespDto;
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u76d1\u542c\u6536\u53d1\u901a\u77e5\u53d6\u6d88\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
        CsBasicsCancelReqDto dto = (CsBasicsCancelReqDto)JSON.parseObject((String)message.getData().toString(), CsBasicsCancelReqDto.class);
        try {
            this.externalPointService.receiveDeliveryNoticeCancelToEasPoint(dto.getPlatformOrderNo(), dto.getBusinessType(), dto.getRemark());
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5EAS\u5931\u8d25");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            logger.info("\u9500\u552e\u8c03\u62e8\u53d6\u6d88\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            if (dto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.ALLOT_SALE.getCode())) {
                noticeOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(dto.getNoticeOrderNo()));
                AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)noticeOrderRespDto), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u901a\u77e5\u5355");
                transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(noticeOrderRespDto.getRelevanceNo()));
                AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)transferOrderRespDto), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
                reqDto = new SaleTransferOrderReqDto();
                reqDto.setTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
                reqDto.setTransferType(SaleTransferTypeEnum.SALE.getCode());
                saleTransferOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.queryByParam(reqDto));
                AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)saleTransferOrderRespDtoList), (String)"\u9500\u552e\u8c03\u62e8\u4e0d\u5b58\u5728");
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLockAndSystem(((SaleTransferOrderRespDto)saleTransferOrderRespDtoList.get(0)).getSaleOrderNo()));
                BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(((SaleTransferOrderRespDto)saleTransferOrderRespDtoList.get(0)).getSaleOrderNo()));
                if (Objects.nonNull(saleOrderRespDto)) {
                    OrderTagRecordAddBatchReqDto tagReqDto = new OrderTagRecordAddBatchReqDto();
                    tagReqDto.setModel(OrderTagRecordAddBatchReqDto.ActionModel.DELETE);
                    tagReqDto.setTagCodes((List)Lists.newArrayList((Object[])new String[]{"GSDB"}));
                    tagReqDto.setSaleOrderIds((List)Lists.newArrayList((Object[])new Long[]{saleOrderRespDto.getId()}));
                    this.orderTagRecordApi.addBatchOrderTagRecord(tagReqDto);
                }
            } else {
                logger.info("\u975e\u9500\u552e\u8c03\u62e8\u65e0\u9700\u5904\u7406");
            }
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8c03\u62e8\u53d6\u6d88\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            logger.info("\u9ea6\u4f18\u9500\u552e\u8c03\u62e8\u53d6\u6d88\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\uff0c\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            if (CsPcpBusinessTypeEnum.maiyouAllotList().contains(dto.getBusinessType())) {
                noticeOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(dto.getNoticeOrderNo()));
                AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)noticeOrderRespDto), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u901a\u77e5\u5355");
                transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(noticeOrderRespDto.getRelevanceNo()));
                AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)transferOrderRespDto), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
                if (StringUtils.isNotBlank((CharSequence)transferOrderRespDto.getSaleOrderNo())) {
                    reqDto = new SaleTransferOrderReqDto();
                    reqDto.setTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
                    reqDto.setTransferTypeList(maiyouALlotTypeList);
                    saleTransferOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.queryByParam(reqDto));
                    AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)saleTransferOrderRespDtoList), (String)"\u9500\u552e\u8c03\u62e8\u4e0d\u5b58\u5728");
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLockAndSystem(((SaleTransferOrderRespDto)saleTransferOrderRespDtoList.get(0)).getSaleOrderNo()));
                    SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
                    saleTransferOrderReqDto.setTransferOrderNo(transferOrderRespDto.getTransferOrderNo());
                    RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.removeSaleTransferOrderByParam(saleTransferOrderReqDto));
                    RestResponseHelper.extractData((RestResponse)this.saleTransferExtApi.delByOrderId(((SaleTransferOrderRespDto)saleTransferOrderRespDtoList.get(0)).getId()));
                }
            } else {
                logger.info("\u975e\u9ea6\u4f18\u9500\u552e\u8c03\u62e8\u65e0\u9700\u5904\u7406");
            }
        }
        catch (Exception e) {
            logger.error("\u9ea6\u4f18\u9500\u552e\u8c03\u62e8\u53d6\u6d88\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.saleTransferOrderClear(dto.getNoticeOrderNo());
        }
        catch (Exception e) {
            logger.error("\u8c03\u62e8\u5355\u53d6\u6d88\uff0c\u9500\u552e\u8c03\u62e8\u6e05\u695a\u5173\u8054\u8bb0\u5f55\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (dto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER.getCode())) {
                noticeOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(dto.getNoticeOrderNo()));
                if (ObjectUtil.isEmpty((Object)noticeOrderRespDto)) {
                    logger.info("\u627e\u4e0d\u5230\u901a\u77e5\u5355\u4fe1\u606f");
                } else {
                    this.otherOutOrderMergeToWmsService.otherOutOrderMergeToWms(null, noticeOrderRespDto.getRelevanceNo());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5176\u4ed6\u51fa\u5e93\u5355\u53d6\u6d88\uff0c\u9700\u8981\u6821\u9a8c\u662f\u5426\u9700\u8981\u63a8\u9001\u5408\u5e76\u6307\u4ee4\u7ed9WMS\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

