/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="OUT_DELIVERY_ADD")
public class OutDeliveryAddProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(OutDeliveryAddProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private ICsOtherStorageOrderApi otherStorageOrderApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536\u65b0\u589e\u5176\u4ed6\u51fa\u5e93\u5355\uff1a{}", (Object)JSON.toJSONString(message));
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse<Long> response = this.addCsOtherStorageOrder(message);
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5176\u4ed6\u51fa\u5e93\u5355\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }

    private RestResponse<Long> addCsOtherStorageOrder(Map<String, Object> message) {
        CsOtherStorageOrderComboReqDto comboReqDto = new CsOtherStorageOrderComboReqDto();
        CsOtherStorageOrderReqDto storageOrder = (CsOtherStorageOrderReqDto)BeanUtil.copyProperties(message, CsOtherStorageOrderReqDto.class, (String[])new String[0]);
        storageOrder.setType(CsOtherStorageOrderEnum.InOrOut.OUT.getCode());
        storageOrder.setStorageOrderNo(Convert.toStr((Object)message.get("platformOrderNo")));
        storageOrder.setBusinessType(Convert.toLong((Object)message.get("businessType")));
        storageOrder.setWarehouseCode(Convert.toStr((Object)message.get("logicWarehouseCode")));
        storageOrder.setConsignee(Convert.toStr((Object)message.get("receivePersonName")));
        storageOrder.setPhone(Convert.toStr((Object)message.get("receivePersonPhone")));
        storageOrder.setProvinceName(Convert.toStr((Object)message.get("receiveProvinceName")));
        storageOrder.setProvinceCode(Convert.toStr((Object)message.get("receiveProvinceCode")));
        storageOrder.setCityName(Convert.toStr((Object)message.get("receiveCityName")));
        storageOrder.setCityCode(Convert.toStr((Object)message.get("receiveCityCode")));
        storageOrder.setAreaName(Convert.toStr((Object)message.get("receiveDistrictName")));
        storageOrder.setAreaCode(Convert.toStr((Object)message.get("receiveDistrictCode")));
        storageOrder.setAddress(Convert.toStr((Object)message.get("receiveDetailAddress")));
        storageOrder.setMessage(Convert.toStr((Object)message.get("digest")));
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        List itemList = itemReqDtoList.stream().map(items -> {
            CsOtherStorageOrderDetailReqDto dto = new CsOtherStorageOrderDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            dto.setVolume(Convert.toBigDecimal((Object)dto.getVolume(), (BigDecimal)BigDecimal.ZERO));
            dto.setLongCode(Convert.toStr(items.get("skuCode")));
            return dto;
        }).collect(Collectors.toList());
        comboReqDto.setCsOtherStorageOrderReqDto(storageOrder);
        comboReqDto.setDetailList(itemList);
        return this.otherStorageOrderApi.addCsOtherStorageOrder(comboReqDto);
    }
}

